/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TShortFloatHashMap;
import gnu.trove.TShortFloatIterator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TShortFloatHashMapDecorator
extends AbstractMap<Short, Float>
implements Map<Short, Float>,
Cloneable {
    protected TShortFloatHashMap _map;

    public TShortFloatHashMapDecorator(TShortFloatHashMap map) {
        this._map = map;
    }

    public TShortFloatHashMap getMap() {
        return this._map;
    }

    @Override
    public TShortFloatHashMapDecorator clone() {
        try {
            TShortFloatHashMapDecorator copy = (TShortFloatHashMapDecorator)super.clone();
            copy._map = (TShortFloatHashMap)this._map.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Float put(Short key, Float value) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value)));
    }

    @Override
    public boolean equals(Object other) {
        if (this._map.equals(other)) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (that.size() != this._map.size()) {
                return false;
            }
            Iterator it = that.entrySet().iterator();
            int i = that.size();
            while (i-- > 0) {
                Map.Entry e = it.next();
                Object key = e.getKey();
                Object val = e.getValue();
                if (key instanceof Short && val instanceof Float) {
                    short k = this.unwrapKey(key);
                    float v = this.unwrapValue(val);
                    if (this._map.containsKey(k) && v == this._map.get(k)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public Float get(Short key) {
        short k = this.unwrapKey(key);
        float v = this._map.get(k);
        if (v == 0.0f) {
            return this._map.containsKey(k) ? this.wrapValue(v) : null;
        }
        return this.wrapValue(v);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    public Float remove(Short key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    @Override
    public Set<Map.Entry<Short, Float>> entrySet() {
        return new AbstractSet<Map.Entry<Short, Float>>(){

            @Override
            public int size() {
                return TShortFloatHashMapDecorator.this._map.size();
            }

            @Override
            public boolean isEmpty() {
                return TShortFloatHashMapDecorator.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Object k = ((Map.Entry)o).getKey();
                    Object v = ((Map.Entry)o).getValue();
                    return TShortFloatHashMapDecorator.this.containsKey(k) && ((Float)TShortFloatHashMapDecorator.this.get(k)).equals(v);
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<Short, Float>> iterator() {
                return new Iterator<Map.Entry<Short, Float>>(){
                    private final TShortFloatIterator it;
                    {
                        this.it = TShortFloatHashMapDecorator.this._map.iterator();
                    }

                    @Override
                    public Map.Entry<Short, Float> next() {
                        this.it.advance();
                        final Short key = TShortFloatHashMapDecorator.this.wrapKey(this.it.key());
                        final Float v = TShortFloatHashMapDecorator.this.wrapValue(this.it.value());
                        return new Map.Entry<Short, Float>(){
                            private Float val;
                            {
                                this.val = v;
                            }

                            @Override
                            public boolean equals(Object o) {
                                return o instanceof Map.Entry && ((Map.Entry)o).getKey().equals(key) && ((Map.Entry)o).getValue().equals(this.val);
                            }

                            @Override
                            public Short getKey() {
                                return key;
                            }

                            @Override
                            public Float getValue() {
                                return this.val;
                            }

                            @Override
                            public int hashCode() {
                                return key.hashCode() + this.val.hashCode();
                            }

                            @Override
                            public Float setValue(Float value) {
                                this.val = value;
                                return TShortFloatHashMapDecorator.this.put(key, value);
                            }
                        };
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public boolean add(Float o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<Short, Float>> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                TShortFloatHashMapDecorator.this.clear();
            }
        };
    }

    @Override
    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends Short, ? extends Float> map) {
        Iterator<Map.Entry<? extends Short, ? extends Float>> it = map.entrySet().iterator();
        int i = map.size();
        while (i-- > 0) {
            Map.Entry<? extends Short, ? extends Float> e = it.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    protected Short wrapKey(short k) {
        return new Short(k);
    }

    protected short unwrapKey(Object key) {
        return (Short)key;
    }

    protected Float wrapValue(float k) {
        return new Float(k);
    }

    protected float unwrapValue(Object value) {
        return ((Float)value).floatValue();
    }
}

