/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Marker;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FeatureStructureImpl;

public class MarkerImpl
implements Marker {
    protected int nextFSId;
    protected int nextStringHeapAddr;
    protected int nextByteHeapAddr;
    protected int nextShortHeapAddr;
    protected int nextLongHeapAddr;
    protected boolean isValid;
    CASImpl cas;

    MarkerImpl(int nextFSAddr, int nextStringHeapAddr, int nextByteHeapAddr, int nextShortHeapAddr, int nextLongHeapAddr, CASImpl cas) {
        this.nextFSId = nextFSAddr;
        this.nextStringHeapAddr = nextStringHeapAddr;
        this.nextByteHeapAddr = nextByteHeapAddr;
        this.nextShortHeapAddr = nextShortHeapAddr;
        this.nextLongHeapAddr = nextLongHeapAddr;
        this.cas = cas;
        this.isValid = true;
    }

    @Override
    public boolean isNew(FeatureStructure fs) {
        if (!this.isValid || ((FeatureStructureImpl)fs).getCASImpl() != this.cas) {
            CASRuntimeException e = new CASRuntimeException("CAS_MISMATCH", new String[]{"FS and Marker are not from the same CAS."});
            throw e;
        }
        return this.isNew(((FeatureStructureImpl)fs).getAddress());
    }

    @Override
    public boolean isModified(FeatureStructure fs) {
        if (!this.isValid || ((FeatureStructureImpl)fs).getCASImpl() != this.cas) {
            CASRuntimeException e = new CASRuntimeException("CAS_MISMATCH", new String[]{"FS and Marker are not from the same CAS."});
            throw e;
        }
        int addr = ((FeatureStructureImpl)fs).getAddress();
        return this.isModified(addr);
    }

    boolean isNew(int addr) {
        return addr >= this.nextFSId;
    }

    boolean isModified(int addr) {
        if (this.isNew(addr)) {
            return false;
        }
        return this.cas.getModifiedFSList().contains(addr);
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public int getNextFSId() {
        return this.nextFSId;
    }

    public int getNextStringHeapAddr() {
        return this.nextStringHeapAddr;
    }

    public int getNextByteHeapAddr() {
        return this.nextByteHeapAddr;
    }

    public int getNextShortHeapAddr() {
        return this.nextShortHeapAddr;
    }

    public int getNextLongHeapAddr() {
        return this.nextLongHeapAddr;
    }
}

