/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.utility;

import de.julielab.jcore.types.InternalReference;
import de.julielab.jcore.utility.JCoReAnnotationIndexMerger;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class JCoReCondensedDocumentText {
    private NavigableMap<Integer, Integer> condensedPos2SumCutMap;
    private NavigableMap<Integer, Integer> originalPos2SumCutMap;
    private String condensedText;
    private JCas cas;
    private Set<Character> cutAwayFillCharacters;
    private boolean skipInternalReferencesWithLetters;

    public boolean isSkipInternalReferencesWithLetters() {
        return this.skipInternalReferencesWithLetters;
    }

    public JCoReCondensedDocumentText(JCas cas, Set<String> cutAwayTypes) throws ClassNotFoundException {
        this(cas, cutAwayTypes, false);
    }

    public JCoReCondensedDocumentText(JCas cas, Set<String> cutAwayTypes, boolean skipInternalReferencesWithLetters) throws ClassNotFoundException {
        this(cas, cutAwayTypes, null, skipInternalReferencesWithLetters);
    }

    public JCoReCondensedDocumentText(JCas cas, Set<String> cutAwayTypes, Set<Character> cutAwayFillCharacters) throws ClassNotFoundException {
        this(cas, cutAwayTypes, cutAwayFillCharacters, false);
    }

    public JCoReCondensedDocumentText(JCas cas, Set<String> cutAwayTypes, Set<Character> cutAwayFillCharacters, boolean skipInternalReferencesWithLetters) throws ClassNotFoundException {
        this.cas = cas;
        this.cutAwayFillCharacters = cutAwayFillCharacters;
        this.skipInternalReferencesWithLetters = skipInternalReferencesWithLetters;
        this.buildMap(cas, cutAwayTypes);
    }

    public JCas getCas() {
        return this.cas;
    }

    public void buildMap(JCas cas, Set<String> cutAwayTypes) throws ClassNotFoundException {
        if (cutAwayTypes == null || cutAwayTypes.isEmpty()) {
            return;
        }
        Pattern letterP = Pattern.compile("[a-zA-Z]");
        StringBuilder sb = new StringBuilder();
        this.condensedPos2SumCutMap = new TreeMap<Integer, Integer>();
        this.condensedPos2SumCutMap.put(0, 0);
        this.originalPos2SumCutMap = new TreeMap<Integer, Integer>();
        this.originalPos2SumCutMap.put(0, 0);
        JCoReAnnotationIndexMerger merger = new JCoReAnnotationIndexMerger(cutAwayTypes, true, null, cas);
        int cutSum = 0;
        int lastBegin = 0;
        int lastEnd = -1;
        int lastCutSum = 0;
        while (merger.incrementAnnotation()) {
            boolean previousCharacterIsCutAwayDelimiter;
            String coveredText;
            Matcher letterM;
            int begin = merger.getCurrentBegin();
            int end = merger.getCurrentEnd();
            if (this.skipInternalReferencesWithLetters && (merger.getAnnotation() instanceof InternalReference || merger.getAnnotation() instanceof de.julielab.jcore.types.pubmed.InternalReference) && (letterM = letterP.matcher(coveredText = ((Annotation)merger.getAnnotation()).getCoveredText())).find()) continue;
            boolean moreThanOneCharacterDistance = begin - lastEnd > 2;
            boolean bl = previousCharacterIsCutAwayDelimiter = this.cutAwayFillCharacters == null || this.cutAwayFillCharacters.isEmpty() || begin - lastEnd == 2 && this.cutAwayFillCharacters.contains(Character.valueOf(cas.getDocumentText().charAt(begin - 1)));
            if (lastEnd > 0 && begin > lastEnd && (previousCharacterIsCutAwayDelimiter || moreThanOneCharacterDistance)) {
                int condensedPosition;
                boolean extendLastEnd;
                boolean precedingCharacterIsWS = lastBegin == 0 || Character.isWhitespace(cas.getDocumentText().charAt(lastBegin - 1));
                boolean succeedingCharacterIsWS = lastEnd < cas.getDocumentText().length() && Character.isWhitespace(cas.getDocumentText().charAt(lastEnd));
                boolean bl2 = extendLastEnd = precedingCharacterIsWS && succeedingCharacterIsWS;
                if (extendLastEnd) {
                    ++lastEnd;
                }
                if (precedingCharacterIsWS && end >= cas.getDocumentText().length()) {
                    --begin;
                }
                if ((condensedPosition = lastEnd - (cutSum += lastEnd - lastBegin)) == lastBegin && !extendLastEnd) {
                    ++condensedPosition;
                }
                this.originalPos2SumCutMap.put(lastBegin, lastCutSum);
                this.originalPos2SumCutMap.put(lastEnd, cutSum);
                lastBegin = begin;
                lastCutSum = cutSum;
                if (condensedPosition + cutSum >= cas.getDocumentText().length()) {
                    cutSum = cas.getDocumentText().length() - 1 - condensedPosition;
                }
                this.condensedPos2SumCutMap.put(condensedPosition, cutSum);
                sb.append(cas.getDocumentText(), lastEnd, begin);
            } else if (lastEnd < 0) {
                if (begin <= 0 || end < cas.getDocumentText().length() || Character.isWhitespace(cas.getDocumentText().charAt(begin - 1))) {
                    // empty if block
                }
                lastBegin = --begin;
                sb.append(cas.getDocumentText(), 0, begin);
            }
            lastEnd = end;
        }
        if (lastEnd > 0) {
            boolean succeedingCharacterIsWS;
            boolean precedingCharacterIsWS = lastBegin < 1 || Character.isWhitespace(cas.getDocumentText().charAt(lastBegin - 1));
            boolean bl = succeedingCharacterIsWS = lastEnd < cas.getDocumentText().length() && Character.isWhitespace(cas.getDocumentText().charAt(lastEnd));
            if (precedingCharacterIsWS && (succeedingCharacterIsWS || lastEnd >= cas.getDocumentText().length())) {
                ++lastEnd;
            }
            int condensedPosition = lastEnd - (cutSum += lastEnd - lastBegin);
            this.originalPos2SumCutMap.put(lastBegin, lastCutSum);
            this.originalPos2SumCutMap.put(lastEnd, cutSum);
            if (condensedPosition + cutSum >= cas.getDocumentText().length()) {
                cutSum = cas.getDocumentText().length() - 1 - condensedPosition;
            }
            this.condensedPos2SumCutMap.put(condensedPosition, cutSum);
        }
        if (lastEnd == -1) {
            lastEnd = 0;
        }
        if (lastEnd < cas.getDocumentText().length()) {
            sb.append(cas.getDocumentText().substring(lastEnd));
        }
        this.condensedText = sb.toString();
    }

    public int getOriginalOffsetForCondensedOffset(int condensedOffset) {
        if (this.condensedPos2SumCutMap == null) {
            return condensedOffset;
        }
        Map.Entry<Integer, Integer> floorEntry = this.condensedPos2SumCutMap.floorEntry(condensedOffset);
        return condensedOffset + floorEntry.getValue();
    }

    public int getCondensedOffsetForOriginalOffset(int originalOffset) {
        if (this.originalPos2SumCutMap == null) {
            return originalOffset;
        }
        Map.Entry<Integer, Integer> floorEntry = this.originalPos2SumCutMap.floorEntry(originalOffset);
        Map.Entry<Integer, Integer> ceilingEntry = this.originalPos2SumCutMap.ceilingEntry(originalOffset);
        if (floorEntry != null && ceilingEntry != null) {
            int ceilingDiff;
            boolean withinCutAway;
            int floorDiff = floorEntry.getKey() - floorEntry.getValue();
            boolean bl = withinCutAway = floorDiff == (ceilingDiff = ceilingEntry.getKey() - ceilingEntry.getValue());
            if (withinCutAway) {
                return originalOffset - ceilingEntry.getValue() + (ceilingEntry.getKey() - originalOffset);
            }
        }
        return originalOffset - floorEntry.getValue();
    }

    public String getCodensedText() {
        return this.condensedText != null ? this.condensedText : this.cas.getDocumentText();
    }
}

