/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.uima.cas.ArrayFS;
import org.apache.uima.cas.BooleanArrayFS;
import org.apache.uima.cas.ByteArrayFS;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.DoubleArrayFS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.FloatArrayFS;
import org.apache.uima.cas.IntArrayFS;
import org.apache.uima.cas.LongArrayFS;
import org.apache.uima.cas.ShortArrayFS;
import org.apache.uima.cas.StringArrayFS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.fit.util.CasUtil;
import org.apache.uima.fit.util.FSCollectionFactory;

public class FSUtil {
    private static Feature getMandatoryFeature(FeatureStructure aFS, String aFeature) {
        Feature feat = aFS.getType().getFeatureByBaseName(aFeature);
        if (feat == null) {
            throw new IllegalArgumentException("Type [" + aFS.getType() + "] has no feature with name [" + aFeature + "]");
        }
        return feat;
    }

    private static void requireSingleValue(Feature aFeature, Object aArray) {
        if (aArray == null) {
            throw new IllegalArgumentException("Cannot set [" + aFeature.getName() + "] to a null value.");
        }
        if (Array.getLength(aArray) != 1) {
            throw new IllegalArgumentException("Feature [" + aFeature.getName() + "] requires a single value but got " + Arrays.asList(aArray));
        }
    }

    private static boolean isListType(TypeSystem aTS, Type aType) {
        return aTS.subsumes(aTS.getType("uima.cas.ListBase"), aType);
    }

    public static boolean hasFeature(FeatureStructure aFS, String aFeature) {
        return aFS.getType().getFeatureByBaseName(aFeature) != null;
    }

    public static boolean isMultiValuedFeature(FeatureStructure aFS, String aFeature) {
        Feature feat = aFS.getType().getFeatureByBaseName(aFeature);
        return FSUtil.isMultiValuedFeature(aFS, feat);
    }

    public static boolean isMultiValuedFeature(FeatureStructure aFS, Feature feat) {
        return FSUtil.isMultiValuedFeature(aFS.getCAS().getTypeSystem(), feat);
    }

    public static boolean isMultiValuedFeature(TypeSystem aTypeSystem, Feature feat) {
        if (feat == null) {
            return false;
        }
        return feat.getRange().isArray() || FSUtil.isListType(aTypeSystem, feat.getRange());
    }

    public static void setFeature(FeatureStructure aFS, String aFeature, boolean ... aValue) {
        Feature feat = FSUtil.getMandatoryFeature(aFS, aFeature);
        if (feat.getRange().isPrimitive()) {
            FSUtil.requireSingleValue(feat, aValue);
            aFS.setBooleanValue(feat, aValue[0]);
        } else if (aValue == null) {
            aFS.setFeatureValue(feat, null);
        } else {
            aFS.setFeatureValue(feat, FSCollectionFactory.createBooleanArray(aFS.getCAS(), aValue));
        }
    }

    public static void setFeature(FeatureStructure aFS, String aFeature, byte ... aValue) {
        Feature feat = FSUtil.getMandatoryFeature(aFS, aFeature);
        if (feat.getRange().isPrimitive()) {
            FSUtil.requireSingleValue(feat, aValue);
            aFS.setByteValue(feat, aValue[0]);
        } else if (aValue == null) {
            aFS.setFeatureValue(feat, null);
        } else {
            aFS.setFeatureValue(feat, FSCollectionFactory.createByteArray(aFS.getCAS(), aValue));
        }
    }

    public static void setFeature(FeatureStructure aFS, String aFeature, double ... aValue) {
        Feature feat = FSUtil.getMandatoryFeature(aFS, aFeature);
        if (feat.getRange().isPrimitive()) {
            FSUtil.requireSingleValue(feat, aValue);
            aFS.setDoubleValue(feat, aValue[0]);
        } else if (aValue == null) {
            aFS.setFeatureValue(feat, null);
        } else {
            aFS.setFeatureValue(feat, FSCollectionFactory.createDoubleArray(aFS.getCAS(), aValue));
        }
    }

    public static void setFeature(FeatureStructure aFS, String aFeature, float ... aValue) {
        Feature feat = FSUtil.getMandatoryFeature(aFS, aFeature);
        if (feat.getRange().isPrimitive()) {
            FSUtil.requireSingleValue(feat, aValue);
            aFS.setFloatValue(feat, aValue[0]);
        } else if (aValue == null) {
            aFS.setFeatureValue(feat, null);
        } else if (feat.getRange().isArray()) {
            aFS.setFeatureValue(feat, FSCollectionFactory.createFloatArray(aFS.getCAS(), aValue));
        } else {
            aFS.setFeatureValue(feat, (FeatureStructure)FSCollectionFactory.createFloatList(aFS.getCAS(), aValue));
        }
    }

    public static void setFeature(FeatureStructure aFS, String aFeature, int ... aValue) {
        Feature feat = FSUtil.getMandatoryFeature(aFS, aFeature);
        if (feat.getRange().isPrimitive()) {
            FSUtil.requireSingleValue(feat, aValue);
            aFS.setIntValue(feat, aValue[0]);
        } else if (aValue == null) {
            aFS.setFeatureValue(feat, null);
        } else if (feat.getRange().isArray()) {
            aFS.setFeatureValue(feat, FSCollectionFactory.createIntArray(aFS.getCAS(), aValue));
        } else {
            aFS.setFeatureValue(feat, (FeatureStructure)FSCollectionFactory.createIntegerList(aFS.getCAS(), aValue));
        }
    }

    public static void setFeature(FeatureStructure aFS, String aFeature, long ... aValue) {
        Feature feat = FSUtil.getMandatoryFeature(aFS, aFeature);
        if (feat.getRange().isPrimitive()) {
            FSUtil.requireSingleValue(feat, aValue);
            aFS.setLongValue(feat, aValue[0]);
        } else if (aValue == null) {
            aFS.setFeatureValue(feat, null);
        } else {
            aFS.setFeatureValue(feat, FSCollectionFactory.createLongArray(aFS.getCAS(), aValue));
        }
    }

    public static void setFeature(FeatureStructure aFS, String aFeature, short ... aValue) {
        Feature feat = FSUtil.getMandatoryFeature(aFS, aFeature);
        if (feat.getRange().isPrimitive()) {
            FSUtil.requireSingleValue(feat, aValue);
            aFS.setShortValue(feat, aValue[0]);
        } else if (aValue == null) {
            aFS.setFeatureValue(feat, null);
        } else {
            aFS.setFeatureValue(feat, FSCollectionFactory.createShortArray(aFS.getCAS(), aValue));
        }
    }

    public static void setFeature(FeatureStructure aFS, String aFeature, String ... aValue) {
        Feature feat = FSUtil.getMandatoryFeature(aFS, aFeature);
        if (feat.getRange().isPrimitive()) {
            FSUtil.requireSingleValue(feat, aValue);
            aFS.setStringValue(feat, aValue[0]);
        } else if (aValue == null) {
            aFS.setFeatureValue(feat, null);
        } else if (feat.getRange().isArray()) {
            aFS.setFeatureValue(feat, FSCollectionFactory.createStringArray(aFS.getCAS(), aValue));
        } else {
            aFS.setFeatureValue(feat, (FeatureStructure)FSCollectionFactory.createStringList(aFS.getCAS(), aValue));
        }
    }

    public static void setFeature(FeatureStructure aFS, String aFeature, FeatureStructure ... aValue) {
        Feature feat = FSUtil.getMandatoryFeature(aFS, aFeature);
        if (feat.getRange().isArray()) {
            aFS.setFeatureValue(feat, FSCollectionFactory.createArrayFS(aFS.getCAS(), aValue));
        } else if (aValue == null) {
            aFS.setFeatureValue(feat, null);
        } else if (FSUtil.isListType(aFS.getCAS().getTypeSystem(), feat.getRange())) {
            aFS.setFeatureValue(feat, (FeatureStructure)FSCollectionFactory.createFSList(aFS.getCAS(), aValue));
        } else {
            FSUtil.requireSingleValue(feat, aValue);
            aFS.setFeatureValue(feat, aValue[0]);
        }
    }

    public static void setFeature(FeatureStructure aFS, String aFeature, Collection aValue) {
        Feature feat = FSUtil.getMandatoryFeature(aFS, aFeature);
        if (aValue == null) {
            aFS.setFeatureValue(feat, null);
        } else if (feat.getRange().isArray()) {
            switch (feat.getRange().getName()) {
                case "uima.cas.BooleanArray": {
                    aFS.setFeatureValue(feat, FSCollectionFactory.createBooleanArray(aFS.getCAS(), (Collection<Boolean>)aValue));
                    break;
                }
                case "uima.cas.ByteArray": {
                    aFS.setFeatureValue(feat, FSCollectionFactory.createByteArray(aFS.getCAS(), (Collection<Byte>)aValue));
                    break;
                }
                case "uima.cas.DoubleArray": {
                    aFS.setFeatureValue(feat, FSCollectionFactory.createDoubleArray(aFS.getCAS(), (Collection<Double>)aValue));
                    break;
                }
                case "uima.cas.FloatArray": {
                    aFS.setFeatureValue(feat, FSCollectionFactory.createFloatArray(aFS.getCAS(), (Collection<Float>)aValue));
                    break;
                }
                case "uima.cas.IntegerArray": {
                    aFS.setFeatureValue(feat, FSCollectionFactory.createIntArray(aFS.getCAS(), (Collection<Integer>)aValue));
                    break;
                }
                case "uima.cas.LongArray": {
                    aFS.setFeatureValue(feat, FSCollectionFactory.createLongArray(aFS.getCAS(), (Collection<Long>)aValue));
                    break;
                }
                case "uima.cas.ShortArray": {
                    aFS.setFeatureValue(feat, FSCollectionFactory.createShortArray(aFS.getCAS(), (Collection<Short>)aValue));
                    break;
                }
                case "uima.cas.StringArray": {
                    aFS.setFeatureValue(feat, FSCollectionFactory.createStringArray(aFS.getCAS(), (Collection<String>)aValue));
                    break;
                }
                default: {
                    aFS.setFeatureValue(feat, FSCollectionFactory.createArrayFS(aFS.getCAS(), aValue));
                    break;
                }
            }
        } else {
            switch (feat.getRange().getName()) {
                case "uima.cas.FloatList": {
                    aFS.setFeatureValue(feat, (FeatureStructure)FSCollectionFactory.createFloatList(aFS.getCAS(), (Collection<Float>)aValue));
                    break;
                }
                case "uima.cas.IntegerList": {
                    aFS.setFeatureValue(feat, (FeatureStructure)FSCollectionFactory.createIntegerList(aFS.getCAS(), (Collection<Integer>)aValue));
                    break;
                }
                case "uima.cas.StringList": {
                    aFS.setFeatureValue(feat, (FeatureStructure)FSCollectionFactory.createStringList(aFS.getCAS(), (Collection<String>)aValue));
                    break;
                }
                default: {
                    aFS.setFeatureValue(feat, (FeatureStructure)FSCollectionFactory.createFSList(aFS.getCAS(), aValue));
                }
            }
        }
    }

    public static <T> T getFeature(FeatureStructure aFS, String aFeature, Class<T> aClazz) {
        Feature feat = FSUtil.getMandatoryFeature(aFS, aFeature);
        return FSUtil.getFeature(aFS, feat, aClazz);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T getFeature(FeatureStructure aFS, Feature aFeature, Class<T> aClazz) {
        void var7_17;
        Object target;
        int length;
        if (aFeature.getRange().isPrimitive()) {
            switch (aFeature.getRange().getName()) {
                case "uima.cas.Boolean": {
                    return aClazz.cast(aFS.getBooleanValue(aFeature));
                }
                case "uima.cas.Byte": {
                    return aClazz.cast(aFS.getByteValue(aFeature));
                }
                case "uima.cas.Double": {
                    return aClazz.cast(aFS.getDoubleValue(aFeature));
                }
                case "uima.cas.Float": {
                    return aClazz.cast(Float.valueOf(aFS.getFloatValue(aFeature)));
                }
                case "uima.cas.Integer": {
                    return aClazz.cast(aFS.getIntValue(aFeature));
                }
                case "uima.cas.Long": {
                    return aClazz.cast(aFS.getLongValue(aFeature));
                }
                case "uima.cas.Short": {
                    return aClazz.cast(aFS.getShortValue(aFeature));
                }
                case "uima.cas.String": {
                    return aClazz.cast(aFS.getStringValue(aFeature));
                }
            }
            throw new IllegalArgumentException("Unable to coerce value of feature [" + aFeature.getName() + "] with type [" + aFeature.getRange().getName() + "] into [" + aClazz.getName() + "]");
        }
        FeatureStructure value = aFS.getFeatureValue(aFeature);
        if (value == null) {
            return null;
        }
        if (value instanceof CommonArrayFS) {
            if (!Object.class.equals(aClazz) && aClazz.isAssignableFrom(value.getClass())) {
                return (T)value;
            }
            CommonArrayFS source = (CommonArrayFS)value;
            length = source.size();
            if (value instanceof BooleanArrayFS) {
                target = new boolean[length];
                ((BooleanArrayFS)source).copyToArray(0, (boolean[])target, 0, length);
            } else if (value instanceof ByteArrayFS) {
                target = new byte[length];
                ((ByteArrayFS)source).copyToArray(0, (byte[])target, 0, length);
            } else if (value instanceof DoubleArrayFS) {
                target = new double[length];
                ((DoubleArrayFS)source).copyToArray(0, (double[])target, 0, length);
            } else if (value instanceof FloatArrayFS) {
                target = new float[length];
                ((FloatArrayFS)source).copyToArray(0, (float[])target, 0, length);
            } else if (value instanceof IntArrayFS) {
                target = new int[length];
                ((IntArrayFS)source).copyToArray(0, (int[])target, 0, length);
            } else if (value instanceof LongArrayFS) {
                target = new long[length];
                ((LongArrayFS)source).copyToArray(0, (long[])target, 0, length);
            } else if (value instanceof ShortArrayFS) {
                target = new short[length];
                ((ShortArrayFS)source).copyToArray(0, (short[])target, 0, length);
            } else if (value instanceof StringArrayFS) {
                target = new String[length];
                ((StringArrayFS)source).copyToArray(0, (String[])target, 0, length);
            } else {
                target = aClazz.isArray() ? (Object)Array.newInstance(aClazz.getComponentType(), length) : (Object)new FeatureStructure[length];
                ((ArrayFS)source).copyToArray(0, (FeatureStructure[])target, 0, length);
            }
        } else if (FSUtil.isListType(aFS.getCAS().getTypeSystem(), aFeature.getRange())) {
            void var7_13;
            if (!Object.class.equals(aClazz) && aClazz.isAssignableFrom(value.getClass())) {
                return (T)value;
            }
            length = 0;
            Object cur = value;
            while (cur.getType().getFeatureByBaseName("head") != null) {
                ++length;
                cur = cur.getFeatureValue(cur.getType().getFeatureByBaseName("tail"));
            }
            cur = aFeature.getRange().getName();
            int n = -1;
            switch (((String)cur).hashCode()) {
                case -2114911781: {
                    if (!((String)cur).equals("uima.cas.FloatList")) break;
                    boolean bl = false;
                    break;
                }
                case 1899557757: {
                    if (!((String)cur).equals("uima.cas.IntegerList")) break;
                    boolean bl = true;
                    break;
                }
                case -1676352594: {
                    if (!((String)cur).equals("uima.cas.StringList")) break;
                    int n2 = 2;
                }
            }
            switch (var7_13) {
                case 0: {
                    float[] floatTarget = new float[length];
                    int i = 0;
                    FeatureStructure cur2 = value;
                    while (cur2.getType().getFeatureByBaseName("head") != null) {
                        floatTarget[i] = cur2.getFloatValue(cur2.getType().getFeatureByBaseName("head"));
                        cur2 = cur2.getFeatureValue(cur2.getType().getFeatureByBaseName("tail"));
                    }
                    target = floatTarget;
                    break;
                }
                case 1: {
                    int[] intTarget = new int[length];
                    int i = 0;
                    FeatureStructure cur2 = value;
                    while (cur2.getType().getFeatureByBaseName("head") != null) {
                        intTarget[i] = cur2.getIntValue(cur2.getType().getFeatureByBaseName("head"));
                        cur2 = cur2.getFeatureValue(cur2.getType().getFeatureByBaseName("tail"));
                    }
                    target = intTarget;
                    break;
                }
                case 2: {
                    String[] stringTarget = new String[length];
                    int i = 0;
                    FeatureStructure cur2 = value;
                    while (cur2.getType().getFeatureByBaseName("head") != null) {
                        stringTarget[i] = cur2.getStringValue(cur2.getType().getFeatureByBaseName("head"));
                        cur2 = cur2.getFeatureValue(cur2.getType().getFeatureByBaseName("tail"));
                    }
                    target = stringTarget;
                    break;
                }
                default: {
                    target = aClazz.isArray() ? (Object)Array.newInstance(aClazz.getComponentType(), length) : (Object)new FeatureStructure[length];
                    int i = 0;
                    FeatureStructure cur3 = value;
                    while (cur3.getType().getFeatureByBaseName("head") != null) {
                        Array.set(target, i, cur3.getFeatureValue(cur3.getType().getFeatureByBaseName("head")));
                        ++i;
                        cur3 = cur3.getFeatureValue(cur3.getType().getFeatureByBaseName("tail"));
                    }
                    break block26;
                }
            }
        } else {
            if (aClazz.isAssignableFrom(value.getClass())) {
                return (T)value;
            }
            if (!aFS.getCAS().getTypeSystem().subsumes(CasUtil.getType(aFS.getCAS(), aClazz), aFeature.getRange())) throw new IllegalArgumentException("Unable to coerce value of feature [" + aFeature.getName() + "] with type [" + aFeature.getRange().getName() + "] into [" + aClazz.getName() + "]");
            return (T)value;
        }
        if (aClazz.isArray()) {
            return aClazz.cast(target);
        }
        Class<Object> targetClass = aClazz;
        if (Object.class.equals(aClazz)) {
            targetClass = List.class;
        }
        if (!Collection.class.isAssignableFrom(targetClass)) throw new IllegalArgumentException("Unable to coerce value of feature [" + aFeature.getName() + "] with type [" + aFeature.getRange().getName() + "] into [" + targetClass.getName() + "]");
        if (targetClass.isInterface()) {
            if (List.class.isAssignableFrom(targetClass)) {
                ArrayList arrayList = new ArrayList(length);
            } else {
                if (!Set.class.isAssignableFrom(targetClass)) throw new IllegalArgumentException("Unable to coerce value of feature [" + aFeature.getName() + "] with type [" + aFeature.getRange().getName() + "] into [" + targetClass.getName() + "]");
                HashSet hashSet = new HashSet(length);
            }
        } else {
            try {
                Collection collection = (Collection)targetClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException("Unable to coerce value of feature [" + aFeature.getName() + "] with type [" + aFeature.getRange().getName() + "] into [" + targetClass.getName() + "]", e);
            }
        }
        for (int i = 0; i < length; ++i) {
            var7_17.add(Array.get(target, i));
        }
        return (T)targetClass.cast(var7_17);
    }
}

