/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.linnaeus;

import de.julielab.jcore.ae.linnaeus.LinnaeusMatcherProvider;
import de.julielab.jcore.types.Organism;
import de.julielab.jcore.types.ResourceEntry;
import de.julielab.jcore.utility.JCoReTools;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.fit.descriptor.ExternalResource;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import uk.ac.man.entitytagger.Mention;
import uk.ac.man.entitytagger.matching.Matcher;

@ResourceMetaData(name="JCore LINNAEUS Species AE")
@TypeCapability(outputs={"de.julielab.jcore.types.Organism", "de.julielab.jcore.types.ResourceEntry"})
public class LinnaeusSpeciesAnnotator
extends JCasAnnotator_ImplBase {
    public static final String RES_KEY_LINNAEUS_MATCHER = "LinnaeusMatcher";
    public static final String PARAM_CONFIG_FILE = "ConfigFile";
    private static final String linnaeusIdPrefix = "species:ncbi:";
    private Matcher matcher;
    @ExternalResource(key="LinnaeusMatcher", description="This resource dependency requires as resource the LINNAEUS configuration file. For each configuration file, one matcher will be created and shared between annotators.")
    private LinnaeusMatcherProvider matcherProvider;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        try {
            this.matcherProvider = (LinnaeusMatcherProvider)aContext.getResourceObject(RES_KEY_LINNAEUS_MATCHER);
            if (this.matcherProvider == null) {
                throw new ResourceInitializationException("resource_dependency_not_satisfied", new Object[]{RES_KEY_LINNAEUS_MATCHER});
            }
        }
        catch (ResourceAccessException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        this.matcher = this.matcherProvider.getMatcher();
        super.initialize(aContext);
    }

    public void process(JCas cas) throws AnalysisEngineProcessException {
        String text = cas.getDocumentText();
        List mentions = this.matcher.match(text);
        for (Mention mention : mentions) {
            String mostProbableID = mention.getMostProbableID();
            if (mostProbableID.startsWith(linnaeusIdPrefix)) {
                mostProbableID = mostProbableID.substring(linnaeusIdPrefix.length());
            }
            Double[] probabilities = mention.getProbabilities();
            double maxprob = 0.0;
            if (probabilities != null) {
                for (int i = 0; i < probabilities.length; ++i) {
                    if (probabilities[i] == null || !(probabilities[i] > maxprob)) continue;
                    maxprob = probabilities[i];
                }
            }
            int start = mention.getStart();
            int end = mention.getEnd();
            try {
                Organism species = null;
                species = new Organism(cas);
                species.setBegin(mention.getStart());
                species.setEnd(mention.getEnd());
                species.setSpecificType("organism");
                species.addToIndexes();
                ResourceEntry resourceEntry = new ResourceEntry(cas);
                resourceEntry.setBegin(start);
                resourceEntry.setEnd(end);
                resourceEntry.setSource("NCBI Taxonomy");
                resourceEntry.setComponentId(((Object)((Object)this)).getClass().getCanonicalName());
                resourceEntry.setEntryId(mostProbableID);
                resourceEntry.setConfidence(String.valueOf(maxprob));
                resourceEntry.addToIndexes();
                FSArray resourceEntryList = species.getResourceEntryList();
                if (null == resourceEntryList) {
                    resourceEntryList = new FSArray(cas, 1);
                    resourceEntryList.set(0, (FeatureStructure)resourceEntry);
                } else {
                    resourceEntryList = JCoReTools.addToFSArray((FSArray)resourceEntryList, (FeatureStructure)resourceEntry);
                }
                species.setResourceEntryList(resourceEntryList);
            }
            catch (IllegalArgumentException | SecurityException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        this.matcher = null;
        super.collectionProcessComplete();
    }
}

