/*
 * Decompiled with CFR 0.152.
 */
package org.ohnlp.ae.medxn;

import de.julielab.jcore.types.medical.Medication;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.cas.FSArray;

public class MedNormAnnotator
extends JCasAnnotator_ImplBase {
    public void process(JCas jcas) throws AnalysisEngineProcessException {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        for (Medication medication : indexes.getAnnotationIndex(Medication.type)) {
        }
    }

    protected String normalizeDrug(Medication med, FSArray attrs) {
        String strength = "";
        String doseForm = "";
        String route = "";
        String time = "";
        String volume = "";
        if (!doseForm.equals("")) {
            if ((doseForm.toLowerCase().startsWith("tab") || doseForm.toLowerCase().startsWith("cap")) && (route.toLowerCase().equals("mouth") || route.toLowerCase().equals("oral") || route.toLowerCase().replaceAll("\\.", "").equals("po"))) {
                doseForm = "oral " + doseForm;
            }
            if (doseForm.toLowerCase().endsWith("tab")) {
                doseForm = doseForm + "let";
            } else if (doseForm.toLowerCase().endsWith("tabs")) {
                doseForm = doseForm.replaceAll("tabs", "tablet");
            } else if (doseForm.toLowerCase().endsWith("cap")) {
                doseForm = doseForm + "sule";
            } else if (doseForm.toLowerCase().endsWith("caps")) {
                doseForm = doseForm.replaceAll("caps", "capsule");
            }
        }
        String bn = "";
        String in = "";
        String inRxType = "";
        boolean isMerged = false;
        String normDrug = "";
        if (isMerged) {
            normDrug = in + "<" + inRxType + ">" + strength.replaceAll("(\\d+,)?\\d+(\\.\\d+)?", "$0 ").replaceAll("-", "") + "<st>" + doseForm + "<df>" + bn + "<bn>";
        }
        normDrug = normDrug.toLowerCase().replaceAll("\\s{2,}", " ");
        return normDrug;
    }
}

