/*
 * Decompiled with CFR 0.152.
 */
package org.ohnlp.ae.medxn;

import de.julielab.jcore.types.medical.GeneralAttributeMention;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;

public class MedAttrAnnotator
extends JCasAnnotator_ImplBase {
    public static final String REGEX_FILE = "regExPatterns";
    public static final String ALLOW_MULT_ANNO = "multipleAnnotations";
    private Map<String, List<String>> regExPat;
    private Boolean multAnno = false;

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        super.initialize(uimaContext);
        this.regExPat = new HashMap<String, List<String>>();
        try {
            InputStream in = this.getContext().getResourceAsStream(REGEX_FILE);
            this.regExPat = this.getRegEx(in);
        }
        catch (ResourceAccessException e) {
            e.printStackTrace();
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        String docText = jcas.getDocumentText();
        this.addToJCas2(jcas, this.removeOverlap(this.getAttribute2(docText)));
    }

    protected void addToJCas2(JCas jcas, List<Attribute> annot) {
        for (Attribute attr : annot) {
            GeneralAttributeMention gam = new GeneralAttributeMention(jcas);
            gam.setTag(attr.tag);
            gam.setBegin(attr.begin);
            gam.setEnd(attr.end);
            gam.addToIndexes();
        }
    }

    protected List<Attribute> getAttribute2(String text) {
        ArrayList<Attribute> ret = new ArrayList<Attribute>();
        for (String tag : this.regExPat.keySet()) {
            int gnum = 0;
            String aTag = tag;
            if (tag.contains("%")) {
                String[] toks = tag.split("%");
                aTag = toks[0];
                gnum = Integer.parseInt(toks[1]);
            }
            for (String regex : this.regExPat.get(tag)) {
                Pattern p = Pattern.compile(regex, 258);
                Matcher m = p.matcher(text);
                while (m.find()) {
                    Attribute attr = new Attribute();
                    attr.tag = aTag;
                    String tText = m.group(gnum);
                    if (tText.length() == 0) continue;
                    boolean hasEndSpace = Character.isWhitespace(tText.charAt(tText.length() - 1));
                    if (hasEndSpace) {
                        tText = tText.substring(0, tText.length() - 1);
                    }
                    attr.text = tText;
                    attr.begin = m.start(gnum);
                    attr.end = m.end(gnum);
                    if (hasEndSpace) {
                        --attr.end;
                    }
                    ret.add(attr);
                }
            }
        }
        return ret;
    }

    protected List<Attribute> removeOverlap(List<Attribute> attr) {
        ArrayList<Attribute> ret = new ArrayList<Attribute>();
        ArrayList<Attribute> tmp = new ArrayList<Attribute>();
        HashSet<String> spans = new HashSet<String>();
        for (Attribute a : attr) {
            String span = a.tag + "|" + a.begin + "|" + a.end;
            if (spans.contains(span)) continue;
            spans.add(span);
            tmp.add(a);
        }
        for (int i = 0; i < tmp.size(); ++i) {
            boolean isOverlap = false;
            for (int j = 0; j < tmp.size(); ++j) {
                if (i == j || this.multAnno.booleanValue() && !((Attribute)tmp.get((int)i)).tag.equals(((Attribute)tmp.get((int)j)).tag) || ((Attribute)tmp.get((int)i)).begin < ((Attribute)tmp.get((int)j)).begin || ((Attribute)tmp.get((int)i)).end > ((Attribute)tmp.get((int)j)).end) continue;
                isOverlap = true;
                break;
            }
            if (isOverlap) continue;
            ret.add((Attribute)tmp.get(i));
        }
        return ret;
    }

    protected Map<String, List<String>> getRegEx(InputStream input) {
        HashMap<String, List<String>> regexMap = new HashMap<String, List<String>>();
        if (input != null) {
            try {
                BufferedReader fin = new BufferedReader(new InputStreamReader(input));
                String line = "";
                HashMap<String, String> varMap = new HashMap<String, String>();
                while ((line = fin.readLine()) != null) {
                    if (line.startsWith("#") || line.length() == 0 || Character.isWhitespace(line.charAt(0))) continue;
                    if (line.startsWith("@")) {
                        String[] toks = line.split("::");
                        String var = toks[0].trim();
                        String val = toks[1].trim();
                        varMap.put(var, val);
                        continue;
                    }
                    String[] strs = line.split("::");
                    String tag = strs[0].trim();
                    String patStr = strs[1].trim();
                    for (String s : varMap.keySet()) {
                        patStr = patStr.replaceAll(s, (String)varMap.get(s));
                    }
                    ArrayList<String> regexList = (ArrayList<String>)regexMap.get(tag);
                    if (regexList == null) {
                        regexList = new ArrayList<String>();
                    }
                    regexList.add(patStr);
                    regexMap.put(tag, regexList);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return regexMap;
    }

    class Attribute {
        String tag;
        String text;
        int begin;
        int end;

        Attribute() {
        }
    }
}

