/*
 * Decompiled with CFR 0.152.
 */
package org.ohnlp.ae.medxn;

import de.julielab.jcore.types.Sentence;
import de.julielab.jcore.types.medical.Dose;
import de.julielab.jcore.types.medical.Duration;
import de.julielab.jcore.types.medical.Frequency;
import de.julielab.jcore.types.medical.GeneralAttributeMention;
import de.julielab.jcore.types.medical.Medication;
import de.julielab.jcore.types.medical.Modus;
import de.julielab.jcore.utility.JCoReAnnotationTools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;

public class MedExtAnnotator
extends JCasAnnotator_ImplBase {
    public static final int SENT_WINDOW_SPAN = 3;
    public static final int SENT_WINDOW_SPAN_DUR = 1;
    Set<String> bogusMed;

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        block5: {
            super.initialize(uimaContext);
            this.bogusMed = new HashSet<String>();
            try {
                InputStream in = this.getContext().getResourceAsStream("falseMedDict");
                if (in == null) break block5;
                try {
                    BufferedReader fin = new BufferedReader(new InputStreamReader(in));
                    String line = "";
                    while ((line = fin.readLine()) != null) {
                        if (line.startsWith("#") || line.length() == 0 || Character.isWhitespace(line.charAt(0))) continue;
                        this.bogusMed.add(line.toLowerCase().trim());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (ResourceAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator medItr = indexes.getAnnotationIndex(Medication.type).iterator();
        ArrayList<Medication> drugs = new ArrayList<Medication>();
        while (medItr.hasNext()) {
            Medication med = (Medication)medItr.next();
            boolean addFlag = true;
            if (drugs.size() == 0) {
                drugs.add(med);
                continue;
            }
            for (int i = 0; i < drugs.size(); ++i) {
                Medication x = (Medication)drugs.get(i);
                int condition = this.contains(med.getBegin(), med.getEnd(), x.getBegin(), x.getEnd());
                if (condition == 1) {
                    drugs.remove(i);
                    --i;
                    continue;
                }
                if (condition != 2) continue;
                addFlag = false;
                break;
            }
            if (!addFlag) continue;
            drugs.add(med);
        }
        String docText = jcas.getDocumentText();
        Integer drug_id = 1;
        Integer attr_id = 1;
        int prevDrugEnd = 0;
        HashMap<GeneralAttributeMention, Boolean> usedAttributes = new HashMap<GeneralAttributeMention, Boolean>();
        for (int i = 0; i < drugs.size(); ++i) {
            int nextDrugBegin;
            Medication nextDrug;
            Medication actMed = (Medication)drugs.get(i);
            if (i == drugs.size() - 1) {
                nextDrug = null;
                nextDrugBegin = Integer.MAX_VALUE;
            } else {
                nextDrug = (Medication)drugs.get(i + 1);
                nextDrugBegin = nextDrug.getBegin();
            }
            int[] span = this.setWindow(jcas, actMed, nextDrugBegin, prevDrugEnd, 3);
            prevDrugEnd = actMed.getEnd();
            FSIterator gamItr = indexes.getAnnotationIndex(GeneralAttributeMention.type).iterator();
            GeneralAttributeMention beforeMedAttr = null;
            HashMap<String, ArrayList<GeneralAttributeMention>> attrMap = new HashMap<String, ArrayList<GeneralAttributeMention>>();
            ArrayList<GeneralAttributeMention> durList = new ArrayList<GeneralAttributeMention>();
            int cnt = 0;
            while (gamItr.hasNext()) {
                GeneralAttributeMention gam = (GeneralAttributeMention)gamItr.next();
                if (gam.getTag().equals("duration")) {
                    durList.add(gam);
                    continue;
                }
                if (gam.getBegin() >= span[0] && gam.getEnd() <= span[1]) {
                    this.assignAttribute(gam, attrMap, usedAttributes);
                    ++cnt;
                }
                if (cnt != 0) continue;
                beforeMedAttr = gam;
            }
            span = this.setWindow(jcas, actMed, nextDrugBegin, prevDrugEnd, 1);
            for (GeneralAttributeMention dur : durList) {
                if (dur.getBegin() >= span[0] && dur.getEnd() <= span[1]) {
                    this.assignAttribute(dur, attrMap, usedAttributes);
                    ++cnt;
                }
                if (cnt != 0) continue;
                beforeMedAttr = dur;
            }
            Integer n = drug_id;
            Integer n2 = drug_id = Integer.valueOf(drug_id + 1);
            attr_id = this.setUpMedictation(actMed, n, attrMap, attr_id, jcas);
        }
    }

    private Integer setUpMedictation(Medication actMed, Integer drug_id, Map<String, ArrayList<GeneralAttributeMention>> attrMap, Integer attr_id, JCas jcas) {
        actMed.setId(String.format("T%1$d", drug_id));
        for (String attr : attrMap.keySet()) {
            ArrayList<GeneralAttributeMention> gamList = attrMap.get(attr);
            FSArray attrArray = new FSArray(jcas, gamList.size());
            switch (attr) {
                case "duration": {
                    Integer n;
                    Integer n2;
                    GeneralAttributeMention gam;
                    int i;
                    for (i = 0; i < gamList.size(); ++i) {
                        gam = gamList.get(i);
                        Duration dur = new Duration(jcas);
                        dur.setBegin(gam.getBegin());
                        dur.setEnd(gam.getEnd());
                        dur.setId(String.format("T%1$d%2$d", drug_id, attr_id));
                        dur.setSpecificType("Duration");
                        dur.addToIndexes();
                        attrArray.set(i, (FeatureStructure)dur);
                        n2 = attr_id;
                        n = attr_id = Integer.valueOf(attr_id + 1);
                    }
                    attrArray.addToIndexes();
                    actMed.setDuration(attrArray);
                    break;
                }
                case "dosage": {
                    Integer n;
                    Integer n2;
                    GeneralAttributeMention gam;
                    int i;
                    for (i = 0; i < gamList.size(); ++i) {
                        gam = gamList.get(i);
                        Dose dos = new Dose(jcas);
                        dos.setBegin(gam.getBegin());
                        dos.setEnd(gam.getEnd());
                        dos.setId(String.format("T%1$d%2$d", drug_id, attr_id));
                        dos.setSpecificType("Dose");
                        dos.addToIndexes();
                        attrArray.set(i, (FeatureStructure)dos);
                        n2 = attr_id;
                        n = attr_id = Integer.valueOf(attr_id + 1);
                    }
                    attrArray.addToIndexes();
                    actMed.setDose(attrArray);
                    break;
                }
                case "route": {
                    Integer n;
                    Integer n2;
                    GeneralAttributeMention gam;
                    int i;
                    for (i = 0; i < gamList.size(); ++i) {
                        gam = gamList.get(i);
                        Modus mod = new Modus(jcas);
                        mod.setBegin(gam.getBegin());
                        mod.setEnd(gam.getEnd());
                        mod.setId(String.format("T%1$d%2$d", drug_id, attr_id));
                        mod.setSpecificType("Modus");
                        mod.addToIndexes();
                        attrArray.set(i, (FeatureStructure)mod);
                        n2 = attr_id;
                        n = attr_id = Integer.valueOf(attr_id + 1);
                    }
                    attrArray.addToIndexes();
                    actMed.setModus(attrArray);
                    break;
                }
                case "frequency": {
                    Integer n;
                    Integer n2;
                    GeneralAttributeMention gam;
                    int i;
                    for (i = 0; i < gamList.size(); ++i) {
                        gam = gamList.get(i);
                        Frequency freq = new Frequency(jcas);
                        freq.setBegin(gam.getBegin());
                        freq.setEnd(gam.getEnd());
                        freq.setId(String.format("T%1$d%2$d", drug_id, attr_id));
                        freq.setSpecificType("Frequency");
                        freq.addToIndexes();
                        attrArray.set(i, (FeatureStructure)freq);
                        n2 = attr_id;
                        n = attr_id = Integer.valueOf(attr_id + 1);
                    }
                    attrArray.addToIndexes();
                    actMed.setFrequency(attrArray);
                    break;
                }
                case "strength": {
                    break;
                }
            }
        }
        return attr_id;
    }

    private void assignAttribute(GeneralAttributeMention gam, Map<String, ArrayList<GeneralAttributeMention>> attrMap, Map<GeneralAttributeMention, Boolean> usedAttributes) {
        String gamType = gam.getTag();
        if (!usedAttributes.containsKey(gam) || !usedAttributes.get(gam).booleanValue()) {
            if (!attrMap.containsKey(gamType)) {
                ArrayList vals = new ArrayList();
                attrMap.put(gamType, vals);
            }
            attrMap.get(gamType).add(gam);
            usedAttributes.put(gam, true);
        }
    }

    protected int[] setWindow(JCas jcas, Medication drug, int nextDrugBegin, int prevDrugEnd, int windowSpan) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator senItr = indexes.getAnnotationIndex(Sentence.type).iterator();
        Sentence drugsen = (Sentence)JCoReAnnotationTools.getIncludingAnnotation((JCas)jcas, (Annotation)drug, Sentence.class);
        int drugSenBegin = drugsen.getBegin();
        int drugSenEnd = drugsen.getEnd();
        int[] ret = new int[]{-1, -1};
        ret[0] = drugSenBegin;
        ret[1] = drugSenEnd;
        int InstructionBegin = -1;
        int IndicationBegin = -1;
        int cnt = 0;
        while (senItr.hasNext() && cnt < windowSpan) {
            Sentence sen = (Sentence)senItr.next();
            if (sen.getBegin() <= drug.getEnd()) continue;
            ++cnt;
            ret[1] = sen.getEnd();
            if (sen.getCoveredText().startsWith("Instruction")) {
                InstructionBegin = sen.getBegin();
                continue;
            }
            if (!sen.getCoveredText().startsWith("Indication")) continue;
            IndicationBegin = sen.getBegin();
        }
        ret[0] = ret[0] < prevDrugEnd ? prevDrugEnd : ret[0];
        ret[1] = ret[1] > nextDrugBegin ? nextDrugBegin : ret[1];
        return ret;
    }

    protected boolean isFalseMed1(String med) {
        if (this.bogusMed.contains(med.toLowerCase().replaceAll("\\W", " "))) {
            if (Character.isLowerCase(med.charAt(0))) {
                return true;
            }
            if (med.equals("Ms")) {
                return true;
            }
        }
        return false;
    }

    protected int contains(int b1, int e1, int b2, int e2) {
        if (b1 <= b2 && e1 >= e2) {
            return 1;
        }
        if (b2 <= b1 && e2 >= e1) {
            return 2;
        }
        return 0;
    }

    class MedDesc {
        List<GeneralAttributeMention> attrs = new ArrayList<GeneralAttributeMention>();

        MedDesc() {
        }
    }
}

