/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.opennlp.sentence;

import de.julielab.jcore.types.Sentence;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.util.Span;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentenceAnnotator
extends JCasAnnotator_ImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentenceAnnotator.class);
    private static final String COMPONENT_ID = "de.julielab.jcore.ae.opennlp.sentence.OpenNLPSentenceDetector";
    private SentenceDetectorME sentenceSplitter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        InputStream is;
        LOGGER.info("initializing OpenNLP Sentence Annotator ...");
        super.initialize(aContext);
        String modelFilename = "";
        Object o = aContext.getConfigParameterValue("modelFile");
        if (o == null) {
            LOGGER.error("[OpenNLP Sentence Annotator] descriptor incomplete, no model file specified!");
            throw new ResourceInitializationException();
        }
        modelFilename = (String)o;
        LOGGER.debug("[OpenNLP Sentence Annotator] Reading sentence model...");
        File modelFile = new File(modelFilename);
        if (!modelFile.exists()) {
            Object resourceLocation = modelFilename.startsWith("/") ? modelFilename : "/" + modelFilename;
            is = ((Object)((Object)this)).getClass().getResourceAsStream((String)resourceLocation);
        } else {
            try {
                is = new FileInputStream(modelFile);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("[OpenNLP Sentence Annotator] Sentence model {} not found.", (Object)modelFile.getAbsolutePath());
                throw new ResourceInitializationException();
            }
        }
        try {
            SentenceModel model = new SentenceModel(is);
            this.sentenceSplitter = new SentenceDetectorME(model);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("[OpenNLP Sentence Annotator] Error while opening sentence model {}. . Sentence Annotations will not be done.", (Object)modelFile);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void process(JCas aJCas) {
        int i;
        LOGGER.info(" [OpenNLP Sentence Annotator] processing document ...");
        String text = aJCas.getDocumentText();
        Span[] sentenceOffsets = this.sentenceSplitter.sentPosDetect(text);
        for (i = 0; i < sentenceOffsets.length; ++i) {
        }
        for (i = 0; i < sentenceOffsets.length; ++i) {
            Sentence sentence = new Sentence(aJCas, sentenceOffsets[i].getStart(), sentenceOffsets[i].getEnd());
            sentence.setComponentId(COMPONENT_ID);
            sentence.addToIndexes();
        }
    }
}

