/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.ppd;

import de.julielab.jcore.types.Sentence;
import de.julielab.jcore.types.Token;
import de.julielab.jcore.utility.JCoReAnnotationTools;
import de.julielab.jcore.utility.JCoReFeaturePath;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ResourceMetaData(name="JCoRe PPD Writer", description="This component writes CAS annotation data to the pipe-separated format. For example, writing tokens with their PoS would result in text like 'The|DET tree|NN is|VBZ green|ADJ'. The component can be configured for an arbitrary number of annotations to be added to each token.")
@TypeCapability(inputs={"de.julielab.jcore.types.Token", "de.julielab.jcore.types.Sentence"})
public class PPDWriter
extends JCasAnnotator_ImplBase {
    private static final Logger log = LoggerFactory.getLogger(PPDWriter.class);
    public static final String PARAM_TYPE_LABEL_MAPPINGS = "TypeToLabelMappings";
    public static final String PARAM_META_DATA_TYPE_MAPPINGS = "MetaDataTypesMapping";
    public static final String PARAM_OUTSIDE_LABEL = "OutsideLabel";
    public static final String PARAM_OUTPUT_FILE = "OutputFile";
    @ConfigurationParameter(name="TypeToLabelMappings", mandatory=true, description="A parameter to define one or multiple mappings from a UIMA type to token labels/classes. A token that is completely overlapped by one of the UIMA types defined in the mapping will be given the mapped label in the PPD output. The format is [qualified type]=[label string / feature path]. I.e. you may map a type to a simple label string or you can read the actual label value from within the type. Examples: \"de.julielab.jcore.types.Gene=GENE\". This would give all tokens that are complete covered by a Gene annotation the label \"GENE\" in the PPD output. The mapping \"de.julielab.jcore.types.Gene=/specificType\" would use the value of the \"specificType\" feature of a Gene annotation as the label for the covered tokens in the PPD output.")
    private String[] typeToLabelMappings;
    @ConfigurationParameter(name="MetaDataTypesMapping", mandatory=false, description="A parameter to define one or multiple mappings from a UIMA type to token meta data in the PPD output. The minimal form of the PPD output is \"token|label\", e.g. \"il-2|Gene\". Additionally, you may deliver as much information as desired, e.g. the part of speech tag: \"il-2|NN|Gene\". This is done by defining meta data mappings with this parameter. The mapping has the form \"[qualified type]=[feature path]\", for example \"de.julielab.jcore.types.PennBioIEPOSTag=/value\". This will use the feature \"value\" to fill in the respective meta data slot in the PPD output. The order in which multiple meta data information is written into the PPD is the order you specify in this mapping array.")
    private String[] metaDataTypeMappings;
    @ConfigurationParameter(name="OutsideLabel", mandatory=true, defaultValue={"O"}, description="The label for all tokens that do not belong to a class of interest. All tokens not covered by at least one UIMA type defined in the TypeToLabelMappings parameter will get this outside label in the PPD output. The default value is \"O\".")
    private String outsideLabel;
    @ConfigurationParameter(name="OutputFile", mandatory=true, description="The path where the output PPD file should be written to.")
    private String outputFileString;
    private Map<Class<? extends Annotation>, String> typeToLabelMap;
    private Map<Class<? extends Annotation>, JCoReFeaturePath> typeToFeaturePathMap;
    private LinkedHashMap<Class<? extends Annotation>, JCoReFeaturePath> metaDataFeaturePathMap;
    private List<String> ppdSentences;
    private File outputFile;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.typeToLabelMappings = (String[])aContext.getConfigParameterValue(PARAM_TYPE_LABEL_MAPPINGS);
        Object configValue = aContext.getConfigParameterValue(PARAM_META_DATA_TYPE_MAPPINGS);
        if (null != configValue) {
            this.metaDataTypeMappings = (String[])configValue;
        }
        this.outsideLabel = (String)aContext.getConfigParameterValue(PARAM_OUTSIDE_LABEL);
        this.outputFileString = (String)aContext.getConfigParameterValue(PARAM_OUTPUT_FILE);
        try {
            this.initializeLabelMaps(this.typeToLabelMappings);
            this.initializeMetaDataMap(this.metaDataTypeMappings);
        }
        catch (CASException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        this.ppdSentences = new ArrayList<String>();
        this.outputFile = new File(this.outputFileString);
        if (this.outputFile.exists()) {
            log.warn("PPD output file {} exists and will be overwritten.", (Object)this.outputFile.getAbsolutePath());
            this.outputFile.delete();
        }
    }

    private void initializeMetaDataMap(String[] metaDataTypeMappings) throws CASException {
        this.metaDataFeaturePathMap = new LinkedHashMap();
        for (String metaDataFeaturePathMapping : metaDataTypeMappings) {
            Class<?> type;
            String[] split = metaDataFeaturePathMapping.split("=");
            if (split.length != 2) {
                throw new IllegalArgumentException("The meta data mapping \"" + metaDataFeaturePathMapping + "\" is not consistent with the expected format \"[qualified type]=[feature path]\" because it does not contain a single equal sign.");
            }
            String typeString = split[0].trim();
            String featurePathString = split[1].trim();
            try {
                type = Class.forName(typeString);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("The type \"" + typeString + "\" that was given in the meta data type mapping does not exist.");
            }
            if (!featurePathString.startsWith("/")) {
                throw new IllegalArgumentException("The value of the meta data feature path mapping \"" + metaDataFeaturePathMapping + "\" is not accepted as a feature path because it does not start with a slash.");
            }
            JCoReFeaturePath featurePath = new JCoReFeaturePath();
            featurePath.initialize(featurePathString);
            this.metaDataFeaturePathMap.put(type, featurePath);
        }
    }

    private void initializeLabelMaps(String[] typeToLabelMappings) throws CASException {
        this.typeToLabelMap = new HashMap<Class<? extends Annotation>, String>();
        this.typeToFeaturePathMap = new HashMap<Class<? extends Annotation>, JCoReFeaturePath>();
        for (String typeLabelMapping : typeToLabelMappings) {
            Class<?> type;
            String[] split = typeLabelMapping.split("=");
            if (split.length != 2) {
                throw new IllegalArgumentException("The type to label mapping \"" + typeLabelMapping + "\" is not consistent with the expected format \"[qualified type]=[label string / feature path]\" because it does not contain a single equal sign.");
            }
            String typeString = split[0].trim();
            String value = split[1].trim();
            try {
                type = Class.forName(typeString);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("The type \"" + typeString + "\" that was given in the type to label mapping does not exist.");
            }
            if (value.startsWith("/")) {
                JCoReFeaturePath featurePath = new JCoReFeaturePath();
                featurePath.initialize(value);
                this.typeToFeaturePathMap.put(type, featurePath);
                continue;
            }
            this.typeToLabelMap.put(type, value);
        }
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        FSIterator sentenceIt = aJCas.getAnnotationIndex(Sentence.type).iterator();
        while (sentenceIt.hasNext()) {
            StringBuilder sb = new StringBuilder();
            Sentence sentence = (Sentence)sentenceIt.next();
            for (Token token : JCoReAnnotationTools.getIncludedAnnotations((JCas)aJCas, (Annotation)sentence, Token.class)) {
                Annotation includingAnnotation;
                sb.append(token.getCoveredText());
                sb.append("|");
                for (Map.Entry<Class<? extends Annotation>, JCoReFeaturePath> entry : this.metaDataFeaturePathMap.entrySet()) {
                    Class<? extends Annotation> metaDataType = entry.getKey();
                    JCoReFeaturePath featurePath = entry.getValue();
                    Annotation metaDataAnnotation = JCoReAnnotationTools.getAnnotationAtMatchingOffsets((JCas)aJCas, (Annotation)token, metaDataType);
                    String metaData = "<N/A>";
                    if (null != metaDataAnnotation) {
                        metaData = featurePath.getValueAsString((FeatureStructure)metaDataAnnotation);
                    } else {
                        log.warn("MetaData annotation for type \"{}\" for token {} does not exist.", (Object)metaDataType.getCanonicalName(), (Object)token);
                    }
                    sb.append(metaData);
                    sb.append("|");
                }
                ArrayList<Class<? extends Annotation>> labelAnnotations = new ArrayList<Class<? extends Annotation>>(1);
                for (Class<? extends Annotation> labelType : this.typeToLabelMap.keySet()) {
                    includingAnnotation = JCoReAnnotationTools.getIncludingAnnotation((JCas)aJCas, (Annotation)token, labelType);
                    if (null == includingAnnotation) continue;
                    labelAnnotations.add(labelType);
                    String label = this.typeToLabelMap.get(labelType);
                    sb.append(label);
                }
                for (Class<? extends Annotation> labelType : this.typeToFeaturePathMap.keySet()) {
                    includingAnnotation = JCoReAnnotationTools.getIncludingAnnotation((JCas)aJCas, (Annotation)token, labelType);
                    if (null == includingAnnotation) continue;
                    labelAnnotations.add(labelType);
                    JCoReFeaturePath featurePath = this.typeToFeaturePathMap.get(labelType);
                    String label = featurePath.getValueAsString((FeatureStructure)includingAnnotation);
                    sb.append(label);
                }
                if (labelAnnotations.size() > 1) {
                    throw new IllegalStateException("Multiple label types for token " + token + " have been found. However, it can be at most one. Found label types are:" + StringUtils.join(labelAnnotations, (String)", "));
                }
                if (labelAnnotations.size() == 0) {
                    sb.append(this.outsideLabel);
                }
                sb.append(" ");
            }
            sb.deleteCharAt(sb.length() - 1);
            this.ppdSentences.add(sb.toString());
        }
    }

    public void batchProcessComplete() throws AnalysisEngineProcessException {
        super.batchProcessComplete();
        try {
            log.debug("Batch process complete, writing {} PPD sentences to {}.", (Object)this.ppdSentences.size(), (Object)this.outputFile.getAbsolutePath());
            this.writePPDToFile(this.outputFile);
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        try {
            log.debug("Collection process complete, writing {} PPD sentences to {}.", (Object)this.ppdSentences.size(), (Object)this.outputFile.getAbsolutePath());
            this.writePPDToFile(this.outputFile);
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    private void writePPDToFile(File outputFile) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile, true), StandardCharsets.UTF_8));){
            for (String sentence : this.ppdSentences) {
                bw.write(sentence);
                bw.newLine();
            }
        }
        this.ppdSentences.clear();
    }
}

