/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JeDISVTDGraphNode {
    protected int vtdIndex;
    protected long elementFragment;
    protected Integer oldXmiId;
    protected Integer newXmiId;
    protected Set<String> annotationModuleLabels = Collections.emptySet();
    protected int sofaXmiId;
    protected String typeName;
    protected List<JeDISVTDGraphNode> predecessors = Collections.emptyList();
    private Map<String, List<Integer>> referencedXmiIds = Collections.emptyMap();

    public JeDISVTDGraphNode(Integer oldXmiId) {
        this();
        this.oldXmiId = oldXmiId;
    }

    public JeDISVTDGraphNode() {
    }

    public String toString() {
        return "JeDISVTDGraphNode{oldXmiId=" + this.oldXmiId + ", annotationModuleLabels=" + this.annotationModuleLabels + ", typeName='" + this.typeName + '\'' + '}';
    }

    public long getElementFragment() {
        return this.elementFragment;
    }

    public void setElementFragment(long elementFragment) {
        this.elementFragment = elementFragment;
    }

    public int getByteOffset() {
        return (int)this.elementFragment;
    }

    public int getByteLength() {
        return (int)(this.elementFragment >> 32);
    }

    public int getVtdIndex() {
        return this.vtdIndex;
    }

    public void setVtdIndex(int vtdIndex) {
        this.vtdIndex = vtdIndex;
    }

    public Integer getOldXmiId() {
        return this.oldXmiId;
    }

    public void setOldXmiId(Integer oldXmiId) {
        this.oldXmiId = oldXmiId;
    }

    public Integer getNewXmiId() {
        return this.newXmiId;
    }

    public void setNewXmiId(Integer newXmiId) {
        this.newXmiId = newXmiId;
    }

    public Set<String> getAnnotationModuleLabels() {
        return this.annotationModuleLabels;
    }

    public void setAnnotationModuleLabels(Set<String> annotationModuleLabels) {
        this.annotationModuleLabels = annotationModuleLabels;
    }

    public int getSofaXmiId() {
        return this.sofaXmiId;
    }

    public void setSofaXmiId(int sofaXmiId) {
        this.sofaXmiId = sofaXmiId;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public List<JeDISVTDGraphNode> getPredecessors() {
        return this.predecessors;
    }

    public void setPredecessors(List<JeDISVTDGraphNode> predecessors) {
        this.predecessors = predecessors;
    }

    public void addPredecessor(JeDISVTDGraphNode referencingNode) {
        if (this.predecessors.isEmpty()) {
            this.predecessors = new ArrayList<JeDISVTDGraphNode>();
        }
        this.predecessors.add(referencingNode);
    }

    public void addAnnotationModuleLabel(String typeName) {
        if (this.annotationModuleLabels.isEmpty()) {
            this.annotationModuleLabels = new HashSet<String>();
        }
        this.annotationModuleLabels.add(typeName);
    }

    public void addAnnotationModuleLabels(Set<String> labels) {
        labels.forEach(this::addAnnotationModuleLabel);
    }

    public Map<String, List<Integer>> getReferencedXmiIds() {
        return this.referencedXmiIds;
    }

    public void setReferencedXmiIds(Map<String, List<Integer>> referencedXmiIds) {
        this.referencedXmiIds = referencedXmiIds;
    }
}

