/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xml;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import de.julielab.xml.StorageElement;
import de.julielab.xml.XmiSplitUtilities;
import de.julielab.xml.XmiSplitter;
import de.julielab.xml.XmiSplitterResult;
import de.julielab.xml.util.XMISplitterException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.jcas.JCas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaxXmiSplitter
implements XmiSplitter {
    private static final Logger log = LoggerFactory.getLogger(StaxXmiSplitter.class);
    private static final XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private static final XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
    private static final XMLEventFactory eventFactory = XMLEventFactory.newInstance();
    private static final QName xmiIdQName = new QName("http://www.omg.org/XMI", "id");
    private static final QName elementsQName = new QName("", "elements");
    private static final QName invalidElementQName = new QName("http://de.julielab/xmi/splitter", "invalidElement");
    private boolean storeAll = false;
    private List<String> annotationModulesToExtract;
    private Set<String> elementsToStoreSet;
    private boolean recursively = false;
    private boolean storeBaseDocument;
    private String docTableName;
    @Deprecated
    private String firstAnnotationType;
    @Deprecated
    private boolean docMode = false;
    private int othersCounter;
    private Map<Integer, String> currentSofaIdMap;
    private Map<String, Integer> originalSofaIdMap;
    private JCas cas;
    private Integer nextId;
    private Integer currentMaxXmiId;
    private Integer casNULLId;
    private Map<String, Map.Entry<XMLEventWriter, ByteArrayOutputStream>> writers;
    private StartElement xmiStartTag;
    private LinkedHashMap<String, ByteArrayOutputStream> xmiData;
    private Map<String, String> namespaces;
    private Set<String> dataWrittenSet;
    private boolean parametersChecked;
    private Set<String> baseDocumentAnnotations;

    public StaxXmiSplitter(List<String> annotationModulesToExtract, boolean recursively, boolean storeBaseDocument, String docTableName, Set<String> baseDocumentAnnotations, int attribute_size) {
        this(annotationModulesToExtract, recursively, storeBaseDocument, docTableName, baseDocumentAnnotations);
        inputFactory.setProperty("com.ctc.wstx.maxAttributeSize", attribute_size);
    }

    public StaxXmiSplitter(List<String> annotationModulesToExtract, boolean recursively, boolean storeBaseDocument, String docTableName, Set<String> baseDocumentAnnotations) {
        this.storeBaseDocument = storeBaseDocument;
        HashSet hashSet = this.baseDocumentAnnotations = baseDocumentAnnotations != null ? baseDocumentAnnotations : new HashSet();
        if (storeBaseDocument) {
            if (docTableName == null) {
                throw new IllegalStateException("If storeBaseDocument is set to true, the table name to store the base document has to be given!");
            }
            this.docTableName = docTableName;
            this.firstAnnotationType = this.firstAnnotationType;
            this.annotationModulesToExtract = new ArrayList<String>();
            this.annotationModulesToExtract.add(docTableName);
            for (String element : annotationModulesToExtract) {
                this.annotationModulesToExtract.add(element);
            }
            this.baseDocumentAnnotations.add("uima.cas.NULL");
            this.baseDocumentAnnotations.add("uima.tcas.DocumentAnnotation");
            this.baseDocumentAnnotations.add("uima.cas.Sofa");
        } else {
            this.annotationModulesToExtract = annotationModulesToExtract;
        }
        this.recursively = recursively;
        this.elementsToStoreSet = new HashSet<String>(annotationModulesToExtract);
        log.info(StaxXmiSplitter.class.getName() + " initialized.");
    }

    public StaxXmiSplitter(String tableName, int attribute_size) {
        this(tableName);
        inputFactory.setProperty("com.ctc.wstx.maxAttributeSize", attribute_size);
    }

    public StaxXmiSplitter(String tableName) {
        this.storeAll = true;
        this.annotationModulesToExtract = new ArrayList<String>();
        this.annotationModulesToExtract.add(tableName);
        log.info(StaxXmiSplitter.class.getName() + " initialized.");
    }

    @Override
    public XmiSplitterResult process(byte[] ba, JCas aCas, int nextPossibleId, Map<String, Integer> existingSofaIdMap) throws XMISplitterException {
        if (!this.parametersChecked) {
            this.checkParameters(aCas.getTypeSystem());
        }
        this.originalSofaIdMap = existingSofaIdMap;
        this.cas = aCas;
        this.nextId = nextPossibleId;
        this.currentMaxXmiId = nextPossibleId;
        this.xmiData = new LinkedHashMap();
        this.namespaces = new HashMap<String, String>();
        this.dataWrittenSet = new HashSet<String>();
        this.currentSofaIdMap = new HashMap<Integer, String>();
        if (this.storeAll) {
            this.determineMaxXmiId(ba);
        } else {
            this.storeSelected(ba);
        }
        return new XmiSplitterResult(this.xmiData, this.currentMaxXmiId + 1, this.namespaces, this.currentSofaIdMap);
    }

    private void checkParameters(TypeSystem typeSystem) {
        for (int i = 1; i < this.annotationModulesToExtract.size(); ++i) {
            String javaName = this.annotationModulesToExtract.get(i);
            if (typeSystem.getType(javaName) != null || !this.recursively) continue;
            throw new IllegalArgumentException("The type system does not contain the type \"" + javaName + "\". However, to be able to store referenced annotations recursively, the type system information is required.");
        }
    }

    public int determineMaxXmiId(byte[] ba) {
        ByteArrayInputStream currentBais = new ByteArrayInputStream(ba);
        try {
            XMLEventReader thisReader = inputFactory.createXMLEventReader(currentBais);
            while (thisReader.hasNext()) {
                int xmiId;
                StartElement element;
                Attribute xmiIdAtt;
                XMLEvent event = thisReader.nextEvent();
                if (!event.isStartElement() || (xmiIdAtt = (element = event.asStartElement()).getAttributeByName(xmiIdQName)) == null || (xmiId = Integer.parseInt(xmiIdAtt.getValue())) <= this.nextId) continue;
                this.nextId = xmiId;
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        Integer n = this.nextId;
        Integer n2 = this.nextId = Integer.valueOf(this.nextId + 1);
        return n;
    }

    private void storeSelected(byte[] bais) throws XMISplitterException {
        this.writers = new LinkedHashMap<String, Map.Entry<XMLEventWriter, ByteArrayOutputStream>>();
        this.xmiStartTag = null;
        if (this.storeBaseDocument) {
            this.docMode = true;
        }
        this.othersCounter = -1;
        HashMultimap xmiIdsToRetrieve = HashMultimap.create();
        LinkedHashMap<String, StorageElement> elementsToWrite = new LinkedHashMap<String, StorageElement>();
        HashMap<String, String> idMap = new HashMap<String, String>();
        HashMap<String, String> specialXmiIds = new HashMap<String, String>();
        HashSet<XMLEvent> specialElements = new HashSet<XMLEvent>();
        this.processAndParse(bais, (Multimap<String, String>)xmiIdsToRetrieve, elementsToWrite, idMap, specialXmiIds, specialElements);
    }

    private void processAndParse(byte[] ba, Multimap<String, String> xmiIdsToRetrieve, LinkedHashMap<String, StorageElement> elementsToWrite, HashMap<String, String> idMap, Map<String, String> specialXmiIds, Set<XMLEvent> specialElements) throws XMISplitterException {
        ByteArrayInputStream currentBais = new ByteArrayInputStream(ba);
        try {
            XMLEventReader reader = inputFactory.createXMLEventReader(currentBais);
            String enclosingElementName = "";
            Collection<String> enclosingStorageKey = Collections.emptyList();
            HashMap xmi2ElementType = new HashMap();
            boolean withinElement = false;
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                List<String> storageKey = Collections.emptyList();
                if (withinElement) {
                    if (event.isEndElement()) {
                        EndElementHandler endElementHandler = new EndElementHandler(event, enclosingElementName, enclosingStorageKey, elementsToWrite, withinElement).invoke();
                        enclosingElementName = endElementHandler.getEnclosingElementName();
                        enclosingStorageKey = endElementHandler.getEnclosingStorageKey();
                        withinElement = endElementHandler.isWithinElement();
                    } else if (event.isStartElement() || event.isCharacters()) {
                        StorageElement storageElement = new StorageElement(event, enclosingStorageKey);
                        this.checkStorageKeysNotEmpty(storageElement);
                        elementsToWrite.put(Integer.toString(this.othersCounter), storageElement);
                        --this.othersCounter;
                    }
                }
                if (!event.isStartElement()) continue;
                StartElementHandler startElementHandler = new StartElementHandler(event, xmiIdsToRetrieve, elementsToWrite, idMap, specialXmiIds, specialElements, enclosingElementName, withinElement, enclosingStorageKey, storageKey).invoke();
                enclosingElementName = startElementHandler.getEnclosingElementName();
                enclosingStorageKey = startElementHandler.getEnclosingStorageKey();
                withinElement = startElementHandler.isWithinElement();
            }
            reader.close();
            HashSet<String> oldXmiIdCollisions = new HashSet<String>();
            for (String oldXmiId : elementsToWrite.keySet()) {
                if (specialElements.contains(elementsToWrite.get(oldXmiId).getElement())) continue;
                String newXmiId = idMap.get(oldXmiId);
                if (!specialXmiIds.keySet().contains(newXmiId)) continue;
                oldXmiIdCollisions.add(oldXmiId);
                if (!log.isDebugEnabled()) continue;
                StorageElement storageElement = elementsToWrite.get(oldXmiId);
                XMLEvent o = null;
                if (storageElement != null && storageElement.getElement() != null) {
                    o = storageElement.getElement();
                }
                log.debug("Element \"{}\" with old XMI ID {} and new XMI ID {} collides with special XMI ID of element {} \"{}\"", new Object[]{o.asStartElement().getName().getLocalPart(), oldXmiId, newXmiId, specialXmiIds.get(newXmiId), elementsToWrite.get(newXmiId).getElement().asStartElement().getName().getLocalPart()});
            }
            for (String oldXmiId : oldXmiIdCollisions) {
                while (specialXmiIds.containsKey(String.valueOf(this.nextId))) {
                    this.nextId = this.nextId + 1;
                }
                idMap.put(oldXmiId, Integer.toString(this.nextId));
                log.debug("Giving element {} with old XMI ID {} new XMI ID: {}", new Object[]{elementsToWrite.get(oldXmiId).getElement().asStartElement().getName().getLocalPart(), oldXmiId, this.nextId});
                Integer n = this.nextId;
                Integer n2 = this.nextId = Integer.valueOf(this.nextId + 1);
            }
            if (!xmiIdsToRetrieve.isEmpty()) {
                this.docMode = false;
                currentBais = new ByteArrayInputStream(ba);
                this.processAndParse(ba, xmiIdsToRetrieve, elementsToWrite, idMap, specialXmiIds, specialElements);
            } else {
                this.removeLooseEdgesAndFS(elementsToWrite, idMap, this.cas.getTypeSystem());
                idMap.putAll(specialXmiIds);
                this.writeWithNewXmiIds(elementsToWrite, idMap);
            }
        }
        catch (XMLStreamException e) {
            throw new XMISplitterException(e);
        }
    }

    private void removeLooseEdgesAndFS(LinkedHashMap<String, StorageElement> elementsToWrite, Map<String, String> idMap, TypeSystem ts) {
        HashSet<String> looseXmiIds = new HashSet<String>();
        for (String xmiId : idMap.keySet()) {
            Type elementType;
            StorageElement storageElement = elementsToWrite.get(xmiId);
            XMLEvent event = storageElement.getElement();
            if (!event.isStartElement()) continue;
            StartElement element = event.asStartElement();
            try {
                elementType = ts.getType(storageElement.getElementTypeJavaName());
            }
            catch (NullPointerException e) {
                continue;
            }
            if (elementType == null || !XmiSplitUtilities.isFSArray(elementType)) continue;
            Attribute elementsAttribute = element.getAttributeByName(elementsQName);
            String[] xmiReferences = elementsAttribute.getValue().split("\\s+");
            int looseReferences = 0;
            for (String xmiReference : xmiReferences) {
                if (elementsToWrite.keySet().contains(xmiReference)) continue;
                looseXmiIds.add(xmiReference);
                ++looseReferences;
            }
            if (looseReferences != xmiReferences.length) continue;
            log.trace("Feature structure of type {} is an array type and all its elements are not on the output list. The feature structure is removed from the output list as well.", (Object)elementType);
            looseXmiIds.add(xmiId);
        }
        if (!looseXmiIds.isEmpty()) {
            log.debug("Found {} loose XMI ID references, including array types for which all references are missing. Removing the respective elements from the output list.", (Object)looseXmiIds.size());
            for (String looseXmiId : looseXmiIds) {
                idMap.remove(looseXmiId);
            }
            this.removeLooseEdgesAndFS(elementsToWrite, idMap, ts);
        }
    }

    private void recordReferencesForExtraction(Attribute attribute, Collection<String> storageKey, Multimap<String, String> xmiIdsToRetrieve, LinkedHashMap<String, StorageElement> elementsToWrite) {
        String value = attribute.getValue();
        String[] elements = this.splitElements(value);
        for (int i = 0; i < elements.length; ++i) {
            String referenceXmiId = elements[i];
            if (referenceXmiId.equals("")) continue;
            if (!elementsToWrite.containsKey(referenceXmiId)) {
                storageKey.forEach(key -> xmiIdsToRetrieve.put((Object)referenceXmiId, key));
                continue;
            }
            if (elementsToWrite.get(referenceXmiId).getStorageKeys().containsAll(storageKey)) continue;
            StorageElement storageElement = elementsToWrite.get(referenceXmiId);
            HashSet<String> storageElementStorageKey = new HashSet<String>(storageElement.getStorageKeys());
            if (this.elementsToStoreSet.contains(storageElement.getElementTypeJavaName())) continue;
            HashSet<String> currentStorageKey = new HashSet<String>(storageKey);
            Sets.SetView missingKeys = Sets.difference(currentStorageKey, storageElementStorageKey);
            storageElement.addStorageKeys((Collection<String>)missingKeys);
        }
    }

    private void writeWithNewXmiIds(LinkedHashMap<String, StorageElement> elementsToWrite, HashMap<String, String> idMap) {
        try {
            ArrayDeque<Collection<String>> storageKeyStack = new ArrayDeque<Collection<String>>();
            ArrayDeque<QName> validElementStack = new ArrayDeque<QName>();
            for (String id : elementsToWrite.keySet()) {
                StorageElement storageElement = elementsToWrite.get(id);
                this.checkStorageKeysNotEmpty(storageElement);
                if (Integer.parseInt(id) >= 0) {
                    if (!idMap.containsKey(id)) {
                        validElementStack.add(invalidElementQName);
                        continue;
                    }
                    StartElement element = storageElement.getElement().asStartElement();
                    String elementPrefix = storageElement.getElementPrefix();
                    String elementNSUri = storageElement.getElementNSUri();
                    String elementName = storageElement.getElementName();
                    String javaName = storageElement.getElementTypeJavaName();
                    validElementStack.add(element.getName());
                    Collection<String> storageKeys = storageElement.getStorageKeys();
                    storageKeyStack.add(storageKeys);
                    StartElement start = eventFactory.createStartElement(elementPrefix, elementNSUri, elementName);
                    for (String key : storageKeys) {
                        Attribute newAttribute;
                        String value;
                        String attributeNSUri;
                        String attributeName;
                        String attributePrefix;
                        QName attributeQName;
                        Attribute attribute;
                        XMLEventWriter tableWriter = this.writers.get(key).getKey();
                        tableWriter.add(start);
                        this.dataWrittenSet.addAll(storageKeys);
                        Iterator<Attribute> attributes = element.getAttributes();
                        Type annotationType = this.cas.getTypeSystem().getType(javaName);
                        if (annotationType != null) {
                            String[] elements;
                            if (XmiSplitUtilities.isFSArray(annotationType)) {
                                while (attributes.hasNext()) {
                                    attribute = attributes.next();
                                    attributeQName = attribute.getName();
                                    attributePrefix = attributeQName.getPrefix();
                                    attributeName = attributeQName.getLocalPart();
                                    attributeNSUri = attributeQName.getNamespaceURI();
                                    value = attribute.getValue();
                                    if (attributePrefix.equals("xmi") && attributeName.equals("id")) {
                                        value = Objects.requireNonNull(idMap.get(value));
                                        int xmiId = Integer.parseInt(value);
                                        if (this.currentMaxXmiId < xmiId) {
                                            this.currentMaxXmiId = xmiId;
                                        }
                                    } else {
                                        elements = this.splitElements(value);
                                        value = Stream.of(elements).filter(elementsToWrite::containsKey).map(idMap::get).filter(Objects::nonNull).collect(Collectors.joining(" "));
                                    }
                                    newAttribute = eventFactory.createAttribute(attributePrefix, attributeNSUri, attributeName, value);
                                    tableWriter.add(newAttribute);
                                }
                                continue;
                            }
                            if (XmiSplitUtilities.isFSArray(annotationType)) continue;
                            while (attributes.hasNext()) {
                                Integer referencedSofaXmiId;
                                String referencedSofaName;
                                Integer originalSofaXmiId;
                                attribute = attributes.next();
                                attributeQName = attribute.getName();
                                attributePrefix = attributeQName.getPrefix();
                                attributeName = attributeQName.getLocalPart();
                                attributeNSUri = attributeQName.getNamespaceURI();
                                value = attribute.getValue();
                                if (attributePrefix.equals("xmi") && attributeName.equals("id")) {
                                    value = elementName.toLowerCase().equals("sofa") ? value : Objects.requireNonNull(idMap.get(value));
                                    int xmiId = Integer.parseInt(value);
                                    if (this.currentMaxXmiId < xmiId) {
                                        this.currentMaxXmiId = xmiId;
                                    }
                                } else if (!XmiSplitUtilities.isPrimitive(annotationType, attributeName)) {
                                    elements = this.splitElements(value);
                                    value = Stream.of(elements).filter(elementsToWrite::containsKey).map(idMap::get).filter(Objects::nonNull).collect(Collectors.joining(" "));
                                } else if (attributeName.equals("sofa") && null != (originalSofaXmiId = this.originalSofaIdMap.get(referencedSofaName = this.currentSofaIdMap.get(referencedSofaXmiId = Integer.valueOf(Integer.parseInt(attribute.getValue())))))) {
                                    value = String.valueOf(originalSofaXmiId);
                                }
                                newAttribute = eventFactory.createAttribute(attributePrefix, attributeNSUri, attributeName, value);
                                tableWriter.add(newAttribute);
                            }
                            continue;
                        }
                        while (attributes.hasNext()) {
                            attribute = attributes.next();
                            attributeQName = attribute.getName();
                            attributePrefix = attributeQName.getPrefix();
                            attributeName = attributeQName.getLocalPart();
                            attributeNSUri = attributeQName.getNamespaceURI();
                            value = attribute.getValue();
                            newAttribute = eventFactory.createAttribute(attributePrefix, attributeNSUri, attributeName, value);
                            tableWriter.add(newAttribute);
                        }
                    }
                    continue;
                }
                if (Integer.parseInt(id) >= 0) continue;
                XMLEvent event = storageElement.getElement();
                Collection storageKeys = (Collection)storageKeyStack.peekLast();
                this.checkStorageKeysNotEmpty(storageElement);
                if (((QName)validElementStack.peekLast()).equals(invalidElementQName)) continue;
                for (String key : storageKeys) {
                    this.writers.get(key).getKey().add(event);
                }
                if (!event.isEndElement() || !event.asEndElement().getName().equals(validElementStack.peekLast())) continue;
                validElementStack.removeLast();
                storageKeyStack.removeLast();
            }
            this.finalizeWriters();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    private void checkStorageKeysNotEmpty(StorageElement storageElement) {
        assert (!storageElement.getStorageKeys().isEmpty()) : "XML element or text item " + storageElement.getElementName() + " should be extracted and stored but was not given any storage keys. This is a programming error.";
    }

    private void finalizeWriters() {
        for (String tableName : this.writers.keySet()) {
            if (!this.dataWrittenSet.contains(tableName)) continue;
            try {
                this.xmiData.put(tableName, this.writers.get(tableName).getValue());
                this.writers.get(tableName).getKey().close();
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        }
    }

    private Map.Entry<XMLEventWriter, ByteArrayOutputStream> getWriterEntry() {
        AbstractMap.SimpleEntry<XMLEventWriter, ByteArrayOutputStream> entry = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLEventWriter eventWriter = outputFactory.createXMLEventWriter(baos);
            entry = new AbstractMap.SimpleEntry<XMLEventWriter, ByteArrayOutputStream>(eventWriter, baos);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        return entry;
    }

    public void setAllJavaNames(ByteArrayInputStream bais) {
        String typesNSUri;
        block11: {
            typesNSUri = null;
            try {
                XMLEventReader reader = inputFactory.createXMLEventReader(bais);
                while (reader.hasNext()) {
                    XMLEvent event = reader.nextEvent();
                    if (!event.isStartElement()) continue;
                    StartElement element = event.asStartElement();
                    QName elementQName = element.getName();
                    String prefix = elementQName.getPrefix();
                    String elementName = elementQName.getLocalPart();
                    if (!(prefix.equals("xmi") & elementName.equals("XMI"))) continue;
                    Iterator<Namespace> namespaces = element.getNamespaces();
                    while (namespaces.hasNext()) {
                        Namespace ns = namespaces.next();
                        if (!(ns.getName().getPrefix().equals("xmlns") & ns.getName().getLocalPart().equals("types"))) continue;
                        typesNSUri = ns.getValue();
                        break block11;
                    }
                }
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        }
        if (typesNSUri != null) {
            String javaName;
            String typesJavaName = XmiSplitUtilities.convertNSUri(typesNSUri);
            if (!this.storeBaseDocument) {
                for (int i = 0; i < this.annotationModulesToExtract.size(); ++i) {
                    if (this.annotationModulesToExtract.get(i).contains(".")) continue;
                    javaName = typesJavaName + this.annotationModulesToExtract.get(i);
                    this.annotationModulesToExtract.set(i, javaName);
                }
            } else {
                for (int i = 1; i < this.annotationModulesToExtract.size(); ++i) {
                    if (this.annotationModulesToExtract.get(i).contains(".")) continue;
                    javaName = typesJavaName + this.annotationModulesToExtract.get(i);
                    this.annotationModulesToExtract.set(i, javaName);
                }
                if (!this.firstAnnotationType.contains(".")) {
                    this.firstAnnotationType = typesJavaName + this.firstAnnotationType;
                }
            }
        } else {
            log.warn("There are annotations that have not been given as the fully qualified java name, but this could not be retrieved from the types namespace. Table names might be in the wrong form!");
        }
    }

    private String[] splitElements(String elements) {
        String[] separateElements = elements.split(" ");
        return separateElements;
    }

    public List<String> getAnnotationsToStore() {
        if (!this.storeBaseDocument) {
            return this.annotationModulesToExtract;
        }
        ArrayList<String> annosWithoutBaseDocument = new ArrayList<String>();
        for (int i = 1; i < this.annotationModulesToExtract.size(); ++i) {
            annosWithoutBaseDocument.add(this.annotationModulesToExtract.get(i));
        }
        return annosWithoutBaseDocument;
    }

    public String getFirstAnnotationtype() {
        return this.firstAnnotationType;
    }

    static {
        outputFactory.setProperty("com.ctc.wstx.outputValidateStructure", Boolean.FALSE);
    }

    private class StartElementHandler {
        private XMLEvent event;
        private Multimap<String, String> xmiIdsToRetrieve;
        private LinkedHashMap<String, StorageElement> elementsToWrite;
        private HashMap<String, String> idMap;
        private Map<String, String> specialXmiIds;
        private Set<XMLEvent> specialElements;
        private String enclosingElementName;
        private boolean withinElement;
        private Collection<String> enclosingStorageKey;
        private Collection<String> storageKey;

        public StartElementHandler(XMLEvent event, Multimap<String, String> xmiIdsToRetrieve, LinkedHashMap<String, StorageElement> elementsToWrite, HashMap<String, String> idMap, Map<String, String> specialXmiIds, Set<XMLEvent> specialElements, String enclosingElementName, boolean withinElement, Collection<String> enclosingStorageKey, Collection<String> storageKey) {
            this.event = event;
            this.xmiIdsToRetrieve = xmiIdsToRetrieve;
            this.elementsToWrite = elementsToWrite;
            this.idMap = idMap;
            this.specialXmiIds = specialXmiIds;
            this.specialElements = specialElements;
            this.enclosingElementName = enclosingElementName;
            this.withinElement = withinElement;
            this.enclosingStorageKey = enclosingStorageKey;
            this.storageKey = storageKey;
        }

        public String getEnclosingElementName() {
            return this.enclosingElementName;
        }

        public Collection<String> getEnclosingStorageKey() {
            return this.enclosingStorageKey;
        }

        public boolean isWithinElement() {
            return this.withinElement;
        }

        public StartElementHandler invoke() {
            Attribute xmiIdAtt;
            StartElement element = this.event.asStartElement();
            QName elementQName = element.getName();
            String elementPrefix = elementQName.getPrefix();
            String elementNSUri = elementQName.getNamespaceURI();
            String elementName = elementQName.getLocalPart();
            String javaName = XmiSplitUtilities.getTypeJavaName(element) + elementName;
            if (elementPrefix.equals("xmi") && elementName.equals("XMI") && StaxXmiSplitter.this.xmiStartTag == null) {
                StaxXmiSplitter.this.xmiStartTag = this.event.asStartElement();
                Iterator<Attribute> it = StaxXmiSplitter.this.xmiStartTag.getAttributes();
                while (it.hasNext()) {
                    Attribute att = it.next();
                    String name = att.getName().getPrefix() + ":" + att.getName().getLocalPart();
                    StaxXmiSplitter.this.namespaces.put(name, att.getValue());
                }
                Iterator<Namespace> nsit = StaxXmiSplitter.this.xmiStartTag.getNamespaces();
                while (nsit.hasNext()) {
                    Namespace ns = nsit.next();
                    StaxXmiSplitter.this.namespaces.put(ns.getPrefix(), ns.getNamespaceURI());
                }
                this.initializeWriters();
            }
            if ((xmiIdAtt = element.getAttributeByName(xmiIdQName)) != null) {
                Object attributeName;
                String xmiId = xmiIdAtt.getValue();
                if (elementName.equals("Sofa")) {
                    Iterator<Attribute> attributes = element.getAttributes();
                    String sofaID = null;
                    while (attributes.hasNext()) {
                        Attribute attribute = attributes.next();
                        QName attributeQName = attribute.getName();
                        attributeName = attributeQName.getLocalPart();
                        if (!((String)attributeName).equals("sofaID")) continue;
                        sofaID = attribute.getValue();
                    }
                    if (sofaID == null) {
                        throw new IllegalStateException("Sofa element without a Sofa ID occurred: " + element);
                    }
                    StaxXmiSplitter.this.currentSofaIdMap.put(Integer.parseInt(xmiId), sofaID);
                    this.specialXmiIds.put(xmiId, xmiId);
                    this.specialElements.add(element);
                }
                boolean toBeWritten = false;
                if (StaxXmiSplitter.this.storeBaseDocument && (StaxXmiSplitter.this.baseDocumentAnnotations.contains(javaName) || StaxXmiSplitter.this.baseDocumentAnnotations.contains("all")) && !this.elementsToWrite.containsKey(xmiId)) {
                    toBeWritten = true;
                    this.storageKey = new ArrayList<String>(Collections.singleton(StaxXmiSplitter.this.docTableName));
                } else if (StaxXmiSplitter.this.annotationModulesToExtract.contains(javaName) && !this.elementsToWrite.containsKey(xmiId)) {
                    toBeWritten = true;
                    this.storageKey = new ArrayList<String>(Collections.singleton(javaName));
                    if (this.xmiIdsToRetrieve.containsKey((Object)xmiId)) {
                        this.xmiIdsToRetrieve.removeAll((Object)xmiId);
                    }
                } else if (this.xmiIdsToRetrieve.containsKey((Object)xmiId) && !this.elementsToWrite.containsKey(xmiId)) {
                    if (XmiSplitUtilities.isFSArray(StaxXmiSplitter.this.cas.getTypeSystem().getType(javaName)) || StaxXmiSplitter.this.recursively) {
                        toBeWritten = true;
                        this.storageKey = new ArrayList<String>(this.xmiIdsToRetrieve.get((Object)xmiId));
                    } else {
                        this.xmiIdsToRetrieve.removeAll((Object)xmiId);
                    }
                }
                if (toBeWritten) {
                    this.withinElement = true;
                    this.enclosingElementName = elementName;
                    this.enclosingStorageKey = this.storageKey;
                    Type annotationType = StaxXmiSplitter.this.cas.getTypeSystem().getType(javaName);
                    if (annotationType != null) {
                        this.recordXmiReferences(element, annotationType, this.xmiIdsToRetrieve, this.elementsToWrite, this.storageKey);
                    } else {
                        StaxXmiSplitter.this.casNULLId = Integer.parseInt(xmiId);
                        this.specialXmiIds.put(xmiId, xmiId);
                        this.specialElements.add(element);
                    }
                    StorageElement storageElement = new StorageElement(element, elementPrefix, elementNSUri, elementName, javaName, this.storageKey);
                    this.elementsToWrite.put(xmiId, storageElement);
                    if (!this.specialXmiIds.keySet().contains(xmiId)) {
                        this.idMap.put(xmiId, Integer.toString(StaxXmiSplitter.this.nextId));
                        Integer n = StaxXmiSplitter.this.nextId;
                        attributeName = StaxXmiSplitter.this.nextId = StaxXmiSplitter.this.nextId + 1;
                    }
                    if (this.xmiIdsToRetrieve.containsKey((Object)xmiId)) {
                        for (String key : this.storageKey) {
                            this.xmiIdsToRetrieve.remove((Object)xmiId, (Object)key);
                        }
                    }
                }
            }
            return this;
        }

        private void initializeWriters() {
            for (String tableName : StaxXmiSplitter.this.annotationModulesToExtract) {
                Map.Entry entry = StaxXmiSplitter.this.getWriterEntry();
                if (StaxXmiSplitter.this.xmiStartTag != null) {
                    StaxXmiSplitter.this.writers.put(tableName, entry);
                    continue;
                }
                log.warn("There is no xmi start tag to add to the writers. Xmi data might not be readable later!");
            }
        }

        private void recordXmiReferences(StartElement element, Type annotationType, Multimap<String, String> xmiIdsToRetrieve, LinkedHashMap<String, StorageElement> elementsToWrite, Collection<String> storageKey) {
            block3: {
                Iterator<Attribute> attributes;
                block2: {
                    attributes = element.getAttributes();
                    if (!XmiSplitUtilities.isFSArray(annotationType)) break block2;
                    while (attributes.hasNext()) {
                        Attribute attribute = attributes.next();
                        QName attributeQName = attribute.getName();
                        String attributePrefix = attributeQName.getPrefix();
                        String attributeName = attributeQName.getLocalPart();
                        if (attributePrefix.equals("xmi") && attributeName.equals("id")) continue;
                        StaxXmiSplitter.this.recordReferencesForExtraction(attribute, storageKey, (Multimap<String, String>)xmiIdsToRetrieve, elementsToWrite);
                    }
                    break block3;
                }
                if (XmiSplitUtilities.isFSArray(annotationType)) break block3;
                while (attributes.hasNext()) {
                    Type featureType;
                    Attribute attribute = attributes.next();
                    QName attributeQName = attribute.getName();
                    String attributePrefix = attributeQName.getPrefix();
                    String attributeName = attributeQName.getLocalPart();
                    if (attributePrefix.equals("xmi") && attributeName.equals("id") || !XmiSplitUtilities.isFSArray(featureType = XmiSplitUtilities.getFeatureType(annotationType, attributeName)) && (XmiSplitUtilities.isPrimitive(featureType) || !StaxXmiSplitter.this.recursively)) continue;
                    StaxXmiSplitter.this.recordReferencesForExtraction(attribute, storageKey, (Multimap<String, String>)xmiIdsToRetrieve, elementsToWrite);
                }
            }
        }
    }

    private class EndElementHandler {
        private XMLEvent event;
        private String enclosingElementName;
        private Collection<String> enclosingStorageKey;
        private LinkedHashMap<String, StorageElement> elementsToWrite;
        private boolean withinElement;

        public EndElementHandler(XMLEvent event, String enclosingElementName, Collection<String> enclosingStorageKey, LinkedHashMap<String, StorageElement> elementsToWrite, boolean withinElement) {
            this.event = event;
            this.enclosingElementName = enclosingElementName;
            this.enclosingStorageKey = enclosingStorageKey;
            this.elementsToWrite = elementsToWrite;
            this.withinElement = withinElement;
        }

        public String getEnclosingElementName() {
            return this.enclosingElementName;
        }

        public Collection<String> getEnclosingStorageKey() {
            return this.enclosingStorageKey;
        }

        public boolean isWithinElement() {
            return this.withinElement;
        }

        public EndElementHandler invoke() {
            EndElement endElement = this.event.asEndElement();
            QName endElementQName = endElement.getName();
            String endElementName = endElementQName.getLocalPart();
            StorageElement storageElement = new StorageElement(endElement, this.enclosingStorageKey);
            StaxXmiSplitter.this.checkStorageKeysNotEmpty(storageElement);
            this.elementsToWrite.put(Integer.toString(StaxXmiSplitter.this.othersCounter), storageElement);
            StaxXmiSplitter.this.othersCounter--;
            if (endElementName.equals(this.enclosingElementName)) {
                this.withinElement = false;
                this.enclosingElementName = "";
                this.enclosingStorageKey = Collections.emptyList();
            }
            return this;
        }
    }
}

