/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xml;

import com.google.common.collect.Sets;
import com.ximpleware.NavException;
import com.ximpleware.VTDException;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import de.julielab.xml.JeDISVTDGraphNode;
import de.julielab.xml.JulieXMLTools;
import de.julielab.xml.SofaVTDGraphNode;
import de.julielab.xml.XmiSplitUtilities;
import de.julielab.xml.XmiSplitter;
import de.julielab.xml.XmiSplitterResult;
import de.julielab.xml.util.XMISplitterException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.jcas.JCas;

public class VtdXmlXmiSplitter
implements XmiSplitter {
    public static final String DOCUMENT_MODULE_LABEL = "DOCUMENT-MODULE";
    private static final String REFERENCE_IDS_SPLIT_REGEX = "\\s+";
    private static final int SECOND_SOFA_MAP_KEY_START = -2;
    private static final int NO_SOFA_KEY = -1;
    private static final int SOFA_UNKNOWN = Integer.MIN_VALUE;
    private final Set<String> moduleAnnotationNames;
    private final boolean recursively;
    private final boolean storeBaseDocument;
    private final String docTableName;
    private final Set<String> baseDocumentAnnotations;
    private int currentSecondSofaMapKey;
    private Map<Integer, JeDISVTDGraphNode> nodesByXmiId;
    private Map<String, Set<JeDISVTDGraphNode>> annotationModules;
    private Set<Integer> unavailableXmiId;
    private VTDNav vn;

    public VtdXmlXmiSplitter(Set<String> moduleAnnotationNames, boolean recursively, boolean storeBaseDocument, String docTableName, Set<String> baseDocumentAnnotations) {
        this.moduleAnnotationNames = moduleAnnotationNames != null ? new HashSet<String>(moduleAnnotationNames) : null;
        this.recursively = recursively;
        this.storeBaseDocument = storeBaseDocument;
        this.docTableName = docTableName;
        Set<Object> set = this.baseDocumentAnnotations = baseDocumentAnnotations == null ? Collections.emptySet() : baseDocumentAnnotations;
        if (storeBaseDocument) {
            this.moduleAnnotationNames.add(DOCUMENT_MODULE_LABEL);
        }
        if (moduleAnnotationNames != null && baseDocumentAnnotations != null && !Sets.intersection(moduleAnnotationNames, baseDocumentAnnotations).isEmpty()) {
            throw new IllegalArgumentException("The annotation types to build modules from and the annotation types to added to the base document overlap in: " + Sets.intersection(moduleAnnotationNames, baseDocumentAnnotations));
        }
    }

    public VTDNav getVTDNav() {
        return this.vn;
    }

    Map<String, Set<JeDISVTDGraphNode>> getAnnotationModules() {
        return this.annotationModules;
    }

    Map<Integer, JeDISVTDGraphNode> getNodesByXmiId() {
        return this.nodesByXmiId;
    }

    @Override
    public XmiSplitterResult process(byte[] xmiData, JCas aCas, int nextPossibleId, Map<String, Integer> existingSofaIdMap) throws XMISplitterException {
        VTDGen vg = new VTDGen();
        vg.setDoc(xmiData);
        try {
            vg.parse(true);
            this.vn = vg.getNav();
            Map namespaceMap = JulieXMLTools.buildNamespaceMap((VTDNav)this.vn);
            this.nodesByXmiId = this.createJedisNodes(this.vn, namespaceMap, aCas);
            this.labelNodes(this.nodesByXmiId, this.moduleAnnotationNames, this.recursively);
            this.annotationModules = this.createAnnotationModules(this.nodesByXmiId);
            ImmutablePair<Integer, Map<String, Integer>> nextXmiIdAndSofaMap = this.assignNewXmiIds(this.nodesByXmiId, existingSofaIdMap, nextPossibleId);
            LinkedHashMap<String, ByteArrayOutputStream> moduleData = this.createAnnotationModuleData(this.nodesByXmiId, this.annotationModules, existingSofaIdMap, nextPossibleId, this.vn);
            Map<Integer, String> reverseSofaIdMap = ((Map)nextXmiIdAndSofaMap.right).entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            return new XmiSplitterResult(moduleData, (Integer)nextXmiIdAndSofaMap.left, namespaceMap, reverseSofaIdMap);
        }
        catch (VTDException e) {
            throw new XMISplitterException(e);
        }
    }

    private ImmutablePair<Integer, Map<String, Integer>> assignNewXmiIds(Map<Integer, JeDISVTDGraphNode> nodesByXmiId, Map<String, Integer> existingSofaIdMap, int nextPossibleId) {
        HashMap<String, Integer> updatedSofaIdMap = null != existingSofaIdMap ? new HashMap<String, Integer>(existingSofaIdMap) : new HashMap();
        int currentXmiId = nextPossibleId;
        this.adaptSofaIdMap(nodesByXmiId, updatedSofaIdMap);
        for (String moduleName : this.annotationModules.keySet()) {
            if (!this.storeBaseDocument && moduleName.equals(DOCUMENT_MODULE_LABEL)) continue;
            Set<JeDISVTDGraphNode> moduleNodes = this.annotationModules.get(moduleName);
            for (JeDISVTDGraphNode node : moduleNodes) {
                if (node instanceof SofaVTDGraphNode) continue;
                while (this.unavailableXmiId.contains(currentXmiId)) {
                    ++currentXmiId;
                }
                node.setNewXmiId(currentXmiId);
                this.unavailableXmiId.add(currentXmiId);
                ++currentXmiId;
            }
        }
        return new ImmutablePair((Object)currentXmiId, updatedSofaIdMap);
    }

    private LinkedHashMap<String, ByteArrayOutputStream> createAnnotationModuleData(Map<Integer, JeDISVTDGraphNode> nodesByXmiId, Map<String, Set<JeDISVTDGraphNode>> annotationModules, Map<String, Integer> existingSofaIdMap, int nextPossibleId, VTDNav vn) throws NavException, XMISplitterException {
        LinkedHashMap<String, ByteArrayOutputStream> annotationModuleData = new LinkedHashMap<String, ByteArrayOutputStream>();
        for (String moduleName : annotationModules.keySet()) {
            if (!this.storeBaseDocument && moduleName.equals(DOCUMENT_MODULE_LABEL)) continue;
            Set<JeDISVTDGraphNode> moduleNodes = annotationModules.get(moduleName);
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Throwable throwable = null;
                try {
                    annotationModuleData.put(moduleName.equals(DOCUMENT_MODULE_LABEL) ? this.docTableName : moduleName, baos);
                    for (JeDISVTDGraphNode node : moduleNodes) {
                        if (node.getSofaXmiId() == Integer.MIN_VALUE) {
                            throw new IllegalArgumentException("An annotation module is requested that belongs to a Sofa that is not present in existing document data and that is also not to be stored now. This would bring inconsistency into the stored data because some elements would refer to a Sofa that does not exist.");
                        }
                        String xmlElement = vn.toRawString(node.getByteOffset(), node.getByteLength());
                        int oldSofaXmiId = node.getSofaXmiId();
                        if (oldSofaXmiId != -1) {
                            xmlElement = xmlElement.replaceFirst("sofa=\"[0-9]+\"", "sofa=\"" + nodesByXmiId.get(node.getSofaXmiId()).getNewXmiId() + "\"");
                        }
                        xmlElement = xmlElement.replaceFirst("xmi:id=\"[0-9]+\"", "xmi:id=\"" + node.getNewXmiId() + "\"");
                        for (String featureName : node.getReferencedXmiIds().keySet()) {
                            List<Integer> references = node.getReferencedXmiIds().get(featureName);
                            String newReferenceString = references.stream().map(oldId -> ((JeDISVTDGraphNode)nodesByXmiId.get(oldId)).getNewXmiId()).map(String::valueOf).collect(Collectors.joining(" "));
                            xmlElement = xmlElement.replaceFirst(featureName + "=\"([0-9]+(\\s+)?)\"", featureName + "=\"" + newReferenceString + "\"");
                        }
                        baos.write(xmlElement.getBytes(StandardCharsets.UTF_8));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (baos == null) continue;
                    if (throwable != null) {
                        try {
                            baos.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    baos.close();
                }
            }
            catch (IOException e) {
                throw new XMISplitterException(e);
            }
        }
        return annotationModuleData;
    }

    private void adaptSofaIdMap(Map<Integer, JeDISVTDGraphNode> nodesByXmiId, Map<String, Integer> updatedSofaIdMap) {
        this.unavailableXmiId = new HashSet<Integer>();
        this.unavailableXmiId.add(0);
        int sofaKey = -2;
        while (nodesByXmiId.containsKey(sofaKey)) {
            int newSofaXmiId;
            SofaVTDGraphNode sofaNode = (SofaVTDGraphNode)nodesByXmiId.get(sofaKey);
            Integer sofaXmiId = sofaNode.getOldXmiId();
            String sofaID = sofaNode.getSofaID();
            if (!updatedSofaIdMap.containsKey(sofaID)) {
                if (this.storeBaseDocument) {
                    updatedSofaIdMap.put(sofaID, sofaXmiId);
                    newSofaXmiId = sofaXmiId;
                } else {
                    newSofaXmiId = Integer.MIN_VALUE;
                }
            } else {
                newSofaXmiId = updatedSofaIdMap.get(sofaID);
            }
            sofaNode.setNewXmiId(newSofaXmiId);
            this.unavailableXmiId.add(newSofaXmiId);
            --sofaKey;
        }
    }

    private Map<String, Set<JeDISVTDGraphNode>> createAnnotationModules(Map<Integer, JeDISVTDGraphNode> nodesByXmiId) {
        HashMap<String, Set<JeDISVTDGraphNode>> modules = new HashMap<String, Set<JeDISVTDGraphNode>>();
        for (JeDISVTDGraphNode node : nodesByXmiId.values()) {
            for (String label : node.getAnnotationModuleLabels()) {
                if (!this.moduleAnnotationNames.contains(label)) continue;
                modules.compute(label, (l, list) -> {
                    HashSet<JeDISVTDGraphNode> ret = list == null ? new HashSet<JeDISVTDGraphNode>() : list;
                    ret.add(node);
                    return ret;
                });
            }
        }
        return modules;
    }

    private void labelNodes(Map<Integer, JeDISVTDGraphNode> nodesByXmiId, Set<String> moduleAnnotationNames, boolean recursively) {
        if (null == moduleAnnotationNames) {
            return;
        }
        for (JeDISVTDGraphNode node : nodesByXmiId.values()) {
            Stream<String> allLabels = this.determineLabelsForNode(node, moduleAnnotationNames, recursively);
            node.setAnnotationModuleLabels(allLabels.collect(Collectors.toSet()));
        }
    }

    private Stream<String> determineLabelsForNode(JeDISVTDGraphNode node, Set<String> moduleAnnotationNames, boolean recursively) {
        if (!node.getAnnotationModuleLabels().isEmpty()) {
            return node.getAnnotationModuleLabels().stream();
        }
        Function<JeDISVTDGraphNode, Stream> fetchLabelsRecursively = n -> n.getPredecessors().stream().flatMap(p -> this.determineLabelsForNode((JeDISVTDGraphNode)p, moduleAnnotationNames, recursively));
        if (XmiSplitUtilities.isAnnotationType(node.getTypeName())) {
            if (moduleAnnotationNames.contains(node.getTypeName())) {
                return Stream.of(node.getTypeName());
            }
            if (this.storeBaseDocument && this.baseDocumentAnnotations.contains(node.getTypeName())) {
                return Stream.of(DOCUMENT_MODULE_LABEL);
            }
            if (recursively) {
                return fetchLabelsRecursively.apply(node);
            }
            return Stream.empty();
        }
        if (this.storeBaseDocument && node.getTypeName().equals("uima.cas.Sofa")) {
            return Stream.of(DOCUMENT_MODULE_LABEL);
        }
        return fetchLabelsRecursively.apply(node);
    }

    private Map<Integer, JeDISVTDGraphNode> createJedisNodes(VTDNav vn, Map<String, String> namespaceMap, JCas aCas) throws VTDException {
        HashMap<Integer, JeDISVTDGraphNode> nodesByXmiId = new HashMap<Integer, JeDISVTDGraphNode>();
        this.currentSecondSofaMapKey = -2;
        vn.toElement(2);
        vn.toElement(2);
        do {
            Integer xmiIdIndex;
            if ((xmiIdIndex = Integer.valueOf(vn.getAttrVal("xmi:id"))) < 0) continue;
            int i = vn.getCurrentIndex();
            int oldXmiId = Integer.parseInt(vn.toRawString(xmiIdIndex.intValue()));
            String typeName = this.getTypeName(vn, namespaceMap, i);
            JeDISVTDGraphNode n = nodesByXmiId.computeIfAbsent(oldXmiId, typeName.equals("uima.cas.Sofa") ? SofaVTDGraphNode::new : JeDISVTDGraphNode::new);
            n.setVtdIndex(i);
            n.setElementFragment(vn.getElementFragment());
            n.setTypeName(typeName);
            int sofaAttrIndex = vn.getAttrVal("sofa");
            if (sofaAttrIndex > -1) {
                n.setSofaXmiId(Integer.parseInt(vn.toRawString(sofaAttrIndex)));
            } else {
                n.setSofaXmiId(-1);
            }
            Map<String, List<Integer>> referencedXmiIds = this.getReferencedXmiIds(vn, n.getTypeName(), aCas.getTypeSystem());
            n.setReferencedXmiIds(referencedXmiIds);
            referencedXmiIds.values().stream().flatMap(Collection::stream).map(refId -> nodesByXmiId.computeIfAbsent((Integer)refId, JeDISVTDGraphNode::new)).forEach(referenced -> referenced.addPredecessor(n));
            if (!n.getTypeName().equals("uima.cas.Sofa")) continue;
            nodesByXmiId.put(this.currentSecondSofaMapKey--, n);
            ((SofaVTDGraphNode)n).setSofaID(vn.toRawString(vn.getAttrVal("sofaID")));
        } while (vn.toElement(4));
        return nodesByXmiId;
    }

    private Map<String, List<Integer>> getReferencedXmiIds(VTDNav vn, String typeName, TypeSystem ts) throws NavException {
        if (typeName.equals("uima.cas.NULL") || typeName.equals("uima.cas.View")) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Integer>> referencesByFeatureBaseName = new HashMap<String, List<Integer>>();
        Type annotationType = ts.getType(typeName);
        Function<String, List> refAttributeValue2Integers = referenceString -> Stream.of(referenceString).filter(StringUtils::isNotBlank).map(refStr -> refStr.split(REFERENCE_IDS_SPLIT_REGEX)).flatMap(Stream::of).map(Integer::parseInt).collect(Collectors.toList());
        if (XmiSplitUtilities.isFSArray(annotationType)) {
            String referenceString2 = vn.toRawString(vn.getAttrVal("elements"));
            referencesByFeatureBaseName.put("elements", refAttributeValue2Integers.apply(referenceString2));
        } else if (!XmiSplitUtilities.isFSArray(annotationType)) {
            List features = annotationType.getFeatures();
            for (Feature f : features) {
                int attributeIndex;
                Type featureType = f.getRange();
                if (!XmiSplitUtilities.isFSArray(featureType) && XmiSplitUtilities.isPrimitive(featureType) || (attributeIndex = vn.getAttrVal(f.getShortName())) < 0) continue;
                String referenceString3 = vn.toRawString(attributeIndex);
                referencesByFeatureBaseName.put(f.getShortName(), refAttributeValue2Integers.apply(referenceString3));
            }
        }
        return referencesByFeatureBaseName;
    }

    private String getTypeName(VTDNav vn, Map<String, String> namespaceMap, int i) throws NavException {
        String elementName = vn.toRawString(i);
        int indexOfColon = elementName.indexOf(58);
        String namespace = elementName.substring(0, indexOfColon);
        String name = elementName.substring(indexOfColon + 1);
        String nsUri = XmiSplitUtilities.convertNSUri(namespaceMap.get(namespace));
        return nsUri + name;
    }
}

