/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xml;

import java.util.Arrays;
import java.util.List;
import javax.xml.stream.events.StartElement;
import org.apache.uima.cas.Type;

public class XmiSplitUtilities {
    public static final String CAS_NULL = "uima.cas.NULL";
    public static final String CAS_VIEW = "uima.cas.View";
    public static final String CAS_SOFA = "uima.cas.Sofa";
    public static final String TYPES_NAMESPACE = "de.julielab.jules.types.";
    public static final List<String> primitives = Arrays.asList("uima.cas.BooleanArray", "uima.cas.ByteArray", "uima.cas.DoubleArray", "uima.cas.FloatArray", "uima.cas.IntegerArray", "uima.cas.LongArray", "uima.cas.ShortArray", "uima.cas.StringArray");

    public static String convertNSUri(String nameSpace) {
        if (nameSpace.startsWith("http:")) {
            nameSpace = nameSpace.substring(5);
        }
        while (nameSpace.startsWith("/")) {
            nameSpace = nameSpace.substring(1);
        }
        if (nameSpace.endsWith(".ecore")) {
            nameSpace = nameSpace.substring(0, nameSpace.length() - 6);
        }
        String javaNamePart = nameSpace.replace('/', '.') + '.';
        return javaNamePart;
    }

    public static String getTypeJavaName(StartElement element) {
        String NSUri = element.getName().getNamespaceURI();
        String typeJavaName = XmiSplitUtilities.convertNSUri(NSUri);
        return typeJavaName;
    }

    public static boolean isFSArray(Type annotationType) {
        boolean isFSArray = false;
        if (annotationType.isArray()) {
            isFSArray = true;
        }
        return isFSArray;
    }

    public static boolean isPrimitive(Type annotationType, String featureName) {
        boolean isPrimitive = false;
        Type featureType = annotationType.getFeatureByBaseName(featureName).getRange();
        return XmiSplitUtilities.isPrimitive(featureType);
    }

    public static boolean isPrimitive(Type type) {
        boolean isPrimitive = false;
        if (type.isPrimitive() || primitives.contains(type.toString()) || type.toString().equals(CAS_SOFA)) {
            isPrimitive = true;
        }
        return isPrimitive;
    }

    public static Type getFeatureType(Type annotationType, String featureName) {
        return annotationType.getFeatureByBaseName(featureName).getRange();
    }

    public static boolean isReferenceFeature(Type type, String featureName) {
        return XmiSplitUtilities.isFSArray(type) || !type.getFeatureByBaseName(featureName).getRange().isPrimitive();
    }

    public static boolean isAnnotationType(String qualifiedTypename) {
        return !qualifiedTypename.startsWith("uima.cas");
    }
}

