/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xml;

import com.fasterxml.aalto.stax.InputFactoryImpl;
import de.julielab.xml.AbstractXmiSplitter;
import de.julielab.xml.JeDISVTDGraphNode;
import de.julielab.xml.SofaVTDGraphNode;
import de.julielab.xml.XmiSplitUtilities;
import de.julielab.xml.XmiSplitterResult;
import de.julielab.xml.util.XMISplitterException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaxXmiSplitter
extends AbstractXmiSplitter {
    private static final int NO_SOFA_KEY = -1;
    private static final int SECOND_SOFA_MAP_KEY_START = -2;
    private static final Logger log = LoggerFactory.getLogger(StaxXmiSplitter.class);
    private static final Object depthMarker = new Object();
    private Deque<Object> depthDeque = new ArrayDeque<Object>();
    private byte[] currentXmiData;
    private XMLInputFactory inputFactory = new InputFactoryImpl();

    public StaxXmiSplitter(Set<String> moduleAnnotationNames, boolean recursively, boolean storeBaseDocument, Set<String> baseDocumentAnnotations) {
        super(moduleAnnotationNames, recursively, storeBaseDocument, baseDocumentAnnotations);
    }

    public StaxXmiSplitter(Set<String> annotationModulesToExtract, boolean recursively, boolean storeBaseDocument, Set<String> baseDocumentAnnotations, int attribute_size) {
        this(annotationModulesToExtract, recursively, storeBaseDocument, baseDocumentAnnotations);
    }

    @Override
    protected String getNodeXml(JeDISVTDGraphNode node) {
        return new String(Arrays.copyOfRange(this.currentXmiData, node.getByteOffset(), node.getByteOffset() + node.getByteLength()));
    }

    @Override
    public XmiSplitterResult process(byte[] xmiData, TypeSystem ts, int nextPossibleId, Map<String, Integer> existingSofaIdMap) throws XMISplitterException {
        nextPossibleId = Math.max(nextPossibleId, 1);
        this.currentXmiData = xmiData;
        try {
            XMLStreamReader reader = this.inputFactory.createXMLStreamReader(new ByteArrayInputStream(xmiData), "UTF-8");
            log.debug("Employed StAX implementation: {}", reader.getClass());
            log.debug("Building namespace map");
            Map<String, String> namespaceMap = this.buildNamespaceMap(reader);
            log.debug("Creating JeDIS nodes");
            this.nodesByXmiId = this.createJedisNodes(reader, namespaceMap, ts);
            log.debug("Labeling nodes");
            this.labelNodes(this.nodesByXmiId, this.moduleAnnotationNames, this.recursively);
            log.debug("Creating annotation modules");
            this.annotationModules = this.createAnnotationModules(this.nodesByXmiId);
            log.debug("Assigning new XMI IDs");
            ImmutablePair<Integer, Map<String, Integer>> nextXmiIdAndSofaMap = this.assignNewXmiIds(this.nodesByXmiId, existingSofaIdMap, nextPossibleId);
            log.debug("Slicing XMI data into annotation module data");
            HashMap<Integer, Integer> oldSofaXmiId2NewSofaXmiId = new HashMap<Integer, Integer>();
            LinkedHashMap<String, ByteArrayOutputStream> moduleData = this.createAnnotationModuleData(this.nodesByXmiId, oldSofaXmiId2NewSofaXmiId, this.annotationModules, ts);
            Map<Integer, String> reverseSofaIdMap = ((Map)nextXmiIdAndSofaMap.right).entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            log.debug("Returning XMI annotation module result");
            return new XmiSplitterResult(moduleData, (Integer)nextXmiIdAndSofaMap.left, namespaceMap, reverseSofaIdMap, this.nodesByXmiId.keySet().stream().filter(id -> id > 0).map(this.nodesByXmiId::get).filter(node -> !node.getAnnotationModuleLabels().isEmpty()).collect(Collectors.toList()));
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Map<Integer, JeDISVTDGraphNode> createJedisNodes(XMLStreamReader reader, Map<String, String> namespaceMap, TypeSystem ts) throws XMLStreamException {
        HashMap<Integer, JeDISVTDGraphNode> nodesByXmiId = new HashMap<Integer, JeDISVTDGraphNode>();
        nodesByXmiId.put(0, JeDISVTDGraphNode.CAS_NULL);
        this.currentSecondSofaMapKey = -2;
        this.forwardTo(reader, r -> this.depthDeque.size() == 2);
        JeDISVTDGraphNode lastNode = null;
        do {
            String xmiIdValue;
            if (lastNode != null && lastNode.getByteLength() == 0) {
                lastNode.setByteLength(reader.getLocation().getCharacterOffset() - lastNode.getByteOffset());
            }
            if ((xmiIdValue = reader.getAttributeValue(namespaceMap.get("xmi"), "id")) == null || "0".equals(xmiIdValue)) continue;
            int oldXmiId = Integer.parseInt(reader.getAttributeValue(namespaceMap.get("xmi"), "id"));
            String typeName = this.getTypeName(reader);
            JeDISVTDGraphNode n = nodesByXmiId.computeIfAbsent(oldXmiId, typeName.equals("uima.cas.Sofa") ? SofaVTDGraphNode::new : JeDISVTDGraphNode::new);
            n.setByteOffset(reader.getLocation().getCharacterOffset());
            n.setTypeName(typeName);
            String sofaId = reader.getAttributeValue(null, "sofa");
            if (sofaId != null) {
                n.setSofaXmiId(Integer.parseInt(sofaId));
            } else {
                n.setSofaXmiId(-1);
            }
            Map<String, List<Integer>> referencedXmiIds = this.getReferencedXmiIds(reader, n.getTypeName(), ts, namespaceMap);
            n.setReferencedXmiIds(referencedXmiIds);
            referencedXmiIds.values().stream().flatMap(Collection::stream).filter(id -> id != 0).map(refId -> nodesByXmiId.computeIfAbsent((Integer)refId, JeDISVTDGraphNode::new)).forEach(referenced -> referenced.addPredecessor(n));
            if (n.getTypeName().equals("uima.cas.Sofa")) {
                nodesByXmiId.put(this.currentSecondSofaMapKey--, n);
                ((SofaVTDGraphNode)n).setSofaID(reader.getAttributeValue(null, "sofaID"));
            }
            lastNode = n;
        } while (this.forwardTo(reader, r -> this.depthDeque.size() == 2 && r.getEventType() == 1));
        if (lastNode != null && lastNode.getByteLength() == 0) {
            lastNode.setByteLength(reader.getLocation().getCharacterOffset() - lastNode.getByteOffset());
        }
        return nodesByXmiId;
    }

    private Map<String, List<Integer>> getReferencedXmiIds(XMLStreamReader reader, String typeName, TypeSystem ts, Map<String, String> namespaceMap) {
        if (typeName.equals("uima.cas.NULL") || typeName.equals("uima.cas.View")) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Integer>> referencesByFeatureBaseName = new HashMap<String, List<Integer>>();
        Type annotationType = ts.getType(typeName);
        if (annotationType == null) {
            throw new IllegalArgumentException("Unknown type " + typeName);
        }
        Function<String, List> refAttributeValue2Integers = referenceString -> Stream.of(referenceString).filter(StringUtils::isNotBlank).map(refStr -> refStr.split("\\s+")).flatMap(Stream::of).map(Integer::parseInt).collect(Collectors.toList());
        if (ts.subsumes(ts.getType("uima.cas.FSArray"), annotationType)) {
            String referenceString2 = reader.getAttributeValue(null, "elements");
            if (referenceString2 != null) {
                referencesByFeatureBaseName.put("elements", refAttributeValue2Integers.apply(referenceString2));
            }
        } else if (ts.subsumes(ts.getType("uima.cas.ListBase"), annotationType)) {
            String headReference;
            String referenceString3 = reader.getAttributeValue(null, "tail");
            if (referenceString3 != null) {
                referencesByFeatureBaseName.put("tail", refAttributeValue2Integers.apply(referenceString3));
            }
            if (XmiSplitUtilities.resolveListSubtypes(annotationType.getName()).equals("uima.cas.FSList") && (headReference = reader.getAttributeValue(null, "head")) != null) {
                referencesByFeatureBaseName.put("head", refAttributeValue2Integers.apply(headReference));
            }
        } else {
            List features = annotationType.getFeatures();
            for (Feature f : features) {
                String referenceString4;
                if (f.getName().equals("uima.cas.AnnotationBase:sofa") || !XmiSplitUtilities.isReferenceFeature(f, ts) || (referenceString4 = reader.getAttributeValue(null, f.getShortName())) == null) continue;
                referencesByFeatureBaseName.put(f.getShortName(), refAttributeValue2Integers.apply(referenceString4));
            }
        }
        return referencesByFeatureBaseName;
    }

    private Map<String, String> buildNamespaceMap(XMLStreamReader reader) throws XMLStreamException {
        HashMap<String, String> map = new HashMap<String, String>();
        this.forwardTo(reader, r -> r.getEventType() == 1 && r.getName().getLocalPart().equals("XMI"));
        for (int i = 0; i < reader.getNamespaceCount(); ++i) {
            map.put(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
        }
        return map;
    }

    private String getTypeName(XMLStreamReader reader) {
        String namespace = reader.getName().getNamespaceURI();
        String name = reader.getName().getLocalPart();
        String nsUri = XmiSplitUtilities.convertNSUri(namespace);
        String typeName = nsUri + name;
        return typeName;
    }

    private boolean forwardTo(XMLStreamReader reader, Predicate<XMLStreamReader> predicate) throws XMLStreamException {
        while (reader.hasNext()) {
            int currentEventType = reader.next();
            if (currentEventType == 1) {
                this.depthDeque.push(depthMarker);
            } else if (currentEventType == 2) {
                this.depthDeque.pop();
            }
            if (!predicate.test(reader)) continue;
            break;
        }
        if (!reader.hasNext()) {
            log.debug("Reached end of XML.");
        }
        return reader.hasNext();
    }
}

