/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xml;

import com.ximpleware.NavException;
import com.ximpleware.VTDException;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import de.julielab.xml.AbstractXmiSplitter;
import de.julielab.xml.JeDISVTDGraphNode;
import de.julielab.xml.JulieXMLTools;
import de.julielab.xml.SofaVTDGraphNode;
import de.julielab.xml.XmiSplitUtilities;
import de.julielab.xml.XmiSplitterResult;
import de.julielab.xml.util.XMISplitterException;
import java.io.ByteArrayOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VtdXmlXmiSplitter
extends AbstractXmiSplitter {
    private static final Logger log = LoggerFactory.getLogger(VtdXmlXmiSplitter.class);
    private static final int SECOND_SOFA_MAP_KEY_START = -2;
    private static final int NO_SOFA_KEY = -1;
    private VTDNav vn;

    public VtdXmlXmiSplitter(Set<String> moduleAnnotationNames, boolean recursively, boolean storeBaseDocument, Set<String> baseDocumentAnnotations) {
        super(moduleAnnotationNames, recursively, storeBaseDocument, baseDocumentAnnotations);
    }

    public VTDNav getVTDNav() {
        return this.vn;
    }

    @Override
    Map<String, Set<JeDISVTDGraphNode>> getAnnotationModules() {
        return this.annotationModules;
    }

    @Override
    Map<Integer, JeDISVTDGraphNode> getNodesByXmiId() {
        return this.nodesByXmiId;
    }

    @Override
    protected String getNodeXml(JeDISVTDGraphNode node) throws XMISplitterException {
        try {
            return this.vn.toRawString(node.getByteOffset(), node.getByteLength());
        }
        catch (NavException e) {
            throw new XMISplitterException(e);
        }
    }

    @Override
    public XmiSplitterResult process(byte[] xmiData, TypeSystem ts, int nextPossibleId, Map<String, Integer> existingSofaIdMap) throws XMISplitterException {
        VTDGen vg = new VTDGen();
        vg.setDoc(xmiData);
        try {
            vg.parse(true);
            this.vn = vg.getNav();
            log.debug("Building namespace map");
            Map namespaceMap = JulieXMLTools.buildNamespaceMap((VTDNav)this.vn);
            log.debug("Creating JeDIS nodes");
            this.nodesByXmiId = this.createJedisNodes(this.vn, namespaceMap, ts);
            log.debug("Labeling nodes");
            this.labelNodes(this.nodesByXmiId, this.moduleAnnotationNames, this.recursively);
            log.debug("Creating annotation modules");
            this.annotationModules = this.createAnnotationModules(this.nodesByXmiId);
            log.debug("Assigning new XMI IDs");
            ImmutablePair<Integer, Map<String, Integer>> nextXmiIdAndSofaMap = this.assignNewXmiIds(this.nodesByXmiId, existingSofaIdMap, nextPossibleId);
            log.debug("Slicing XMI data into annotation module data");
            HashMap<Integer, Integer> oldSofaXmiId2NewSofaXmiId = new HashMap<Integer, Integer>();
            LinkedHashMap<String, ByteArrayOutputStream> moduleData = this.createAnnotationModuleData(this.nodesByXmiId, oldSofaXmiId2NewSofaXmiId, this.annotationModules, ts);
            Map<Integer, String> reverseSofaIdMap = ((Map)nextXmiIdAndSofaMap.right).entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            log.debug("Returning XMI annotation module result");
            System.out.println(nextXmiIdAndSofaMap.right);
            return new XmiSplitterResult(moduleData, (Integer)nextXmiIdAndSofaMap.left, namespaceMap, reverseSofaIdMap, this.nodesByXmiId.keySet().stream().filter(id -> id >= 0).map(this.nodesByXmiId::get).collect(Collectors.toList()));
        }
        catch (VTDException e) {
            throw new XMISplitterException(e);
        }
    }

    private Map<Integer, JeDISVTDGraphNode> createJedisNodes(VTDNav vn, Map<String, String> namespaceMap, TypeSystem ts) throws VTDException {
        HashMap<Integer, JeDISVTDGraphNode> nodesByXmiId = new HashMap<Integer, JeDISVTDGraphNode>();
        this.currentSecondSofaMapKey = -2;
        vn.toElement(2);
        vn.toElement(2);
        do {
            int xmiIdIndex;
            if ((xmiIdIndex = vn.getAttrVal("xmi:id")) < 0) continue;
            int i = vn.getCurrentIndex();
            int oldXmiId = Integer.parseInt(vn.toRawString(xmiIdIndex));
            String typeName = this.getTypeName(vn, namespaceMap, i);
            JeDISVTDGraphNode n = nodesByXmiId.computeIfAbsent(oldXmiId, typeName.equals("uima.cas.Sofa") ? SofaVTDGraphNode::new : JeDISVTDGraphNode::new);
            n.setElementFragment(vn.getElementFragment());
            n.setTypeName(typeName);
            int sofaAttrIndex = vn.getAttrVal("sofa");
            if (sofaAttrIndex > -1) {
                n.setSofaXmiId(Integer.parseInt(vn.toRawString(sofaAttrIndex)));
            } else {
                n.setSofaXmiId(-1);
            }
            Map<String, List<Integer>> referencedXmiIds = this.getReferencedXmiIds(vn, n.getTypeName(), ts);
            n.setReferencedXmiIds(referencedXmiIds);
            referencedXmiIds.values().stream().flatMap(Collection::stream).map(refId -> nodesByXmiId.computeIfAbsent((Integer)refId, JeDISVTDGraphNode::new)).forEach(referenced -> referenced.addPredecessor(n));
            if (!n.getTypeName().equals("uima.cas.Sofa")) continue;
            nodesByXmiId.put(this.currentSecondSofaMapKey--, n);
            ((SofaVTDGraphNode)n).setSofaID(vn.toRawString(vn.getAttrVal("sofaID")));
        } while (vn.toElement(4));
        return nodesByXmiId;
    }

    private Map<String, List<Integer>> getReferencedXmiIds(VTDNav vn, String typeName, TypeSystem ts) throws NavException {
        if (typeName.equals("uima.cas.NULL") || typeName.equals("uima.cas.View")) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Integer>> referencesByFeatureBaseName = new HashMap<String, List<Integer>>();
        Type annotationType = ts.getType(typeName);
        Function<String, List> refAttributeValue2Integers = referenceString -> Stream.of(referenceString).filter(StringUtils::isNotBlank).map(refStr -> refStr.split("\\s+")).flatMap(Stream::of).map(Integer::parseInt).collect(Collectors.toList());
        if (XmiSplitUtilities.isFSArray(annotationType)) {
            String referenceString2 = vn.toRawString(vn.getAttrVal("elements"));
            referencesByFeatureBaseName.put("elements", refAttributeValue2Integers.apply(referenceString2));
        } else if (!XmiSplitUtilities.isFSArray(annotationType)) {
            List features = annotationType.getFeatures();
            for (Feature f : features) {
                int attributeIndex;
                Type featureType = f.getRange();
                if (!XmiSplitUtilities.isFSArray(featureType) && XmiSplitUtilities.isPrimitive(featureType) || (attributeIndex = vn.getAttrVal(f.getShortName())) < 0) continue;
                String referenceString3 = vn.toRawString(attributeIndex);
                referencesByFeatureBaseName.put(f.getShortName(), refAttributeValue2Integers.apply(referenceString3));
            }
        }
        return referencesByFeatureBaseName;
    }

    private String getTypeName(VTDNav vn, Map<String, String> namespaceMap, int i) throws NavException {
        String elementName = vn.toRawString(i);
        int indexOfColon = elementName.indexOf(58);
        String namespace = elementName.substring(0, indexOfColon);
        String name = elementName.substring(indexOfColon + 1);
        String nsUri = XmiSplitUtilities.convertNSUri(namespaceMap.get(namespace));
        return nsUri + name;
    }
}

