/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xml.binary;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import de.julielab.xml.XmiSplitUtilities;
import de.julielab.xml.binary.BinaryDecodingResult;
import de.julielab.xml.binary.DataRange;
import de.julielab.xml.binary.Element;
import de.julielab.xml.binary.JeDISAttribute;
import de.julielab.xml.util.XMIBuilderException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryJeDISNodeDecoder {
    public static final int JEDIS_BINARY_MAGIC = 24981;
    private static final Logger log = LoggerFactory.getLogger(BinaryJeDISNodeDecoder.class);
    private Set<String> annotationLabelsToLoad;
    private boolean shrinkArraysAndListsIfReferenceNotLoaded;
    private int currentXmiId;
    private int currentSofaId;
    private Element currentElement;
    private Set<Integer> xmiIds;

    public BinaryJeDISNodeDecoder(Set<String> annotationLabelsToLoad, boolean shrinkArraysAndListsIfReferenceNotLoaded) {
        this.annotationLabelsToLoad = annotationLabelsToLoad;
        this.shrinkArraysAndListsIfReferenceNotLoaded = shrinkArraysAndListsIfReferenceNotLoaded;
    }

    private void init() {
        this.currentXmiId = -1;
        this.currentSofaId = -1;
        this.currentElement = null;
        this.xmiIds = new HashSet<Integer>();
    }

    public BinaryDecodingResult decode(Map<String, InputStream> input, TypeSystem ts, Map<Integer, String> reversedMapping, Map<String, Boolean> mappedFeatures, Map<String, String> namespaceMap) throws IOException, XMIBuilderException {
        if (namespaceMap == null || namespaceMap.isEmpty()) {
            throw new IllegalArgumentException("The XMI namespace map passed to the BinaryJeDISNodeDecoder is empty. This is an error because it is required for decoding of binary annotation modules.");
        }
        this.init();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        HashMultimap sofaElementsMap = HashMultimap.create();
        BinaryDecodingResult res = new BinaryDecodingResult(baos, (Multimap<Integer, Integer>)sofaElementsMap, this.shrinkArraysAndListsIfReferenceNotLoaded);
        HashMap<Integer, Element> elementsWithReferences = new HashMap<Integer, Element>();
        for (String string : input.keySet()) {
            InputStream is = input.get(string);
            short header = (short)((0xFF & is.read()) << 8 | 0xFF & is.read());
            if (header != 24981) {
                throw new IOException("Not in JeDIS binary format.");
            }
            ByteBuffer bb = XmiSplitUtilities.readInputStreamIntoBuffer(is);
            while (bb.position() < bb.limit()) {
                byte finishedIndicator;
                int binaryTypeId = bb.getInt();
                String prefixedNameType = reversedMapping.get(binaryTypeId);
                if (prefixedNameType == null) {
                    throw new XMIBuilderException("The binary element ID " + binaryTypeId + " is not contained in the mapping. It should be the prefixed type name of an annotation element.");
                }
                int elementStart = baos.size();
                baos.write(60);
                this.writeWs(prefixedNameType, baos);
                String[] prefixAndTypeName = prefixedNameType.split(":");
                String prefix = namespaceMap.get(prefixAndTypeName[0]);
                if (prefix == null) {
                    throw new IllegalArgumentException("The namespace map does not include an entry for the prefix '" + prefix + "' which is contained in the decoded data.");
                }
                String typeName = XmiSplitUtilities.convertNSUri(prefix) + prefixAndTypeName[1];
                this.currentElement = new Element(typeName);
                Type type = ts.getType(typeName);
                int numAttributes = bb.get();
                this.currentXmiId = -1;
                this.currentSofaId = -1;
                for (int i = 0; i < numAttributes; ++i) {
                    this.readAttribute(bb, typeName, type, mappedFeatures, reversedMapping, ts, res);
                }
                if (this.currentSofaId != -1 && this.currentXmiId != -1) {
                    if (string.equals("DOCUMENT-MODULE") && !typeName.equals("uima.cas.Sofa")) {
                        sofaElementsMap.put((Object)this.currentSofaId, (Object)this.currentXmiId);
                    } else if (this.annotationLabelsToLoad.contains(typeName)) {
                        sofaElementsMap.put((Object)this.currentSofaId, (Object)this.currentXmiId);
                    }
                }
                if ((finishedIndicator = bb.get()) == 0) {
                    baos.write(62);
                    this.writeStringArray(bb, ts.getType(typeName), ts, reversedMapping, mappedFeatures, baos);
                    baos.write(60);
                    baos.write(47);
                    this.write(prefixedNameType, baos);
                    bb.get();
                } else {
                    baos.write(47);
                }
                baos.write(62);
                int elementEnd = baos.size();
                this.currentElement.setRange(elementStart, elementEnd);
                this.currentElement.setArray(type.isArray());
                this.currentElement.setXmiId(this.currentXmiId);
                elementsWithReferences.put(this.currentXmiId, this.currentElement);
            }
        }
        HashSet<Integer> seenElementIds = new HashSet<Integer>();
        for (Element e2 : elementsWithReferences.values()) {
            this.tagElementsForOmission(e2, elementsWithReferences, 0, seenElementIds);
        }
        Stream<Object> dataRangeStream = elementsWithReferences.values().stream().flatMap(e -> Stream.concat(Stream.of(e), e.getAttributes().values().stream()));
        dataRangeStream = this.shrinkArraysAndListsIfReferenceNotLoaded ? dataRangeStream.filter(dr -> dr.isToBeOmitted() || dr instanceof JeDISAttribute && ((JeDISAttribute)dr).isModified()) : dataRangeStream.filter(JeDISAttribute.class::isInstance).filter(a -> ((JeDISAttribute)a).isModified());
        List<DataRange> list = dataRangeStream.sorted((dr1, dr2) -> Integer.compare(dr1.getBegin(), dr2.getBegin()) != 0 ? Integer.compare(dr1.getBegin(), dr2.getBegin()) : Integer.compare(dr2.getEnd(), dr1.getEnd())).collect(Collectors.toList());
        res.setXmiPortionsToModify(list);
        return res;
    }

    private void tagElementsForOmission(Element e, Map<Integer, Element> elements, int recursionLevel, Set<Integer> seenElementIds) {
        if (!seenElementIds.add(e.getXmiId())) {
            return;
        }
        String intendation = StringUtils.repeat((String)"    ", (int)recursionLevel);
        log.debug(intendation + e.getTypeName() + "(" + e.getXmiId() + ")");
        if (e.isListNode()) {
            log.debug(intendation + "WARNING: List node");
        }
        boolean omitAttribute = false;
        for (JeDISAttribute a : e.getAttributes().values()) {
            log.debug("    " + intendation + a.getName() + ": " + a.getReferencedIds());
            for (Integer id : a.getReferencedIds()) {
                Element element = elements.get(id);
                if (element == null) continue;
                this.tagElementsForOmission(element, elements, recursionLevel + 2, seenElementIds);
                if (element.isToBeOmitted()) continue;
                a.addFoundReference(id);
            }
            if (a.getFoundReferences().size() < a.getReferencedIds().size()) {
                a.setModified(true);
            }
            omitAttribute |= a.isToBeOmitted();
        }
        if (this.shrinkArraysAndListsIfReferenceNotLoaded) {
            e.setToBeOmitted(e.isArray() && omitAttribute || e.isListNode() && e.getAttributes().containsKey("head") && e.getAttribute("head").isToBeOmitted());
            for (JeDISAttribute a : e.getAttributes().values()) {
                for (Integer referencedId : a.getReferencedIds()) {
                    Element referencedElement = elements.get(referencedId);
                    if (referencedElement == null || !referencedElement.isListNode() || !referencedElement.isToBeOmitted()) continue;
                    this.closeLinkedListGapDueToOmission(e, a.getName(), elements, intendation);
                }
            }
        }
        log.debug(intendation + e.isToBeOmitted());
    }

    private void closeLinkedListGapDueToOmission(Element e, String attrName, Map<Integer, Element> elements, String intendation) {
        JeDISAttribute attribute = e.getAttribute(attrName);
        IntStream.Builder idsToAdd = IntStream.builder();
        IntStream.Builder idsToRemove = IntStream.builder();
        for (Integer referencedId : attribute.getReferencedIds()) {
            Element referencedElement = elements.get(referencedId);
            Element nextNode = null;
            if (referencedElement.isToBeOmitted() && referencedElement.isListNode() && referencedElement.getAttributes().containsKey("tail")) {
                idsToRemove.add(referencedId);
                nextNode = elements.get(referencedElement.getAttribute("tail").getReferencedIds().iterator().next());
                if (nextNode.isToBeOmitted()) {
                    while (nextNode.isToBeOmitted()) {
                        Integer nextNodeId = nextNode.getAttribute("tail").getReferencedIds().iterator().next();
                        nextNode = elements.get(nextNodeId);
                    }
                }
                if (nextNode != null) {
                    idsToAdd.add(nextNode.getXmiId());
                }
            }
            if (nextNode == null) continue;
            log.debug(intendation + "exchanging " + attrName + " ID " + referencedId + " with " + nextNode.getXmiId());
            attribute.setModified(true);
        }
        idsToRemove.build().mapToObj(Integer::valueOf).forEach(attribute.getReferencedIds()::remove);
        idsToAdd.build().forEach(i -> {
            attribute.getReferencedIds().add(i);
            attribute.getFoundReferences().add(i);
        });
    }

    private void readAttribute(ByteBuffer bb, String typeName, Type type, Map<String, Boolean> mappedFeatures, Map<Integer, String> mapping, TypeSystem ts, BinaryDecodingResult res) {
        ByteArrayOutputStream baos = res.getXmiData();
        int attrNameCode = bb.getInt();
        String attrName = mapping.get(attrNameCode);
        if (attrName == null) {
            throw new IllegalArgumentException("The binary code integer '" + attrNameCode + "' should encode an attribute name of the UIMA type element '" + typeName + "' but was not found in the mapping. Buffer position: " + bb.position());
        }
        Feature feature = type.getFeatureByBaseName(attrName);
        int attributeBegin = baos.size();
        this.write(attrName, baos);
        JeDISAttribute attribute = null;
        baos.write(61);
        baos.write(34);
        if (attrName.equals("xmi:id") || attrName.equals("sofa")) {
            this.handleXmiIdAndSofaAttributes(bb, attrName, res);
        } else if (XmiSplitUtilities.isReferenceAttribute(type, attrName, ts)) {
            attribute = new JeDISAttribute(attrName);
            this.handleReferenceAttributes(bb, res, attribute);
        } else if (XmiSplitUtilities.isMultiValuedFeatureAttribute(type, attrName) || feature.getRange().isArray() || XmiSplitUtilities.isListTypeName(feature.getRange().getName())) {
            this.handleArrayElementFeature(bb, type, attrName, baos);
        } else if (XmiSplitUtilities.isListTypeName(typeName)) {
            this.handleListTypes(bb, typeName, ts, attrName, mapping, mappedFeatures, baos);
        } else if (feature.getRange().isPrimitive()) {
            this.handlePrimitiveFeatures(bb, mappedFeatures, mapping, baos, attrName, feature, ts);
        } else {
            throw new IllegalArgumentException("Unhandled attribute '" + attrName + "' of type '" + typeName + "'.");
        }
        baos.write(34);
        baos.write(32);
        int attributeEnd = baos.size();
        if (attribute != null) {
            attribute.setRange(attributeBegin, attributeEnd);
            this.currentElement.addAttribute(attribute);
        }
    }

    private void handlePrimitiveFeatures(ByteBuffer bb, Map<String, Boolean> mappedFeatures, Map<Integer, String> mapping, ByteArrayOutputStream ret, String attrName, Feature feature, TypeSystem ts) {
        if (ts.subsumes(ts.getType("uima.cas.String"), feature.getRange())) {
            this.writeStringWithMapping(bb, feature.getName(), ts, mappedFeatures, mapping, ret);
        } else if (ts.subsumes(ts.getType("uima.cas.Float"), feature.getRange())) {
            this.write(bb.getDouble(), ret);
        } else if (ts.subsumes(ts.getType("uima.cas.Double"), feature.getRange())) {
            this.write(bb.getDouble(), ret);
        } else if (ts.subsumes(ts.getType("uima.cas.Short"), feature.getRange())) {
            this.write(bb.getShort(), ret);
        } else if (ts.subsumes(ts.getType("uima.cas.Byte"), feature.getRange())) {
            this.write(bb.get(), ret);
        } else if (ts.subsumes(ts.getType("uima.cas.Integer"), feature.getRange())) {
            this.write(bb.getInt(), ret);
        } else if (ts.subsumes(ts.getType("uima.cas.Long"), feature.getRange())) {
            this.write(bb.getLong(), ret);
        } else if (ts.subsumes(ts.getType("uima.cas.Boolean"), feature.getRange())) {
            this.write(bb.get() == 1 ? "true" : "false", ret);
        } else {
            throw new IllegalArgumentException("Unhandled feature value decoding of feature " + feature.getName() + " of type " + feature.getRange().getName());
        }
    }

    private void handleArrayElementFeature(ByteBuffer bb, Type type, String attrName, ByteArrayOutputStream ret) {
        Consumer<ByteBuffer> componentValueConsumer;
        Feature feature = type.getFeatureByBaseName(attrName);
        String typeName = XmiSplitUtilities.isMultiValuedFeatureAttribute(type, attrName) ? type.getName() : feature.getRange().getName();
        int length = bb.getInt();
        if (typeName.equals("uima.cas.DoubleArray") || typeName.equals("uima.cas.FloatList")) {
            componentValueConsumer = buf -> this.write(buf.getDouble(), ret);
        } else if (typeName.equals("uima.cas.ShortArray")) {
            componentValueConsumer = buf -> this.write(bb.getShort(), ret);
        } else if (typeName.equals("uima.cas.ByteArray")) {
            componentValueConsumer = buf -> this.write(bb.get(), ret);
        } else if (typeName.equals("uima.cas.IntegerArray") || typeName.equals("uima.cas.IntegerList")) {
            componentValueConsumer = buf -> this.write(bb.getInt(), ret);
        } else if (typeName.equals("uima.cas.LongArray")) {
            componentValueConsumer = buf -> this.write(bb.getLong(), ret);
        } else if (typeName.equals("uima.cas.StringArray")) {
            componentValueConsumer = buf -> bb.getInt();
        } else {
            throw new IllegalArgumentException("Unsupported UIMA array type: " + typeName);
        }
        for (int i = 0; i < length; ++i) {
            componentValueConsumer.accept(bb);
            if (i >= length - 1) continue;
            ret.write(32);
        }
    }

    private void handleListTypes(ByteBuffer bb, String typeName, TypeSystem ts, String attrName, Map<Integer, String> mapping, Map<String, Boolean> mappedFeatures, ByteArrayOutputStream ret) {
        String baseListType = XmiSplitUtilities.resolveListSubtypes(typeName);
        if (attrName.equals("tail")) {
            this.write(bb.getInt(), ret);
        } else if (attrName.equals("head")) {
            if (baseListType.equals("uima.cas.FloatList")) {
                this.write(bb.getDouble(), ret);
            } else if (baseListType.equals("uima.cas.FSList")) {
                this.write(bb.getInt(), ret);
            } else if (baseListType.equals("uima.cas.IntegerList")) {
                this.write(bb.getInt(), ret);
            } else if (baseListType.equals("uima.cas.StringList")) {
                this.writeStringWithMapping(bb, "uima.cas.NonEmptyStringList:head", ts, mappedFeatures, mapping, ret);
            } else {
                throw new IllegalArgumentException("Unhandled UIMA list type: " + typeName);
            }
        }
    }

    private void handleXmiIdAndSofaAttributes(ByteBuffer bb, String attrName, BinaryDecodingResult res) {
        ByteArrayOutputStream baos = res.getXmiData();
        if (attrName.equals("xmi:id")) {
            this.currentXmiId = bb.getInt();
            this.write(this.currentXmiId, baos);
            this.xmiIds.add(this.currentXmiId);
        } else if (attrName.equals("sofa")) {
            this.currentSofaId = bb.get();
            this.write(this.currentSofaId, baos);
        }
    }

    private void handleReferenceAttributes(ByteBuffer bb, BinaryDecodingResult res, JeDISAttribute attribute) {
        ByteArrayOutputStream baos = res.getXmiData();
        int numReferences = bb.getInt();
        for (int j = 0; j < numReferences; ++j) {
            int referenceXmiId = bb.getInt();
            attribute.addReferencedId(referenceXmiId);
            if (referenceXmiId >= 0) {
                this.write(referenceXmiId, baos);
            } else {
                this.write("null", baos);
            }
            if (j >= numReferences - 1) continue;
            baos.write(32);
        }
    }

    private void writeStringArray(ByteBuffer bb, Type type, TypeSystem ts, Map<Integer, String> mapping, Map<String, Boolean> mappedFeatures, ByteArrayOutputStream ret) {
        int numStringArrayFeatures = bb.getInt();
        for (int i = 0; i < numStringArrayFeatures; ++i) {
            String featureBaseName = mapping.get(bb.getInt());
            int numValues = bb.getInt();
            for (int j = 0; j < numValues; ++j) {
                ret.write(60);
                this.write(featureBaseName, ret);
                ret.write(62);
                this.writeStringWithMapping(bb, type.getFeatureByBaseName(featureBaseName).getName(), ts, mappedFeatures, mapping, ret);
                ret.write(60);
                ret.write(47);
                this.write(featureBaseName, ret);
                ret.write(62);
            }
        }
    }

    private void write(String s, ByteArrayOutputStream baos) {
        baos.writeBytes(s.getBytes(StandardCharsets.UTF_8));
    }

    private void writeWs(String s, ByteArrayOutputStream baos) {
        baos.writeBytes(s.getBytes(StandardCharsets.UTF_8));
        baos.write(32);
    }

    private void write(int i, ByteArrayOutputStream baos) {
        baos.writeBytes(this.getStringBytes(i));
    }

    private void write(double d, ByteArrayOutputStream baos) {
        baos.writeBytes(this.getStringBytes(d));
    }

    private void write(long l, ByteArrayOutputStream baos) {
        baos.writeBytes(this.getStringBytes(l));
    }

    private byte[] getStringBytes(int i) {
        return String.valueOf(i).getBytes(StandardCharsets.UTF_8);
    }

    private byte[] getStringBytes(long l) {
        return String.valueOf(l).getBytes(StandardCharsets.UTF_8);
    }

    private byte[] getStringBytes(double d) {
        return String.valueOf(d).getBytes(StandardCharsets.UTF_8);
    }

    private void writeStringWithMapping(ByteBuffer bb, String fullFeatureName, TypeSystem ts, Map<String, Boolean> mappedFeatures, Map<Integer, String> mapping, ByteArrayOutputStream baos) {
        Feature feature = ts.getFeatureByFullName(fullFeatureName);
        boolean featureIsStringArray = ts.subsumes(ts.getType("uima.cas.StringArray"), feature.getRange());
        boolean featureIsStringList = ts.subsumes(ts.getType("uima.cas.StringList"), feature.getRange());
        if (!featureIsStringArray && !featureIsStringList && mappedFeatures.get(fullFeatureName).booleanValue()) {
            this.write(mapping.get(bb.getInt()), baos);
        } else {
            int length = bb.getInt();
            baos.write(bb.array(), bb.position(), length);
            bb.position(bb.position() + length);
        }
    }
}

