/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.bioportal.ontologies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class DownloadStats {
    private int numSummaries;
    private List<String> ontologiesWithoutFile = Collections.emptyList();
    private List<String> deniedOntologies = Collections.emptyList();
    private List<String> downloadedOntologies = Collections.emptyList();
    private List<Pair<String, String>> ontologiesWithDownloadError = Collections.emptyList();

    public int getNumSummaries() {
        return this.numSummaries;
    }

    public void setNumSummaries(int numSummaries) {
        this.numSummaries = numSummaries;
    }

    public List<String> getOntologiesWithoutFile() {
        return this.ontologiesWithoutFile;
    }

    public List<String> getDeniedOntologies() {
        return this.deniedOntologies;
    }

    public List<String> getDownloadedOntologies() {
        return this.downloadedOntologies;
    }

    public List<Pair<String, String>> getOntologiesWithDownloadError() {
        return this.ontologiesWithDownloadError;
    }

    public void addOntologyWithoutFile(String acronym) {
        if (this.ontologiesWithoutFile.isEmpty()) {
            this.ontologiesWithoutFile = new ArrayList<String>();
        }
        this.ontologiesWithoutFile.add(acronym);
    }

    public void addDeniedOntology(String acronym) {
        if (this.deniedOntologies.isEmpty()) {
            this.deniedOntologies = new ArrayList<String>();
        }
        this.deniedOntologies.add(acronym);
    }

    public void addDownloadedOntology(String acronym) {
        if (this.downloadedOntologies.isEmpty()) {
            this.downloadedOntologies = new ArrayList<String>();
        }
        this.downloadedOntologies.add(acronym);
    }

    public void addOntologyWithDownloadError(String acronym, String errorMessage) {
        if (this.ontologiesWithDownloadError.isEmpty()) {
            this.ontologiesWithDownloadError = new ArrayList<Pair<String, String>>();
        }
        this.ontologiesWithDownloadError.add((Pair<String, String>)new ImmutablePair((Object)acronym, (Object)errorMessage));
    }

    public String report() {
        StringBuilder sb = new StringBuilder();
        sb.append("Number of successfully downloaded ontologies: " + this.downloadedOntologies.size() + "\n");
        sb.append("Number of ontologies which were only summaries: " + this.numSummaries + "\n");
        sb.append("The following ontologies couldn't be downloaded because no file was available:\n");
        for (String string : this.ontologiesWithoutFile) {
            sb.append("\t");
            sb.append(string);
            sb.append("\n");
        }
        sb.append("\n");
        sb.append("The following ontologies couldn't be downloaded because at least one resource associated with the ontology was denied access to:\n");
        for (String string : this.deniedOntologies) {
            sb.append("\t");
            sb.append(string);
            sb.append("\n");
        }
        if (this.deniedOntologies.isEmpty()) {
            sb.append("<none>\n");
        }
        sb.append("\n");
        sb.append("The following ontologies couldn't be downloaded because there were errors during download:\n");
        for (Pair pair : this.ontologiesWithDownloadError) {
            sb.append("\t");
            sb.append((String)pair.getLeft());
            sb.append(": ");
            sb.append((String)pair.getRight());
            sb.append("\n");
        }
        if (this.ontologiesWithDownloadError.isEmpty()) {
            sb.append("<none>\n");
        }
        return sb.toString();
    }

    public void incNumSummaries() {
        ++this.numSummaries;
    }

    public int getNumOntologiesDownloaded() {
        return this.downloadedOntologies.size();
    }

    public int getNumOntologiesDenied() {
        return this.deniedOntologies.size();
    }

    public int getNumOntologiesWithoutFile() {
        return this.ontologiesWithoutFile.size();
    }

    public void removeOntologyWithDownloadError(String acronym) {
        Iterator<Pair<String, String>> iterator = this.ontologiesWithDownloadError.iterator();
        while (iterator.hasNext()) {
            Pair<String, String> pair = iterator.next();
            if (!((String)pair.getLeft()).equals(acronym)) continue;
            iterator.remove();
        }
    }
}

