/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.bioportal.ontologies;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import de.julielab.bioportal.ontologies.HttpHandler;
import de.julielab.bioportal.ontologies.data.OntologyGroup;
import de.julielab.bioportal.ontologies.data.OntologyMetaData;
import de.julielab.bioportal.ontologies.data.OntologyMetric;
import de.julielab.bioportal.util.BioPortalOntologyToolsException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntologyListRetriver {
    private static final Logger log = LoggerFactory.getLogger(OntologyListRetriver.class);
    private HttpHandler httpHandler;
    private Gson gson;
    private static final String metaDataInclude = "name,acronym,group,ontologyType&no_context=true";

    public OntologyListRetriver(HttpHandler httpHandler) {
        this.httpHandler = httpHandler;
        this.gson = new Gson();
    }

    public List<OntologyMetaData> getOntologiesMetaData(File outputFile, Set<String> ontologiesToDownload) throws ParseException, IOException, BioPortalOntologyToolsException {
        ArrayList<OntologyMetaData> effectiveOntologiesMetaData = new ArrayList<OntologyMetaData>();
        Type fromJsonConversionListType = new TypeToken<List<OntologyMetaData>>(){}.getType();
        log.info("Requesting ontology list from BioPortal");
        HttpEntity response = this.httpHandler.sendGetRequest("http://data.bioontology.org/ontologies?include=name,acronym,group,ontologyType&no_context=true");
        String responseString = EntityUtils.toString((HttpEntity)response);
        List ontologiesMetaData = (List)this.gson.fromJson(responseString, fromJsonConversionListType);
        log.info("Retrieved meta data of {} ontologies", (Object)ontologiesMetaData.size());
        for (Iterator ontologyMetaData : ontologiesMetaData) {
            if (null != ontologiesToDownload && ontologiesToDownload.size() > 0 && !ontologiesToDownload.contains(((OntologyMetaData)((Object)ontologyMetaData)).acronym)) continue;
            effectiveOntologiesMetaData.add((OntologyMetaData)((Object)ontologyMetaData));
        }
        Map<String, OntologyMetric> ontologyMetrics = this.getOntologyMetrics();
        for (OntologyMetaData metaData : effectiveOntologiesMetaData) {
            OntologyMetric metric;
            metaData.ontologyMetric = metric = ontologyMetrics.get(metaData.id);
        }
        for (OntologyMetaData metaData : effectiveOntologiesMetaData) {
            for (String groupUri : metaData.group) {
                OntologyGroup ontologyGroup = this.getOntologyGroup(groupUri);
                metaData.addOntologyGroup(ontologyGroup);
            }
        }
        if (null != outputFile) {
            log.info("Storing the ontology meta data list for {} ontologies to {}.", (Object)ontologiesMetaData.size(), (Object)outputFile);
            try (GZIPOutputStream os = new GZIPOutputStream(new FileOutputStream(outputFile));){
                IOUtils.writeLines(effectiveOntologiesMetaData, (String)"\n", (OutputStream)os, (String)"UTF-8");
            }
        }
        return effectiveOntologiesMetaData;
    }

    private Map<String, OntologyMetric> getOntologyMetrics() throws IOException, BioPortalOntologyToolsException {
        String address = "http://data.bioontology.org/metrics";
        HttpEntity response = this.httpHandler.sendGetRequest(address);
        String utf8Response = HttpHandler.convertEntityToUTF8String(response);
        Type fromJsonConversionListType = new TypeToken<List<OntologyMetric>>(){}.getType();
        List ontologyMetrics = (List)this.gson.fromJson(utf8Response, fromJsonConversionListType);
        HashMap<String, OntologyMetric> metricByOntologyUri = new HashMap<String, OntologyMetric>();
        for (OntologyMetric metric : ontologyMetrics) {
            metricByOntologyUri.put(metric.links.ontology, metric);
        }
        return metricByOntologyUri;
    }

    private OntologyGroup getOntologyGroup(String groupUri) throws IOException, BioPortalOntologyToolsException {
        HttpEntity response = this.httpHandler.sendGetRequest(groupUri);
        String utf8Response = HttpHandler.convertEntityToUTF8String(response);
        return (OntologyGroup)this.gson.fromJson(utf8Response, OntologyGroup.class);
    }
}

