/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.bioportal.ontologies.apps;

import de.julielab.bioportal.ontologies.apps.MappingDownloadApplication;
import de.julielab.bioportal.ontologies.apps.NameExtractorApplication;
import de.julielab.bioportal.ontologies.apps.OntologyDownloadApplication;
import de.julielab.bioportal.util.BioPortalOntologyToolsException;
import de.julielab.java.utilities.CLIInteractionUtilities;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.stream.IntStream;
import org.apache.http.ParseException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;

public class BioPortalTools {
    public static void main(String[] args) {
        String task;
        String string = task = args.length > 0 ? args[0] : null;
        if (args.length == 0) {
            System.out.println("Please select a task (you may also directly specify the given shortcut on the command line to skip this dialog):\n");
            System.out.println("1. Download ontologies from BioPortal (-do)");
            System.out.println("2. Extract class information from downloaded ontologies (-eci)");
            System.out.println("3. Download ontology mapping from BioPortal (-dm)");
            System.out.println("4. Exit");
            while (task == null) {
                try {
                    String line;
                    switch (line = CLIInteractionUtilities.readLineFromStdIn()) {
                        case "1": 
                        case "1.": {
                            task = "do";
                            break;
                        }
                        case "2": 
                        case "2.": {
                            task = "eci";
                            break;
                        }
                        case "3": 
                        case "3.": {
                            task = "dm";
                            break;
                        }
                        case "4": 
                        case "4.": {
                            System.exit(0);
                        }
                    }
                }
                catch (IOException e) {
                    System.err.println("Reading input from standard input failed. Stack trace follows.");
                    e.printStackTrace();
                }
            }
        }
        if (task.startsWith("-")) {
            task = task.substring(1);
        }
        String[] argsForApp = args.length > 1 ? (String[])IntStream.range(1, args.length).mapToObj(i -> args[i]).toArray(i -> new String[args.length - 1]) : new String[]{};
        try {
            switch (task) {
                case "do": {
                    OntologyDownloadApplication.main(argsForApp);
                    break;
                }
                case "eci": {
                    NameExtractorApplication.main(argsForApp);
                    break;
                }
                case "dm": {
                    MappingDownloadApplication.main(argsForApp);
                }
            }
        }
        catch (BioPortalOntologyToolsException | IOException | InterruptedException | ExecutionException | ParseException | OWLOntologyCreationException e) {
            System.err.println("Executing task " + task + " failed. Exception stacktrace follows.");
            e.printStackTrace();
        }
    }
}

