/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.bioportal.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.julielab.bioportal.util.BioPortalOntologyToolsException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BioPortalToolUtils {
    private static final Logger log = LoggerFactory.getLogger(BioPortalToolUtils.class);

    public static String getAcronymFromFileName(String filename) {
        if (filename.indexOf(46) != -1) {
            return filename.substring(0, filename.indexOf(46));
        }
        return filename;
    }

    public static String getAcronymFromFileName(File ontologyFile) {
        return BioPortalToolUtils.getAcronymFromFileName(ontologyFile.getName());
    }

    public static Gson getGson() {
        return new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssX").create();
    }

    public static boolean isSupportedOntologyFile(File file) {
        String lcfn = file.getName().toLowerCase();
        return lcfn.contains(".obo") || lcfn.contains(".owl") || lcfn.contains(".umls");
    }

    public static boolean isUMLSOntology(File file) {
        String lcfn = file.getName().toLowerCase();
        return lcfn.contains(".umls");
    }

    public static AtomicInteger fixUmlsFile(File original, File target) throws BioPortalOntologyToolsException {
        AtomicInteger removedLines = new AtomicInteger(0);
        InputStream is = null;
        try {
            boolean gzip;
            is = Files.newInputStream(original.toPath(), new OpenOption[0]);
            OutputStream os = Files.newOutputStream(target.toPath(), new OpenOption[0]);
            boolean bl = gzip = original.getName().toLowerCase().contains(".gz") || original.getName().toLowerCase().contains(".gzip");
            if (gzip) {
                is = new GZIPInputStream(is);
                os = new GZIPOutputStream(os);
            }
            Matcher m = Pattern.compile("\"\"\".*'''").matcher("");
            try (Stream<String> lines = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8"))).lines();
                 BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os, Charset.forName("UTF-8")));){
                Stream<String> filteredLines = lines.filter(l -> {
                    m.reset((CharSequence)l);
                    if (m.find()) {
                        removedLines.incrementAndGet();
                        return false;
                    }
                    return true;
                });
                filteredLines.forEach(l -> {
                    try {
                        bw.write(l + "\n");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
        }
        catch (IOException e) {
            throw new BioPortalOntologyToolsException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new BioPortalOntologyToolsException(e);
            }
        }
        return removedLines;
    }
}

