/*
 * Decompiled with CFR 0.152.
 */
package GNormPluslib;

import GNormPluslib.GNPProcessingData;
import GNormPluslib.GNormPlus;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.tartarus.snowball.ext.englishStemmer;

public class SimConcept {
    private GNPProcessingData data;

    public SimConcept(GNPProcessingData data) {
        this.data = data;
    }

    public void FeatureExtraction_Train(String FilenameData) throws XMLStreamException {
        try {
            BufferedWriter FileData = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FilenameData), "UTF-8"));
            englishStemmer stemmer = new englishStemmer();
            for (int i = 0; i < this.data.getBioCDocobj().PMIDs.size(); ++i) {
                String Pmid = this.data.getBioCDocobj().PMIDs.get(i);
                for (int j = 0; j < this.data.getBioCDocobj().PassageNames.get(i).size(); ++j) {
                    ArrayList<String> Annotation = this.data.getBioCDocobj().Annotations.get(i).get(j);
                    int Inital_Annotation_size = Annotation.size();
                    for (int k = 0; k < Annotation.size(); ++k) {
                        Pattern ptmp;
                        Matcher mtmp;
                        String[] anno = Annotation.get(k).split("\\t", -1);
                        int MentionStart = Integer.parseInt(anno[0]);
                        int MentionLast = Integer.parseInt(anno[1]);
                        String Mention = anno[2];
                        String Type = anno[3];
                        if (anno.length <= 4) continue;
                        String ID = anno[4];
                        String TokenSTR = Mention;
                        TokenSTR = TokenSTR.replaceAll("([0-9])([A-Za-z])", "$1 $2");
                        TokenSTR = TokenSTR.replaceAll("([A-Za-z])([0-9])", "$1 $2");
                        TokenSTR = TokenSTR.replaceAll("([A-Z])([a-z])", "$1 $2");
                        TokenSTR = TokenSTR.replaceAll("([a-z])([A-Z])", "$1 $2");
                        TokenSTR = TokenSTR.replaceAll("([\\W])", " $1 ");
                        TokenSTR = TokenSTR.replaceAll("[ ]+", " ");
                        TokenSTR = TokenSTR.replaceAll("^[ ]+", "");
                        TokenSTR = TokenSTR.replaceAll("[ ]+$", "");
                        if (ID.equals("ASJAS") && k < Inital_Annotation_size && (mtmp = (ptmp = Pattern.compile("^([^ ][^ ][^ ]+) ([^ ]+) ([^\\W\\-\\_]+) ([^ ]+) ([^ ]+)$")).matcher(TokenSTR.toLowerCase())).find()) {
                            String t1 = mtmp.group(1);
                            String t2 = mtmp.group(2);
                            String t3 = mtmp.group(3);
                            String t4 = mtmp.group(4);
                            String t5 = mtmp.group(5);
                            String tmp_ment = t1 + " " + t2 + " " + (String)t3 + " - " + t5;
                            Annotation.add(MentionStart + "\t" + MentionLast + "\t" + tmp_ment + "\t" + Type + "\tASCOS");
                            tmp_ment = t1 + " " + t2 + " " + (String)t3 + " " + t4.substring(0, 1) + " " + t5;
                            Annotation.add(MentionStart + "\t" + MentionLast + "\t" + tmp_ment + "\t" + Type + "\tASCSS");
                            tmp_ment = t1 + " " + t2 + " / " + t5;
                            Annotation.add(MentionStart + "\t" + MentionLast + "\t" + tmp_ment + "\t" + Type + "\tASCS");
                            tmp_ment = t1 + " " + t2 + " or - " + t5;
                            Annotation.add(MentionStart + "\t" + MentionLast + "\t" + tmp_ment + "\t" + Type + "\tASCOS");
                            tmp_ment = t1 + " I, II, and III";
                            Annotation.add(MentionStart + "\t" + MentionLast + "\t" + tmp_ment + "\t" + Type + "\tASCSCCS");
                            tmp_ment = t1 + " B, D, and F";
                            Annotation.add(MentionStart + "\t" + MentionLast + "\t" + tmp_ment + "\t" + Type + "\tASCSCCS");
                            tmp_ment = t1 + " A, B, C, D, E, and F";
                            Annotation.add(MentionStart + "\t" + MentionLast + "\t" + tmp_ment + "\t" + Type + "\tASCSCSCSCSCCS");
                            tmp_ment = t1 + "1, -2, -4, -7, -9, and -12";
                            Annotation.add(MentionStart + "\t" + MentionLast + "\t" + tmp_ment + "\t" + Type + "\tASCOSCOSCOSCOSCCOS");
                            tmp_ment = "B and G " + t1;
                            Annotation.add(MentionStart + "\t" + MentionLast + "\t" + tmp_ment + "\t" + Type + "\tSCSA");
                            tmp_ment = "A/E " + t1;
                            Annotation.add(MentionStart + "\t" + MentionLast + "\t" + tmp_ment + "\t" + Type + "\tSCSA");
                            tmp_ment = "alpha/beta " + t1;
                            Annotation.add(MentionStart + "\t" + MentionLast + "\t" + tmp_ment + "\t" + Type + "\tSCSA");
                            if (t5.matches("[0-9]") && t2.matches("[0-9]") && Integer.parseInt(t5) > Integer.parseInt(t2)) {
                                tmp_ment = t1 + " " + t2 + " to " + t5;
                                Annotation.add(MentionStart + "\t" + MentionLast + "\t" + tmp_ment + "\t" + Type + "\tASNS");
                                tmp_ment = t1 + " " + t2 + " to -" + t5;
                                Annotation.add(MentionStart + "\t" + MentionLast + "\t" + tmp_ment + "\t" + Type + "\tASNOS");
                                tmp_ment = t1 + " -" + t2 + " to -" + t5;
                                Annotation.add(MentionStart + "\t" + MentionLast + "\t" + tmp_ment + "\t" + Type + "\tAASNOS");
                                tmp_ment = t1 + " " + t2 + " to " + t1 + " " + t5;
                                Annotation.add(MentionStart + "\t" + MentionLast + "\t" + tmp_ment + "\t" + Type + "\tASNAS");
                                tmp_ment = t1 + " " + t2 + "-" + t5;
                                Annotation.add(MentionStart + "\t" + MentionLast + "\t" + tmp_ment + "\t" + Type + "\tASNS");
                                tmp_ment = t1 + " " + t2 + ", " + t5 + ", and " + (Integer.parseInt(t5) + 2);
                                Annotation.add(MentionStart + "\t" + MentionLast + "\t" + tmp_ment + "\t" + Type + "\tASCSCCS");
                                tmp_ment = t1 + " -" + t2 + ", -" + t5 + ", and -" + (Integer.parseInt(t5) + 2);
                                Annotation.add(MentionStart + "\t" + MentionLast + "\t" + tmp_ment + "\t" + Type + "\tAASC0SCC0S");
                            }
                        }
                        String Mention_tmp = Mention;
                        String[] tokens = TokenSTR.split(" ", -1);
                        HashMap<String, Integer> Token2Num = new HashMap<String, Integer>();
                        for (int p = 0; p < tokens.length; ++p) {
                            if (!Token2Num.containsKey(tokens[p])) {
                                Token2Num.put(tokens[p], 0);
                            }
                            Token2Num.put(tokens[p], (Integer)Token2Num.get(tokens[p]) + 1);
                        }
                        HashMap<Integer, String> AbbLFStatus_hash = new HashMap<Integer, String>();
                        for (String Pmid_LF : this.data.getPmidLF2Abb_hash().keySet()) {
                            int l;
                            String[] pf = Pmid_LF.split("\\t", -1);
                            if (!pf[0].equals(Pmid)) continue;
                            String Abb = this.data.getPmidLF2Abb_hash().get(Pmid_LF);
                            String LF = pf[1];
                            Abb = Abb.replaceAll("([0-9])([A-Za-z])", "$1 $2");
                            Abb = Abb.replaceAll("([A-Za-z])([0-9])", "$1 $2");
                            Abb = Abb.replaceAll("([A-Z])([a-z])", "$1 $2");
                            Abb = Abb.replaceAll("([a-z])([A-Z])", "$1 $2");
                            Abb = Abb.replaceAll("([\\W])", " $1 ");
                            Abb = Abb.replaceAll("[ ]+", " ");
                            Abb = Abb.replaceAll("^[ ]+", "");
                            LF = LF.replaceAll("([0-9])([A-Za-z])", "$1 $2");
                            LF = LF.replaceAll("([A-Za-z])([0-9])", "$1 $2");
                            LF = LF.replaceAll("([A-Z])([a-z])", "$1 $2");
                            LF = LF.replaceAll("([a-z])([A-Z])", "$1 $2");
                            LF = LF.replaceAll("([\\W])", " $1 ");
                            LF = LF.replaceAll("[ ]+", " ");
                            LF = LF.replaceAll("^[ ]+", "");
                            LF = LF.replaceAll("[ ]+$", "");
                            Abb = Abb.replaceAll("([^A-Za-z0-9@ ])", "\\\\$1");
                            LF = LF.replaceAll("([^A-Za-z0-9@ ])", "\\\\$1");
                            Abb = Abb.toLowerCase();
                            LF = LF.toLowerCase();
                            Pattern ptmp1 = Pattern.compile("(.*)(" + LF + ")([ ]*\\([ ]*)(" + Abb + ")[ ]*\\).*");
                            Matcher mtmp1 = ptmp1.matcher(TokenSTR.toLowerCase());
                            Pattern ptmp2 = Pattern.compile("(.*)(" + Abb + ")([ ]*\\([ ]*)(" + LF + ")[ ]*\\).*");
                            Matcher mtmp2 = ptmp2.matcher(TokenSTR.toLowerCase());
                            int start_LF = 0;
                            int last_LF = 0;
                            int start_Abb = 0;
                            int last_Abb = 0;
                            if (mtmp1.find()) {
                                start_LF = mtmp1.group(1).length();
                                last_LF = start_LF + mtmp1.group(2).length();
                                start_Abb = last_LF + mtmp1.group(3).length();
                                last_Abb = start_Abb + mtmp1.group(4).length();
                            } else if (mtmp2.find()) {
                                start_Abb = mtmp2.group(1).length();
                                last_Abb = start_LF + mtmp2.group(2).length();
                                start_LF = last_LF + mtmp2.group(3).length();
                                last_LF = start_Abb + mtmp2.group(4).length();
                            }
                            for (l = start_LF; l < last_LF; ++l) {
                                AbbLFStatus_hash.put(l, "FullName");
                            }
                            for (l = start_Abb; l < last_Abb; ++l) {
                                AbbLFStatus_hash.put(l, "Abbreviation");
                            }
                        }
                        int Offset = 0;
                        for (int p = 0; p < tokens.length; ++p) {
                            Object Pattern1;
                            Object WSB = "WSB:N/A";
                            Object WSF = "WSF:N/A";
                            if (p > 0) {
                                String B = tokens[p - 1];
                                B = B.replaceAll("[A-Za-z]+", "A");
                                B = B.replaceAll("[0-9]+", "0");
                                WSB = "WSB:" + B;
                            }
                            if (p < tokens.length - 1) {
                                String F = tokens[p + 1];
                                F = F.replaceAll("[A-Za-z]+", "A");
                                F = F.replaceAll("[0-9]+", "0");
                                WSF = "WSF:" + F;
                            }
                            stemmer.setCurrent(tokens[p].toLowerCase());
                            stemmer.stem();
                            String stem = stemmer.getCurrent();
                            Object Num_num = "";
                            String tmp = tokens[p];
                            tmp = tmp.replaceAll("[^0-9]", "");
                            Num_num = tmp.length() > 3 ? "N:4+" : "N:" + tmp.length();
                            Object Num_Uc = "";
                            tmp = tokens[p];
                            tmp = tmp.replaceAll("[^A-Z]", "");
                            Num_Uc = tmp.length() > 3 ? "U:4+" : "U:" + tmp.length();
                            Object Num_lc = "";
                            tmp = tokens[p];
                            tmp = tmp.replaceAll("[^a-z]", "");
                            Num_lc = tmp.length() > 3 ? "L:4+" : "L:" + tmp.length();
                            Object Num_All = "";
                            Num_All = tokens[p].length() > 3 ? "A:4+" : "A:" + tokens[p].length();
                            String SpecificC = "__nil__";
                            if (tokens[p].equals(";") || tokens[p].equals(":") || tokens[p].equals(",") || tokens[p].equals(".") || tokens[p].equals("-") || tokens[p].equals(">") || tokens[p].equals("+") || tokens[p].equals("_")) {
                                SpecificC = "-SpecificC1-";
                            } else if (tokens[p].equals("(") || tokens[p].equals(")")) {
                                SpecificC = "-SpecificC2-";
                            } else if (tokens[p].equals("{") || tokens[p].equals("}")) {
                                SpecificC = "-SpecificC3-";
                            } else if (tokens[p].equals("[") || tokens[p].equals("]")) {
                                SpecificC = "-SpecificC4-";
                            } else if (tokens[p].equals("\\") || tokens[p].equals("/")) {
                                SpecificC = "-SpecificC5-";
                            }
                            String ChemPreSuf = "__nil__";
                            if (tokens[p].matches(".*(yl|ylidyne|oyl|sulfonyl)")) {
                                ChemPreSuf = "-CHEMinlineSuffix-";
                            } else if (tokens[p].matches("(meth|eth|prop|tetracos).*")) {
                                ChemPreSuf = "-CHEMalkaneStem-";
                            } else if (tokens[p].matches("(di|tri|tetra).*")) {
                                ChemPreSuf = "-CHEMsimpleMultiplier-";
                            } else if (tokens[p].matches("(benzen|pyridin|toluen).*")) {
                                ChemPreSuf = "-CHEMtrivialRing-";
                            } else if (tokens[p].matches(".*(one|ol|carboxylic|amide|ate|acid|ium|ylium|ide|uide|iran|olan|inan|pyrid|acrid|amid|keten|formazan|fydrazin)(s|)")) {
                                ChemPreSuf = "-CHEMsuffix-";
                            }
                            Object MentionType = "__nil__";
                            if (GNormPlus.SimConceptMention2Type_hash.containsKey(tokens[p])) {
                                MentionType = "-" + GNormPlus.SimConceptMention2Type_hash.get(tokens[p]) + "-";
                            }
                            String ProteinSym = "__nil__";
                            if (tokens[p].matches(".*(glutamine|glutamic|leucine|valine|isoleucine|lysine|alanine|glycine|aspartate|methionine|threonine|histidine|aspartic|asparticacid|arginine|asparagine|tryptophan|proline|phenylalanine|cysteine|serine|glutamate|tyrosine|stop|frameshift).*")) {
                                ChemPreSuf = "-ProteinSymFull-";
                            } else if (tokens[p].matches("(cys|ile|ser|gln|met|asn|pro|lys|asp|thr|phe|ala|gly|his|leu|arg|trp|val|glu|tyr|fs|fsx)")) {
                                ChemPreSuf = "-ProteinSymTri-";
                            } else if (tokens[p].matches("[CISQMNPKDTFAGHLRWVEYX]")) {
                                ChemPreSuf = "-ProteinSymChar-";
                            }
                            String Repeat = "__nil__";
                            if ((Integer)Token2Num.get(tokens[p]) > 1 && tokens[p].length() > 1 && !tokens[p].matches("([\\W\\-\\_0-9]+|and|or|alpha|beta|gamma|theta|zeta|delta|kappa|II|VI|IV|III)")) {
                                Repeat = "-Repeat-";
                            }
                            if (((String)(Pattern1 = tokens[p])).matches(".*[\\W\\-\\_].*")) {
                                Pattern1 = "__nil__";
                            } else {
                                Pattern1 = ((String)Pattern1).replaceAll("[A-Z]", "A");
                                Pattern1 = ((String)Pattern1).replaceAll("[a-z]", "a");
                                Pattern1 = ((String)Pattern1).replaceAll("[0-9]", "0");
                                Pattern1 = "P1:" + (String)Pattern1;
                            }
                            Object Pattern2 = tokens[p];
                            if (((String)Pattern2).matches(".*[\\W\\-\\_].*")) {
                                Pattern2 = "__nil__";
                            } else {
                                Pattern2 = ((String)Pattern2).replaceAll("[A-Za-z]", "a");
                                Pattern2 = ((String)Pattern2).replaceAll("[0-9]", "0");
                                Pattern2 = "P2:" + (String)Pattern2;
                            }
                            Object Pattern3 = tokens[p];
                            if (((String)Pattern3).matches(".*[\\W\\-\\_].*")) {
                                Pattern3 = "__nil__";
                            } else {
                                Pattern3 = ((String)Pattern3).replaceAll("[A-Z]+", "A");
                                Pattern3 = ((String)Pattern3).replaceAll("[a-z]+", "a");
                                Pattern3 = ((String)Pattern3).replaceAll("[0-9]+", "0");
                                Pattern3 = "P3:" + (String)Pattern3;
                            }
                            Object Pattern4 = tokens[p];
                            if (((String)Pattern4).matches(".*[\\W\\-\\_].*")) {
                                Pattern4 = "__nil__";
                            } else {
                                Pattern4 = ((String)Pattern4).replaceAll("[A-Za-z]+", "a");
                                Pattern4 = ((String)Pattern4).replaceAll("[0-9]+", "0");
                                Pattern4 = "P4:" + (String)Pattern4;
                            }
                            Object prefix = "";
                            tmp = tokens[p];
                            prefix = tmp.length() >= 1 ? tmp.substring(0, 1) : "__nil__";
                            prefix = tmp.length() >= 2 ? (String)prefix + " " + tmp.substring(0, 2) : (String)prefix + " __nil__";
                            prefix = tmp.length() >= 3 ? (String)prefix + " " + tmp.substring(0, 3) : (String)prefix + " __nil__";
                            prefix = tmp.length() >= 4 ? (String)prefix + " " + tmp.substring(0, 4) : (String)prefix + " __nil__";
                            prefix = tmp.length() >= 5 ? (String)prefix + " " + tmp.substring(0, 5) : (String)prefix + " __nil__";
                            Object suffix = "";
                            tmp = tokens[p];
                            suffix = tmp.length() >= 1 ? tmp.substring(tmp.length() - 1, tmp.length()) : "__nil__";
                            suffix = tmp.length() >= 2 ? (String)suffix + " " + tmp.substring(tmp.length() - 2, tmp.length()) : (String)suffix + " __nil__";
                            suffix = tmp.length() >= 3 ? (String)suffix + " " + tmp.substring(tmp.length() - 3, tmp.length()) : (String)suffix + " __nil__";
                            suffix = tmp.length() >= 4 ? (String)suffix + " " + tmp.substring(tmp.length() - 4, tmp.length()) : (String)suffix + " __nil__";
                            suffix = tmp.length() >= 5 ? (String)suffix + " " + tmp.substring(tmp.length() - 5, tmp.length()) : (String)suffix + " __nil__";
                            String AbbLF = "__nil__";
                            if (AbbLFStatus_hash.containsKey(Offset)) {
                                AbbLF = (String)AbbLFStatus_hash.get(Offset);
                            }
                            String Status = ID.substring(p, p + 1);
                            FileData.write(tokens[p] + " " + (String)WSB + " " + (String)WSF + " " + stem + " " + (String)Num_num + " " + (String)Num_num + " " + (String)Num_Uc + " " + (String)Num_lc + " " + (String)Num_All + " " + SpecificC + " " + ChemPreSuf + " " + (String)MentionType + " " + ProteinSym + " " + Repeat + " " + (String)Pattern1 + " " + (String)Pattern2 + " " + (String)Pattern3 + " " + (String)Pattern4 + " " + (String)prefix + " " + (String)suffix + " " + AbbLF + " " + Status + "\n");
                            Offset = Offset + tokens[p].length() + 1;
                            if (ID.length() <= tokens.length) continue;
                            System.out.println(ID + "\t" + TokenSTR);
                        }
                        FileData.write("\n");
                    }
                }
            }
            FileData.close();
        }
        catch (IOException e1) {
            System.out.println("[MR]: Input file is not exist.");
        }
    }

    public void FeatureExtraction_Test(String FilenameData) throws XMLStreamException {
        try {
            BufferedWriter FileData = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FilenameData), "UTF-8"));
            englishStemmer stemmer = new englishStemmer();
            for (int i = 0; i < this.data.getBioCDocobj().Annotations.size(); ++i) {
                String Pmid = this.data.getBioCDocobj().PMIDs.get(i);
                for (int j = 0; j < this.data.getBioCDocobj().Annotations.get(i).size(); ++j) {
                    ArrayList<String> Annotation = this.data.getBioCDocobj().Annotations.get(i).get(j);
                    for (int k = 0; k < Annotation.size(); ++k) {
                        String[] anno = Annotation.get(k).split("\\t", -1);
                        String Mentions = anno[2];
                        String Type = anno[3];
                        String[] MentionArr = Mentions.split("\\|", -1);
                        if (!Type.equals("Gene")) continue;
                        for (int m = 0; m < MentionArr.length; ++m) {
                            String Mention;
                            String TokenSTR = Mention = MentionArr[m];
                            TokenSTR = TokenSTR.replaceAll("([0-9])([A-Za-z])", "$1 $2");
                            TokenSTR = TokenSTR.replaceAll("([A-Za-z])([0-9])", "$1 $2");
                            TokenSTR = TokenSTR.replaceAll("([A-Z])([a-z])", "$1 $2");
                            TokenSTR = TokenSTR.replaceAll("([a-z])([A-Z])", "$1 $2");
                            TokenSTR = TokenSTR.replaceAll("([\\W])", " $1 ");
                            TokenSTR = TokenSTR.replaceAll("[ ]+", " ");
                            TokenSTR = TokenSTR.replaceAll("^[ ]+", "");
                            String Mention_tmp = Mention;
                            String[] tokens = TokenSTR.split(" ", -1);
                            HashMap<String, Integer> Token2Num = new HashMap<String, Integer>();
                            for (int p = 0; p < tokens.length; ++p) {
                                if (!Token2Num.containsKey(tokens[p])) {
                                    Token2Num.put(tokens[p], 0);
                                }
                                Token2Num.put(tokens[p], (Integer)Token2Num.get(tokens[p]) + 1);
                            }
                            HashMap<Integer, String> AbbLFStatus_hash = new HashMap<Integer, String>();
                            for (String Pmid_LF : this.data.getPmidLF2Abb_hash().keySet()) {
                                int l;
                                String[] pf = Pmid_LF.split("\\t", -1);
                                if (!pf[0].equals(Pmid)) continue;
                                String Abb = this.data.getPmidLF2Abb_hash().get(Pmid_LF);
                                String LF = pf[1];
                                Abb = Abb.replaceAll("([0-9])([A-Za-z])", "$1 $2");
                                Abb = Abb.replaceAll("([A-Za-z])([0-9])", "$1 $2");
                                Abb = Abb.replaceAll("([A-Z])([a-z])", "$1 $2");
                                Abb = Abb.replaceAll("([a-z])([A-Z])", "$1 $2");
                                Abb = Abb.replaceAll("([\\W])", " $1 ");
                                Abb = Abb.replaceAll("[ ]+", " ");
                                Abb = Abb.replaceAll("^[ ]+", "");
                                LF = LF.replaceAll("([0-9])([A-Za-z])", "$1 $2");
                                LF = LF.replaceAll("([A-Za-z])([0-9])", "$1 $2");
                                LF = LF.replaceAll("([A-Z])([a-z])", "$1 $2");
                                LF = LF.replaceAll("([a-z])([A-Z])", "$1 $2");
                                LF = LF.replaceAll("([\\W])", " $1 ");
                                LF = LF.replaceAll("[ ]+", " ");
                                LF = LF.replaceAll("^[ ]+", "");
                                Abb = Abb.replaceAll("([\\~\\!\\@\\#\\$\\%\\^\\&\\*\\(\\)\\_\\+\\-\\=\\[\\]\\;\\'\\,\\.\\/\\{\\}\\|\\:\\?])", "\\\\$1");
                                LF = LF.replaceAll("([\\~\\!\\@\\#\\$\\%\\^\\&\\*\\(\\)\\_\\+\\-\\=\\[\\]\\;\\'\\,\\.\\/\\{\\}\\|\\:\\?])", "\\\\$1");
                                Abb = Abb.toLowerCase();
                                LF = LF.toLowerCase();
                                Pattern ptmp1 = Pattern.compile("(.*)(" + LF + ")([ ]*\\([ ]*)(" + Abb + ")[ ]*\\).*");
                                Matcher mtmp1 = ptmp1.matcher(TokenSTR.toLowerCase());
                                Pattern ptmp2 = Pattern.compile("(.*)(" + Abb + ")([ ]*\\([ ]*)(" + LF + ")[ ]*\\).*");
                                Matcher mtmp2 = ptmp2.matcher(TokenSTR.toLowerCase());
                                int start_LF = 0;
                                int last_LF = 0;
                                int start_Abb = 0;
                                int last_Abb = 0;
                                if (mtmp1.find()) {
                                    start_LF = mtmp1.group(1).length();
                                    last_LF = start_LF + mtmp1.group(2).length();
                                    start_Abb = last_LF + mtmp1.group(3).length();
                                    last_Abb = start_Abb + mtmp1.group(4).length();
                                } else if (mtmp2.find()) {
                                    start_Abb = mtmp2.group(1).length();
                                    last_Abb = start_LF + mtmp2.group(2).length();
                                    start_LF = last_LF + mtmp2.group(3).length();
                                    last_LF = start_Abb + mtmp2.group(4).length();
                                }
                                for (l = start_LF; l < last_LF; ++l) {
                                    AbbLFStatus_hash.put(l, "FullName");
                                }
                                for (l = start_Abb; l < last_Abb; ++l) {
                                    AbbLFStatus_hash.put(l, "Abbreviation");
                                }
                            }
                            int Offset = 0;
                            for (int p = 0; p < tokens.length; ++p) {
                                Object Pattern1;
                                Object WSB = "WSB:N/A";
                                Object WSF = "WSF:N/A";
                                if (p > 0) {
                                    String B = tokens[p - 1];
                                    B = B.replaceAll("[A-Za-z]+", "A");
                                    B = B.replaceAll("[0-9]+", "0");
                                    WSB = "WSB:" + B;
                                }
                                if (p < tokens.length - 1) {
                                    String F = tokens[p + 1];
                                    F = F.replaceAll("[A-Za-z]+", "A");
                                    F = F.replaceAll("[0-9]+", "0");
                                    WSF = "WSF:" + F;
                                }
                                stemmer.setCurrent(tokens[p].toLowerCase());
                                stemmer.stem();
                                String stem = stemmer.getCurrent();
                                Object Num_num = "";
                                String tmp = tokens[p];
                                tmp = tmp.replaceAll("[^0-9]", "");
                                Num_num = tmp.length() > 3 ? "N:4+" : "N:" + tmp.length();
                                Object Num_Uc = "";
                                tmp = tokens[p];
                                tmp = tmp.replaceAll("[^A-Z]", "");
                                Num_Uc = tmp.length() > 3 ? "U:4+" : "U:" + tmp.length();
                                Object Num_lc = "";
                                tmp = tokens[p];
                                tmp = tmp.replaceAll("[^a-z]", "");
                                Num_lc = tmp.length() > 3 ? "L:4+" : "L:" + tmp.length();
                                Object Num_All = "";
                                Num_All = tokens[p].length() > 3 ? "A:4+" : "A:" + tokens[p].length();
                                String SpecificC = "__nil__";
                                if (tokens[p].equals(";") || tokens[p].equals(":") || tokens[p].equals(",") || tokens[p].equals(".") || tokens[p].equals("-") || tokens[p].equals(">") || tokens[p].equals("+") || tokens[p].equals("_")) {
                                    SpecificC = "-SpecificC1-";
                                } else if (tokens[p].equals("(") || tokens[p].equals(")")) {
                                    SpecificC = "-SpecificC2-";
                                } else if (tokens[p].equals("{") || tokens[p].equals("}")) {
                                    SpecificC = "-SpecificC3-";
                                } else if (tokens[p].equals("[") || tokens[p].equals("]")) {
                                    SpecificC = "-SpecificC4-";
                                } else if (tokens[p].equals("\\") || tokens[p].equals("/")) {
                                    SpecificC = "-SpecificC5-";
                                }
                                String ChemPreSuf = "__nil__";
                                if (tokens[p].matches(".*(yl|ylidyne|oyl|sulfonyl)")) {
                                    ChemPreSuf = "-CHEMinlineSuffix-";
                                } else if (tokens[p].matches("(meth|eth|prop|tetracos).*")) {
                                    ChemPreSuf = "-CHEMalkaneStem-";
                                } else if (tokens[p].matches("(di|tri|tetra).*")) {
                                    ChemPreSuf = "-CHEMsimpleMultiplier-";
                                } else if (tokens[p].matches("(benzen|pyridin|toluen).*")) {
                                    ChemPreSuf = "-CHEMtrivialRing-";
                                } else if (tokens[p].matches(".*(one|ol|carboxylic|amide|ate|acid|ium|ylium|ide|uide|iran|olan|inan|pyrid|acrid|amid|keten|formazan|fydrazin)(s|)")) {
                                    ChemPreSuf = "-CHEMsuffix-";
                                }
                                Object MentionType = "__nil__";
                                if (GNormPlus.SimConceptMention2Type_hash.containsKey(tokens[p])) {
                                    MentionType = "-" + GNormPlus.SimConceptMention2Type_hash.get(tokens[p]) + "-";
                                }
                                String ProteinSym = "__nil__";
                                if (tokens[p].matches(".*(glutamine|glutamic|leucine|valine|isoleucine|lysine|alanine|glycine|aspartate|methionine|threonine|histidine|aspartic|asparticacid|arginine|asparagine|tryptophan|proline|phenylalanine|cysteine|serine|glutamate|tyrosine|stop|frameshift).*")) {
                                    ChemPreSuf = "-ProteinSymFull-";
                                } else if (tokens[p].matches("(cys|ile|ser|gln|met|asn|pro|lys|asp|thr|phe|ala|gly|his|leu|arg|trp|val|glu|tyr|fs|fsx)")) {
                                    ChemPreSuf = "-ProteinSymTri-";
                                } else if (tokens[p].matches("[CISQMNPKDTFAGHLRWVEYX]")) {
                                    ChemPreSuf = "-ProteinSymChar-";
                                }
                                String Repeat = "__nil__";
                                if ((Integer)Token2Num.get(tokens[p]) > 1 && tokens[p].length() > 1 && !tokens[p].matches("([\\W\\-\\_0-9]+|and|or|alpha|beta|gamma|theta|zeta|delta|kappa|II|VI|IV|III)")) {
                                    Repeat = "-Repeat-";
                                }
                                if (((String)(Pattern1 = tokens[p])).matches(".*[\\W\\-\\_].*")) {
                                    Pattern1 = "__nil__";
                                } else {
                                    Pattern1 = ((String)Pattern1).replaceAll("[A-Z]", "A");
                                    Pattern1 = ((String)Pattern1).replaceAll("[a-z]", "a");
                                    Pattern1 = ((String)Pattern1).replaceAll("[0-9]", "0");
                                    Pattern1 = "P1:" + (String)Pattern1;
                                }
                                Object Pattern2 = tokens[p];
                                if (((String)Pattern2).matches(".*[\\W\\-\\_].*")) {
                                    Pattern2 = "__nil__";
                                } else {
                                    Pattern2 = ((String)Pattern2).replaceAll("[A-Za-z]", "a");
                                    Pattern2 = ((String)Pattern2).replaceAll("[0-9]", "0");
                                    Pattern2 = "P2:" + (String)Pattern2;
                                }
                                Object Pattern3 = tokens[p];
                                if (((String)Pattern3).matches(".*[\\W\\-\\_].*")) {
                                    Pattern3 = "__nil__";
                                } else {
                                    Pattern3 = ((String)Pattern3).replaceAll("[A-Z]+", "A");
                                    Pattern3 = ((String)Pattern3).replaceAll("[a-z]+", "a");
                                    Pattern3 = ((String)Pattern3).replaceAll("[0-9]+", "0");
                                    Pattern3 = "P3:" + (String)Pattern3;
                                }
                                Object Pattern4 = tokens[p];
                                if (((String)Pattern4).matches(".*[\\W\\-\\_].*")) {
                                    Pattern4 = "__nil__";
                                } else {
                                    Pattern4 = ((String)Pattern4).replaceAll("[A-Za-z]+", "a");
                                    Pattern4 = ((String)Pattern4).replaceAll("[0-9]+", "0");
                                    Pattern4 = "P4:" + (String)Pattern4;
                                }
                                Object prefix = "";
                                tmp = tokens[p];
                                prefix = tmp.length() >= 1 ? tmp.substring(0, 1) : "__nil__";
                                prefix = tmp.length() >= 2 ? (String)prefix + " " + tmp.substring(0, 2) : (String)prefix + " __nil__";
                                prefix = tmp.length() >= 3 ? (String)prefix + " " + tmp.substring(0, 3) : (String)prefix + " __nil__";
                                prefix = tmp.length() >= 4 ? (String)prefix + " " + tmp.substring(0, 4) : (String)prefix + " __nil__";
                                prefix = tmp.length() >= 5 ? (String)prefix + " " + tmp.substring(0, 5) : (String)prefix + " __nil__";
                                Object suffix = "";
                                tmp = tokens[p];
                                suffix = tmp.length() >= 1 ? tmp.substring(tmp.length() - 1, tmp.length()) : "__nil__";
                                suffix = tmp.length() >= 2 ? (String)suffix + " " + tmp.substring(tmp.length() - 2, tmp.length()) : (String)suffix + " __nil__";
                                suffix = tmp.length() >= 3 ? (String)suffix + " " + tmp.substring(tmp.length() - 3, tmp.length()) : (String)suffix + " __nil__";
                                suffix = tmp.length() >= 4 ? (String)suffix + " " + tmp.substring(tmp.length() - 4, tmp.length()) : (String)suffix + " __nil__";
                                suffix = tmp.length() >= 5 ? (String)suffix + " " + tmp.substring(tmp.length() - 5, tmp.length()) : (String)suffix + " __nil__";
                                String AbbLF = "__nil__";
                                if (AbbLFStatus_hash.containsKey(Offset)) {
                                    AbbLF = (String)AbbLFStatus_hash.get(Offset);
                                }
                                FileData.write(tokens[p] + " " + (String)WSB + " " + (String)WSF + " " + stem + " " + (String)Num_num + " " + (String)Num_num + " " + (String)Num_Uc + " " + (String)Num_lc + " " + (String)Num_All + " " + SpecificC + " " + ChemPreSuf + " " + (String)MentionType + " " + ProteinSym + " " + Repeat + " " + (String)Pattern1 + " " + (String)Pattern2 + " " + (String)Pattern3 + " " + (String)Pattern4 + " " + (String)prefix + " " + (String)suffix + " " + AbbLF + "\n");
                                Offset = Offset + tokens[p].length() + 1;
                            }
                            FileData.write("\n");
                        }
                    }
                }
            }
            FileData.close();
        }
        catch (IOException e1) {
            System.out.println("[MR]: Input file is not exist.");
        }
    }

    public void CRF_test(String model, String FilenameData, String FilenameOutput) throws IOException {
        File f = new File(FilenameOutput);
        BufferedWriter fr = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
        Runtime runtime = Runtime.getRuntime();
        String cmd = "CRF/crf_test -m " + model + " -o " + FilenameOutput + " " + FilenameData;
        try {
            Process process = runtime.exec(cmd);
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is, "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            String line = "";
            while ((line = br.readLine()) != null) {
                fr.write(line);
                fr.newLine();
                fr.flush();
            }
            is.close();
            isr.close();
            br.close();
            fr.close();
        }
        catch (IOException e) {
            System.out.println(e);
            runtime.exit(0);
        }
    }

    public void CRF_learn(String model, String FilenameData) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        String line = null;
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        String cmd = "CRF/crf_learn -f 3 -c 4.0 CRF/template_SimConcept " + FilenameData + " " + model;
        try {
            process = runtime.exec(cmd);
            is = process.getInputStream();
            isr = new InputStreamReader(is, "UTF-8");
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                System.out.println(line);
                System.out.flush();
            }
            is.close();
            isr.close();
            br.close();
        }
        catch (IOException e) {
            System.out.println(e);
            runtime.exit(0);
        }
    }

    public void ReadCRFresult(String Filename, String FilenameOutput, String FilenameBioC) throws XMLStreamException, IOException {
        String[] MenArr;
        String[] anno;
        int i;
        String line;
        ArrayList<String> outputArr1 = new ArrayList<String>();
        BufferedReader inputfile = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FilenameOutput), "UTF-8"));
        while ((line = inputfile.readLine()) != null) {
            outputArr1.add(line);
        }
        inputfile.close();
        int Count_mention = 0;
        boolean Simplified = false;
        Object Mention = "";
        Object Mention_NoSpace = "";
        Object States = "";
        HashMap<Object, Object> Mentions_hash = new HashMap<Object, Object>();
        HashMap<String, Object> States_hash = new HashMap<String, Object>();
        HashMap<String, Object> Output_Split_mention_Ind = new HashMap<String, Object>();
        HashMap<String, Object> Output_Split_mention = new HashMap<String, Object>();
        for (int i2 = 0; i2 < outputArr1.size(); ++i2) {
            String[] outputsRow = ((String)outputArr1.get(i2)).split("\\t", -1);
            String Token = outputsRow[0];
            String TknState = outputsRow[outputsRow.length - 1];
            if (TknState.matches("[CJBEFN]")) {
                Simplified = true;
            }
            if (outputsRow.length <= 1) {
                if (Simplified) {
                    for (String PmidAbb : this.data.getPmidAbb2LF_hash().keySet()) {
                        int t;
                        String N4;
                        Object N3;
                        Object N2;
                        String N1;
                        String[] t3;
                        String[] t2;
                        int t1_len;
                        String[] PmidAbbs = PmidAbb.split("\\t", -1);
                        String Abb = PmidAbbs[1];
                        String LF = this.data.getPmidAbb2LF_hash().get(PmidAbb);
                        Abb = Abb.replaceAll("([0-9])([A-Za-z])", "$1 $2");
                        Abb = Abb.replaceAll("([A-Za-z])([0-9])", "$1 $2");
                        Abb = Abb.replaceAll("([A-Z])([a-z])", "$1 $2");
                        Abb = Abb.replaceAll("([a-z])([A-Z])", "$1 $2");
                        Abb = Abb.replaceAll("([\\W])", " $1 ");
                        Abb = Abb.replaceAll("[ ]+", " ");
                        Abb = Abb.replaceAll("^[ ]+", "");
                        LF = LF.replaceAll("([0-9])([A-Za-z])", "$1 $2");
                        LF = LF.replaceAll("([A-Za-z])([0-9])", "$1 $2");
                        LF = LF.replaceAll("([A-Z])([a-z])", "$1 $2");
                        LF = LF.replaceAll("([a-z])([A-Z])", "$1 $2");
                        LF = LF.replaceAll("([\\W])", " $1 ");
                        LF = LF.replaceAll("[ ]+", " ");
                        LF = LF.replaceAll("^[ ]+", "");
                        Abb = Abb.replaceAll("([^A-Za-z0-9@ ])", "\\\\$1");
                        LF = LF.replaceAll("([^A-Za-z0-9@ ])", "\\\\$1");
                        Pattern ptmp1 = Pattern.compile("^(.*)(" + LF + ") \\( (" + Abb + ") \\) (.*)$");
                        Matcher mtmp1 = ptmp1.matcher((CharSequence)Mention);
                        Pattern ptmp2 = Pattern.compile("^(.*)(" + Abb + ") \\( (" + LF + ") \\) (.*)$");
                        Matcher mtmp2 = ptmp2.matcher((CharSequence)Mention);
                        if (mtmp1.find()) {
                            t1_len = 0;
                            if (!mtmp1.group(1).equals("")) {
                                t1_len = mtmp1.group(1).split(" ", -1).length;
                            }
                            t2 = mtmp1.group(2).split(" ", -1);
                            t3 = mtmp1.group(3).split(" ", -1);
                            N1 = "";
                            N2 = "";
                            N3 = "";
                            N4 = "";
                            N1 = ((String)States).substring(0, t1_len);
                            for (t = 0; t < t2.length; ++t) {
                                N2 = (String)N2 + "W";
                            }
                            for (t = 0; t < t3.length; ++t) {
                                N3 = (String)N3 + "W";
                            }
                            N4 = ((String)States).substring(N1.length() + ((String)N2).length() + ((String)N3).length() + 2);
                            States = N1 + (String)N2 + "X" + (String)N3 + "O" + N4;
                            continue;
                        }
                        if (!mtmp2.find()) continue;
                        t1_len = 0;
                        if (!mtmp2.group(1).equals("")) {
                            t1_len = mtmp2.group(1).split(" ", -1).length;
                        }
                        t2 = mtmp2.group(2).split(" ", -1);
                        t3 = mtmp2.group(3).split(" ", -1);
                        N1 = "";
                        N2 = "";
                        N3 = "";
                        N4 = "";
                        N1 = ((String)States).substring(0, t1_len);
                        for (t = 0; t < t2.length; ++t) {
                            N2 = (String)N2 + "W";
                        }
                        for (t = 0; t < t3.length; ++t) {
                            N3 = (String)N3 + "W";
                        }
                        N4 = ((String)States).substring(N1.length() + ((String)N2).length() + ((String)N3).length() + 2);
                        States = N1 + (String)N2 + "X" + (String)N3 + "O" + N4;
                    }
                    States_hash.put((String)Mention_NoSpace, States);
                    Mentions_hash.put(Mention_NoSpace, Mention);
                }
                Simplified = false;
                Mention = "";
                Mention_NoSpace = "";
                ++Count_mention;
                States = "";
                continue;
            }
            Mention = ((String)Mention).equals("") ? Token : (String)Mention + " " + Token;
            States = (String)States + TknState;
            Mention_NoSpace = (String)Mention_NoSpace + Token;
        }
        for (String MNoSpace : Mentions_hash.keySet()) {
            Object A;
            int m;
            int s;
            ArrayList<Object> Split_mention = new ArrayList<Object>();
            ArrayList<Object> Split_state = new ArrayList<Object>();
            Object tmp_mention = "";
            Object tmp_state = "";
            String[] TokenArr = ((String)Mentions_hash.get(MNoSpace)).split(" ", -1);
            String[] StateArr = ((String)States_hash.get(MNoSpace)).split("", -1);
            Pattern ptmp1 = Pattern.compile("^([S]+)([CN])([S]+)$");
            Matcher mtmp1 = ptmp1.matcher((CharSequence)States_hash.get(MNoSpace));
            if (mtmp1.find()) {
                States_hash.put(MNoSpace, mtmp1.group(1) + "J" + mtmp1.group(3));
            }
            int len = TokenArr.length;
            if (StateArr.length < TokenArr.length) {
                len = StateArr.length;
            }
            for (s = 0; s < len; ++s) {
                if (StateArr[s].matches("[BE]")) {
                    if (((String)tmp_mention).length() > 0) {
                        Split_mention.add(tmp_mention);
                        Split_state.add(tmp_state);
                    }
                    tmp_mention = "";
                    tmp_state = "";
                    continue;
                }
                tmp_mention = (String)tmp_mention + TokenArr[s] + " ";
                tmp_state = (String)tmp_state + StateArr[s];
            }
            if (!((String)tmp_mention).equals("")) {
                Split_mention.add(tmp_mention);
                Split_state.add(tmp_state);
            }
            for (m = 0; m < Split_mention.size(); ++m) {
                A = "";
                String X = "";
                Object STAA = "";
                Object strainX = "";
                Object STAstrainX = "";
                int X_continous = 0;
                ArrayList<Object> strainsX = new ArrayList<Object>();
                ArrayList<Object> STAstrainsX = new ArrayList<Object>();
                String[] each_token = ((String)Split_mention.get(m)).split(" ");
                String[] each_state = ((String)Split_state.get(m)).split("");
                for (int s2 = 0; s2 < each_state.length; ++s2) {
                    if (each_state[s2].matches("[ACNS]")) {
                        A = (String)A + each_token[s2] + " ";
                        STAA = (String)STAA + each_state[s2];
                        continue;
                    }
                    if (each_state[s2].equals("W")) {
                        A = (String)A + "STRAINXXX";
                        STAA = (String)STAA + "@";
                        strainX = (String)strainX + each_token[s2] + " ";
                        STAstrainX = (String)STAstrainX + each_state[s2];
                        X_continous = 0;
                        continue;
                    }
                    if (!each_state[s2].equals("X") || X_continous != 0) continue;
                    X = each_state[s2];
                    strainsX.add(strainX);
                    STAstrainsX.add(STAstrainX);
                    strainX = "";
                    STAstrainX = "";
                    ++X_continous;
                }
                if (!((String)strainX).equals("")) {
                    strainsX.add(strainX);
                }
                if (!((String)STAstrainX).equals("")) {
                    STAstrainsX.add(STAstrainX);
                }
                A = ((String)A).replaceAll("(STRAINXXX){1,}", "STRAINXXX");
                STAA = ((String)STAA).replaceAll("(@){1,}", "@");
                if (!X.equals("X")) continue;
                for (int x = 0; x < strainsX.size(); ++x) {
                    String strain = (String)strainsX.get(x);
                    String state = (String)STAstrainsX.get(x);
                    Object tkns = A;
                    strain = strain.replaceAll("([\\W\\-\\_])", "\\\\$1");
                    tkns = ((String)tkns).replaceAll("STRAINXXX", strain);
                    if (((String)(tkns = ((String)tkns).replaceAll("  ", " "))).substring(((String)tkns).length() - 1, ((String)tkns).length() - 1).equals(" ")) {
                        tkns = ((String)tkns).substring(0, ((String)tkns).length() - 2);
                    }
                    Object STAAs = STAA;
                    STAAs = ((String)STAAs).replaceAll("@", state);
                    Split_mention.add(tkns);
                    Split_state.add(STAAs);
                }
                Split_mention.remove(m);
                Split_state.remove(m);
            }
            for (s = 0; s < Split_state.size(); ++s) {
                Split_state.set(s, ((String)Split_state.get(s)).replaceAll("W", "A"));
            }
            for (m = 0; m < Split_mention.size(); ++m) {
                String[] each_token = ((String)Split_mention.get(m)).split(" ", -1);
                String[] each_state = ((String)Split_state.get(m)).split("", -1);
                Object sub_mention = "";
                boolean found_J = false;
                for (int k = 0; k < each_state.length; ++k) {
                    if (each_state[k].equals("J")) {
                        found_J = true;
                        if (Output_Split_mention_Ind.containsKey(MNoSpace)) {
                            Output_Split_mention_Ind.put(MNoSpace, (String)Output_Split_mention_Ind.get(MNoSpace) + "|" + (String)sub_mention);
                        } else {
                            Output_Split_mention_Ind.put(MNoSpace, sub_mention);
                        }
                        sub_mention = "";
                        continue;
                    }
                    sub_mention = (String)sub_mention + each_token[k] + " ";
                }
                if (!found_J) continue;
                if (Output_Split_mention_Ind.containsKey(MNoSpace)) {
                    Output_Split_mention_Ind.put(MNoSpace, (String)Output_Split_mention_Ind.get(MNoSpace) + "|" + (String)sub_mention);
                    continue;
                }
                Output_Split_mention_Ind.put(MNoSpace, sub_mention);
            }
            for (m = 0; m < Split_mention.size(); ++m) {
                A = "";
                Object strainCN = "";
                int CNO_continous = 0;
                ArrayList<Object> strainsCN = new ArrayList<Object>();
                String CorN = "";
                String[] each_token = ((String)Split_mention.get(m)).split(" ", -1);
                String[] each_state = ((String)Split_state.get(m)).split("", -1);
                for (int k = 0; k < each_state.length; ++k) {
                    if (each_state[k].equals("A")) {
                        A = (String)A + each_token[k] + " ";
                        continue;
                    }
                    if (each_state[k].equals("S")) {
                        if (((String)A).length() >= 4) {
                            A = ((String)A).replace("s $", "");
                        }
                        A = (String)A + "STRAINXXX";
                        strainCN = (String)strainCN + each_token[k] + " ";
                        CNO_continous = 0;
                        continue;
                    }
                    if (each_state[k].matches("[CN]") && CNO_continous == 0) {
                        CorN = each_state[k];
                        strainsCN.add(strainCN);
                        strainCN = "";
                        ++CNO_continous;
                        continue;
                    }
                    if (!each_state[k].equals("J")) continue;
                    if (!((String)strainCN).equals("")) {
                        strainsCN.add(strainCN);
                    }
                    A = ((String)A).replaceAll("STRAINXXXSTRAINXXX", "STRAINXXX");
                    A = ((String)A).replaceAll("STRAINXXXSTRAINXXX", "STRAINXXX");
                    ptmp1 = Pattern.compile("^(.+)s (.*)$");
                    mtmp1 = ptmp1.matcher((CharSequence)A);
                    if (mtmp1.find() && mtmp1.group(1).length() >= 3) {
                        A = mtmp1.group(1) + " " + mtmp1.group(2);
                    }
                    if (CorN.equals("C")) {
                        for (int x = 0; x < strainsCN.size(); ++x) {
                            Object tmp = A;
                            String strainsCN_tmp = ((String)strainsCN.get(x)).replaceAll("([^A-Za-z0-9@ ])", "\\\\$1");
                            tmp = ((String)tmp).replaceAll("STRAINXXX", strainsCN_tmp);
                            if (((String)(tmp = ((String)tmp).replaceAll("[ ]+", " "))).length() > 2 && ((String)tmp).substring(((String)tmp).length() - 2, ((String)tmp).length() - 2).equals(" ")) {
                                tmp = ((String)tmp).substring(0, ((String)tmp).length() - 2);
                            }
                            if (Output_Split_mention_Ind.containsKey(MNoSpace)) {
                                Output_Split_mention_Ind.put(MNoSpace, (String)Output_Split_mention_Ind.get(MNoSpace) + "|" + (String)tmp);
                                continue;
                            }
                            Output_Split_mention_Ind.put(MNoSpace, tmp);
                        }
                    } else if (CorN.equals("N")) {
                        if (strainsCN.contains(0) && strainsCN.contains(1)) {
                            String strain1 = ((String)strainsCN.get(0)).replaceAll(" ", "");
                            String strain2 = ((String)strainsCN.get(1)).replaceAll(" ", "");
                            if (strain1.matches("[0-9]+") && strain2.matches("[0-9]+")) {
                                if (Integer.parseInt(strain2) - Integer.parseInt(strain1) <= 20) {
                                    for (int strCount = Integer.parseInt(strain1); strCount <= Integer.parseInt(strain2); ++strCount) {
                                        Object tmp = A;
                                        tmp = ((String)tmp).replace("STRAINXXX", Integer.toString(strCount));
                                        if (((String)(tmp = ((String)tmp).replaceAll("[ ]+", " "))).length() > 2 && ((String)tmp).substring(((String)tmp).length() - 2, ((String)tmp).length() - 2).equals(" ")) {
                                            tmp = ((String)tmp).substring(0, ((String)tmp).length() - 2);
                                        }
                                        if (Output_Split_mention_Ind.containsKey(MNoSpace)) {
                                            Output_Split_mention_Ind.put(MNoSpace, (String)Output_Split_mention_Ind.get(MNoSpace) + "|" + (String)tmp);
                                            continue;
                                        }
                                        Output_Split_mention_Ind.put(MNoSpace, tmp);
                                    }
                                }
                            } else if (strain1.matches("[A-Z]+ ") && strain2.matches("[A-Z]+ ")) {
                                int strInt1 = strain1.replaceAll(" ", "").charAt(0);
                                char strInt2 = strain2.replaceAll(" ", "").charAt(0);
                                if (strInt2 - strInt1 <= 20) {
                                    for (int strCount = strInt1; strCount <= strInt2; ++strCount) {
                                        Object tmp = A;
                                        tmp = ((String)tmp).replace("STRAINXXX", Integer.toString(strCount));
                                        if (((String)(tmp = ((String)tmp).replaceAll("[ ]+", " "))).length() > 2 && ((String)tmp).substring(((String)tmp).length() - 2, ((String)tmp).length() - 2).equals(" ")) {
                                            tmp = ((String)tmp).substring(0, ((String)tmp).length() - 2);
                                        }
                                        if (Output_Split_mention_Ind.containsKey(MNoSpace)) {
                                            Output_Split_mention_Ind.put(MNoSpace, (String)Output_Split_mention_Ind.get(MNoSpace) + "|" + (String)tmp);
                                            continue;
                                        }
                                        Output_Split_mention_Ind.put(MNoSpace, tmp);
                                    }
                                }
                            } else if (Output_Split_mention.containsKey(MNoSpace)) {
                                Output_Split_mention.put(MNoSpace, (String)Output_Split_mention.get(MNoSpace) + "|" + (String)Split_mention.get(m));
                            } else {
                                Output_Split_mention.put(MNoSpace, (String)Split_mention.get(m));
                            }
                        }
                    } else if (Output_Split_mention.containsKey(MNoSpace)) {
                        Output_Split_mention.put(MNoSpace, (String)Output_Split_mention.get(MNoSpace) + "|" + (String)Split_mention.get(m));
                    } else {
                        Output_Split_mention.put(MNoSpace, (String)Split_mention.get(m));
                    }
                    A = "";
                    strainCN = "";
                    CNO_continous = 0;
                    strainsCN = new ArrayList();
                    CorN = "";
                }
                if (!((String)strainCN).equals("")) {
                    strainsCN.add(strainCN);
                }
                A = ((String)A).replaceAll("(STRAINXXX){2,}", "STRAINXXX");
                ptmp1 = Pattern.compile("^(.+)s (.*)$");
                mtmp1 = ptmp1.matcher((CharSequence)A);
                if (mtmp1.find() && mtmp1.group(1).length() >= 3) {
                    A = mtmp1.group(1) + " " + mtmp1.group(2);
                }
                if (CorN.equals("C")) {
                    for (int x = 0; x < strainsCN.size(); ++x) {
                        Object tmp = A;
                        tmp = ((String)tmp).replaceAll("\\$", " ");
                        strainsCN.set(x, ((String)strainsCN.get(x)).replaceAll("\\$", " "));
                        tmp = ((String)tmp).replaceAll("STRAINXXX", (String)strainsCN.get(x));
                        tmp = ((String)tmp).replaceAll("[ ]+", " ");
                        if (((String)tmp).length() > 2 && ((String)tmp).substring(((String)tmp).length() - 2, ((String)tmp).length() - 2).equals(" ")) {
                            tmp = ((String)tmp).substring(0, ((String)tmp).length() - 2);
                        }
                        if (Output_Split_mention_Ind.containsKey(MNoSpace)) {
                            Output_Split_mention_Ind.put(MNoSpace, (String)Output_Split_mention_Ind.get(MNoSpace) + "|" + (String)tmp);
                            continue;
                        }
                        Output_Split_mention_Ind.put(MNoSpace, tmp);
                    }
                    continue;
                }
                if (CorN.equals("N")) {
                    if (strainsCN.size() != 2) continue;
                    String strain1 = ((String)strainsCN.get(0)).replaceAll(" ", "");
                    String strain2 = ((String)strainsCN.get(1)).replaceAll(" ", "");
                    if (strain1.matches("[0-9]{1,7}") && strain2.matches("[0-9]{1,7}")) {
                        if (Integer.parseInt(strain2) - Integer.parseInt(strain1) > 20) continue;
                        for (int strCount = Integer.parseInt(strain1); strCount <= Integer.parseInt(strain2); ++strCount) {
                            Object tmp = A;
                            tmp = ((String)tmp).replace("STRAINXXX", Integer.toString(strCount));
                            if (((String)(tmp = ((String)tmp).replaceAll("[ ]+", " "))).length() > 2 && ((String)tmp).substring(((String)tmp).length() - 2, ((String)tmp).length() - 2).equals(" ")) {
                                tmp = ((String)tmp).substring(0, ((String)tmp).length() - 2);
                            }
                            if (Output_Split_mention_Ind.containsKey(MNoSpace)) {
                                Output_Split_mention_Ind.put(MNoSpace, (String)Output_Split_mention_Ind.get(MNoSpace) + "|" + (String)tmp);
                                continue;
                            }
                            Output_Split_mention_Ind.put(MNoSpace, tmp);
                        }
                        continue;
                    }
                    if (strain1.matches("[A-Z]+ ") && strain2.matches("[A-Z]+ ")) {
                        int strInt1 = strain1.replaceAll(" ", "").charAt(0);
                        char strInt2 = strain2.replaceAll(" ", "").charAt(0);
                        if (strInt2 - strInt1 > 20) continue;
                        for (int strCount = strInt1; strCount <= strInt2; ++strCount) {
                            Object tmp = A;
                            tmp = ((String)tmp).replace("STRAINXXX", Integer.toString(strCount));
                            if (((String)(tmp = ((String)tmp).replaceAll("[ ]+", " "))).length() > 2 && ((String)tmp).substring(((String)tmp).length() - 2, ((String)tmp).length() - 2).equals(" ")) {
                                tmp = ((String)tmp).substring(0, ((String)tmp).length() - 2);
                            }
                            if (Output_Split_mention_Ind.containsKey(MNoSpace)) {
                                Output_Split_mention_Ind.put(MNoSpace, (String)Output_Split_mention_Ind.get(MNoSpace) + "|" + (String)tmp);
                                continue;
                            }
                            Output_Split_mention_Ind.put(MNoSpace, tmp);
                        }
                        continue;
                    }
                    if (Output_Split_mention.containsKey(MNoSpace)) {
                        Output_Split_mention.put(MNoSpace, (String)Output_Split_mention.get(MNoSpace) + "|" + (String)Split_mention.get(m));
                        continue;
                    }
                    Output_Split_mention.put(MNoSpace, (String)Split_mention.get(m));
                    continue;
                }
                if (Output_Split_mention.containsKey(MNoSpace)) {
                    Output_Split_mention.put(MNoSpace, (String)Output_Split_mention.get(MNoSpace) + "|" + (String)Split_mention.get(m));
                    continue;
                }
                Output_Split_mention.put(MNoSpace, (String)Split_mention.get(m));
            }
        }
        for (i = 0; i < this.data.getBioCDocobj().Annotations.size(); ++i) {
            for (int j = 0; j < this.data.getBioCDocobj().Annotations.get(i).size(); ++j) {
                int Annotation_Num = this.data.getBioCDocobj().Annotations.get(i).get(j).size();
                for (int k = 0; k < Annotation_Num; ++k) {
                    anno = this.data.getBioCDocobj().Annotations.get(i).get(j).get(k).split("\\t");
                    MenArr = anno[2].split("\\|");
                    for (int m = 0; m < MenArr.length; ++m) {
                        String MNoSpace = MenArr[m];
                        if (Output_Split_mention_Ind.containsKey(MNoSpace = MNoSpace.replaceAll("[ ]+", ""))) {
                            String anno2;
                            int s;
                            String[] split_men;
                            if (anno.length == 5) {
                                split_men = ((String)Output_Split_mention_Ind.get(MNoSpace)).split("\\|");
                                for (s = 0; s < split_men.length; ++s) {
                                    anno2 = anno[2] + "|" + split_men[s];
                                    this.data.getBioCDocobj().Annotations.get(i).get(j).add(anno[0] + "\t" + anno[1] + "\t" + anno2 + "\t" + anno[3] + "\t" + anno[4]);
                                }
                                continue;
                            }
                            if (anno.length >= 5) continue;
                            split_men = ((String)Output_Split_mention_Ind.get(MNoSpace)).split("\\|");
                            for (s = 0; s < split_men.length; ++s) {
                                anno2 = anno[2] + "|" + split_men[s];
                                this.data.getBioCDocobj().Annotations.get(i).get(j).add(anno[0] + "\t" + anno[1] + "\t" + anno2 + "\t" + anno[3]);
                            }
                            continue;
                        }
                        if (!Output_Split_mention.containsKey(MNoSpace)) continue;
                        if (anno.length == 5) {
                            String anno2 = anno[2] + "|" + (String)Output_Split_mention.get(MNoSpace);
                            this.data.getBioCDocobj().Annotations.get(i).get(j).set(k, anno[0] + "\t" + anno[1] + "\t" + anno2 + "\t" + anno[3] + "\t" + anno[4]);
                            continue;
                        }
                        if (anno.length >= 5) continue;
                        this.data.getBioCDocobj().Annotations.get(i).get(j).set(k, anno[0] + "\t" + anno[1] + "\t" + anno[2] + "\t" + anno[3]);
                    }
                }
            }
        }
        for (i = 0; i < this.data.getBioCDocobj().Annotations.size(); ++i) {
            for (int j = 0; j < this.data.getBioCDocobj().Annotations.get(i).size(); ++j) {
                int Annotation_Num = this.data.getBioCDocobj().Annotations.get(i).get(j).size();
                for (int k = 0; k < Annotation_Num; ++k) {
                    anno = this.data.getBioCDocobj().Annotations.get(i).get(j).get(k).split("\\t");
                    MenArr = anno[2].split("\\|");
                    ArrayList<String> Mentions = new ArrayList<String>();
                    block32: for (int m = 0; m < MenArr.length; ++m) {
                        Mentions.add(MenArr[m]);
                        for (String orig_mention : GNormPlus.suffixprefix_orig2modified.keySet()) {
                            String modi_mention = GNormPlus.suffixprefix_orig2modified.get(orig_mention);
                            if (!MenArr[m].equals(orig_mention)) continue;
                            Mentions.add(modi_mention);
                            continue block32;
                        }
                    }
                    Object mens = "";
                    for (int m = 0; m < Mentions.size(); ++m) {
                        String mention = (String)Mentions.get(m);
                        mens = ((String)mens).equals("") ? mention : (String)mens + "|" + mention;
                    }
                    if (anno.length == 5) {
                        this.data.getBioCDocobj().Annotations.get(i).get(j).set(k, anno[0] + "\t" + anno[1] + "\t" + (String)mens + "\t" + anno[3] + "\t" + anno[4]);
                        continue;
                    }
                    if (anno.length >= 5) continue;
                    this.data.getBioCDocobj().Annotations.get(i).get(j).set(k, anno[0] + "\t" + anno[1] + "\t" + (String)mens + "\t" + anno[3]);
                }
            }
        }
        this.data.getBioCDocobj().BioCOutput(Filename, FilenameBioC, this.data.getBioCDocobj().Annotations, false, true);
    }
}

