/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.learning;

import ciir.umass.edu.utilities.RankLibError;
import java.util.Arrays;

public abstract class DataPoint {
    public static boolean missingZero = false;
    public static int MAX_FEATURE = 51;
    public static int FEATURE_INCREASE = 10;
    protected static float UNKNOWN = Float.NaN;
    protected float label = 0.0f;
    protected String id = "";
    protected String description = "";
    protected float[] fVals = null;
    protected int knownFeatures;
    protected double cached = -1.0;

    protected static boolean isUnknown(float fVal) {
        return Float.isNaN(fVal);
    }

    protected static String getKey(String pair) {
        return pair.substring(0, pair.indexOf(":"));
    }

    protected static String getValue(String pair) {
        return pair.substring(pair.lastIndexOf(":") + 1);
    }

    protected float[] parse(String text) {
        float[] fVals = new float[MAX_FEATURE];
        Arrays.fill(fVals, UNKNOWN);
        int lastFeature = -1;
        try {
            int idx = text.indexOf("#");
            if (idx != -1) {
                this.description = text.substring(idx);
                text = text.substring(0, idx).trim();
            }
            String[] fs = text.split("\\s+");
            this.label = Float.parseFloat(fs[0]);
            if (this.label < 0.0f) {
                System.out.println("Relevance label cannot be negative. System will now exit.");
                System.exit(1);
            }
            this.id = DataPoint.getValue(fs[1]);
            String key = "";
            String val = "";
            for (int i = 2; i < fs.length; ++i) {
                ++this.knownFeatures;
                key = DataPoint.getKey(fs[i]);
                val = DataPoint.getValue(fs[i]);
                int f = Integer.parseInt(key);
                if (f <= 0) {
                    throw RankLibError.create("Cannot use feature numbering less than or equal to zero. Start your features at 1.");
                }
                if (f >= MAX_FEATURE) {
                    while (f >= MAX_FEATURE) {
                        MAX_FEATURE += FEATURE_INCREASE;
                    }
                    float[] tmp = new float[MAX_FEATURE];
                    System.arraycopy(fVals, 0, tmp, 0, fVals.length);
                    Arrays.fill(tmp, fVals.length, MAX_FEATURE, UNKNOWN);
                    fVals = tmp;
                }
                fVals[f] = Float.parseFloat(val);
                if (f <= lastFeature) continue;
                lastFeature = f;
            }
            float[] tmp = new float[lastFeature + 1];
            System.arraycopy(fVals, 0, tmp, 0, lastFeature + 1);
            fVals = tmp;
        }
        catch (Exception ex) {
            throw RankLibError.create("Error in DataPoint::parse()", ex);
        }
        return fVals;
    }

    public abstract float getFeatureValue(int var1);

    public abstract void setFeatureValue(int var1, float var2);

    public abstract void setFeatureVector(float[] var1);

    public abstract float[] getFeatureVector();

    protected DataPoint() {
    }

    protected DataPoint(String text) {
        float[] fVals = this.parse(text);
        this.setFeatureVector(fVals);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public float getLabel() {
        return this.label;
    }

    public void setLabel(float label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        assert (description.contains("#"));
        this.description = description;
    }

    public void setCached(double c) {
        this.cached = c;
    }

    public double getCached() {
        return this.cached;
    }

    public void resetCached() {
        this.cached = -1.0E8;
    }

    public String toString() {
        float[] fVals = this.getFeatureVector();
        String output = (int)this.label + " qid:" + this.id + " ";
        for (int i = 1; i < fVals.length; ++i) {
            if (DataPoint.isUnknown(fVals[i])) continue;
            output = output + i + ":" + fVals[i] + (i == fVals.length - 1 ? "" : " ");
        }
        output = output + " " + this.description;
        return output.trim();
    }

    public int getNumberOfKnownFeatures() {
        return this.knownFeatures;
    }
}

