/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.learning;

import ciir.umass.edu.learning.DataPoint;
import ciir.umass.edu.utilities.RankLibError;
import java.util.Arrays;

public class SparseDataPoint
extends DataPoint {
    private static accessPattern searchPattern = accessPattern.RANDOM;
    int[] fIds;
    int lastMinId = -1;
    int lastMinPos = -1;

    public SparseDataPoint(String text) {
        super(text);
    }

    public SparseDataPoint(float[] fVals, int[] fIds, String queryId, float relevanceLabel) {
        this.fVals = fVals;
        this.fIds = fIds;
        this.knownFeatures = fIds[fIds.length - 1];
        this.id = queryId;
        this.label = relevanceLabel;
    }

    public SparseDataPoint(SparseDataPoint dp) {
        this.label = dp.label;
        this.id = dp.id;
        this.description = dp.description;
        this.cached = dp.cached;
        this.fIds = new int[dp.fIds.length];
        this.fVals = new float[dp.fVals.length];
        System.arraycopy(dp.fIds, 0, this.fIds, 0, dp.fIds.length);
        System.arraycopy(dp.fVals, 0, this.fVals, 0, dp.fVals.length);
    }

    private int locate(int fid) {
        if (searchPattern == accessPattern.SEQUENTIAL) {
            if (this.lastMinId > fid) {
                this.lastMinId = -1;
                this.lastMinPos = -1;
            }
            while (this.lastMinPos < this.knownFeatures && this.lastMinId < fid) {
                this.lastMinId = this.fIds[++this.lastMinPos];
            }
            if (this.lastMinId == fid) {
                return this.lastMinPos;
            }
        } else if (searchPattern == accessPattern.RANDOM) {
            int pos = Arrays.binarySearch(this.fIds, fid);
            if (pos >= 0) {
                return pos;
            }
        } else {
            System.err.println("Invalid search pattern specified for sparse data points.");
        }
        return -1;
    }

    public boolean hasFeature(int fid) {
        return this.locate(fid) != -1;
    }

    @Override
    public float getFeatureValue(int fid) {
        if (fid <= 0 || fid > this.fIds[this.fIds.length - 1]) {
            if (missingZero) {
                return 0.0f;
            }
            throw RankLibError.create("Error in SparseDataPoint::getFeatureValue(): requesting unspecified feature, fid=" + fid);
        }
        int pos = this.locate(fid);
        if (pos >= 0) {
            return this.fVals[pos];
        }
        return 0.0f;
    }

    @Override
    public void setFeatureValue(int fid, float fval) {
        if (fid <= 0 || fid > this.knownFeatures) {
            throw RankLibError.create("Error in SparseDataPoint::setFeatureValue(): feature (id=" + fid + ") out of range.");
        }
        int pos = this.locate(fid);
        if (pos >= 0) {
            this.fVals[pos] = fval;
        } else {
            System.err.println("Error in SparseDataPoint::setFeatureValue(): feature (id=" + fid + ") not found.");
            System.exit(1);
        }
    }

    @Override
    public float[] getFeatureVector() {
        float[] dfVals = new float[this.fIds[this.knownFeatures - 1] + 1];
        Arrays.fill(dfVals, UNKNOWN);
        for (int i = 0; i < this.knownFeatures; ++i) {
            dfVals[this.fIds[i]] = this.fVals[i];
        }
        return dfVals;
    }

    @Override
    public void setFeatureVector(float[] dfVals) {
        this.fIds = new int[this.knownFeatures];
        this.fVals = new float[this.knownFeatures];
        int pos = 0;
        for (int i = 1; i < dfVals.length; ++i) {
            if (SparseDataPoint.isUnknown(dfVals[i])) continue;
            this.fIds[pos] = i;
            this.fVals[pos] = dfVals[i];
            ++pos;
        }
        assert (pos == this.knownFeatures);
    }

    private static enum accessPattern {
        SEQUENTIAL,
        RANDOM;

    }
}

