/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.utilities;

import ciir.umass.edu.utilities.RankLibError;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;

public class FileUtils {
    public static BufferedReader smartReader(String inputFile) throws IOException {
        return FileUtils.smartReader(inputFile, "UTF-8");
    }

    public static BufferedReader smartReader(String inputFile, String encoding) throws IOException {
        InputStream input = new FileInputStream(inputFile);
        if (inputFile.endsWith(".gz")) {
            input = new GZIPInputStream(input);
        }
        return new BufferedReader(new InputStreamReader(input, encoding));
    }

    public static String read(String filename, String encoding) {
        StringBuffer content = new StringBuffer();
        try (BufferedReader in = FileUtils.smartReader(filename, encoding);){
            char[] newContent = new char[40960];
            int numRead = -1;
            while ((numRead = in.read(newContent)) != -1) {
                content.append(new String(newContent, 0, numRead));
            }
        }
        catch (Exception e) {
            content = new StringBuffer();
        }
        return content.toString();
    }

    public static List<String> readLine(String filename, String encoding) {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String content = "";
            BufferedReader in = FileUtils.smartReader(filename, encoding);
            while ((content = in.readLine()) != null) {
                if ((content = content.trim()).length() == 0) continue;
                lines.add(content);
            }
            in.close();
        }
        catch (Exception ex) {
            throw RankLibError.create(ex);
        }
        return lines;
    }

    public static boolean write(String filename, String encoding, String strToWrite) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), encoding));
            out.write(strToWrite);
            out.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String[] getAllFiles(String directory) {
        File dir = new File(directory);
        String[] fns = dir.list();
        return fns;
    }

    public static List<String> getAllFiles2(String directory) {
        File dir = new File(directory);
        String[] fns = dir.list();
        ArrayList<String> files = new ArrayList<String>();
        if (fns != null) {
            for (int i = 0; i < fns.length; ++i) {
                files.add(fns[i]);
            }
        }
        return files;
    }

    public static String getFileName(String pathName) {
        int idx2;
        int idx1 = pathName.lastIndexOf("/");
        int idx = idx1 > (idx2 = pathName.lastIndexOf("\\")) ? idx1 : idx2;
        return pathName.substring(idx + 1);
    }

    public static String makePathStandard(String directory) {
        String dir = directory;
        char c = dir.charAt(dir.length() - 1);
        if (c != '/' && c != '\\') {
            dir = dir + File.separator;
        }
        return dir;
    }
}

