/*
 * Decompiled with CFR 0.152.
 */
package de.kaufhof.hajobs;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ScalaActorRef;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import com.datastax.driver.core.utils.UUIDs;
import de.kaufhof.hajobs.Job;
import de.kaufhof.hajobs.JobExecutor;
import de.kaufhof.hajobs.JobExecutor$;
import de.kaufhof.hajobs.JobManager$;
import de.kaufhof.hajobs.JobStartStatus;
import de.kaufhof.hajobs.JobStatus;
import de.kaufhof.hajobs.JobStatusRepository;
import de.kaufhof.hajobs.JobType;
import de.kaufhof.hajobs.LockRepository;
import de.kaufhof.hajobs.TPData;
import de.kaufhof.hajobs.TriggerPuller;
import de.kaufhof.hajobs.package$;
import java.util.TimeZone;
import java.util.UUID;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005uf\u0001B\u0001\u0003\u0001%\u0011!BS8c\u001b\u0006t\u0017mZ3s\u0015\t\u0019A!\u0001\u0004iC*|'m\u001d\u0006\u0003\u000b\u0019\tqa[1vM\"|gMC\u0001\b\u0003\t!Wm\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\u000f\u001b\u0005a!\"A\u0007\u0002\u000bM\u001c\u0017\r\\1\n\u0005=a!AB!osJ+g\r\u0003\u0005\u0012\u0001\t\u0005I\u0015!\u0003\u0013\u0003-i\u0017M\\1hK\u0012TuNY:\u0011\u0007-\u0019R#\u0003\u0002\u0015\u0019\tAAHY=oC6,g\b\u0005\u0002\u001759\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011DA\u0001\ba\u0006\u001c7.Y4f\u0013\tYBD\u0001\u0003K_\n\u001c(BA\r\u0003\u0011!q\u0002A!A!\u0002\u0013y\u0012\u0001\u00037pG.\u0014V\r]8\u0011\u0005]\u0001\u0013BA\u0011\u0003\u00059aunY6SKB|7/\u001b;pefD\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\u000eU>\u00147\u000b^1ukN\u0014V\r]8\u0011\u0005])\u0013B\u0001\u0014\u0003\u0005MQuNY*uCR,8OU3q_NLGo\u001c:z\u0011!A\u0003A!A!\u0002\u0013I\u0013aC1di>\u00148+_:uK6\u0004\"AK\u0018\u000e\u0003-R!\u0001L\u0017\u0002\u000b\u0005\u001cGo\u001c:\u000b\u00039\nA!Y6lC&\u0011\u0001g\u000b\u0002\f\u0003\u000e$xN]*zgR,W\u000e\u0003\u00053\u0001\t\u0005\t\u0015!\u00034\u0003%\u00198\r[3ek2,'\u000f\u0005\u00025s5\tQG\u0003\u00027o\u00051\u0011/^1sijT\u0011\u0001O\u0001\u0004_J<\u0017B\u0001\u001e6\u0005%\u00196\r[3ek2,'\u000f\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u0003M)g.\u00192mK*{'mU2iK\u0012,H.\u001b8h!\tYa(\u0003\u0002@\u0019\t9!i\\8mK\u0006t\u0007\"B!\u0001\t\u0003\u0011\u0015A\u0002\u001fj]&$h\bF\u0004D\t\u00163u\tS%\u0011\u0005]\u0001\u0001BB\tA\t\u0003\u0007!\u0003C\u0003\u001f\u0001\u0002\u0007q\u0004C\u0003$\u0001\u0002\u0007A\u0005C\u0003)\u0001\u0002\u0007\u0011\u0006C\u00033\u0001\u0002\u00071\u0007C\u0003=\u0001\u0002\u0007Q\bC\u0003B\u0001\u0011\u00051\nF\u0004D\u0019rkflX1\t\u000b5S\u0005\u0019\u0001(\u0002\t)|'m\u001d\t\u0004\u001fZKfB\u0001)V\u001d\t\tF+D\u0001S\u0015\t\u0019\u0006\"\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u0011\u0011\u0004D\u0005\u0003/b\u00131aU3r\u0015\tIB\u0002\u0005\u0002\u00185&\u00111L\u0001\u0002\u0004\u0015>\u0014\u0007\"\u0002\u0010K\u0001\u0004y\u0002\"B\u0012K\u0001\u0004!\u0003\"\u0002\u0015K\u0001\u0004I\u0003b\u00021K!\u0003\u0005\raM\u0001\u0006g\u000eDW\r\u001a\u0005\by)\u0003\n\u00111\u0001>\u0011\u001d\u0019\u0007A1A\u0005\n\u0011\fa\u0001\\8hO\u0016\u0014X#A3\u0011\u0005\u0019LW\"A4\u000b\u0005!<\u0014!B:mMRR\u0017B\u00016h\u0005\u0019aunZ4fe\"1A\u000e\u0001Q\u0001\n\u0015\fq\u0001\\8hO\u0016\u0014\b\u0005C\u0004o\u0001\t\u0007I\u0011B8\u0002\u0011\u0015DXmY;u_J,\u0012\u0001\u001d\t\u0003UEL!A]\u0016\u0003\u0011\u0005\u001bGo\u001c:SK\u001aDa\u0001\u001e\u0001!\u0002\u0013\u0001\u0018!C3yK\u000e,Ho\u001c:!\u0011\u00151\b\u0001\"\u0005x\u0003\u0011Ig.\u001b;\u0015\u0003a\u0004\"aC=\n\u0005id!\u0001B+oSRDQ\u0001 \u0001\u0005\u0002]\f\u0001b\u001d5vi\u0012|wO\u001c\u0005\u0006}\u0002!\tb`\u0001\fg\u000eDW\rZ;mK*{'\rF\u0002y\u0003\u0003Aa!a\u0001~\u0001\u0004I\u0016!\u00046pER{7k\u00195fIVdW\rC\u0004\u0002\b\u0001!\t\"!\u0003\u0002\u0019M\u001c\u0007.\u001a3vY\u0016TuNY:\u0016\u0003aDq!!\u0004\u0001\t\u0003\ty!\u0001\u0006ue&<w-\u001a:K_\n$B!!\u0005\u0002$A1\u00111CA\r\u0003;i!!!\u0006\u000b\u0007\u0005]A\"\u0001\u0006d_:\u001cWO\u001d:f]RLA!a\u0007\u0002\u0016\t1a)\u001e;ve\u0016\u00042aFA\u0010\u0013\r\t\tC\u0001\u0002\u000f\u0015>\u00147\u000b^1siN#\u0018\r^;t\u0011!\t)#a\u0003A\u0002\u0005\u001d\u0012a\u00026pERK\b/\u001a\t\u0004/\u0005%\u0012bAA\u0016\u0005\t9!j\u001c2UsB,\u0007bBA\u0018\u0001\u0011\u0005\u0011\u0011G\u0001\re\u0016$(/[4hKJTuN\u0019\u000b\u0007\u0003#\t\u0019$!\u000e\t\u0011\u0005\u0015\u0012Q\u0006a\u0001\u0003OA\u0001\"a\u000e\u0002.\u0001\u0007\u0011\u0011H\u0001\niJLwmZ3s\u0013\u0012\u0004B!a\u000f\u0002F5\u0011\u0011Q\b\u0006\u0005\u0003\u007f\t\t%\u0001\u0003vi&d'BAA\"\u0003\u0011Q\u0017M^1\n\t\u0005\u001d\u0013Q\b\u0002\u0005+VKE\tC\u0004\u0002L\u0001!\t!!\u0014\u0002\u0013\r\fgnY3m\u0015>\u0014Gc\u0001=\u0002P!A\u0011QEA%\u0001\u0004\t9\u0003C\u0004\u0002T\u0001!\t!!\u0016\u0002\r\u001d,GOS8c)\rI\u0016q\u000b\u0005\t\u0003K\t\t\u00061\u0001\u0002(!9\u00111\f\u0001\u0005\u0002\u0005u\u0013\u0001D1mY*{'m\u0015;biV\u001cH\u0003BA0\u0003[\u0002b!a\u0005\u0002\u001a\u0005\u0005\u0004#B(\u0002d\u0005\u001d\u0014bAA31\n!A*[:u!\r9\u0012\u0011N\u0005\u0004\u0003W\u0012!!\u0003&pEN#\u0018\r^;t\u0011!\t)#!\u0017A\u0002\u0005\u001d\u0002bBA9\u0001\u0011\u0005\u00111O\u0001\nU>\u00147\u000b^1ukN$b!!\u001e\u0002~\u0005}\u0004CBA\n\u00033\t9\bE\u0003\f\u0003s\n9'C\u0002\u0002|1\u0011aa\u00149uS>t\u0007\u0002CA\u0013\u0003_\u0002\r!a\n\t\u0011\u0005\u0005\u0015q\u000ea\u0001\u0003s\tQA[8c\u0013\u0012<q!!\"\u0003\u0011\u0003\t9)\u0001\u0006K_\nl\u0015M\\1hKJ\u00042aFAE\r\u0019\t!\u0001#\u0001\u0002\fN\u0019\u0011\u0011\u0012\u0006\t\u000f\u0005\u000bI\t\"\u0001\u0002\u0010R\u0011\u0011q\u0011\u0005\tG\u0006%%\u0019!C\u0005I\"9A.!#!\u0002\u0013)\u0007\u0002CAL\u0003\u0013#\t!!'\u0002\u001f\r\u0014X-\u0019;f'\u000eDW\rZ;mKJ,\u0012a\r\u0005\u000b\u0003;\u000bI)%A\u0005\u0002\u0005}\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0006\u0002\u0002\"*\u001a1'a),\u0005\u0005\u0015\u0006\u0003BAT\u0003ck!!!+\u000b\t\u0005-\u0016QV\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a,\r\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003g\u000bIKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!\"a.\u0002\nF\u0005I\u0011AA]\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u0011\u00111\u0018\u0016\u0004{\u0005\r\u0006")
public class JobManager {
    private final Function0<Map<JobType, Job>> managedJobs;
    private final JobStatusRepository jobStatusRepo;
    private final ActorSystem actorSystem;
    public final Scheduler de$kaufhof$hajobs$JobManager$$scheduler;
    private final boolean enableJobScheduling;
    private final Logger de$kaufhof$hajobs$JobManager$$logger;
    private final ActorRef executor;

    public static boolean $lessinit$greater$default$6() {
        return JobManager$.MODULE$.$lessinit$greater$default$6();
    }

    public static Scheduler $lessinit$greater$default$5() {
        return JobManager$.MODULE$.$lessinit$greater$default$5();
    }

    public static Scheduler createScheduler() {
        return JobManager$.MODULE$.createScheduler();
    }

    public Logger de$kaufhof$hajobs$JobManager$$logger() {
        return this.de$kaufhof$hajobs$JobManager$$logger;
    }

    private ActorRef executor() {
        return this.executor;
    }

    public void init() {
        if (this.enableJobScheduling) {
            this.de$kaufhof$hajobs$JobManager$$logger().debug("JobManager: Starting scheduler");
            this.de$kaufhof$hajobs$JobManager$$scheduler.start();
            this.scheduleJobs();
        } else {
            this.de$kaufhof$hajobs$JobManager$$logger().warn("CRON JOBS ARE GLOBALLY DISABLED via config, will not schedule jobs!");
        }
    }

    public void shutdown() {
        this.de$kaufhof$hajobs$JobManager$$logger().info("JobManager shutdown(): stopping scheduler and canceling running jobs.");
        this.de$kaufhof$hajobs$JobManager$$scheduler.shutdown(false);
        ((MapLike)this.managedJobs.apply()).keys().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JobManager $outer;

            public final void apply(JobType jobType) {
                this.$outer.cancelJob(jobType);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.actorSystem.stop(this.executor());
    }

    public void scheduleJob(Job jobToSchedule) {
        JobType jobType = jobToSchedule.jobType();
        try {
            jobToSchedule.cronExpression().map((Function1)new Serializable(this, jobType){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JobManager $outer;
                private final JobType jobType$1;

                public final void apply(String cronExpression) {
                    this.$outer.de$kaufhof$hajobs$JobManager$$logger().debug("scheduling job for {}", new Object[]{this.jobType$1});
                    JobDetail job = JobBuilder.newJob(TriggerPuller.class).usingJobData(new TPData(this.jobType$1, this.$outer).asDataMap()).build();
                    String jobName = this.jobType$1.name();
                    CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-trigger"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobName}))).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression).inTimeZone(TimeZone.getTimeZone("UTC"))).build();
                    this.$outer.de$kaufhof$hajobs$JobManager$$scheduler.scheduleJob(job, (Trigger)trigger);
                    this.$outer.de$kaufhof$hajobs$JobManager$$logger().info("Job '{}' has cron expression '{}', first execution at {}", new Object[]{this.jobType$1, trigger.getCronExpression(), trigger.getNextFireTime()});
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.jobType$1 = jobType$1;
                }
            }).getOrElse((Function0)new Serializable(this, jobType){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JobManager $outer;
                private final JobType jobType$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.de$kaufhof$hajobs$JobManager$$logger().info("No cronExpression defined for job {}", new Object[]{this.jobType$1});
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.jobType$1 = jobType$1;
                }
            });
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.de$kaufhof$hajobs$JobManager$$logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not start scheduler for job type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobType})), e);
            throw e;
        }
    }

    public void scheduleJobs() {
        ((MapLike)this.managedJobs.apply()).values().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JobManager $outer;

            public final void apply(Job jobToSchedule) {
                this.$outer.scheduleJob(jobToSchedule);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Future<JobStartStatus> triggerJob(JobType jobType) {
        UUID triggerId = UUIDs.timeBased();
        this.de$kaufhof$hajobs$JobManager$$logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Triggering job of type ", " with triggerid ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobType, triggerId})));
        return this.retriggerJob(jobType, triggerId);
    }

    public Future<JobStartStatus> retriggerJob(JobType jobType, UUID triggerId) {
        Job job = (Job)((MapLike)this.managedJobs.apply()).apply((Object)jobType);
        Timeout timeout = new Timeout(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds());
        return AskableActorRef$.MODULE$.$qmark$extension(akka.pattern.package$.MODULE$.ask(this.executor()), (Object)new JobExecutor.Execute(job, triggerId), timeout).mapTo(ClassTag$.MODULE$.apply(JobStartStatus.class));
    }

    public void cancelJob(JobType jobType) {
        this.de$kaufhof$hajobs$JobManager$$logger().info("Cancelling job for job type {}", new Object[]{jobType});
        ScalaActorRef qual$1 = akka.actor.package$.MODULE$.actorRef2Scala(this.executor());
        JobExecutor.Cancel x$1 = new JobExecutor.Cancel(jobType);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public Job getJob(JobType jobType) {
        return (Job)((MapLike)this.managedJobs.apply()).apply((Object)jobType);
    }

    public Future<List<JobStatus>> allJobStatus(JobType jobType) {
        return this.jobStatusRepo.list(jobType, this.jobStatusRepo.list$default$2(), this.jobStatusRepo.list$default$3(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<Option<JobStatus>> jobStatus(JobType jobType, UUID jobId) {
        return this.jobStatusRepo.get(jobType, jobId, this.jobStatusRepo.get$default$3(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
    }

    public JobManager(Function0<Map<JobType, Job>> managedJobs, LockRepository lockRepo, JobStatusRepository jobStatusRepo, ActorSystem actorSystem, Scheduler scheduler, boolean enableJobScheduling) {
        this.managedJobs = managedJobs;
        this.jobStatusRepo = jobStatusRepo;
        this.actorSystem = actorSystem;
        this.de$kaufhof$hajobs$JobManager$$scheduler = scheduler;
        this.enableJobScheduling = enableJobScheduling;
        this.de$kaufhof$hajobs$JobManager$$logger = LoggerFactory.getLogger(this.getClass());
        this.executor = actorSystem.actorOf(JobExecutor$.MODULE$.props(lockRepo), "JobExecutor");
        this.init();
    }

    public JobManager(Seq<Job> jobs, LockRepository lockRepo, JobStatusRepository jobStatusRepo, ActorSystem actorSystem, Scheduler sched, boolean enableJobScheduling) {
        this((Function0<Map<JobType, Job>>)new Serializable(jobs){
            public static final long serialVersionUID = 0L;
            private final Seq jobs$1;

            public final Map<JobType, Job> apply() {
                return package$.MODULE$.Jobs((Seq<Job>)this.jobs$1);
            }
            {
                this.jobs$1 = jobs$1;
            }
        }, lockRepo, jobStatusRepo, actorSystem, sched, enableJobScheduling);
    }
}

