/*
 * Decompiled with CFR 0.152.
 */
package de.kaufhof.hajobs;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ScalaActorRef;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import com.datastax.driver.core.utils.UUIDs;
import de.kaufhof.hajobs.Error;
import de.kaufhof.hajobs.Job;
import de.kaufhof.hajobs.JobExecutor;
import de.kaufhof.hajobs.JobExecutor$;
import de.kaufhof.hajobs.JobManager$;
import de.kaufhof.hajobs.JobResult$;
import de.kaufhof.hajobs.JobStartStatus;
import de.kaufhof.hajobs.JobState$;
import de.kaufhof.hajobs.JobStatus;
import de.kaufhof.hajobs.JobStatusRepository;
import de.kaufhof.hajobs.JobType;
import de.kaufhof.hajobs.LockRepository;
import de.kaufhof.hajobs.TPData;
import de.kaufhof.hajobs.TriggerPuller;
import de.kaufhof.hajobs.package$;
import java.util.TimeZone;
import java.util.UUID;
import org.joda.time.DateTime;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015a\u0001B\u0001\u0003\u0001%\u0011!BS8c\u001b\u0006t\u0017mZ3s\u0015\t\u0019A!\u0001\u0004iC*|'m\u001d\u0006\u0003\u000b\u0019\tqa[1vM\"|gMC\u0001\b\u0003\t!Wm\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\u000f\u001b\u0005a!\"A\u0007\u0002\u000bM\u001c\u0017\r\\1\n\u0005=a!AB!osJ+g\r\u0003\u0005\u0012\u0001\t\u0005I\u0015!\u0003\u0013\u0003-i\u0017M\\1hK\u0012TuNY:\u0011\u0007-\u0019R#\u0003\u0002\u0015\u0019\tAAHY=oC6,g\b\u0005\u0002\u001759\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011DA\u0001\ba\u0006\u001c7.Y4f\u0013\tYBD\u0001\u0003K_\n\u001c(BA\r\u0003\u0011!q\u0002A!A!\u0002\u0013y\u0012\u0001\u00037pG.\u0014V\r]8\u0011\u0005]\u0001\u0013BA\u0011\u0003\u00059aunY6SKB|7/\u001b;pefD\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\u000eU>\u00147\u000b^1ukN\u0014V\r]8\u0011\u0005])\u0013B\u0001\u0014\u0003\u0005MQuNY*uCR,8OU3q_NLGo\u001c:z\u0011!A\u0003A!A!\u0002\u0013I\u0013aC1di>\u00148+_:uK6\u0004\"AK\u0018\u000e\u0003-R!\u0001L\u0017\u0002\u000b\u0005\u001cGo\u001c:\u000b\u00039\nA!Y6lC&\u0011\u0001g\u000b\u0002\f\u0003\u000e$xN]*zgR,W\u000e\u0003\u00053\u0001\t\u0005\t\u0015!\u00034\u0003%\u00198\r[3ek2,'\u000f\u0005\u00025s5\tQG\u0003\u00027o\u00051\u0011/^1sijT\u0011\u0001O\u0001\u0004_J<\u0017B\u0001\u001e6\u0005%\u00196\r[3ek2,'\u000f\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u0003M)g.\u00192mK*{'mU2iK\u0012,H.\u001b8h!\tYa(\u0003\u0002@\u0019\t9!i\\8mK\u0006t\u0007\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\u0002#M\u001c\u0007.\u001a3vY\u0016\u001cH+[7f5>tW\r\u0005\u0002D\u00116\tAI\u0003\u0002F\r\u0006!Q\u000f^5m\u0015\u00059\u0015\u0001\u00026bm\u0006L!!\u0013#\u0003\u0011QKW.\u001a.p]\u0016DQa\u0013\u0001\u0005\u00021\u000ba\u0001P5oSRtD\u0003C'O\u001fB\u000b&k\u0015+\u0011\u0005]\u0001\u0001BB\tK\t\u0003\u0007!\u0003C\u0003\u001f\u0015\u0002\u0007q\u0004C\u0003$\u0015\u0002\u0007A\u0005C\u0003)\u0015\u0002\u0007\u0011\u0006C\u00033\u0015\u0002\u00071\u0007C\u0003=\u0015\u0002\u0007Q\bC\u0003B\u0015\u0002\u0007!\tC\u0003L\u0001\u0011\u0005a\u000b\u0006\u0005N/\u001eD\u0017N\u001b7n\u0011\u0015AV\u000b1\u0001Z\u0003\u0011QwNY:\u0011\u0007i\u000bGM\u0004\u0002\\A:\u0011AlX\u0007\u0002;*\u0011a\fC\u0001\u0007yI|w\u000e\u001e \n\u00035I!!\u0007\u0007\n\u0005\t\u001c'aA*fc*\u0011\u0011\u0004\u0004\t\u0003/\u0015L!A\u001a\u0002\u0003\u0007){'\rC\u0003\u001f+\u0002\u0007q\u0004C\u0003$+\u0002\u0007A\u0005C\u0003)+\u0002\u0007\u0011\u0006C\u0004l+B\u0005\t\u0019A\u001a\u0002\u000bM\u001c\u0007.\u001a3\t\u000fq*\u0006\u0013!a\u0001{!9\u0011)\u0016I\u0001\u0002\u0004\u0011\u0005bB8\u0001\u0005\u0004%I\u0001]\u0001\u0007Y><w-\u001a:\u0016\u0003E\u0004\"A];\u000e\u0003MT!\u0001^\u001c\u0002\u000bMdg\r\u000e6\n\u0005Y\u001c(A\u0002'pO\u001e,'\u000f\u0003\u0004y\u0001\u0001\u0006I!]\u0001\bY><w-\u001a:!\u0011\u001dQ\bA1A\u0005\nm\f\u0001\"\u001a=fGV$xN]\u000b\u0002yB\u0011!&`\u0005\u0003}.\u0012\u0001\"Q2u_J\u0014VM\u001a\u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003}\u0003%)\u00070Z2vi>\u0014\b\u0005C\u0004\u0002\u0006\u0001!\t\"a\u0002\u0002\t%t\u0017\u000e\u001e\u000b\u0003\u0003\u0013\u00012aCA\u0006\u0013\r\ti\u0001\u0004\u0002\u0005+:LG\u000fC\u0004\u0002\u0012\u0001!\t!a\u0002\u0002\u0011MDW\u000f\u001e3po:Dq!!\u0006\u0001\t#\t9\"A\u0006tG\",G-\u001e7f\u0015>\u0014G\u0003BA\u0005\u00033Aq!a\u0007\u0002\u0014\u0001\u0007A-A\u0007k_\n$vnU2iK\u0012,H.\u001a\u0005\b\u0003?\u0001A\u0011CA\u0011\u00031\u00198\r[3ek2,'j\u001c2t+\t\tI\u0001C\u0004\u0002&\u0001!\t!a\n\u0002\u0015Q\u0014\u0018nZ4fe*{'\r\u0006\u0003\u0002*\u0005m\u0002CBA\u0016\u0003c\t)$\u0004\u0002\u0002.)\u0019\u0011q\u0006\u0007\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u00024\u00055\"A\u0002$viV\u0014X\rE\u0002\u0018\u0003oI1!!\u000f\u0003\u00059QuNY*uCJ$8\u000b^1ukND\u0001\"!\u0010\u0002$\u0001\u0007\u0011qH\u0001\bU>\u0014G+\u001f9f!\r9\u0012\u0011I\u0005\u0004\u0003\u0007\u0012!a\u0002&pERK\b/\u001a\u0005\b\u0003\u000f\u0002A\u0011AA%\u00031\u0011X\r\u001e:jO\u001e,'OS8c)\u0019\tI#a\u0013\u0002N!A\u0011QHA#\u0001\u0004\ty\u0004\u0003\u0005\u0002P\u0005\u0015\u0003\u0019AA)\u0003%!(/[4hKJLE\rE\u0002D\u0003'J1!!\u0016E\u0005\u0011)V+\u0013#\t\u000f\u0005e\u0003\u0001\"\u0001\u0002\\\u0005I1-\u00198dK2TuN\u0019\u000b\u0005\u0003\u0013\ti\u0006\u0003\u0005\u0002>\u0005]\u0003\u0019AA \u0011\u001d\t\t\u0007\u0001C\u0001\u0003G\naaZ3u\u0015>\u0014Gc\u00013\u0002f!A\u0011QHA0\u0001\u0004\ty\u0004C\u0004\u0002j\u0001!\t!a\u001b\u0002\u0019\u0005dGNS8c'R\fG/^:\u0015\t\u00055\u00141\u0010\t\u0007\u0003W\t\t$a\u001c\u0011\u000bi\u000b\t(!\u001e\n\u0007\u0005M4M\u0001\u0003MSN$\bcA\f\u0002x%\u0019\u0011\u0011\u0010\u0002\u0003\u0013){'m\u0015;biV\u001c\b\u0002CA\u001f\u0003O\u0002\r!a\u0010\t\u000f\u0005}\u0004\u0001\"\u0001\u0002\u0002\u0006I!n\u001c2Ti\u0006$Xo\u001d\u000b\u0007\u0003\u0007\u000bY)!$\u0011\r\u0005-\u0012\u0011GAC!\u0015Y\u0011qQA;\u0013\r\tI\t\u0004\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005u\u0012Q\u0010a\u0001\u0003\u007fA\u0001\"a$\u0002~\u0001\u0007\u0011\u0011K\u0001\u0006U>\u0014\u0017\n\u001a\u0005\b\u0003'\u0003AQBAK\u0003\u0015\u0011X\r\u001e:z+\u0011\t9*!)\u0015\t\u0005e\u0015\u0011\u0018\u000b\u0005\u00037\u000b\u0019\f\u0005\u0004\u0002,\u0005E\u0012Q\u0014\t\u0005\u0003?\u000b\t\u000b\u0004\u0001\u0005\u0011\u0005\r\u0016\u0011\u0013b\u0001\u0003K\u0013\u0011\u0001V\t\u0005\u0003O\u000bi\u000bE\u0002\f\u0003SK1!a+\r\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aCAX\u0013\r\t\t\f\u0004\u0002\u0004\u0003:L\b\"CA[\u0003##\t\u0019AA\\\u0003\t1g\u000e\u0005\u0003\f'\u0005m\u0005\u0002CA^\u0003#\u0003\r!!0\u0002\u00039\u00042aCA`\u0013\r\t\t\r\u0004\u0002\u0004\u0013:$xaBAc\u0005!\u0005\u0011qY\u0001\u000b\u0015>\u0014W*\u00198bO\u0016\u0014\bcA\f\u0002J\u001a1\u0011A\u0001E\u0001\u0003\u0017\u001c2!!3\u000b\u0011\u001dY\u0015\u0011\u001aC\u0001\u0003\u001f$\"!a2\t\u0011=\fIM1A\u0005\nADq\u0001_AeA\u0003%\u0011\u000f\u0003\u0005\u0002X\u0006%G\u0011AAm\u0003=\u0019'/Z1uKN\u001b\u0007.\u001a3vY\u0016\u0014X#A\u001a\t\u0015\u0005u\u0017\u0011ZI\u0001\n\u0003\ty.A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0003\u0003CT3aMArW\t\t)\u000f\u0005\u0003\u0002h\u0006EXBAAu\u0015\u0011\tY/!<\u0002\u0013Ut7\r[3dW\u0016$'bAAx\u0019\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0018\u0011\u001e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007BCA|\u0003\u0013\f\n\u0011\"\u0001\u0002z\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY*\"!a?+\u0007u\n\u0019\u000f\u0003\u0006\u0002\u0000\u0006%\u0017\u0013!C\u0001\u0005\u0003\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012:TC\u0001B\u0002U\r\u0011\u00151\u001d")
public class JobManager {
    private final Function0<Map<JobType, Job>> managedJobs;
    public final JobStatusRepository de$kaufhof$hajobs$JobManager$$jobStatusRepo;
    private final ActorSystem actorSystem;
    public final Scheduler de$kaufhof$hajobs$JobManager$$scheduler;
    private final boolean enableJobScheduling;
    public final TimeZone de$kaufhof$hajobs$JobManager$$schedulesTimeZone;
    private final Logger de$kaufhof$hajobs$JobManager$$logger;
    private final ActorRef executor;

    public static TimeZone $lessinit$greater$default$7() {
        return JobManager$.MODULE$.$lessinit$greater$default$7();
    }

    public static boolean $lessinit$greater$default$6() {
        return JobManager$.MODULE$.$lessinit$greater$default$6();
    }

    public static Scheduler $lessinit$greater$default$5() {
        return JobManager$.MODULE$.$lessinit$greater$default$5();
    }

    public static Scheduler createScheduler() {
        return JobManager$.MODULE$.createScheduler();
    }

    public Logger de$kaufhof$hajobs$JobManager$$logger() {
        return this.de$kaufhof$hajobs$JobManager$$logger;
    }

    private ActorRef executor() {
        return this.executor;
    }

    public void init() {
        if (this.enableJobScheduling) {
            this.de$kaufhof$hajobs$JobManager$$logger().debug("JobManager: Starting scheduler");
            this.de$kaufhof$hajobs$JobManager$$scheduler.start();
            this.scheduleJobs();
        } else {
            this.de$kaufhof$hajobs$JobManager$$logger().warn("CRON JOBS ARE GLOBALLY DISABLED via config, will not schedule jobs!");
        }
    }

    public void shutdown() {
        this.de$kaufhof$hajobs$JobManager$$logger().info("JobManager shutdown(): stopping scheduler and canceling running jobs.");
        this.de$kaufhof$hajobs$JobManager$$scheduler.shutdown(false);
        ((MapLike)this.managedJobs.apply()).keys().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JobManager $outer;

            public final void apply(JobType jobType) {
                this.$outer.cancelJob(jobType);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.actorSystem.stop(this.executor());
    }

    public void scheduleJob(Job jobToSchedule) {
        JobType jobType = jobToSchedule.jobType();
        try {
            jobToSchedule.cronExpression().map((Function1)new Serializable(this, jobType){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JobManager $outer;
                private final JobType jobType$1;

                public final void apply(String cronExpression) {
                    this.$outer.de$kaufhof$hajobs$JobManager$$logger().debug("scheduling job for {}", new Object[]{this.jobType$1});
                    JobDetail job = JobBuilder.newJob(TriggerPuller.class).usingJobData(new TPData(this.jobType$1, this.$outer).asDataMap()).build();
                    String jobName = this.jobType$1.name();
                    CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-trigger"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobName}))).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression).inTimeZone(this.$outer.de$kaufhof$hajobs$JobManager$$schedulesTimeZone)).build();
                    this.$outer.de$kaufhof$hajobs$JobManager$$scheduler.scheduleJob(job, (Trigger)trigger);
                    this.$outer.de$kaufhof$hajobs$JobManager$$logger().info("Job '{}' has cron expression '{}', first execution at {}", new Object[]{this.jobType$1, trigger.getCronExpression(), trigger.getNextFireTime()});
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.jobType$1 = jobType$1;
                }
            }).getOrElse((Function0)new Serializable(this, jobType){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JobManager $outer;
                private final JobType jobType$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.de$kaufhof$hajobs$JobManager$$logger().info("No cronExpression defined for job {}", new Object[]{this.jobType$1});
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.jobType$1 = jobType$1;
                }
            });
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.de$kaufhof$hajobs$JobManager$$logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not start scheduler for job type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobType})), e);
            throw e;
        }
    }

    public void scheduleJobs() {
        ((MapLike)this.managedJobs.apply()).values().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JobManager $outer;

            public final void apply(Job jobToSchedule) {
                this.$outer.scheduleJob(jobToSchedule);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Future<JobStartStatus> triggerJob(JobType jobType) {
        UUID triggerId = UUIDs.timeBased();
        this.de$kaufhof$hajobs$JobManager$$logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Triggering job of type ", " with triggerid ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobType, triggerId})));
        return this.retriggerJob(jobType, triggerId);
    }

    public Future<JobStartStatus> retriggerJob(JobType jobType, UUID triggerId) {
        Job job = (Job)((MapLike)this.managedJobs.apply()).apply((Object)jobType);
        Timeout timeout = new Timeout(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds());
        return AskableActorRef$.MODULE$.$qmark$extension(akka.pattern.package$.MODULE$.ask(this.executor()), (Object)new JobExecutor.Execute(job, triggerId), timeout).mapTo(ClassTag$.MODULE$.apply(JobStartStatus.class)).recoverWith((PartialFunction)new Serializable(this, jobType, triggerId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JobManager $outer;
            public final JobType jobType$2;
            public final UUID triggerId$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Option option = NonFatal$.MODULE$.unapply(A1);
                if (option.isEmpty()) {
                    object = function1.apply(x1);
                } else {
                    Throwable e = (Throwable)option.get();
                    this.$outer.de$kaufhof$hajobs$JobManager$$logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error starting Job {} triggerId {}, set JobStatus to Failed! "})).s((Seq)Nil$.MODULE$), new Object[]{this.jobType$2, this.triggerId$1, e});
                    object = this.$outer.de$kaufhof$hajobs$JobManager$$retry(3, new Serializable(this, e){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$retriggerJob$1 $outer;
                        private final Throwable e$1;

                        public final Future<JobStatus> apply() {
                            return this.$outer.de$kaufhof$hajobs$JobManager$$anonfun$$$outer().de$kaufhof$hajobs$JobManager$$jobStatusRepo.save(new JobStatus(this.$outer.triggerId$1, this.$outer.jobType$2, UUID.randomUUID(), JobState$.MODULE$.Failed(), JobResult$.MODULE$.Failed(), DateTime.now(), (Option<JsValue>)new Some((Object)Json$.MODULE$.toJson((Object)this.e$1.getMessage(), (Writes)Writes$.MODULE$.StringWrites()))), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.e$1 = e$1;
                        }
                    }).map((Function1)new Serializable(this, e){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$retriggerJob$1 $outer;
                        private final Throwable e$1;

                        public final Error apply(JobStatus x$1) {
                            return new Error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error starting Job ", " triggerId ", ", set JobStatus to Failed! Msg: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.jobType$2, this.$outer.triggerId$1, this.e$1.getMessage()})));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.e$1 = e$1;
                        }
                    }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global()).recover((PartialFunction)new Serializable(this, e){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$retriggerJob$1 $outer;
                        private final Throwable e$1;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                            A1 A1 = x2;
                            this.$outer.de$kaufhof$hajobs$JobManager$$anonfun$$$outer().de$kaufhof$hajobs$JobManager$$logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while writing JobStatus for job {} triggerId {}"})).s((Seq)Nil$.MODULE$), new Object[]{this.$outer.jobType$2, this.$outer.triggerId$1, A1});
                            Error error = new Error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error starting Job ", " triggerId ", ", setting JobStatus to Failed failed! Msg: ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.jobType$2, this.$outer.triggerId$1, this.e$1.getMessage(), A1.getMessage()})));
                            return (B1)error;
                        }

                        public final boolean isDefinedAt(Throwable x2) {
                            Throwable throwable = x2;
                            boolean bl = true;
                            return bl;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.e$1 = e$1;
                        }
                    }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                Option option = NonFatal$.MODULE$.unapply(throwable);
                boolean bl = !option.isEmpty();
                return bl;
            }

            public /* synthetic */ JobManager de$kaufhof$hajobs$JobManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.jobType$2 = jobType$2;
                this.triggerId$1 = triggerId$1;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
    }

    public void cancelJob(JobType jobType) {
        this.de$kaufhof$hajobs$JobManager$$logger().info("Cancelling job for job type {}", new Object[]{jobType});
        ScalaActorRef qual$1 = akka.actor.package$.MODULE$.actorRef2Scala(this.executor());
        JobExecutor.Cancel x$2 = new JobExecutor.Cancel(jobType);
        ActorRef x$3 = qual$1.$bang$default$2((Object)x$2);
        qual$1.$bang((Object)x$2, x$3);
    }

    public Job getJob(JobType jobType) {
        return (Job)((MapLike)this.managedJobs.apply()).apply((Object)jobType);
    }

    public Future<List<JobStatus>> allJobStatus(JobType jobType) {
        return this.de$kaufhof$hajobs$JobManager$$jobStatusRepo.list(jobType, this.de$kaufhof$hajobs$JobManager$$jobStatusRepo.list$default$2(), this.de$kaufhof$hajobs$JobManager$$jobStatusRepo.list$default$3(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<Option<JobStatus>> jobStatus(JobType jobType, UUID jobId) {
        return this.de$kaufhof$hajobs$JobManager$$jobStatusRepo.get(jobType, jobId, this.de$kaufhof$hajobs$JobManager$$jobStatusRepo.get$default$3(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
    }

    public final <T> Future<T> de$kaufhof$hajobs$JobManager$$retry(int n, Function0<Future<T>> fn) {
        return ((Future)fn.apply()).recoverWith((PartialFunction)new Serializable(this, n, fn){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JobManager $outer;
            private final int n$1;
            private final Function0 fn$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Future future;
                A1 A1 = x3;
                if (this.n$1 > 1) {
                    future = this.$outer.de$kaufhof$hajobs$JobManager$$retry(this.n$1 - 1, this.fn$1);
                } else {
                    Option option = NonFatal$.MODULE$.unapply(A1);
                    if (option.isEmpty()) {
                        future = function1.apply(x3);
                    } else {
                        Throwable e = (Throwable)option.get();
                        future = Future$.MODULE$.failed(e);
                    }
                }
                return (B1)future;
            }

            public final boolean isDefinedAt(Throwable x3) {
                Option option;
                Throwable throwable = x3;
                boolean bl = this.n$1 > 1 ? true : !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty();
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.n$1 = n$1;
                this.fn$1 = fn$1;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
    }

    public JobManager(Function0<Map<JobType, Job>> managedJobs, LockRepository lockRepo, JobStatusRepository jobStatusRepo, ActorSystem actorSystem, Scheduler scheduler, boolean enableJobScheduling, TimeZone schedulesTimeZone) {
        this.managedJobs = managedJobs;
        this.de$kaufhof$hajobs$JobManager$$jobStatusRepo = jobStatusRepo;
        this.actorSystem = actorSystem;
        this.de$kaufhof$hajobs$JobManager$$scheduler = scheduler;
        this.enableJobScheduling = enableJobScheduling;
        this.de$kaufhof$hajobs$JobManager$$schedulesTimeZone = schedulesTimeZone;
        this.de$kaufhof$hajobs$JobManager$$logger = LoggerFactory.getLogger(this.getClass());
        this.executor = actorSystem.actorOf(JobExecutor$.MODULE$.props(lockRepo), "JobExecutor");
        this.init();
    }

    public JobManager(Seq<Job> jobs, LockRepository lockRepo, JobStatusRepository jobStatusRepo, ActorSystem actorSystem, Scheduler sched, boolean enableJobScheduling, TimeZone schedulesTimeZone) {
        this((Function0<Map<JobType, Job>>)new Serializable(jobs){
            public static final long serialVersionUID = 0L;
            private final Seq jobs$1;

            public final Map<JobType, Job> apply() {
                return package$.MODULE$.Jobs((Seq<Job>)this.jobs$1);
            }
            {
                this.jobs$1 = jobs$1;
            }
        }, lockRepo, jobStatusRepo, actorSystem, sched, enableJobScheduling, schedulesTimeZone);
    }
}

