/*
 * Decompiled with CFR 0.152.
 */
package de.kaufhof.hajobs;

import com.datastax.driver.core.utils.UUIDs;
import de.kaufhof.hajobs.JobResult$;
import de.kaufhof.hajobs.JobState$;
import de.kaufhof.hajobs.JobStatus;
import de.kaufhof.hajobs.JobType;
import de.kaufhof.hajobs.JobType$;
import de.kaufhof.hajobs.JobTypes;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.joda.time.format.PeriodFormat;
import play.api.data.validation.ValidationError;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.json.Format;
import play.api.libs.json.JsError;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsString;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsSuccess$;
import play.api.libs.json.JsValue;
import play.api.libs.json.OWrites;
import play.api.libs.json.OWrites$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.api.libs.json.package$;
import scala.Enumeration;
import scala.Function1;
import scala.Function7;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple7;
import scala.Tuple9;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.math.BigDecimal;
import scala.util.control.NonFatal$;

public final class JobStatus$
implements Serializable {
    public static final JobStatus$ MODULE$;
    private final Object iso8601DateTimeFormat;
    private final Object periodFormat;
    private final Map<Enumeration.Value, Enumeration.Value> stateResultMapping;

    static {
        new JobStatus$();
    }

    private Object iso8601DateTimeFormat() {
        return this.iso8601DateTimeFormat;
    }

    private Object periodFormat() {
        return this.periodFormat;
    }

    public Reads<JobStatus> jobStatusReads(JobTypes jobTypes) {
        return (Reads)play.api.libs.functional.syntax.package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("triggerId").read(Reads$.MODULE$.uuidReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("jobType").read(JobType$.MODULE$.jobTypeReads(jobTypes))).and((Object)JsPath$.MODULE$.$bslash("jobId").read(Reads$.MODULE$.uuidReads())).and((Object)JsPath$.MODULE$.$bslash("jobState").read(JobState$.MODULE$.enumRead())).and((Object)JsPath$.MODULE$.$bslash("jobResult").read(JobResult$.MODULE$.enumRead())).and((Object)JsPath$.MODULE$.$bslash("jobStatusTs").read((Reads)this.iso8601DateTimeFormat())).and((Object)JsPath$.MODULE$.$bslash("content").readNullable((Reads)Reads$.MODULE$.JsValueReads())).apply((Function7)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JobStatus apply(UUID triggerId, JobType jobType, UUID jobId, Enumeration.Value jobState, Enumeration.Value jobResult, DateTime jobStatusTs, Option<JsValue> content) {
                return new JobStatus(triggerId, jobType, jobId, jobState, jobResult, jobStatusTs, content);
            }
        }, Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult())));
    }

    public OWrites<JobStatus> jobStatusWrites() {
        return (OWrites)play.api.libs.functional.syntax.package$.MODULE$.toFunctionalBuilderOps((Object)package$.MODULE$.__().$bslash("triggerId").write((Writes)Writes$.MODULE$.UuidWrites()), OWrites$.MODULE$.functionalCanBuildOWrites()).and((Object)package$.MODULE$.__().$bslash("jobType").write(JobType$.MODULE$.jobTypeWrites())).and((Object)package$.MODULE$.__().$bslash("jobId").write((Writes)Writes$.MODULE$.UuidWrites())).and((Object)package$.MODULE$.__().$bslash("jobState").write(JobState$.MODULE$.enumWrite())).and((Object)package$.MODULE$.__().$bslash("jobResult").write(JobResult$.MODULE$.enumWrite())).and((Object)package$.MODULE$.__().$bslash("jobStatusTs").write((Writes)this.iso8601DateTimeFormat())).and((Object)package$.MODULE$.__().$bslash("content").writeNullable((Writes)Writes$.MODULE$.JsValueWrites())).and((Object)package$.MODULE$.__().$bslash("startTime").writeNullable((Writes)this.iso8601DateTimeFormat())).and((Object)package$.MODULE$.__().$bslash("duration").writeNullable(this.periodFormat())).apply((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple9<UUID, JobType, UUID, Enumeration.Value, Enumeration.Value, DateTime, Option<JsValue>, Option<DateTime>, Option<Period>> apply(JobStatus j) {
                return JobStatus$.MODULE$.de$kaufhof$hajobs$JobStatus$$asJsonTuple(j);
            }
        }, OWrites$.MODULE$.contravariantfunctorOWrites());
    }

    public Tuple9<UUID, JobType, UUID, Enumeration.Value, Enumeration.Value, DateTime, Option<JsValue>, Option<DateTime>, Option<Period>> de$kaufhof$hajobs$JobStatus$$asJsonTuple(JobStatus j) {
        None$ none$;
        int n = j.jobId().version();
        switch (n) {
            default: {
                none$ = None$.MODULE$;
                break;
            }
            case 1: {
                none$ = new Some((Object)new DateTime(UUIDs.unixTimestamp((UUID)j.jobId())));
            }
        }
        None$ maybeStartTime = none$;
        Option maybeDuration = maybeStartTime.map((Function1)new Serializable(j){
            public static final long serialVersionUID = 0L;
            private final JobStatus j$1;

            public final Period apply(DateTime startTime) {
                return new Period((ReadableInstant)startTime, (ReadableInstant)this.j$1.jobStatusTs());
            }
            {
                this.j$1 = j$1;
            }
        });
        return new Tuple9((Object)j.triggerId(), (Object)j.jobType(), (Object)j.jobId(), (Object)j.jobState(), (Object)j.jobResult(), (Object)j.jobStatusTs(), j.content(), (Object)maybeStartTime, (Object)maybeDuration);
    }

    private Map<Enumeration.Value, Enumeration.Value> stateResultMapping() {
        return this.stateResultMapping;
    }

    public Enumeration.Value stateToResult(Enumeration.Value state) {
        return (Enumeration.Value)this.stateResultMapping().apply((Object)state);
    }

    public JobStatus apply(UUID triggerId, JobType jobType, UUID jobId, Enumeration.Value jobState, Enumeration.Value jobResult, DateTime jobStatusTs, Option<JsValue> content) {
        return new JobStatus(triggerId, jobType, jobId, jobState, jobResult, jobStatusTs, content);
    }

    public Option<Tuple7<UUID, JobType, UUID, Enumeration.Value, Enumeration.Value, DateTime, Option<JsValue>>> unapply(JobStatus x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple7((Object)x$0.triggerId(), (Object)x$0.jobType(), (Object)x$0.jobId(), (Object)x$0.jobState(), (Object)x$0.jobResult(), (Object)x$0.jobStatusTs(), x$0.content()));
    }

    public Option<JsValue> apply$default$7() {
        return None$.MODULE$;
    }

    public Option<JsValue> $lessinit$greater$default$7() {
        return None$.MODULE$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private JobStatus$() {
        MODULE$ = this;
        this.iso8601DateTimeFormat = new Format<DateTime>(){

            public <B> Reads<B> map(Function1<DateTime, B> f) {
                return Reads.class.map((Reads)this, f);
            }

            public <B> Reads<B> flatMap(Function1<DateTime, Reads<B>> f) {
                return Reads.class.flatMap((Reads)this, f);
            }

            public Reads<DateTime> filter(Function1<DateTime, Object> f) {
                return Reads.class.filter((Reads)this, f);
            }

            public Reads<DateTime> filter(ValidationError error, Function1<DateTime, Object> f) {
                return Reads.class.filter((Reads)this, (ValidationError)error, f);
            }

            public Reads<DateTime> filterNot(Function1<DateTime, Object> f) {
                return Reads.class.filterNot((Reads)this, f);
            }

            public Reads<DateTime> filterNot(ValidationError error, Function1<DateTime, Object> f) {
                return Reads.class.filterNot((Reads)this, (ValidationError)error, f);
            }

            public <B> Reads<B> collect(ValidationError error, PartialFunction<DateTime, B> f) {
                return Reads.class.collect((Reads)this, (ValidationError)error, f);
            }

            public Reads<DateTime> orElse(Reads<DateTime> v) {
                return Reads.class.orElse((Reads)this, v);
            }

            public <B extends JsValue> Reads<DateTime> compose(Reads<B> rb) {
                return Reads.class.compose((Reads)this, rb);
            }

            public <B> Reads<B> andThen(Reads<B> rb, Predef.$less$colon$less<DateTime, JsValue> witness) {
                return Reads.class.andThen((Reads)this, rb, witness);
            }

            public Writes<DateTime> transform(Function1<JsValue, JsValue> transformer) {
                return Writes.class.transform((Writes)this, transformer);
            }

            public Writes<DateTime> transform(Writes<JsValue> transformer) {
                return Writes.class.transform((Writes)this, transformer);
            }

            public JsValue writes(DateTime o) {
                return new JsString(o.toString(ISODateTimeFormat.dateTime()));
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public JsResult<DateTime> reads(JsValue json) {
                JsValue jsValue = json;
                if (jsValue instanceof JsString) {
                    JsSuccess jsSuccess;
                    try {
                        jsSuccess = new JsSuccess((Object)ISODateTimeFormat.dateTime().parseDateTime((String)json.as((Reads)Reads$.MODULE$.StringReads())), JsSuccess$.MODULE$.apply$default$2());
                        return jsSuccess;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (option.isEmpty()) {
                            throw throwable;
                        }
                        Throwable e = (Throwable)option.get();
                        JsError jsError = JsError$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not parse jobStatusTs: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e})));
                        jsSuccess = jsError;
                    }
                    return jsSuccess;
                } else {
                    if (!(jsValue instanceof JsNumber)) return JsError$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected value for jobStatusTs: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{json})));
                    JsNumber jsNumber = (JsNumber)jsValue;
                    BigDecimal value = jsNumber.value();
                    return new JsSuccess((Object)new DateTime(value.toLong()), JsSuccess$.MODULE$.apply$default$2());
                }
            }
            {
                Writes.class.$init$((Writes)this);
                Reads.class.$init$((Reads)this);
            }
        };
        this.periodFormat = new Writes<Period>(){

            public Writes<Period> transform(Function1<JsValue, JsValue> transformer) {
                return Writes.class.transform((Writes)this, transformer);
            }

            public Writes<Period> transform(Writes<JsValue> transformer) {
                return Writes.class.transform((Writes)this, transformer);
            }

            public JsValue writes(Period o) {
                return new JsString(o.toString(PeriodFormat.wordBased()));
            }
            {
                Writes.class.$init$((Writes)this);
            }
        };
        this.stateResultMapping = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JobState$.MODULE$.Running()), (Object)JobResult$.MODULE$.Pending()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JobState$.MODULE$.Preparing()), (Object)JobResult$.MODULE$.Pending()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JobState$.MODULE$.Finished()), (Object)JobResult$.MODULE$.Success()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JobState$.MODULE$.Failed()), (Object)JobResult$.MODULE$.Failed()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JobState$.MODULE$.Canceled()), (Object)JobResult$.MODULE$.Failed()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JobState$.MODULE$.Dead()), (Object)JobResult$.MODULE$.Failed()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JobState$.MODULE$.Warning()), (Object)JobResult$.MODULE$.Success()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JobState$.MODULE$.Skipped()), (Object)JobResult$.MODULE$.Success()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JobState$.MODULE$.NoActionNeeded()), (Object)JobResult$.MODULE$.Success())}));
    }
}

