/*
 * Decompiled with CFR 0.152.
 */
package de.kaufhof.hajobs;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ScalaActorRef;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import com.datastax.driver.core.utils.UUIDs;
import de.kaufhof.hajobs.Error;
import de.kaufhof.hajobs.Job;
import de.kaufhof.hajobs.JobExecutor;
import de.kaufhof.hajobs.JobExecutor$;
import de.kaufhof.hajobs.JobManager$;
import de.kaufhof.hajobs.JobResult$;
import de.kaufhof.hajobs.JobStartStatus;
import de.kaufhof.hajobs.JobState$;
import de.kaufhof.hajobs.JobStatus;
import de.kaufhof.hajobs.JobStatusRepository;
import de.kaufhof.hajobs.JobType;
import de.kaufhof.hajobs.JobTypes$JobSupervisor$;
import de.kaufhof.hajobs.LockRepository;
import de.kaufhof.hajobs.TPData;
import de.kaufhof.hajobs.TriggerPuller;
import de.kaufhof.hajobs.package$;
import java.util.TimeZone;
import java.util.UUID;
import org.joda.time.DateTime;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005e\u0001B\u0001\u0003\u0001%\u0011!BS8c\u001b\u0006t\u0017mZ3s\u0015\t\u0019A!\u0001\u0004iC*|'m\u001d\u0006\u0003\u000b\u0019\tqa[1vM\"|gMC\u0001\b\u0003\t!Wm\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\u000f\u001b\u0005a!\"A\u0007\u0002\u000bM\u001c\u0017\r\\1\n\u0005=a!AB!osJ+g\r\u0003\u0005\u0012\u0001\t\u0005I\u0015!\u0003\u0013\u0003-i\u0017M\\1hK\u0012TuNY:\u0011\u0007-\u0019R#\u0003\u0002\u0015\u0019\tAAHY=oC6,g\b\u0005\u0002\u001759\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011DA\u0001\ba\u0006\u001c7.Y4f\u0013\tYBD\u0001\u0003K_\n\u001c(BA\r\u0003\u0011!q\u0002A!A!\u0002\u0013y\u0012\u0001\u00037pG.\u0014V\r]8\u0011\u0005]\u0001\u0013BA\u0011\u0003\u00059aunY6SKB|7/\u001b;pefD\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\u000eU>\u00147\u000b^1ukN\u0014V\r]8\u0011\u0005])\u0013B\u0001\u0014\u0003\u0005MQuNY*uCR,8OU3q_NLGo\u001c:z\u0011!A\u0003A!A!\u0002\u0013I\u0013aC1di>\u00148+_:uK6\u0004\"AK\u0018\u000e\u0003-R!\u0001L\u0017\u0002\u000b\u0005\u001cGo\u001c:\u000b\u00039\nA!Y6lC&\u0011\u0001g\u000b\u0002\f\u0003\u000e$xN]*zgR,W\u000e\u0003\u00053\u0001\t\u0005\t\u0015!\u00034\u0003%\u00198\r[3ek2,'\u000f\u0005\u00025s5\tQG\u0003\u00027o\u00051\u0011/^1sijT\u0011\u0001O\u0001\u0004_J<\u0017B\u0001\u001e6\u0005%\u00196\r[3ek2,'\u000f\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u0003M)g.\u00192mK*{'mU2iK\u0012,H.\u001b8h!\tYa(\u0003\u0002@\u0019\t9!i\\8mK\u0006t\u0007\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\u0002#M\u001c\u0007.\u001a3vY\u0016\u001cH+[7f5>tW\r\u0005\u0002D\u00116\tAI\u0003\u0002F\r\u0006!Q\u000f^5m\u0015\u00059\u0015\u0001\u00026bm\u0006L!!\u0013#\u0003\u0011QKW.\u001a.p]\u0016DQa\u0013\u0001\u0005\u00021\u000ba\u0001P5oSRtD\u0003C'O\u001fB\u000b&k\u0015+\u0011\u0005]\u0001\u0001BB\tK\t\u0003\u0007!\u0003C\u0003\u001f\u0015\u0002\u0007q\u0004C\u0003$\u0015\u0002\u0007A\u0005C\u0003)\u0015\u0002\u0007\u0011\u0006C\u00033\u0015\u0002\u00071\u0007C\u0003=\u0015\u0002\u0007Q\bC\u0003B\u0015\u0002\u0007!\tC\u0003L\u0001\u0011\u0005a\u000b\u0006\u0005N/\u001eD\u0017N\u001b7n\u0011\u0015AV\u000b1\u0001Z\u0003\u0011QwNY:\u0011\u0007i\u000bGM\u0004\u0002\\A:\u0011AlX\u0007\u0002;*\u0011a\fC\u0001\u0007yI|w\u000e\u001e \n\u00035I!!\u0007\u0007\n\u0005\t\u001c'aA*fc*\u0011\u0011\u0004\u0004\t\u0003/\u0015L!A\u001a\u0002\u0003\u0007){'\rC\u0003\u001f+\u0002\u0007q\u0004C\u0003$+\u0002\u0007A\u0005C\u0003)+\u0002\u0007\u0011\u0006C\u0004l+B\u0005\t\u0019A\u001a\u0002\u000bM\u001c\u0007.\u001a3\t\u000fq*\u0006\u0013!a\u0001{!9\u0011)\u0016I\u0001\u0002\u0004\u0011\u0005bB8\u0001\u0005\u0004%I\u0001]\u0001\u0007Y><w-\u001a:\u0016\u0003E\u0004\"A];\u000e\u0003MT!\u0001^\u001c\u0002\u000bMdg\r\u000e6\n\u0005Y\u001c(A\u0002'pO\u001e,'\u000f\u0003\u0004y\u0001\u0001\u0006I!]\u0001\bY><w-\u001a:!\u0011\u001dQ\bA1A\u0005\nm\f\u0001\"\u001a=fGV$xN]\u000b\u0002yB\u0011!&`\u0005\u0003}.\u0012\u0001\"Q2u_J\u0014VM\u001a\u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003}\u0003%)\u00070Z2vi>\u0014\b\u0005C\u0005\u0002\u0006\u0001\u0011\r\u0011\"\u0003\u0002\b\u00059\u0012\r\u001c7K_\n\u001c8k\u00195fIVdW\r\u001a)s_6L7/Z\u000b\u0003\u0003\u0013\u0001R!a\u0003\u0002\u0012uj!!!\u0004\u000b\u0007\u0005=A\"\u0001\u0006d_:\u001cWO\u001d:f]RLA!a\u0005\u0002\u000e\t9\u0001K]8nSN,\u0007\u0002CA\f\u0001\u0001\u0006I!!\u0003\u00021\u0005dGNS8cgN\u001b\u0007.\u001a3vY\u0016$\u0007K]8nSN,\u0007\u0005C\u0004\u0002\u001c\u0001!\t\"!\b\u0002\t%t\u0017\u000e\u001e\u000b\u0003\u0003?\u00012aCA\u0011\u0013\r\t\u0019\u0003\u0004\u0002\u0005+:LG\u000fC\u0004\u0002(\u0001!\t\"!\u000b\u0002-\u0015t7/\u001e:f\u0015>\u0014\u0007K]3d_:$\u0017\u000e^5p]N$\"!a\u000b1\t\u00055\u0012q\u0007\t\u0007\u0003\u0017\ty#a\r\n\t\u0005E\u0012Q\u0002\u0002\u0007\rV$XO]3\u0011\t\u0005U\u0012q\u0007\u0007\u0001\t1\tI$!\n\u0002\u0002\u0003\u0005)\u0011AA\u001e\u0005\ryF%M\t\u0005\u0003{\t\u0019\u0005E\u0002\f\u0003\u007fI1!!\u0011\r\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aCA#\u0013\r\t9\u0005\u0004\u0002\u0004\u0003:L\bbBA&\u0001\u0011\u0005\u0011QD\u0001\tg\",H\u000fZ8x]\"9\u0011q\n\u0001\u0005\u0012\u0005E\u0013aC:dQ\u0016$W\u000f\\3K_\n$B!a\u0015\u0002VA1\u00111BA\u0018\u0003?Aq!a\u0016\u0002N\u0001\u0007A-A\u0007k_\n$vnU2iK\u0012,H.\u001a\u0005\b\u00037\u0002A\u0011CA/\u0003m\t7mY3qi\u0006\u0014G.\u001a#fY\u0006L\u0018I\u001a;feJ+7\u000f^1siR!\u0011qLA6!\u0011\t\t'a\u001a\u000e\u0005\u0005\r$\u0002BA3\u0003\u001b\t\u0001\u0002Z;sCRLwN\\\u0005\u0005\u0003S\n\u0019G\u0001\u0005EkJ\fG/[8o\u0011!\ti'!\u0017A\u0002\u0005=\u0014a\u00026pERK\b/\u001a\t\u0004/\u0005E\u0014bAA:\u0005\t9!j\u001c2UsB,\u0007bBA<\u0001\u0011E\u0011\u0011P\u0001\u0004]><XCAA>!\u0011\ti(a\"\u000e\u0005\u0005}$\u0002BAA\u0003\u0007\u000bA\u0001^5nK*\u0019\u0011QQ\u001c\u0002\t)|G-Y\u0005\u0005\u0003\u0013\u000byH\u0001\u0005ECR,G+[7f\u0011\u001d\ti\t\u0001C\t\u0003\u001f\u000b\u0001E];o\u0015>\u0014gj\\<JMB\u0013XM^5pkN\u0014VO\\,bgN[\u0017\u000e\u001d9fIR1\u0011\u0011SAJ\u0003K\u0003R!a\u0003\u00020uB\u0001\"!&\u0002\f\u0002\u0007\u0011qS\u0001\u000fGJ|g.\u0012=qe\u0016\u001c8/[8o!\u0011\tI*a(\u000f\u0007-\tY*C\u0002\u0002\u001e2\ta\u0001\u0015:fI\u00164\u0017\u0002BAQ\u0003G\u0013aa\u0015;sS:<'bAAO\u0019!A\u0011QNAF\u0001\u0004\ty\u0007C\u0004\u0002*\u0002!\t\"a+\u0002\u0019M\u001c\u0007.\u001a3vY\u0016TuNY:\u0015\u0005\u0005M\u0003bBAX\u0001\u0011\u0005\u0011\u0011W\u0001\u0011C2d'j\u001c2t'\u000eDW\rZ;mK\u0012,\"!!%\t\u000f\u0005U\u0006\u0001\"\u0001\u00028\u0006QAO]5hO\u0016\u0014(j\u001c2\u0015\t\u0005e\u0016\u0011\u0019\t\u0007\u0003\u0017\ty#a/\u0011\u0007]\ti,C\u0002\u0002@\n\u0011aBS8c'R\f'\u000f^*uCR,8\u000f\u0003\u0005\u0002n\u0005M\u0006\u0019AA8\u0011\u001d\t)\r\u0001C\u0001\u0003\u000f\fAB]3ue&<w-\u001a:K_\n$b!!/\u0002J\u0006-\u0007\u0002CA7\u0003\u0007\u0004\r!a\u001c\t\u0011\u00055\u00171\u0019a\u0001\u0003\u001f\f\u0011\u0002\u001e:jO\u001e,'/\u00133\u0011\u0007\r\u000b\t.C\u0002\u0002T\u0012\u0013A!V+J\t\"9\u0011q\u001b\u0001\u0005\u0012\u0005e\u0017a\u00046pEN#\u0018M\u001d;US6,w.\u001e;\u0015\t\u0005m\u0017Q\u001d\t\u0005\u0003;\f\t/\u0004\u0002\u0002`*\u0011Q)L\u0005\u0005\u0003G\fyNA\u0004US6,w.\u001e;\t\u0011\u00055\u0014Q\u001ba\u0001\u0003_Bq!!;\u0001\t\u0003\tY/A\u0005dC:\u001cW\r\u001c&pER!\u0011qDAw\u0011!\ti'a:A\u0002\u0005=\u0004bBAy\u0001\u0011\u0005\u00111_\u0001\u0007O\u0016$(j\u001c2\u0015\u0007\u0011\f)\u0010\u0003\u0005\u0002n\u0005=\b\u0019AA8\u0011\u001d\tI\u0010\u0001C\u0001\u0003w\fA\"\u00197m\u0015>\u00147\u000b^1ukN$b!!@\u0003\f\t5\u0001CBA\u0006\u0003_\ty\u0010E\u0003[\u0005\u0003\u0011)!C\u0002\u0003\u0004\r\u0014A\u0001T5tiB\u0019qCa\u0002\n\u0007\t%!AA\u0005K_\n\u001cF/\u0019;vg\"A\u0011QNA|\u0001\u0004\ty\u0007\u0003\u0006\u0003\u0010\u0005]\b\u0013!a\u0001\u0005#\tQ\u0001\\5nSR\u00042a\u0003B\n\u0013\r\u0011)\u0002\u0004\u0002\u0004\u0013:$\bb\u0002B\r\u0001\u0011\u0005!1D\u0001\nU>\u00147\u000b^1ukN$bA!\b\u0003&\t\u001d\u0002CBA\u0006\u0003_\u0011y\u0002E\u0003\f\u0005C\u0011)!C\u0002\u0003$1\u0011aa\u00149uS>t\u0007\u0002CA7\u0005/\u0001\r!a\u001c\t\u0011\t%\"q\u0003a\u0001\u0003\u001f\fQA[8c\u0013\u0012D\u0001B!\f\u0001\t\u0003\u0011!qF\u0001\u0010e\u0016$(/[4hKJ\u001cu.\u001e8ugV\u0011!\u0011\u0007\t\t\u00033\u0013\u0019$a\u001c\u0003\u0012%!!QGAR\u0005\ri\u0015\r\u001d\u0005\n\u0005s\u0001\u0011\u0013!C\u0001\u0005w\ta#\u00197m\u0015>\u00147\u000b^1ukN$C-\u001a4bk2$HEM\u000b\u0003\u0005{QCA!\u0005\u0003@-\u0012!\u0011\t\t\u0005\u0005\u0007\u0012i%\u0004\u0002\u0003F)!!q\tB%\u0003%)hn\u00195fG.,GMC\u0002\u0003L1\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011yE!\u0012\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cWmB\u0004\u0003T\tA\tA!\u0016\u0002\u0015){'-T1oC\u001e,'\u000fE\u0002\u0018\u0005/2a!\u0001\u0002\t\u0002\te3c\u0001B,\u0015!91Ja\u0016\u0005\u0002\tuCC\u0001B+\u0011!y'q\u000bb\u0001\n\u0013\u0001\bb\u0002=\u0003X\u0001\u0006I!\u001d\u0005\t\u0005K\u00129\u0006\"\u0001\u0003h\u0005y1M]3bi\u0016\u001c6\r[3ek2,'/F\u00014\u0011)\u0011YGa\u0016\u0012\u0002\u0013\u0005!QN\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t=$fA\u001a\u0003@!Q!1\u000fB,#\u0003%\tA!\u001e\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\u00119HK\u0002>\u0005\u007fA!Ba\u001f\u0003XE\u0005I\u0011\u0001B?\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!q\u0010\u0016\u0004\u0005\n}\u0002")
public class JobManager {
    private final Function0<Map<JobType, Job>> managedJobs;
    public final JobStatusRepository de$kaufhof$hajobs$JobManager$$jobStatusRepo;
    private final ActorSystem actorSystem;
    public final Scheduler de$kaufhof$hajobs$JobManager$$scheduler;
    private final boolean enableJobScheduling;
    private final TimeZone schedulesTimeZone;
    private final Logger de$kaufhof$hajobs$JobManager$$logger;
    private final ActorRef executor;
    private final Promise<Object> de$kaufhof$hajobs$JobManager$$allJobsScheduledPromise;

    public static TimeZone $lessinit$greater$default$7() {
        return JobManager$.MODULE$.$lessinit$greater$default$7();
    }

    public static boolean $lessinit$greater$default$6() {
        return JobManager$.MODULE$.$lessinit$greater$default$6();
    }

    public static Scheduler $lessinit$greater$default$5() {
        return JobManager$.MODULE$.$lessinit$greater$default$5();
    }

    public static Scheduler createScheduler() {
        return JobManager$.MODULE$.createScheduler();
    }

    public Logger de$kaufhof$hajobs$JobManager$$logger() {
        return this.de$kaufhof$hajobs$JobManager$$logger;
    }

    private ActorRef executor() {
        return this.executor;
    }

    public Promise<Object> de$kaufhof$hajobs$JobManager$$allJobsScheduledPromise() {
        return this.de$kaufhof$hajobs$JobManager$$allJobsScheduledPromise;
    }

    public void init() {
        if (this.enableJobScheduling) {
            this.ensureJobPreconditions().andThen((PartialFunction)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JobManager $outer;

                public final <A1 extends Try<Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Promise promise;
                    A1 A1 = x1;
                    if (A1 instanceof Success) {
                        this.$outer.de$kaufhof$hajobs$JobManager$$logger().debug("JobManager: Starting scheduler");
                        this.$outer.de$kaufhof$hajobs$JobManager$$scheduler.start();
                        promise = this.$outer.scheduleJobs();
                    } else if (A1 instanceof Failure) {
                        Failure failure = (Failure)A1;
                        Throwable e = failure.exception();
                        this.$outer.de$kaufhof$hajobs$JobManager$$logger().error("Job preconditions failed with exception, will not schedule jobs!", e);
                        promise = this.$outer.de$kaufhof$hajobs$JobManager$$allJobsScheduledPromise().failure(e);
                    } else {
                        promise = function1.apply(x1);
                    }
                    return (B1)promise;
                }

                public final boolean isDefinedAt(Try<Object> x1) {
                    Try<Object> try_ = x1;
                    boolean bl = try_ instanceof Success ? true : try_ instanceof Failure;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        } else {
            this.de$kaufhof$hajobs$JobManager$$logger().warn("CRON JOBS ARE GLOBALLY DISABLED via config, will not schedule jobs!");
            this.de$kaufhof$hajobs$JobManager$$allJobsScheduledPromise().success((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
    }

    public Future<?> ensureJobPreconditions() {
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    public void shutdown() {
        this.de$kaufhof$hajobs$JobManager$$logger().info("JobManager shutdown(): stopping scheduler and canceling running jobs.");
        this.de$kaufhof$hajobs$JobManager$$scheduler.shutdown(false);
        ((MapLike)this.managedJobs.apply()).keys().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JobManager $outer;

            public final void apply(JobType jobType) {
                this.$outer.cancelJob(jobType);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.actorSystem.stop(this.executor());
    }

    public Future<BoxedUnit> scheduleJob(Job jobToSchedule) {
        Future future;
        JobType jobType = jobToSchedule.jobType();
        try {
            Future future2;
            Option<String> option = jobToSchedule.cronExpression();
            if (option instanceof Some) {
                Some some = (Some)option;
                String cronExpression = (String)some.x();
                this.de$kaufhof$hajobs$JobManager$$logger().debug("scheduling job for {}", new Object[]{jobType});
                JobDetail job = JobBuilder.newJob(TriggerPuller.class).usingJobData(new TPData(jobType, this).asDataMap()).build();
                String jobName = jobType.name();
                CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-trigger"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobName}))).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression).inTimeZone(this.schedulesTimeZone)).build();
                this.de$kaufhof$hajobs$JobManager$$scheduler.scheduleJob(job, (Trigger)trigger);
                this.de$kaufhof$hajobs$JobManager$$logger().info("Job '{}' has cron expression '{}', first execution at {}", new Object[]{jobType, trigger.getCronExpression(), trigger.getNextFireTime()});
                future2 = this.runJobNowIfPreviousRunWasSkipped(cronExpression, jobType).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(boolean x$1) {
                    }
                }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
            } else if (None$.MODULE$.equals(option)) {
                this.de$kaufhof$hajobs$JobManager$$logger().info("No cronExpression defined for job {}", new Object[]{jobType});
                future2 = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
            } else {
                throw new MatchError(option);
            }
            future = future2;
        }
        catch (Throwable throwable) {
            Future future3;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.de$kaufhof$hajobs$JobManager$$logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not start scheduler for job type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobType})), e);
            future = future3 = Future$.MODULE$.failed(e);
        }
        return future;
    }

    public Duration acceptableDelayAfterRestart(JobType jobType) {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(30)).minutes();
    }

    public DateTime now() {
        return DateTime.now();
    }

    public Future<Object> runJobNowIfPreviousRunWasSkipped(String cronExpression, JobType jobType) {
        return this.allJobStatus(jobType, 1).flatMap((Function1)new Serializable(this, cronExpression, jobType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JobManager $outer;
            private final String cronExpression$1;
            private final JobType jobType$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Future<Object> apply(List<JobStatus> x0$1) {
                Future future;
                List<JobStatus> list2 = x0$1;
                if (!(list2 instanceof .colon.colon)) return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
                .colon.colon colon2 = (.colon.colon)list2;
                JobStatus status = (JobStatus)colon2.head();
                List list3 = colon2.tl$1();
                if (!Nil$.MODULE$.equals(list3)) return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
                CronExpression cron = new CronExpression(this.cronExpression$1);
                DateTime nextFireTimeAfterLastRun = new DateTime((Object)cron.getNextValidTimeAfter(status.jobStatusTs().toDate()));
                DateTime nextFireTime = new DateTime((Object)cron.getNextValidTimeAfter(this.$outer.now().toDate()));
                if (nextFireTimeAfterLastRun.isBeforeNow()) {
                    if (nextFireTime.minusMillis((int)this.$outer.acceptableDelayAfterRestart(this.jobType$1).toMillis()).isAfterNow()) {
                        this.$outer.de$kaufhof$hajobs$JobManager$$logger().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The previous run of job ", " was probably scheduled during a down-time "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.jobType$1.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"of the server s(", "), starting the job now..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nextFireTimeAfterLastRun}))).toString());
                        future = this.$outer.triggerJob(this.jobType$1).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(JobStartStatus x$2) {
                                return true;
                            }
                        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
                        return future;
                    } else {
                        this.$outer.de$kaufhof$hajobs$JobManager$$logger().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The previous run of job ", " was probably scheduled during a down-time "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.jobType$1.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"of the server s(", "); will not restart the job since the next scheduled "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nextFireTimeAfterLastRun}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"run is already at ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nextFireTime}))).toString());
                        future = Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
                    }
                    return future;
                } else {
                    future = Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
                }
                return future;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.cronExpression$1 = cronExpression$1;
                this.jobType$1 = jobType$1;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<BoxedUnit> scheduleJobs() {
        Future result = Future$.MODULE$.sequence((TraversableOnce)((MapLike)this.managedJobs.apply()).values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JobManager $outer;

            public final Future<BoxedUnit> apply(Job jobToSchedule) {
                return this.$outer.scheduleJob(jobToSchedule);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        result.onComplete((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JobManager $outer;

            public final Promise<Object> apply(Try<Iterable<BoxedUnit>> x0$2) {
                Try<Iterable<BoxedUnit>> try_;
                block4: {
                    Promise promise;
                    block3: {
                        block2: {
                            try_ = x0$2;
                            if (!(try_ instanceof Success)) break block2;
                            promise = this.$outer.de$kaufhof$hajobs$JobManager$$allJobsScheduledPromise().success((Object)BoxesRunTime.boxToBoolean((boolean)true));
                            break block3;
                        }
                        if (!(try_ instanceof Failure)) break block4;
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        promise = this.$outer.de$kaufhof$hajobs$JobManager$$allJobsScheduledPromise().failure(e);
                    }
                    return promise;
                }
                throw new MatchError(try_);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        return result.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Iterable<BoxedUnit> x$3) {
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<Object> allJobsScheduled() {
        return this.de$kaufhof$hajobs$JobManager$$allJobsScheduledPromise().future();
    }

    public Future<JobStartStatus> triggerJob(JobType jobType) {
        UUID triggerId = UUIDs.timeBased();
        this.de$kaufhof$hajobs$JobManager$$logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Triggering job of type ", " with triggerid ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobType, triggerId})));
        return this.retriggerJob(jobType, triggerId);
    }

    public Future<JobStartStatus> retriggerJob(JobType jobType, UUID triggerId) {
        Job job = (Job)((MapLike)this.managedJobs.apply()).apply((Object)jobType);
        Timeout timeout = this.jobStartTimeout(jobType);
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(this.executor());
        JobExecutor.Execute x$5 = new JobExecutor.Execute(job, triggerId);
        Timeout x$6 = timeout;
        ActorRef x$7 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$5);
        return AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)x$5, x$6, x$7).mapTo(ClassTag$.MODULE$.apply(JobStartStatus.class)).recoverWith((PartialFunction)new Serializable(this, jobType, triggerId, job){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JobManager $outer;
            public final JobType jobType$2;
            public final UUID triggerId$1;
            private final Job job$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                Option option = NonFatal$.MODULE$.unapply(A1);
                if (option.isEmpty()) {
                    object = function1.apply(x2);
                } else {
                    Future future;
                    Throwable e = (Throwable)option.get();
                    JobType jobType = this.jobType$2;
                    JobTypes$JobSupervisor$ jobTypes$JobSupervisor$ = JobTypes$JobSupervisor$.MODULE$;
                    if (!(jobType != null ? !((Object)jobType).equals(jobTypes$JobSupervisor$) : jobTypes$JobSupervisor$ != null)) {
                        future = Future$.MODULE$.successful((Object)new Error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error starting Job ", " triggerId ", ". Msg: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.jobType$2, this.triggerId$1, e.getMessage()}))));
                    } else {
                        this.$outer.de$kaufhof$hajobs$JobManager$$logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error starting Job {} triggerId {}, set JobStatus to Failed! "})).s((Seq)Nil$.MODULE$), new Object[]{this.jobType$2, this.triggerId$1, e});
                        future = package$.MODULE$.retry(3, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"saveJobStartFailure(", "/triggerId ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.job$1.jobType().name(), this.triggerId$1})), new Serializable(this, e){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$retriggerJob$1 $outer;
                            private final Throwable e$1;

                            public final Future<JobStatus> apply() {
                                return this.$outer.de$kaufhof$hajobs$JobManager$$anonfun$$$outer().de$kaufhof$hajobs$JobManager$$jobStatusRepo.save(new JobStatus(this.$outer.triggerId$1, this.$outer.jobType$2, UUIDs.timeBased(), JobState$.MODULE$.Failed(), JobResult$.MODULE$.Failed(), this.$outer.de$kaufhof$hajobs$JobManager$$anonfun$$$outer().now(), (Option<JsValue>)new Some((Object)Json$.MODULE$.toJson((Object)this.e$1.getMessage(), (Writes)Writes$.MODULE$.StringWrites()))), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.e$1 = e$1;
                            }
                        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global()).map((Function1)new Serializable(this, e){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$retriggerJob$1 $outer;
                            private final Throwable e$1;

                            public final Error apply(JobStatus x$4) {
                                return new Error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error starting Job ", " triggerId ", ", set JobStatus to Failed! Msg: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.jobType$2, this.$outer.triggerId$1, this.e$1.getMessage()})));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.e$1 = e$1;
                            }
                        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global()).recover((PartialFunction)new Serializable(this, e){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$retriggerJob$1 $outer;
                            private final Throwable e$1;

                            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                                A1 A1 = x3;
                                this.$outer.de$kaufhof$hajobs$JobManager$$anonfun$$$outer().de$kaufhof$hajobs$JobManager$$logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while writing JobStatus for job {} triggerId {}"})).s((Seq)Nil$.MODULE$), new Object[]{this.$outer.jobType$2, this.$outer.triggerId$1, A1});
                                Error error = new Error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error starting Job ", " triggerId ", ", setting JobStatus to Failed failed! Msg: ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.jobType$2, this.$outer.triggerId$1, this.e$1.getMessage(), A1.getMessage()})));
                                return (B1)error;
                            }

                            public final boolean isDefinedAt(Throwable x3) {
                                Throwable throwable = x3;
                                boolean bl = true;
                                return bl;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.e$1 = e$1;
                            }
                        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
                    }
                    object = future;
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable = x2;
                Option option = NonFatal$.MODULE$.unapply(throwable);
                boolean bl = !option.isEmpty();
                return bl;
            }

            public /* synthetic */ JobManager de$kaufhof$hajobs$JobManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.jobType$2 = jobType$2;
                this.triggerId$1 = triggerId$1;
                this.job$1 = job$1;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
    }

    public Timeout jobStartTimeout(JobType jobType) {
        return new Timeout(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds());
    }

    public void cancelJob(JobType jobType) {
        this.de$kaufhof$hajobs$JobManager$$logger().info("Cancelling job for job type {}", new Object[]{jobType});
        ScalaActorRef qual$2 = akka.actor.package$.MODULE$.actorRef2Scala(this.executor());
        JobExecutor.Cancel x$8 = new JobExecutor.Cancel(jobType);
        ActorRef x$9 = qual$2.$bang$default$2((Object)x$8);
        qual$2.$bang((Object)x$8, x$9);
    }

    public Job getJob(JobType jobType) {
        return (Job)((MapLike)this.managedJobs.apply()).apply((Object)jobType);
    }

    public Future<List<JobStatus>> allJobStatus(JobType jobType, int limit) {
        return this.de$kaufhof$hajobs$JobManager$$jobStatusRepo.list(jobType, limit, this.de$kaufhof$hajobs$JobManager$$jobStatusRepo.list$default$3(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
    }

    public int allJobStatus$default$2() {
        return 20;
    }

    public Future<Option<JobStatus>> jobStatus(JobType jobType, UUID jobId) {
        return this.de$kaufhof$hajobs$JobManager$$jobStatusRepo.get(jobType, jobId, this.de$kaufhof$hajobs$JobManager$$jobStatusRepo.get$default$3(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
    }

    public Map<JobType, Object> retriggerCounts() {
        return (Map)((TraversableLike)this.managedJobs.apply()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<JobType, Object> apply(Tuple2<JobType, Job> x0$3) {
                Tuple2<JobType, Job> tuple2 = x0$3;
                if (tuple2 != null) {
                    JobType jobType = (JobType)tuple2._1();
                    Job job = (Job)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)jobType), (Object)BoxesRunTime.boxToInteger((int)job.retriggerCount()));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    public JobManager(Function0<Map<JobType, Job>> managedJobs, LockRepository lockRepo, JobStatusRepository jobStatusRepo, ActorSystem actorSystem, Scheduler scheduler, boolean enableJobScheduling, TimeZone schedulesTimeZone) {
        this.managedJobs = managedJobs;
        this.de$kaufhof$hajobs$JobManager$$jobStatusRepo = jobStatusRepo;
        this.actorSystem = actorSystem;
        this.de$kaufhof$hajobs$JobManager$$scheduler = scheduler;
        this.enableJobScheduling = enableJobScheduling;
        this.schedulesTimeZone = schedulesTimeZone;
        this.de$kaufhof$hajobs$JobManager$$logger = LoggerFactory.getLogger(this.getClass());
        this.executor = actorSystem.actorOf(JobExecutor$.MODULE$.props(lockRepo), "JobExecutor");
        this.de$kaufhof$hajobs$JobManager$$allJobsScheduledPromise = Promise$.MODULE$.apply();
        this.init();
    }

    public JobManager(Seq<Job> jobs, LockRepository lockRepo, JobStatusRepository jobStatusRepo, ActorSystem actorSystem, Scheduler sched, boolean enableJobScheduling, TimeZone schedulesTimeZone) {
        this((Function0<Map<JobType, Job>>)new Serializable(jobs){
            public static final long serialVersionUID = 0L;
            private final Seq jobs$1;

            public final Map<JobType, Job> apply() {
                return package$.MODULE$.Jobs((Seq<Job>)this.jobs$1);
            }
            {
                this.jobs$1 = jobs$1;
            }
        }, lockRepo, jobStatusRepo, actorSystem, sched, enableJobScheduling, schedulesTimeZone);
    }
}

