/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.baall.helper.client;

import de.dfki.baall.helper.client.exceptions.LoginFailedException;
import de.dfki.baall.helper.client.exceptions.NotFoundException;
import de.dfki.baall.helper.client.exceptions.RequestConflictException;
import de.dfki.baall.helper.client.exceptions.RequestFailedException;
import de.dfki.baall.helper.client.exceptions.RequestNoAccessException;
import de.dfki.baall.helper.client.exceptions.RequestWrongStatusExeption;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpMethod;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthedHTTPClient
extends HttpClient {
    private static final Logger logger = LoggerFactory.getLogger((String)"AuthedHTTPClient");
    private final String base;
    private int maxRetries = 3;

    public AuthedHTTPClient(String baseurl) throws Exception {
        if (baseurl.endsWith("/")) {
            baseurl = baseurl.substring(0, baseurl.length() - 1);
        }
        this.base = baseurl;
        this.start();
    }

    public abstract void authorizeRequest(@Nonnull Request var1) throws LoginFailedException;

    @Nonnull
    public Request createRequest(@Nonnull String url, @Nonnull HttpMethod method) {
        if (!((String)url).startsWith("http")) {
            url = this.base + (String)url;
        }
        Request request = this.newRequest((String)url);
        request.method(method);
        request.agent("KosmoS Client");
        return request;
    }

    @Nonnull
    public String getBase() {
        return this.base;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    protected ContentResponse getResponse(@Nonnull String url, @Nonnull HttpMethod method, int maxRetries, @CheckForNull Integer expectedStatus) throws RequestFailedException {
        return this.getResponse(url, method, null, maxRetries, expectedStatus);
    }

    protected ContentResponse getResponse(@Nonnull String url, @Nonnull HttpMethod method, @CheckForNull Object body, @CheckForNull Integer expectedStatus) throws RequestFailedException {
        return this.getResponse(url, method, body, this.getMaxRetries(), expectedStatus);
    }

    public abstract String getToken();

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    @Nonnull
    protected ContentResponse getResponse(@Nonnull String url, @Nonnull HttpMethod method, @CheckForNull Object body, int maxRetries, @CheckForNull Integer expectedStatus) throws RequestFailedException {
        Request request = this.createRequest(url, method);
        this.authorizeRequest(request);
        if (body != null) {
            if (body instanceof JSONObject) {
                request.content((ContentProvider)new StringContentProvider(body.toString()), "application/json");
            } else if (body instanceof JSONArray) {
                request.content((ContentProvider)new StringContentProvider(body.toString()), "application/json");
            } else {
                request.content((ContentProvider)new StringContentProvider(body.toString()), "application/text");
            }
        }
        try {
            ContentResponse response = request.send();
            int s = response.getStatus();
            if (expectedStatus != null && s != expectedStatus) {
                if (s == 401 && maxRetries > 0) {
                    this.clearToken();
                    this.refreshToken();
                    return this.getResponse(url, method, body, maxRetries - 1, expectedStatus);
                }
                if (s == 404) {
                    throw new NotFoundException(s);
                }
                if (s == 409) {
                    throw new RequestConflictException(s);
                }
                if (s == 403) {
                    throw new RequestNoAccessException(s);
                }
                if (maxRetries > 0) {
                    logger.info("got wrong status?! {} {}", (Object)response.getStatus(), (Object)expectedStatus);
                    return this.getResponse(url, method, body, maxRetries - 1, expectedStatus);
                }
                throw new RequestWrongStatusExeption(response.getStatus());
            }
            return response;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
            if (maxRetries > 0) {
                return this.getResponse(url, method, body, maxRetries - 1, expectedStatus);
            }
            throw new RequestFailedException(e);
        }
    }

    public abstract void clearToken();

    protected ContentResponse getResponse(@Nonnull String url, @Nonnull HttpMethod method, @Nullable Integer expectedStatus) throws RequestFailedException {
        return this.getResponse(url, method, null, this.getMaxRetries(), expectedStatus);
    }

    public abstract boolean refreshToken() throws LoginFailedException;
}

