/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.baall.helper.webserver;

import de.dfki.baall.helper.persistence.ISesssionPersistence;
import de.dfki.baall.helper.persistence.IUserPersistence;
import de.dfki.baall.helper.persistence.exceptions.NoPersistenceException;
import de.dfki.baall.helper.persistence.exceptions.NotFoundInPersistenceException;
import de.dfki.baall.helper.webserver.MyHttpServletRequest;
import de.dfki.baall.helper.webserver.MyServlet;
import de.dfki.baall.helper.webserver.WebServer;
import de.dfki.baall.helper.webserver.data.User;
import de.dfki.baall.helper.webserver.exceptions.LoginFailedException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.json.JSONObject;

public abstract class AuthedServlet
extends MyServlet {
    protected final int level;

    public AuthedServlet(WebServer webServer) {
        this(webServer, 1);
    }

    public AuthedServlet(WebServer webServer, int level) {
        super(webServer);
        this.level = level;
        logger.info("created servlet {}", ((Object)((Object)this)).getClass());
    }

    @Override
    protected boolean isAllowed(HttpServletRequest request, HttpServletResponse response) {
        String auth = request.getHeader("Authorization");
        if (auth != null) {
            block15: {
                if ((auth = auth.trim()).startsWith("Bearer")) {
                    auth = auth.substring(6).trim();
                }
                JSONObject s = null;
                try {
                    s = this.server.getPersistence(ISesssionPersistence.class).verifyJWT(auth);
                    if (s == null) break block15;
                    try {
                        User u = this.server.getPersistence(IUserPersistence.class).getUser(s.getString("name"));
                        request.setAttribute("user", (Object)u);
                        if (u.canAccess(this.level)) {
                            return true;
                        }
                    }
                    catch (NotFoundInPersistenceException e) {
                        e.printStackTrace();
                    }
                    response.setStatus(403);
                    return false;
                }
                catch (NoPersistenceException e) {
                    // empty catch block
                }
            }
            response.setHeader("WWW-Authenticate", "Bearer realm=\"example\",\n                   error=\"invalid_token\",\n                   error_description=\"The access token expired\"");
            response.setStatus(401);
            return false;
        }
        String username = request.getHeader("username");
        String password = request.getHeader("password");
        if (username == null || password == null) {
            username = request.getParameter("username");
            password = request.getParameter("password");
        }
        if (username != null && password != null) {
            try {
                try {
                    User u = this.server.getPersistence(IUserPersistence.class).login(username, password);
                    if (u != null) {
                        request.setAttribute("user", (Object)u);
                        if (u.canAccess(this.level)) {
                            return true;
                        }
                    }
                }
                catch (NoPersistenceException e) {
                    e.printStackTrace();
                }
            }
            catch (LoginFailedException e) {
                e.printStackTrace();
            }
        }
        response.setStatus(401);
        return false;
    }

    protected boolean isMeOrAmAdmin(MyHttpServletRequest request, User u) {
        User me = request.getUser();
        return me.isAdmin() && me.getLevel() >= u.getLevel();
    }
}

