/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.baall.helper.webserver;

import de.dfki.baall.helper.persistence.exceptions.NoPersistenceException;
import de.dfki.baall.helper.webserver.MyHttpServletRequest;
import de.dfki.baall.helper.webserver.WebServer;
import de.dfki.baall.helper.webserver.exceptions.LoginFailedException;
import de.dfki.baall.helper.webserver.exceptions.NotFoundException;
import de.dfki.baall.helper.webserver.exceptions.ParameterNotFoundException;
import de.dfki.baall.helper.webserver.exceptions.UnauthorizedException;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyServlet
extends HttpServlet {
    protected static final Logger logger = LoggerFactory.getLogger((String)"MyServlet");
    protected static final int STATUS_OK = 200;
    protected static final int STATUS_NO_RESPONSE = 204;
    protected static final int STATUS_FORBIDDEN = 403;
    protected static final int STATUS_FAILED = 400;
    protected static final int STATUS_NO_AUTH = 401;
    protected static final int STATUS_NOT_FOUND = 404;
    protected static final int STATUS_CONFLICT = 409;
    protected static final int STATUS_UNPROCESSABLE = 422;
    protected static final int STATUS_ERROR = 500;
    protected static final int STATUS_METHOD_NOT_ALLOWED = 405;
    protected static final Pattern pattern_host = Pattern.compile("^(?<name>http|https|ws|wss)://(?<host>(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])*)(:(?<port>[0-9]*))?$");
    protected final WebServer server;

    public MyServlet(WebServer server) {
        this.server = server;
    }

    protected void addCORSHeader(HttpServletRequest req, HttpServletResponse resp) {
        Matcher m;
        String origin = req.getHeader("Origin");
        origin = origin == null || origin.length() == 0 ? "*" : (!(m = pattern_host.matcher(origin)).matches() ? "*" : URLEncoder.encode(origin, StandardCharsets.UTF_8));
        resp.setHeader("Access-Control-Allow-Origin", origin);
        resp.setHeader("Access-Control-Allow-Headers", "Authorization, Content-Type, Cache-Control");
        resp.setHeader("Access-Control-Allow-Credentials", "true");
    }

    protected boolean checkParameter(HttpServletRequest req, HttpServletResponse response, String[] keys) throws IOException {
        Enumeration it = req.getParameterNames();
        HashMap<String, Boolean> missing = new HashMap<String, Boolean>();
        for (String k : keys) {
            missing.put(k, true);
        }
        while (it.hasMoreElements()) {
            String e = (String)it.nextElement();
            missing.remove(e);
        }
        if (!missing.isEmpty()) {
            response.setStatus(400);
            PrintWriter w = response.getWriter();
            for (String k : missing.keySet()) {
                w.println("missing parameter '" + k + "'");
            }
            return false;
        }
        return true;
    }

    public void delete(MyHttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, ParameterNotFoundException, NotFoundException {
        response.setStatus(405);
    }

    public void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isAllowed(request, response)) {
            try {
                this.addCORSHeader(request, response);
                this.delete(new MyHttpServletRequest(request), response);
            }
            catch (ParameterNotFoundException e) {
                response.setStatus(422);
                response.getWriter().print(e.getMessage());
            }
            catch (NotFoundException e) {
                response.setStatus(404);
                response.getWriter().print(e.getMessage());
            }
            catch (JSONException e) {
                response.setStatus(422);
                response.getWriter().print(e.getMessage());
            }
            catch (Exception e) {
                response.setStatus(500);
                e.printStackTrace();
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isAllowed(request, response)) {
            try {
                this.addCORSHeader(request, response);
                this.get(new MyHttpServletRequest(request), response);
            }
            catch (ParameterNotFoundException e) {
                response.setStatus(422);
                response.getWriter().print(e.getMessage());
            }
            catch (NotFoundException e) {
                response.setStatus(404);
                response.getWriter().print(e.getMessage());
            }
            catch (JSONException e) {
                response.setStatus(422);
                response.getWriter().print(e.getMessage());
            }
            catch (LoginFailedException e) {
                response.setStatus(403);
                response.getWriter().print(e.getMessage());
            }
            catch (UnauthorizedException e) {
                response.setStatus(401);
                response.getWriter().print(e.getMessage());
            }
            catch (Exception e) {
                response.setStatus(500);
                e.printStackTrace();
            }
        }
    }

    public void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.addCORSHeader(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isAllowed(request, response)) {
            try {
                this.addCORSHeader(request, response);
                this.post(new MyHttpServletRequest(request), response);
            }
            catch (JSONException e) {
                response.setStatus(422);
                response.getWriter().print(e.getMessage());
            }
            catch (ParameterNotFoundException e) {
                response.setStatus(422);
                response.getWriter().print(e.getMessage());
            }
            catch (NotFoundException e) {
                response.setStatus(404);
                response.getWriter().print(e.getMessage());
            }
            catch (LoginFailedException e) {
                response.setStatus(403);
                response.getWriter().print(e.getMessage());
            }
            catch (UnauthorizedException e) {
                response.setStatus(401);
            }
            catch (Exception e) {
                response.setStatus(500);
                e.printStackTrace();
            }
        }
    }

    public void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        super.doPut(request, response);
        if (this.isAllowed(request, response)) {
            try {
                this.addCORSHeader(request, response);
                this.put(new MyHttpServletRequest(request), response);
            }
            catch (ParameterNotFoundException e) {
                response.setStatus(422);
                response.getWriter().print(e.getMessage());
            }
            catch (NotFoundException e) {
                response.setStatus(404);
                response.getWriter().print(e.getMessage());
            }
            catch (JSONException e) {
                response.setStatus(422);
                response.getWriter().print(e.getMessage());
            }
            catch (LoginFailedException e) {
                response.setStatus(403);
                response.getWriter().print(e.getMessage());
            }
            catch (UnauthorizedException e) {
                response.setStatus(401);
            }
            catch (Exception e) {
                response.setStatus(500);
                e.printStackTrace();
            }
        }
    }

    public void get(MyHttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, ParameterNotFoundException, NotFoundException, LoginFailedException, UnauthorizedException, NoPersistenceException {
        response.setStatus(405);
    }

    protected boolean isAllowed(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    public void options(MyHttpServletRequest request, HttpServletResponse response) {
        response.setStatus(200);
        this.addCORSHeader(request.getRequest(), response);
    }

    public void post(MyHttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, ParameterNotFoundException, NotFoundException, UnauthorizedException, NoSuchAlgorithmException, InvalidKeyException, NoPersistenceException, LoginFailedException {
        response.setStatus(405);
    }

    public void put(MyHttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, ParameterNotFoundException, NotFoundException, LoginFailedException, UnauthorizedException {
        response.setStatus(405);
    }

    protected void sendJSON(MyHttpServletRequest req, HttpServletResponse response, JSONObject obj) throws IOException {
        response.setHeader("Content-Type", "application/json");
        try {
            String p = req.getParameter("pretty");
            if ("1".equals(p)) {
                response.getWriter().print(obj.toString(4));
            } else {
                response.getWriter().print(obj.toString());
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            response.getWriter().print(obj.toString());
        }
    }

    protected void sendJSON(MyHttpServletRequest req, HttpServletResponse response, JSONArray obj) throws IOException {
        response.setHeader("Content-Type", "application/json");
        try {
            String p = req.getParameter("pretty");
            if ("1".equals(p)) {
                response.getWriter().print(obj.toString(4));
            } else {
                response.getWriter().print(obj.toString());
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            response.getWriter().print(obj.toString());
        }
    }

    protected void sendJWT(MyHttpServletRequest req, HttpServletResponse response, String text) throws IOException {
        response.setHeader("Content-Type", "application/jwt");
        response.getWriter().print(text);
    }

    protected void sendText(MyHttpServletRequest req, HttpServletResponse response, String text) throws IOException {
        response.setHeader("Content-Type", "text/plain");
        response.getWriter().print(text);
    }

    protected void sendXML(MyHttpServletRequest req, HttpServletResponse response, String text) throws IOException {
        response.setHeader("Content-Type", "application/xml");
        response.getWriter().print(text);
    }
}

