/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.baall.helper.webserver;

import de.dfki.baall.helper.persistence.ControllerWithPersistence;
import de.dfki.baall.helper.persistence.IPersistence;
import de.dfki.baall.helper.persistence.ISesssionPersistence;
import de.dfki.baall.helper.persistence.JSONPersistence;
import de.dfki.baall.helper.persistence.exceptions.NoPersistenceException;
import de.dfki.baall.helper.webserver.JWT;
import de.dfki.baall.helper.webserver.MyServlet;
import de.kosmos_lab.utils.FileUtils;
import de.kosmos_lab.utils.HashFunctions;
import de.kosmos_lab.utils.StringFunctions;
import jakarta.servlet.Servlet;
import jakarta.servlet.annotation.WebServlet;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.json.JSONException;
import org.json.JSONObject;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebServer
implements ControllerWithPersistence {
    private static final Logger logger = LoggerFactory.getLogger((String)"WebServer");
    private static final int DEFAULT_PORT = 8101;
    private static final String DEFAULT_STORAGE = "storage.json";
    private static final String DEFAULT_CONFIG = "config/config.json";
    private static final long JWTLIFETIME = 3600000L;
    private final Server server;
    private final int port;
    private final String pepper;
    private final ConcurrentHashMap<Class<?>, IPersistence> persistences = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, Object> usedUUID = new ConcurrentHashMap();
    private final File configFile;
    private final JWT jwt;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebServer(File configFile, boolean testing) throws Exception {
        String temp;
        this.prepare();
        JSONObject config = null;
        if (configFile == null) {
            configFile = new File(this.getDefaultConfig());
        }
        this.configFile = configFile;
        if (!configFile.exists()) {
            if (!configFile.getParentFile().exists() && !configFile.getParentFile().mkdirs()) {
                logger.error("COULD NOT CREATE PARENT DIRS:{}", (Object)configFile.getParentFile());
                throw new RuntimeException("COULD NOT CREATE PARENT DIRS:" + configFile.getParentFile());
            }
            File distFile = new File(configFile.getAbsolutePath() + ".dist");
            if (distFile.exists()) {
                try {
                    Files.copy(distFile.toPath(), configFile.toPath(), new CopyOption[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (configFile.exists()) {
            try {
                config = new JSONObject(FileUtils.readFile((File)configFile));
            }
            catch (JSONException distFile) {
                // empty catch block
            }
        }
        if (config == null) {
            config = new JSONObject();
        }
        int myPort = this.getDefaultPort();
        try {
            myPort = config.getInt("port");
        }
        catch (Exception e) {
            config.put("port", this.getDefaultPort());
        }
        finally {
            this.port = myPort;
        }
        this.pepper = temp = config.optString("pepper", null);
        if (temp == null) {
            temp = StringFunctions.generateRandomKey();
            config.put("pepper", (Object)temp);
        }
        if ((temp = config.optString("jwt", null)) == null) {
            temp = StringFunctions.generateRandomKey();
            config.put("jwt", (Object)temp);
        }
        this.jwt = new JWT(temp, 3600000L);
        temp = config.optString("jwt", null);
        if (temp == null) {
            temp = StringFunctions.generateRandomKey();
            config.put("jwt", (Object)temp);
        }
        this.createPersistence(config);
        this.init(config);
        FileUtils.writeToFile((File)configFile, (String)config.toString());
        int maxThreads = 10;
        int minThreads = 2;
        int idleTimeout = 120;
        QueuedThreadPool threadPool = new QueuedThreadPool(maxThreads, minThreads, idleTimeout);
        this.server = new Server((ThreadPool)threadPool);
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(this.port);
        this.server.addConnector((Connector)connector);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        ServletHolder staticFiles = new ServletHolder("default", (Servlet)new DefaultServlet());
        staticFiles.setInitParameter("resourceBase", "./web/");
        context.addServlet(staticFiles, "/*");
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(Arrays.asList(ClasspathHelper.forClass(MyServlet.class, (ClassLoader[])new ClassLoader[0]))));
        for (Class c : reflections.getSubTypesOf(MyServlet.class)) {
            WebServlet f = c.getAnnotation(WebServlet.class);
            if (f == null) continue;
            try {
                MyServlet s = (MyServlet)((Object)c.getConstructor(WebServer.class).newInstance(this));
                for (String url : f.urlPatterns()) {
                    context.addServlet(new ServletHolder((Servlet)s), url);
                }
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        this.server.setHandler((Handler)context);
        try {
            this.server.start();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    public WebServer() throws Exception {
        this(null, false);
    }

    @Override
    public void addJWT(String jwtid, JSONObject o) throws NoPersistenceException {
        this.getPersistence(ISesssionPersistence.class).addJWT(jwtid);
    }

    @Override
    public void addPersistence(IPersistence perstistence, Class<?> clazz) {
        this.persistences.put(clazz, perstistence);
    }

    @Override
    public void addPersistence(IPersistence p) {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(Arrays.asList(ClasspathHelper.forClass(IPersistence.class, (ClassLoader[])new ClassLoader[0]))));
        Set subTypes = reflections.getSubTypesOf(IPersistence.class);
        for (Class c : subTypes) {
            if (!c.isInterface()) continue;
            logger.info("Found IPersistence for in {} {}", (Object)p.getClass().getCanonicalName(), (Object)c.getCanonicalName());
            this.addPersistence(p, c);
        }
    }

    @Override
    public void addUUID(UUID uuid, Object object) {
        this.usedUUID.put(uuid, object);
    }

    @Override
    public IPersistence createPersistence(JSONObject config) {
        Object storage_file;
        JSONObject persistence = config.optJSONObject("persistence");
        if (persistence == null) {
            persistence = new JSONObject();
            config.put("persistence", (Object)persistence);
        }
        if ((storage_file = persistence.optString("file", null)) == null) {
            String relativepath = this.configFile.getParentFile().toString();
            storage_file = relativepath + "/" + this.getDefaultStorage();
            persistence.put("file", storage_file);
        }
        String clazz = persistence.optString("class");
        Class c = null;
        try {
            if (clazz != null) {
                c = Class.forName(clazz);
            }
        }
        catch (ClassNotFoundException e) {
            logger.error("COULD NOT FIND PERSISTENCE CLASS: {}", (Object)clazz);
            e.printStackTrace();
        }
        if (c == null || !JSONPersistence.class.isAssignableFrom(c)) {
            c = this.getDefaultPersistenceClass();
            persistence.put("class", (Object)c.getCanonicalName());
        }
        try {
            IPersistence p = (IPersistence)c.getConstructor(ControllerWithPersistence.class, File.class).newInstance(this, new File((String)storage_file));
            this.addPersistence(p);
            return p;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public UUID generateUUID() {
        UUID uuid = UUID.randomUUID();
        while (this.getByUUID(uuid) != null) {
            uuid = UUID.randomUUID();
        }
        return uuid;
    }

    @Override
    public Object getByUUID(UUID uuid) {
        return this.usedUUID.get(uuid);
    }

    public String getDefaultConfig() {
        return DEFAULT_CONFIG;
    }

    @Override
    public Class getDefaultPersistenceClass() {
        return JSONPersistence.class;
    }

    public int getDefaultPort() {
        return 8101;
    }

    public String getDefaultStorage() {
        return DEFAULT_STORAGE;
    }

    @Override
    public JWT getJwt() {
        return this.jwt;
    }

    @Override
    public <T> T getPersistence(Class<T> clazz) throws NoPersistenceException {
        IPersistence p = this.persistences.get(clazz);
        if (p != null) {
            return clazz.cast(p);
        }
        throw new NoPersistenceException();
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public String hashPepper(String input) {
        return HashFunctions.getSaltedHash((String)input, (String)this.pepper);
    }

    @Override
    public String hashSaltPepper(String input, String salt) {
        return HashFunctions.getSaltedAndPepperdHash((String)input, (String)salt, (String)this.pepper);
    }

    public abstract void init(JSONObject var1);

    @Override
    public boolean isKnownJWTID(String jwtid) {
        try {
            JSONObject jwt = this.getPersistence(ISesssionPersistence.class).getJWT(jwtid);
            if (jwt != null) {
                return true;
            }
        }
        catch (NoPersistenceException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public void prepare() {
    }

    public abstract void sanitizeConfig(JSONObject var1);

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

