/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ClassUtils;
import org.pf4j.DefaultPluginManager;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KosmosPluginManager
extends DefaultPluginManager {
    protected static final Logger logger = LoggerFactory.getLogger((String)"KosmosPluginManager");
    private final HashSet<Class> classes = new HashSet();

    public KosmosPluginManager() {
        this.init();
    }

    @Nonnull
    public Class getClass(@Nonnull String name) throws ClassNotFoundException {
        for (Class extension : this.classes) {
            if (extension.getCanonicalName().equals(name)) {
                return extension;
            }
            if (!extension.getName().equals(name)) continue;
            return extension;
        }
        throw new ClassNotFoundException(String.format("Could not find class %s", name));
    }

    @Nonnull
    public Collection<Class> getClassesFor(@Nonnull Class className) {
        HashSet<Class> matched = new HashSet<Class>();
        for (Class extension : this.classes) {
            for (Class i : ClassUtils.getAllSuperclasses((Class)extension)) {
                if (!className.isAssignableFrom(i)) continue;
                matched.add(extension);
            }
        }
        return matched;
    }

    public <T> T getInstance(@Nonnull String className, @CheckForNull Object params) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class c = this.getClass(className);
        if (params == null) {
            return c.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return c.getConstructor(params.getClass()).newInstance(params);
    }

    boolean deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                this.deleteDirectory(file);
            }
        }
        return directoryToBeDeleted.delete();
    }

    public void init() {
        for (Path p : this.pluginsRoots) {
            logger.info("found Plugin Path {}", (Object)p);
            if (p == null) continue;
            try {
                if (!p.toFile().exists()) continue;
                for (File f : p.toFile().listFiles()) {
                    if (!f.isDirectory()) continue;
                    logger.info("cleaning old data for {}", (Object)f);
                    this.deleteDirectory(f);
                }
            }
            catch (Exception ex) {
                logger.error("Exception:", (Throwable)ex);
            }
        }
        this.loadPlugins();
        this.startPlugins();
        List startedPlugins = this.getStartedPlugins();
        for (PluginWrapper plugin : startedPlugins) {
            String pluginId = plugin.getDescriptor().getPluginId();
            List extensionClasses = this.getExtensionClasses(pluginId);
            if (extensionClasses.isEmpty()) continue;
            for (Class extension : extensionClasses) {
                logger.info("Extension {} added by {}", (Object)extension, (Object)plugin.getPluginId());
                this.classes.add(extension);
            }
            try {
                Path myPath;
                URL r = ((Class)extensionClasses.get(0)).getResource("/web");
                if (r == null) continue;
                URI uri = r.toURI();
                if (uri.getScheme().equals("jar")) {
                    FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                    myPath = fileSystem.getPath("/web/", new String[0]);
                } else {
                    myPath = Paths.get(uri);
                }
                Stream<Path> walk = Files.walk(myPath, new FileVisitOption[0]);
                Iterator it = walk.iterator();
                while (it.hasNext()) {
                    Path path = (Path)it.next();
                    String filteredName = path.toString().substring(myPath.toString().length());
                    if (filteredName.length() <= 0) continue;
                    if (path.toFile().isFile()) {
                        Path to = new File(String.format("./web/%s", filteredName)).toPath();
                        logger.info("Found resource to copy in {}: {} ", (Object)plugin.getPluginId(), (Object)filteredName);
                        Files.copy(path, to, StandardCopyOption.REPLACE_EXISTING);
                        continue;
                    }
                    if (!path.toFile().isDirectory()) continue;
                    logger.info("Found resource to create in {}: {}", (Object)plugin.getPluginId(), (Object)filteredName);
                    new File(String.format("./web/%s", filteredName)).mkdirs();
                }
            }
            catch (IOException | NullPointerException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }
}

