/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.client.websocket;

import de.kosmos_lab.kosmos.client.websocket.WebSocketClientEndpoint;
import de.kosmos_lab.kosmos.client.websocket.WebSocketEventConsumer;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.Endpoint;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.MultiPartContentProvider;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpMethod;
import org.glassfish.tyrus.client.ClientManager;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketClient
extends HttpClient {
    private static final Logger logger = LoggerFactory.getLogger((String)"WebSocketClient");
    private final String user;
    private final String pass;
    private final String base;
    boolean stopped = false;
    private String token;
    private WebSocketClientEndpoint endpoint;

    public WebSocketClientEndpoint getEndpoint() {
        return this.endpoint;
    }

    public WebSocketClient(String base, String user, String pass) {
        this.base = base;
        this.user = user;
        this.pass = pass;
        this.setConnectTimeout(5000L);
        try {
            this.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void connect() {
        final WebSocketClient c = this;
        new Thread(){

            @Override
            public void run() {
                while (!WebSocketClient.this.stopped) {
                    try {
                        ClientEndpointConfig cec = ClientEndpointConfig.Builder.create().build();
                        ClientManager client = ClientManager.createClient();
                        WebSocketClient.this.endpoint = new WebSocketClientEndpoint(c);
                        client.connectToServer((Endpoint)WebSocketClient.this.endpoint, cec, new URI(WebSocketClient.this.getBase().replace("https:", "wss:").replace("http:", "ws:") + "/api/websocket"));
                        while (!WebSocketClient.this.endpoint.stopped) {
                            Thread.sleep(100L);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Exception!", (Throwable)e);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        logger.error("Exception!", (Throwable)e);
                    }
                }
            }
        }.start();
    }

    private Request createRequest(String url, HttpMethod method) {
        if (!((String)url).startsWith("http")) {
            url = this.base + (String)url;
        }
        logger.trace("creating request for {}", url);
        Request request = this.newRequest((String)url);
        request.method(method);
        request.agent("KosmoS Client");
        return request;
    }

    public void disconnect() {
        this.stopped = true;
        this.endpoint.stop();
    }

    public JSONObject getVars() {
        return this.endpoint.getVars();
    }

    public String getBase() {
        return this.base;
    }

    public String getPass() {
        return this.pass;
    }

    private ContentResponse getResponse(Request request) {
        ContentResponse response = null;
        try {
            response = request.send();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return response;
    }

    public String getToken() {
        return this.token;
    }

    public Object getVar(String key) {
        return this.endpoint.getVar(key);
    }

    public void setToken(String access_token) {
        this.token = access_token;
    }

    public String getUser() {
        return this.user;
    }

    public WebSocketClientEndpoint getWebSocket() {
        return this.endpoint;
    }

    public String post(String url, HashMap<String, Object> parameters) {
        Request request = this.createRequest(url, HttpMethod.POST);
        MultiPartContentProvider multiPart = new MultiPartContentProvider();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            multiPart.addFieldPart(entry.getKey(), (ContentProvider)new StringContentProvider(entry.getValue().toString()), null);
        }
        request.content((ContentProvider)multiPart);
        return this.getResponse(request).getContentAsString();
    }

    public JSONObject postJSON(String url, JSONObject json) {
        ContentResponse r;
        Request request = this.createRequest(url, HttpMethod.POST);
        if (json != null) {
            request.content((ContentProvider)new StringContentProvider(json.toString()), "application/json");
        }
        if (this.token != null) {
            request.header("authorization", "Bearer " + this.token);
        }
        if ((r = this.getResponse(request)) != null) {
            try {
                return new JSONObject(r.getContentAsString());
            }
            catch (JSONException ex) {
                logger.error("HTTP Status {}:{}", (Object)r.getStatus(), (Object)r.getContentAsString());
                logger.error("Exception", (Throwable)ex);
            }
        }
        return null;
    }

    public void sendCommand(JSONObject command, WebSocketEventConsumer consumer) {
        if (this.endpoint != null) {
            this.endpoint.sendCommand(command, consumer);
        } else {
            logger.error("NO ENDPOINT!!");
        }
    }

    public void unstop() {
        this.stopped = false;
    }

    public boolean waitForValue(String key, Object expected, long waittime) {
        return this.endpoint.waitForValue(key, expected, waittime);
    }

    public void waitForInit() throws InterruptedException {
        this.endpoint.initLatch.await();
    }
}

