/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.client.websocket;

import de.kosmos_lab.kosmos.client.websocket.WebSocketClient;
import de.kosmos_lab.kosmos.client.websocket.WebSocketEventConsumer;
import de.kosmos_lab.utils.JSONChecker;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketClientEndpoint
extends Endpoint {
    private static final Logger logger = LoggerFactory.getLogger((String)"WebSocketClientEndpoint");
    protected final WebSocketClient client;
    public CountDownLatch initLatch;
    protected boolean stopped = false;
    int lastId = 1;
    protected Session session;
    private boolean authed = false;
    private final JSONObject vars = new JSONObject();
    protected final HashMap<Integer, WebSocketEventConsumer> consumers = new HashMap();

    public WebSocketClientEndpoint(WebSocketClient webSocketClient) {
        this.client = webSocketClient;
        this.initLatch = new CountDownLatch(1);
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void addConsumer(int id, WebSocketEventConsumer consumer) {
        this.consumers.put(id, consumer);
    }

    public Object getVar(String name) {
        return this.vars.get(name);
    }

    public JSONObject getVars() {
        return this.vars;
    }

    public boolean isAuthed() {
        return this.authed;
    }

    public void onClose(Session session, CloseReason closeReason) {
        super.onClose(session, closeReason);
        logger.info("WS onClose");
    }

    public void onMessageReceived(String message) {
        logger.info("wsreceived: {}", (Object)message);
    }

    public void onOpen(Session session, EndpointConfig endpointConfig) {
        try {
            logger.info("WSClient onOpen");
            this.session = session;
            session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

                public void onMessage(String message) {
                    WebSocketClientEndpoint.this.onMessageReceived(message);
                }
            });
        }
        catch (Exception e) {
            logger.error("Exception!", (Throwable)e);
        }
    }

    public void send(String text) throws IOException {
        this.session.getBasicRemote().sendText(text);
    }

    public void sendCommand(JSONObject command, WebSocketEventConsumer consumer) {
        if (command.has("id")) {
            try {
                int id = command.getInt("id");
                if (id > this.lastId) {
                    this.lastId = id;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!command.has("id")) {
            command.put("id", ++this.lastId);
        }
        this.addConsumer(command.getInt("id"), consumer);
        try {
            logger.info("wssent: {}", (Object)command);
            this.send(command.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean waitForValue(String key, Object expected, long waittime) {
        long delta;
        long started = System.currentTimeMillis();
        do {
            try {
                if (JSONChecker.equals((Object)this.vars.get(key), (Object)expected)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while ((delta = System.currentTimeMillis() - started) <= waittime);
        return false;
    }

    public void setVar(String name, Object value) {
        logger.info("setting {} to {}", (Object)name, value);
        this.vars.put(name, value);
    }

    public void stop() {
        this.stopped = true;
        try {
            this.session.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

