/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.data;

import de.kosmos_lab.utils.KosmosFileUtils;
import de.kosmos_lab.utils.StringFunctions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"DM_EXIT"})
public class Config
extends JSONObject {
    private File file;
    private static final Logger logger = LoggerFactory.getLogger((String)"Config");

    public Config(@Nonnull File f) throws IOException {
        super(new JSONTokener((Reader)new FileReader(f, StandardCharsets.UTF_8)));
        this.file = f;
        this.init();
    }

    public Config() {
        this.init();
    }

    public void setFile(@Nonnull File f) {
        this.file = f;
    }

    public void save() {
        KosmosFileUtils.writeToFile((File)this.file, (String)this.toString(4));
    }

    private void init() {
        JSONObject statelog;
        JSONObject webserver;
        String jwt;
        String pepper;
        Object o;
        String jdbcurl;
        JSONObject sql = this.optJSONObject("sql");
        if (sql == null) {
            sql = new JSONObject();
            this.put("sql", sql);
        }
        if ((jdbcurl = sql.optString("url", null)) == null) {
            sql.put("url", (Object)"jdbc:sqlite:./db/database.sqlite");
            File f = new File("db/");
            if (!f.exists() && !f.mkdirs()) {
                logger.warn("could not create database folder \"{}\" - exiting", (Object)f);
                System.exit(1);
            }
        }
        if ((o = sql.opt("maxConnections")) == null) {
            sql.put("maxConnections", 10);
        }
        if ((pepper = this.optString("pepper", null)) == null) {
            pepper = StringFunctions.generateRandomKey();
            this.put("pepper", pepper);
        }
        if ((jwt = this.optString("jwt", null)) == null) {
            jwt = StringFunctions.generateRandomKey();
            this.put("jwt", jwt);
        }
        if ((webserver = this.optJSONObject("webserver")) == null) {
            webserver = new JSONObject();
            this.put("webserver", webserver);
        }
        try {
            int n = webserver.getInt("port");
        }
        catch (JSONException e) {
            webserver.put("port", 18080);
        }
        JSONObject mqtt = this.optJSONObject("mqtt");
        if (mqtt == null) {
            mqtt = new JSONObject();
            this.put("mqtt", mqtt);
        }
        try {
            int n = mqtt.getInt("port");
        }
        catch (JSONException e) {
            mqtt.put("port", 1883);
        }
        try {
            String e = mqtt.getString("host");
        }
        catch (JSONException e) {
            mqtt.put("host", (Object)"0.0.0.0");
        }
        if (!this.has("statelog")) {
            this.put("statelog", new JSONObject());
        }
        if (!(statelog = this.getJSONObject("statelog")).has("whitelist")) {
            statelog.put("whitelist", (Object)new JSONArray());
        }
        if (!statelog.has("blacklist")) {
            statelog.put("blacklist", (Object)new JSONArray());
        }
    }
}

