/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.data;

import de.kosmos_lab.kosmos.data.DataSchema;
import javax.annotation.Nonnull;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ValidationException;
import org.json.JSONObject;

public class DataEntry
extends JSONObject {
    private final DataSchema schema;

    public DataEntry(@Nonnull DataSchema schema, @Nonnull JSONObject json, boolean force) throws ValidationException {
        if (!force) {
            schema.validate(json);
        }
        this.silentOverwrite(json);
        this.schema = schema;
    }

    protected void silentOverwrite(@Nonnull JSONObject json) {
        for (String key : json.keySet()) {
            this.put(key, json.get(key));
        }
    }

    public DataEntry(@Nonnull DataSchema schema, @Nonnull String json) throws ValidationException {
        super(json);
        schema.validate(this);
        this.schema = schema;
    }

    public DataSchema getDataSchema() {
        return this.schema;
    }

    public ObjectSchema getSchema() {
        return this.schema.getSchema();
    }
}

