/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.data;

import de.kosmos_lab.kosmos.exceptions.NotObjectSchemaException;
import de.kosmos_lab.kosmos.platform.utils.LocalSchemaClient;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Random;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaClient;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSchema {
    private static final Logger logger = LoggerFactory.getLogger((String)"DataSchema");
    private static final Random random = new Random();
    private ObjectSchema schema;
    private JSONObject rawSchema;

    public DataSchema(@Nonnull File file) throws IOException, NotObjectSchemaException {
        FileReader f = new FileReader(file, StandardCharsets.UTF_8);
        JSONObject json = new JSONObject(new JSONTokener((Reader)f));
        this.load(json);
    }

    public JSONObject getRawSchema() {
        return this.rawSchema;
    }

    public ObjectSchema getSchema() {
        return this.schema;
    }

    public DataSchema(@Nonnull InputStream stream) throws NotObjectSchemaException {
        JSONObject json = new JSONObject(new JSONTokener(stream));
        this.load(json);
    }

    public void load(@Nonnull JSONObject json) throws NotObjectSchemaException {
        if (!json.has("$schema")) {
            json.put("$schema", (Object)"http://json-schema.org/draft-07/schema#");
        }
        this.rawSchema = json;
        SchemaLoader loader = SchemaLoader.builder().schemaClient((SchemaClient)new LocalSchemaClient("https://kosmos-lab.de/")).schemaJson(json).build();
        Schema s = loader.load().build();
        if (!(s instanceof ObjectSchema)) {
            throw new NotObjectSchemaException();
        }
        this.schema = (ObjectSchema)s;
    }

    public DataSchema(@Nonnull JSONObject json) throws NotObjectSchemaException {
        this.load(json);
    }

    public void validate(@Nonnull JSONObject data) throws ValidationException {
        this.schema.validate((Object)data);
    }

    public boolean definesProperty(@Nonnull String key) {
        return this.schema.definesProperty(key);
    }

    @CheckForNull
    public static Object getExample(@Nonnull Schema s) {
        logger.info("getting an example value for " + s.getId() + " type:" + s.getClass().toString());
        if (s instanceof NumberSchema) {
            NumberSchema ns = (NumberSchema)s;
            if (!ns.requiresInteger()) {
                double v;
                double maximum = 1000000.0;
                Number max = ns.getMaximum();
                if (max != null) {
                    try {
                        maximum = max.doubleValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                double minimum = -1000000.0;
                Number min = ns.getMinimum();
                if (min != null) {
                    try {
                        minimum = min.doubleValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                double multipleOf2 = 1.0;
                Number multi = ns.getMultipleOf();
                if (multi != null) {
                    try {
                        multipleOf2 = multi.doubleValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (multipleOf2 != 0.0) {
                    int bound = (int)((maximum - minimum) / multipleOf2);
                    v = random.nextInt(bound);
                    if (multipleOf2 != 0.0) {
                        v *= multipleOf2;
                    }
                    v += minimum;
                } else {
                    double bound = maximum - minimum;
                    v = random.nextDouble() * bound;
                    v += minimum;
                }
                logger.info("getting an example value for " + s.getId() + " from " + minimum + " to " + maximum + " in " + multipleOf2 + " steps : " + v);
                return v;
            }
            int maximum = Integer.MAX_VALUE;
            Number max = ns.getMaximum();
            if (max != null) {
                try {
                    maximum = max.intValue();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            int minimum = Integer.MIN_VALUE;
            Number min = ns.getMinimum();
            if (min != null) {
                try {
                    minimum = min.intValue();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            int multipleOf = 1;
            Number multi = ns.getMultipleOf();
            if (multi != null) {
                try {
                    multipleOf = multi.intValue();
                    if (multipleOf == 0) {
                        multipleOf = 1;
                    }
                }
                catch (NumberFormatException multipleOf2) {
                    // empty catch block
                }
            }
            logger.info("getting an example value for " + s.getId() + " from " + minimum + " to " + maximum + " in " + multipleOf + " steps: ");
            int bound = maximum == Integer.MAX_VALUE && minimum == Integer.MIN_VALUE ? Integer.MAX_VALUE / multipleOf : (maximum - minimum) / multipleOf;
            int v = random.nextInt(bound);
            v *= multipleOf;
            logger.info("got value: {}", (Object)(v += minimum));
            return v;
        }
        if (s instanceof EnumSchema) {
            EnumSchema es = (EnumSchema)s;
            List lst = es.getPossibleValuesAsList();
            int idx = random.nextInt(lst.size());
            return lst.get(idx);
        }
        if (s instanceof StringSchema) {
            int leftLimit = 48;
            int rightLimit = 122;
            int targetStringLength = 10;
            String generatedString = random.ints(leftLimit, rightLimit + 1).filter(i -> !(i > 57 && i < 65 || i > 90 && i < 97)).limit(targetStringLength).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
            return generatedString;
        }
        if (s instanceof BooleanSchema) {
            return random.nextBoolean();
        }
        if (s instanceof CombinedSchema) {
            Object v;
            CombinedSchema cs = (CombinedSchema)s;
            for (Schema sub : cs.getSubschemas()) {
                if (!(sub instanceof EnumSchema) || (v = DataSchema.getExample(sub)) == null) continue;
                return v;
            }
            for (Schema sub : cs.getSubschemas()) {
                v = DataSchema.getExample(sub);
                if (v == null) continue;
                return v;
            }
        }
        return null;
    }
}

