/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.data;

import de.dfki.baall.helper.webserver.data.IUser;
import de.kosmos_lab.kosmos.data.DataEntry;
import de.kosmos_lab.kosmos.data.DataSchema;
import de.kosmos_lab.kosmos.data.Scope;
import de.kosmos_lab.kosmos.data.StateUpdates;
import de.kosmos_lab.kosmos.exceptions.NoAccessToScope;
import de.kosmos_lab.kosmos.platform.IController;
import de.kosmos_lab.kosmos.platform.smarthome.CommandInterface;
import de.kosmos_lab.kosmos.platform.smarthome.CommandSourceName;
import de.kosmos_lab.utils.DoubleFunctions;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;
import org.everit.json.schema.ValidationException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Device
extends DataEntry {
    protected static final Logger logger = LoggerFactory.getLogger((String)"Device");
    private final IController controller;
    private final String uuid;
    private final IUser owner;
    protected HashMap<String, Object> hidden = new HashMap();
    ConcurrentHashMap<String, Long> lastChangeMap = new ConcurrentHashMap();
    ReentrantLock lock = new ReentrantLock();
    private String name;
    private CommandSourceName source;
    private Date lastUpdate;
    private Date lastChange;
    private Scope delScope;
    private Scope readScope;
    private Scope writeScope;
    private Location location = null;

    public Device(@Nonnull IController controller, @Nonnull CommandSourceName source, @Nonnull DataSchema schema, @Nonnull JSONObject json, @Nonnull String name, @Nonnull String uuid, @Nonnull IUser owner, boolean force) throws ValidationException {
        super(schema, json, force);
        Date now;
        this.controller = controller;
        this.source = source;
        this.name = name;
        this.uuid = uuid;
        this.lastUpdate = now = new Date();
        this.lastChange = now;
        this.owner = owner;
    }

    public boolean canDel(@Nonnull IUser user) throws NoAccessToScope {
        if (this.delScope == null) {
            return true;
        }
        if (user.isAdmin()) {
            return true;
        }
        if (this.delScope.hasAccess(user)) {
            return true;
        }
        throw new NoAccessToScope(this.delScope);
    }

    public boolean canHave(@Nonnull String key, boolean def) {
        if (this.has(key)) {
            return true;
        }
        if (this.getDataSchema() != null) {
            return this.getDataSchema().definesProperty(key);
        }
        return def;
    }

    public boolean canHave(@Nonnull String key) {
        return this.canHave(key, true);
    }

    public boolean canRead(@Nonnull IUser user) throws NoAccessToScope {
        if (this.readScope == null) {
            return true;
        }
        if (user.isAdmin()) {
            return true;
        }
        if (this.readScope.hasAccess(user)) {
            return true;
        }
        throw new NoAccessToScope(this.readScope);
    }

    public boolean canWrite(@Nonnull IUser user) throws NoAccessToScope {
        if (this.writeScope == null) {
            return true;
        }
        if (user.isAdmin()) {
            return true;
        }
        if (this.writeScope.hasAccess(user)) {
            return true;
        }
        throw new NoAccessToScope(this.writeScope);
    }

    public boolean canWrite(@Nonnull String key, @Nonnull IUser user) {
        if (this.owner == null) {
            logger.error("Device {} has NO OWNER?!", (Object)this.getUniqueID());
            return true;
        }
        try {
            Schema schema = (Schema)this.getSchema().getPropertySchemas().get(key);
            if (schema != null) {
                if (schema.isReadOnly() == null) {
                    return true;
                }
                if (schema.isReadOnly().booleanValue() && !this.canWriteReadOnly(user)) {
                    return false;
                }
            }
        }
        catch (Exception ex) {
            logger.warn("could not verify readonly state of {} in {}", new Object[]{key, this.getSchema().getId(), ex});
        }
        return true;
    }

    public boolean canWriteReadOnly(@Nonnull IUser u) {
        if (this.owner.equals(u)) {
            return true;
        }
        return u.isAdmin();
    }

    @CheckForNull
    public StateUpdates getChanges(long maxage) {
        if (this.length() > 0) {
            StateUpdates upd = new StateUpdates();
            for (Map.Entry<String, Long> entry : this.lastChangeMap.entrySet()) {
                long delta = System.currentTimeMillis() - entry.getValue();
                if (delta > maxage) continue;
                upd.addUpdate(entry.getKey(), delta);
            }
            return upd;
        }
        return null;
    }

    @CheckForNull
    public Object getHidden(@Nonnull String key) {
        return this.hidden.get(key);
    }

    public Date getLastUpdated() {
        return this.lastUpdate;
    }

    @CheckForNull
    public Location getLocation() {
        return this.location;
    }

    public void setLocation(@Nullable Location location) {
        this.location = location;
    }

    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public IUser getOwner() {
        return this.owner;
    }

    public CommandSourceName getSource() {
        return this.source;
    }

    public void setSource(@Nonnull CommandSourceName source) {
        this.source = source;
    }

    @Nonnull
    public String getUniqueID() {
        return this.uuid;
    }

    @CheckForNull
    public String getUnit(@Nonnull String property) {
        JSONObject p;
        JSONObject properties = this.getDataSchema().getRawSchema().optJSONObject("properties");
        if (properties != null && (p = properties.optJSONObject(property)) != null) {
            return p.optString("unit", null);
        }
        return null;
    }

    public boolean hasDelScope() {
        return this.delScope != null;
    }

    public boolean set(String key, Object value, boolean round) throws ValidationException {
        Date now;
        block50: {
            EnumSchema es;
            CombinedSchema cs;
            List list;
            EnumSchema es22;
            NumberSchema ns2;
            Schema schema;
            block49: {
                block52: {
                    block51: {
                        this.lastUpdate = now = new Date();
                        if (this.controller != null) {
                            this.controller.updateLastUpdate(this);
                        }
                        if (!(value instanceof Integer) && !(value instanceof Double) && !(value instanceof Float) || (schema = (Schema)this.getSchema().getPropertySchemas().get(key)) == null) break block49;
                        if (!(schema instanceof NumberSchema)) break block51;
                        try {
                            Number multiplier;
                            ns2 = (NumberSchema)schema;
                            if (ns2.requiresInteger()) {
                                multiplier = ns2.getMultipleOf();
                                value = multiplier != null ? Integer.valueOf(DoubleFunctions.roundToNearest((double)((Number)value).doubleValue(), (double)multiplier.intValue()).intValue()) : Integer.valueOf(((Number)value).intValue());
                            } else {
                                if (value instanceof Integer) {
                                    value = ((Number)value).doubleValue();
                                }
                                if ((multiplier = ns2.getMultipleOf()) != null) {
                                    value = DoubleFunctions.roundToNearest((double)((Number)value).doubleValue(), (double)multiplier.doubleValue());
                                }
                            }
                            break block49;
                        }
                        catch (NumberFormatException ns2) {}
                        break block49;
                    }
                    if (!(schema instanceof EnumSchema)) break block52;
                    es22 = (EnumSchema)schema;
                    boolean found = false;
                    list = es22.getPossibleValuesAsList();
                    if (list.isEmpty()) break block49;
                    for (Object f : list) {
                        if (!value.toString().equalsIgnoreCase(f.toString())) continue;
                        found = true;
                        value = f.toString();
                        break;
                    }
                    if (found) break block49;
                    value = list.get(0).toString();
                    break block49;
                }
                if (schema instanceof StringSchema) {
                    try {
                        value = value.toString();
                    }
                    catch (NumberFormatException es22) {}
                } else if (schema instanceof CombinedSchema) {
                    cs = (CombinedSchema)schema;
                    block9: for (Schema sub : cs.getSubschemas()) {
                        if (sub instanceof EnumSchema) {
                            es = (EnumSchema)sub;
                            boolean found = false;
                            List list2 = es.getPossibleValuesAsList();
                            if (list2.isEmpty()) continue;
                            for (Object f : list2) {
                                if (!value.toString().equalsIgnoreCase(f.toString())) continue;
                                found = true;
                                value = f.toString();
                                break block9;
                            }
                            if (found) continue;
                            value = list2.get(0).toString();
                            continue;
                        }
                        if (!(schema instanceof StringSchema)) continue;
                        value = value.toString();
                    }
                }
            }
            if (value instanceof String) {
                schema = (Schema)this.getSchema().getPropertySchemas().get(key);
                if (schema instanceof BooleanSchema) {
                    if ("true".equalsIgnoreCase((String)value) || "on".equalsIgnoreCase((String)value) || value.equals("1") || value.equals("heat")) {
                        value = true;
                    } else if ("false".equalsIgnoreCase((String)value) || "off".equalsIgnoreCase((String)value) || value.equals("0")) {
                        value = false;
                    }
                } else if (schema instanceof NumberSchema) {
                    try {
                        ns2 = (NumberSchema)schema;
                        if (ns2.requiresInteger()) {
                            value = Double.valueOf((String)value);
                            Number multiplier = ns2.getMultipleOf();
                            value = multiplier != null ? Integer.valueOf(DoubleFunctions.roundToNearest((double)((Double)value), (double)multiplier.intValue()).intValue()) : Integer.valueOf(((Number)value).intValue());
                        } else {
                            value = Double.valueOf((String)value);
                            Number multiplier = ns2.getMultipleOf();
                            if (multiplier != null) {
                                value = DoubleFunctions.roundToNearest((double)((Double)value), (double)multiplier.doubleValue());
                            }
                        }
                    }
                    catch (NumberFormatException ns3) {}
                } else if (schema instanceof EnumSchema) {
                    es22 = (EnumSchema)schema;
                    boolean found = false;
                    list = es22.getPossibleValuesAsList();
                    if (!list.isEmpty()) {
                        for (Object f : list) {
                            if (!((String)value).equalsIgnoreCase(f.toString())) continue;
                            found = true;
                            value = f.toString();
                            break;
                        }
                        if (!found) {
                            value = list.get(0).toString();
                        }
                    }
                } else if (schema instanceof CombinedSchema) {
                    cs = (CombinedSchema)schema;
                    for (Schema sub : cs.getSubschemas()) {
                        if (sub instanceof EnumSchema) {
                            es = (EnumSchema)sub;
                            List list3 = es.getPossibleValuesAsList();
                            if (!list3.isEmpty()) {
                                for (Object f : list3) {
                                    if (!value.toString().equalsIgnoreCase(f.toString())) continue;
                                    value = f.toString();
                                    break block50;
                                }
                            }
                            value = list3.get(0).toString();
                            continue;
                        }
                        if (!(schema instanceof StringSchema)) continue;
                        value = value.toString();
                    }
                } else if (schema instanceof ArraySchema) {
                    value = new JSONArray(value);
                } else if (schema instanceof ObjectSchema) {
                    value = new JSONObject(value);
                }
            }
        }
        try {
            Object old = this.get(key);
            if (old instanceof JSONObject && value instanceof JSONObject) {
                if (((JSONObject)old).toMap().equals(((JSONObject)value).toMap())) {
                    return false;
                }
                if (old.toString().equals(value.toString())) {
                    return false;
                }
            }
            if (old instanceof JSONArray && value instanceof JSONArray ? old.toString().equals(value.toString()) : old.equals(value)) {
                return false;
            }
        }
        catch (JSONException old) {
            // empty catch block
        }
        JSONObject newState = new JSONObject(this.toMap());
        newState.put(key, value);
        logger.info("state to validate {}", (Object)newState);
        this.getSchema().validate((Object)newState);
        this.put(key, value);
        this.lastChangeMap.put(key, System.currentTimeMillis());
        this.lastChange = now;
        return true;
    }

    public void setDelScope(Scope scope) {
        this.delScope = scope;
    }

    public void setHidden(String key, Object value) {
        this.hidden.put(key, value);
    }

    public void setReadScope(Scope scope) {
        this.readScope = scope;
    }

    public void setState(JSONObject o, boolean b) throws ValidationException {
        Date now = new Date();
        this.getSchema().validate((Object)o);
        this.silentOverwrite(o);
        this.lastUpdate = now;
        this.lastChange = now;
    }

    public void setWriteScope(Scope scope) {
        this.writeScope = scope;
    }

    public JSONObject toJSON() {
        JSONObject o = new JSONObject();
        JSONObject state = new JSONObject();
        for (String key : this.keySet()) {
            state.put(key, this.get(key));
        }
        o.put("state", (Object)state);
        o.put("name", (Object)this.name);
        o.put("uuid", (Object)this.uuid);
        o.put("schema", (Object)this.getSchema().getId());
        o.put("lastUpdate", this.lastUpdate.getTime());
        o.put("lastChange", this.lastChange.getTime());
        return o;
    }

    public boolean updateFromJSON(CommandInterface from, JSONObject o, CommandSourceName source) {
        HashSet<String> dirtyKeys = new HashSet<String>();
        for (String key : o.keySet()) {
            if (!this.set(key, o.get(key), true)) continue;
            dirtyKeys.add(key);
        }
        for (String key : dirtyKeys) {
            this.controller.publishUpdate(from, this, key, source);
        }
        return dirtyKeys.size() > 0;
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public static class Location {
        private Integer x;
        private Integer y;
        private Integer z;
        private Integer w;
        private Integer d;
        private Integer h;
        private Integer roll;
        private Integer pitch;
        private Integer yaw;
        private String area;

        public Location(Integer x, Integer y, Integer z, Integer w, Integer d, Integer h, Integer roll, Integer pitch, Integer yaw, String area) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.w = w;
            this.d = d;
            this.h = h;
            this.roll = roll;
            this.pitch = pitch;
            this.yaw = yaw;
            this.area = area;
        }

        public Location(JSONObject json) {
            if (json.has("x")) {
                try {
                    this.x = json.getInt("x");
                }
                catch (JSONException ex) {
                    this.x = null;
                    ex.printStackTrace();
                }
            }
            if (json.has("y")) {
                try {
                    this.y = json.getInt("y");
                }
                catch (JSONException ex) {
                    this.y = null;
                    ex.printStackTrace();
                }
            }
            if (json.has("z")) {
                try {
                    this.z = json.getInt("z");
                }
                catch (JSONException ex) {
                    this.z = null;
                    ex.printStackTrace();
                }
            }
            if (json.has("w")) {
                try {
                    this.w = json.getInt("w");
                }
                catch (JSONException ex) {
                    this.w = null;
                    ex.printStackTrace();
                }
            }
            if (json.has("h")) {
                try {
                    this.h = json.getInt("h");
                }
                catch (JSONException ex) {
                    this.h = null;
                    ex.printStackTrace();
                }
            }
            if (json.has("d")) {
                try {
                    this.d = json.getInt("d");
                }
                catch (JSONException ex) {
                    this.d = null;
                    ex.printStackTrace();
                }
            }
            if (json.has("roll")) {
                try {
                    this.roll = json.getInt("roll");
                }
                catch (JSONException ex) {
                    this.roll = null;
                    ex.printStackTrace();
                }
            }
            if (json.has("pitch")) {
                try {
                    this.pitch = json.getInt("pitch");
                }
                catch (JSONException ex) {
                    ex.printStackTrace();
                }
            }
            if (json.has("yaw")) {
                try {
                    this.yaw = json.getInt("yaw");
                }
                catch (JSONException ex) {
                    this.yaw = null;
                    ex.printStackTrace();
                }
            }
            this.area = json.optString("area", null);
        }

        public String getArea() {
            return this.area;
        }

        public Integer getD() {
            return this.d;
        }

        public Integer getH() {
            return this.h;
        }

        public Integer getPitch() {
            return this.pitch;
        }

        public Integer getRoll() {
            return this.roll;
        }

        public Integer getW() {
            return this.w;
        }

        public Integer getX() {
            return this.x;
        }

        public Integer getY() {
            return this.y;
        }

        public Integer getYaw() {
            return this.yaw;
        }

        public Integer getZ() {
            return this.z;
        }

        public JSONObject toJSON() {
            JSONObject json = new JSONObject();
            if (this.x != null) {
                json.put("x", (Object)this.x);
            }
            if (this.y != null) {
                json.put("y", (Object)this.y);
            }
            if (this.z != null) {
                json.put("z", (Object)this.z);
            }
            if (this.w != null) {
                json.put("w", (Object)this.w);
            }
            if (this.d != null) {
                json.put("d", (Object)this.d);
            }
            if (this.h != null) {
                json.put("h", (Object)this.h);
            }
            if (this.roll != null) {
                json.put("roll", (Object)this.roll);
            }
            if (this.pitch != null) {
                json.put("pitch", (Object)this.pitch);
            }
            if (this.yaw != null) {
                json.put("yaw", (Object)this.yaw);
            }
            if (this.area != null) {
                json.put("area", (Object)this.area);
            }
            return json;
        }

        public boolean updateFromJSON(JSONObject json) {
            int newV;
            boolean dirty = false;
            if (json.has("x")) {
                newV = json.getInt("x");
                if (this.x == null || newV != this.x) {
                    this.x = newV;
                    dirty = true;
                }
            }
            if (json.has("y")) {
                newV = json.getInt("y");
                if (this.y == null || newV != this.y) {
                    this.y = newV;
                    dirty = true;
                }
            }
            if (json.has("z")) {
                newV = json.getInt("z");
                if (this.z == null || newV != this.z) {
                    this.z = newV;
                    dirty = true;
                }
            }
            if (json.has("w")) {
                newV = json.getInt("w");
                if (this.w == null || newV != this.w) {
                    this.w = newV;
                    dirty = true;
                }
            }
            if (json.has("d")) {
                newV = json.getInt("d");
                if (this.d == null || newV != this.d) {
                    this.d = newV;
                    dirty = true;
                }
            }
            if (json.has("h")) {
                newV = json.getInt("h");
                if (this.h == null || newV != this.h) {
                    this.h = newV;
                    dirty = true;
                }
            }
            if (json.has("roll")) {
                newV = json.getInt("roll");
                if (this.roll == null || newV != this.roll) {
                    this.roll = newV;
                    dirty = true;
                }
            }
            if (json.has("pitch")) {
                newV = json.getInt("pitch");
                if (this.pitch == null || newV != this.pitch) {
                    this.pitch = newV;
                    dirty = true;
                }
            }
            if (json.has("yaw")) {
                newV = json.getInt("yaw");
                if (this.yaw == null || newV != this.yaw) {
                    this.yaw = newV;
                    dirty = true;
                }
            }
            if (json.has("area")) {
                String newV2 = json.getString("area");
                if (this.area == null || !newV2.equals(this.area)) {
                    this.area = newV2;
                    dirty = true;
                }
            }
            return dirty;
        }
    }
}

