/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.data;

import de.dfki.baall.helper.webserver.data.IUser;
import de.kosmos_lab.kosmos.platform.IController;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KosmoSUser
implements IUser {
    public static final int LEVEL_ADMIN = 100;
    private static final Logger logger = LoggerFactory.getLogger((String)"User");
    private int id;
    private final IController controller;
    private final String user;
    private final int level;
    private String hash;
    private String salt;

    @Override
    public boolean isAdmin() {
        return this.level >= 100;
    }

    public void setID(int id) {
        this.id = id;
    }

    public KosmoSUser(@Nonnull IController controller, @Nonnull String user, int id, int level, @Nonnull String hash, @Nonnull String salt) {
        this.controller = controller;
        this.user = user;
        this.id = id;
        this.level = level;
        this.hash = hash;
        this.salt = salt;
    }

    @Override
    public boolean canAccess(int level) {
        return this.level >= level;
    }

    @Override
    public boolean checkPassword(@Nonnull String input) {
        String toTest = this.controller.getPasswordHash(input, this.salt);
        return toTest.equals(this.hash);
    }

    public int getID() {
        return this.id;
    }

    @Nonnull
    public String getHash() {
        return this.hash;
    }

    @Nonnull
    public String getSalt() {
        return this.salt;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.user;
    }

    @Override
    @Nonnull
    public UUID getUUID() {
        return new UUID(0L, this.id);
    }

    public void setPassword(@Nonnull String salt, @Nonnull String hash) {
        this.hash = hash;
        this.salt = salt;
    }

    @Override
    @Nonnull
    public JSONObject toJWT() {
        JSONObject o = new JSONObject();
        o.put("name", (Object)this.user);
        o.put("id", this.id);
        o.put("level", this.level);
        o.put("hash", (Object)this.controller.hashPepper(this.salt).substring(0, 8));
        return o;
    }

    public boolean equals(@CheckForNull Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KosmoSUser user = (KosmoSUser)o;
        return this.id == user.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

