/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.data;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class LoggingRequest {
    private final Set<String> properties;
    private final String uuid;

    public LoggingRequest(@Nonnull String uuid) {
        this(uuid, new HashSet<String>());
    }

    public LoggingRequest(@Nonnull String uuid, @Nonnull Set<String> properties) {
        this.uuid = uuid;
        this.properties = properties;
    }

    public LoggingRequest(@Nonnull String uuid, @Nonnull String property) {
        this(uuid, new HashSet<String>());
        this.addProperty(property);
    }

    public LoggingRequest(@Nonnull String uuid, @Nonnull String[] props) {
        this(uuid, new HashSet<String>());
        for (String prop : props) {
            this.addProperty(prop);
        }
    }

    public void addProperty(@Nonnull String property) {
        this.properties.add(property);
    }

    @Nonnull
    public Set<String> getProperties() {
        return this.properties;
    }

    @Nonnull
    public String getUuid() {
        return this.uuid;
    }
}

