/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.data;

import de.dfki.baall.helper.webserver.data.IUser;
import de.kosmos_lab.kosmos.data.Group;
import java.util.HashSet;
import javax.annotation.Nonnull;
import org.json.JSONArray;
import org.json.JSONObject;

public class Scope {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_ID = "id";
    public static final String FIELD_USERS = "users";
    public static final String FIELD_ADMINS = "admins";
    public static final String FIELD_USER_GROUPS = "userGroups";
    public static final String FIELD_ADMIN_GROUPS = "adminGroups";
    private final String name;
    private final int id;
    HashSet<IUser> admins = new HashSet();
    HashSet<IUser> users = new HashSet();
    HashSet<Group> adminGroups = new HashSet();
    HashSet<Group> userGroups = new HashSet();

    public void addAdmin(@Nonnull IUser user) {
        this.admins.add(user);
    }

    public void addUser(@Nonnull IUser user) {
        this.users.add(user);
    }

    public void addUserGroup(@Nonnull Group group) {
        this.userGroups.add(group);
    }

    public void addAdminGroup(@Nonnull Group group) {
        this.adminGroups.add(group);
    }

    public void delUser(@Nonnull IUser user) {
        this.users.remove(user);
    }

    public void delAdmin(@Nonnull IUser user) {
        this.admins.remove(user);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public int getID() {
        return this.id;
    }

    public boolean hasUser(@Nonnull IUser user) {
        return this.users.contains(user);
    }

    public boolean hasAdmin(@Nonnull IUser user) {
        if (this.admins.contains(user)) {
            return true;
        }
        for (Group g : this.adminGroups) {
            if (!g.hasAdmin(user)) continue;
            return true;
        }
        return false;
    }

    public Scope(@Nonnull Integer id, @Nonnull String name) {
        this.id = id;
        this.name = name;
    }

    boolean hasAccess(@Nonnull IUser user) {
        if (this.admins.contains(user)) {
            return true;
        }
        if (this.users.contains(user)) {
            return true;
        }
        for (Group g : this.adminGroups) {
            if (!g.hasAccess(user)) continue;
            return true;
        }
        for (Group g : this.userGroups) {
            if (!g.hasAccess(user)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public JSONObject toJSON() {
        JSONObject o = new JSONObject();
        o.put(FIELD_NAME, (Object)this.name);
        o.put(FIELD_ID, this.id);
        JSONArray arr = new JSONArray();
        for (IUser u : this.admins) {
            arr.put((Object)new JSONObject().put(FIELD_ID, (Object)u.getUUID()).put(FIELD_NAME, (Object)u.getName()));
        }
        o.put(FIELD_ADMINS, (Object)arr);
        arr = new JSONArray();
        for (IUser u : this.users) {
            arr.put((Object)new JSONObject().put(FIELD_ID, (Object)u.getUUID()).put(FIELD_NAME, (Object)u.getName()));
        }
        o.put(FIELD_USERS, (Object)arr);
        arr = new JSONArray();
        for (Group g : this.adminGroups) {
            arr.put((Object)new JSONObject().put(FIELD_ID, g.getID()).put(FIELD_NAME, (Object)g.getName()));
        }
        o.put(FIELD_ADMIN_GROUPS, (Object)arr);
        arr = new JSONArray();
        for (Group g : this.userGroups) {
            arr.put((Object)new JSONObject().put(FIELD_ID, g.getID()).put(FIELD_NAME, (Object)g.getName()));
        }
        o.put(FIELD_USER_GROUPS, (Object)arr);
        return o;
    }

    @Nonnull
    public String toString() {
        return this.name;
    }

    public static enum ScopeType {
        read,
        write,
        delete;

    }
}

