/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.data;

import de.kosmos_lab.kosmos.data.TimedListEntry;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import org.json.JSONArray;

public class TimedList {
    private final long timeout;
    private final LinkedList<TimedListEntry> entries;

    public TimedList(long timeout) {
        this.timeout = timeout;
        this.entries = new LinkedList();
    }

    public void addEntry(@Nonnull Object entry) {
        this.addEntry(entry, System.currentTimeMillis());
    }

    private void addEntry(@Nonnull Object entry, long time) {
        this.entries.add(new TimedListEntry<Object>(entry, time + this.timeout));
    }

    public void clear() {
        this.entries.clear();
    }

    @Nonnull
    public LinkedList<TimedListEntry> getEntries() {
        long now = System.currentTimeMillis();
        LinkedList<TimedListEntry> values = new LinkedList<TimedListEntry>();
        Iterator itr = this.entries.iterator();
        while (itr.hasNext()) {
            TimedListEntry e = (TimedListEntry)itr.next();
            if (e.validTo < now) {
                itr.remove();
                continue;
            }
            values.add((TimedListEntry)e.value);
        }
        return values;
    }

    @Nonnull
    public JSONArray toJSONArray() {
        JSONArray arr = new JSONArray();
        for (Object e : this.getEntries()) {
            arr.put(e);
        }
        return arr;
    }

    @Nonnull
    public Collection<String> toStringList() {
        LinkedList<String> list = new LinkedList<String>();
        for (Object e : this.getEntries()) {
            list.add(e.toString());
        }
        return list;
    }

    @Nonnull
    public String toString() {
        return this.toJSONArray().toString();
    }
}

