/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.platform.gesture.data;

import de.kosmos_lab.kosmos.platform.gesture.data.Point;
import de.kosmos_lab.kosmos.platform.gesture.utils.Geometry;
import de.kosmos_lab.utils.StringFunctions;
import javax.annotation.Nonnull;
import org.json.JSONArray;
import org.json.JSONObject;

public class Gesture {
    private static final int SAMPLING_RESOLUTION = 32;
    private static final int MAX_INT_COORDINATES = 1024;
    public static final int LUT_SIZE = 64;
    public static final int LUT_SCALE_FACTOR = 16;
    public final Point[] rawPoints;
    public final String Id;
    public Point[] points = null;
    public String name;
    public int[][] lookupTable = null;

    public Gesture(@Nonnull Point[] points, @Nonnull String gestureName, @Nonnull String id) {
        this(points, gestureName, true, id);
    }

    public Gesture(@Nonnull Point[] points) {
        this(points, "", true, StringFunctions.generateRandomKey((int)26));
    }

    public Gesture(@Nonnull Point[] points, @Nonnull String gestureName, boolean constructLUT, @Nonnull String id) {
        this.Id = id;
        this.name = gestureName;
        this.rawPoints = points;
        this.points = this.Scale(points);
        this.points = this.TranslateTo(this.points, this.Centroid(this.points));
        this.points = this.Resample(this.points, 32);
        if (constructLUT) {
            this.TransformCoordinatesToIntegers();
            this.ConstructLUT();
        }
    }

    private Point Centroid(@Nonnull Point[] points) {
        float cx = 0.0f;
        float cy = 0.0f;
        for (int i = 0; i < points.length; ++i) {
            cx += points[i].x;
            cy += points[i].y;
        }
        return new Point(cx / (float)points.length, cy / (float)points.length, 0);
    }

    private void ConstructLUT() {
        int i;
        this.lookupTable = new int[64][];
        for (i = 0; i < 64; ++i) {
            this.lookupTable[i] = new int[64];
        }
        for (i = 0; i < 64; ++i) {
            for (int j = 0; j < 64; ++j) {
                int minDistance = Integer.MAX_VALUE;
                int indexMin = -1;
                for (int t = 0; t < this.points.length; ++t) {
                    int row = this.points[t].lookupY / 16;
                    int col = this.points[t].lookupX / 16;
                    int dist = (row - i) * (row - i) + (col - j) * (col - j);
                    if (dist >= minDistance) continue;
                    minDistance = dist;
                    indexMin = t;
                }
                this.lookupTable[i][j] = indexMin;
            }
        }
    }

    private float PathLength(@Nonnull Point[] points) {
        float length = 0.0f;
        for (int i = 1; i < points.length; ++i) {
            if (points[i].stroke != points[i - 1].stroke) continue;
            length += Geometry.euclideanDistance(points[i - 1], points[i]);
        }
        return length;
    }

    @Nonnull
    public Point[] Resample(@Nonnull Point[] points, int n) {
        Point[] newPoints = new Point[n];
        newPoints[0] = new Point(points[0].x, points[0].y, points[0].stroke);
        int numPoints = 1;
        float I = this.PathLength(points) / (float)(n - 1);
        float D = 0.0f;
        for (int i = 1; i < points.length; ++i) {
            if (points[i].stroke != points[i - 1].stroke) continue;
            float d = Geometry.euclideanDistance(points[i - 1], points[i]);
            if (D + d >= I) {
                Point firstPoint = points[i - 1];
                while (D + d >= I) {
                    float t = Math.min(Math.max((I - D) / d, 0.0f), 1.0f);
                    if (Float.isNaN(t)) {
                        t = 0.5f;
                    }
                    newPoints[numPoints++] = new Point((1.0f - t) * firstPoint.x + t * points[i].x, (1.0f - t) * firstPoint.y + t * points[i].y, points[i].stroke);
                    d = D + d - I;
                    D = 0.0f;
                    firstPoint = newPoints[numPoints - 1];
                }
                D = d;
                continue;
            }
            D += d;
        }
        if (numPoints == n - 1) {
            newPoints[numPoints++] = new Point(points[points.length - 1].x, points[points.length - 1].y, points[points.length - 1].stroke);
        }
        return newPoints;
    }

    @Nonnull
    private Point[] Scale(@Nonnull Point[] points) {
        float minx = Float.MAX_VALUE;
        float miny = Float.MAX_VALUE;
        float maxx = -3.4028235E38f;
        float maxy = -3.4028235E38f;
        for (int i = 0; i < points.length; ++i) {
            if (minx > points[i].x) {
                minx = points[i].x;
            }
            if (miny > points[i].y) {
                miny = points[i].y;
            }
            if (maxx < points[i].x) {
                maxx = points[i].x;
            }
            if (!(maxy < points[i].y)) continue;
            maxy = points[i].y;
        }
        Point[] newPoints = new Point[points.length];
        float scale = Math.max(maxx - minx, maxy - miny);
        for (int i = 0; i < points.length; ++i) {
            newPoints[i] = new Point((points[i].x - minx) / scale, (points[i].y - miny) / scale, points[i].stroke);
        }
        return newPoints;
    }

    private void TransformCoordinatesToIntegers() {
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i].lookupX = (int)((this.points[i].x + 1.0f) / 2.0f * 1023.0f);
            this.points[i].lookupY = (int)((this.points[i].y + 1.0f) / 2.0f * 1023.0f);
        }
    }

    @Nonnull
    private Point[] TranslateTo(@Nonnull Point[] points, @Nonnull Point p) {
        Point[] newPoints = new Point[points.length];
        for (int i = 0; i < points.length; ++i) {
            newPoints[i] = new Point(points[i].x - p.x, points[i].y - p.y, points[i].stroke);
        }
        return newPoints;
    }

    @Nonnull
    public JSONArray pointsToJSON() {
        JSONArray points = new JSONArray();
        for (Point p : this.rawPoints) {
            points.put((Object)new JSONArray().put((double)p.x).put((double)p.y));
        }
        return points;
    }

    @Nonnull
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("name", (Object)this.name);
        json.put("points", (Object)this.pointsToJSON());
        return json;
    }
}

