/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.platform.persistence;

import de.dfki.baall.helper.persistence.exceptions.NotFoundInPersistenceException;
import de.kosmos_lab.kosmos.data.Device;
import de.kosmos_lab.kosmos.data.LogEntry;
import de.kosmos_lab.kosmos.platform.IController;
import de.kosmos_lab.kosmos.platform.persistence.IPersistence;
import de.kosmos_lab.utils.StringFunctions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.StringWriter;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC"})
public abstract class SQLPersistence
implements IPersistence {
    protected String url;
    protected LinkedList<Connection> connections;
    protected BigInteger numConnections;
    static final Logger logger = LoggerFactory.getLogger((String)"SQLPersistence");
    protected IController server;
    final Pattern noSuchTablePattern = Pattern.compile(".*\\(no such table: (.*)\\)");
    final Pattern tableExistsPattern = Pattern.compile(".*\\(table (.*) already exists\\)");

    public static Integer getInt(ResultSet rs, Integer index) {
        try {
            return rs.getInt(index);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Long getLong(ResultSet rs, Integer index) {
        try {
            return rs.getLong(index);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final int[] getInta2(IController server, ResultSet rs, boolean getData) {
        try {
            return new int[]{rs.getInt(1), rs.getInt(2)};
        }
        catch (SQLException e) {
            e.printStackTrace();
            return new int[]{0, 0};
        }
    }

    public static final int getInt(IController server, ResultSet rs, boolean getData) {
        try {
            return rs.getInt(1);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static final double getDouble(IController server, ResultSet rs, boolean getData) {
        try {
            return rs.getDouble(1);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public static final long getLong(IController server, ResultSet rs, boolean getData) {
        try {
            return rs.getLong(1);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static final Date getDate(IController server, ResultSet rs, boolean getData) {
        try {
            return rs.getDate(1);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Float parseNullFloat(Float v) {
        if (v.floatValue() == -1.0f) {
            return null;
        }
        return v;
    }

    protected void close(Connection conn) {
        try {
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.connections.remove(conn);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void clean(Statement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected int getConnections() {
        return this.connections.size();
    }

    protected abstract Connection connect(String var1);

    protected boolean checkException(SQLException ex, String query, Object[] params) {
        if (ex.getMessage().startsWith("Duplicate")) {
            return false;
        }
        if (ex.getMessage().contains("UNIQUE constraint failed")) {
            return false;
        }
        if (ex.getMessage().contains("already exists")) {
            return false;
        }
        if (ex.getMessage().contains("Connection is closed")) {
            return true;
        }
        if (ex.getMessage().contains("database is locked")) {
            return true;
        }
        Matcher m = this.tableExistsPattern.matcher(ex.getMessage());
        if (m.matches()) {
            return false;
        }
        m = this.noSuchTablePattern.matcher(ex.getMessage());
        if (m.matches()) {
            String table = m.group(1);
            logger.error("can not find table:" + table);
            this.createTable(table);
            return false;
        }
        if (ex.getMessage().contains("A NOT NULL constraint failed")) {
            logger.debug(ex.getMessage());
            return false;
        }
        if (ex.getMessage().contains("Data truncation:")) {
            logger.debug(ex.getMessage());
            return false;
        }
        if (query != null) {
            logger.error(SQLPersistence.fullPrint(query, params));
        }
        logger.error("SQLException", (Throwable)ex);
        return false;
    }

    protected abstract void createTable(String var1);

    protected String formatDate(Date p) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(p);
    }

    protected void fillStatement(PreparedStatement stmt, Object[] params) throws SQLException {
        int i = 0;
        block40: while (i < params.length) {
            Object p = params[i];
            if (p == null) {
                stmt.setNull(++i, 1111);
                continue;
            }
            if (p instanceof Integer) {
                stmt.setInt(++i, (Integer)p);
                continue;
            }
            if (p instanceof Long) {
                stmt.setLong(++i, (Long)p);
                continue;
            }
            if (p instanceof Float) {
                stmt.setFloat(++i, ((Float)p).floatValue());
                continue;
            }
            if (p instanceof Double) {
                stmt.setDouble(++i, (Double)p);
                continue;
            }
            if (p instanceof Byte) {
                stmt.setByte(++i, (Byte)p);
                continue;
            }
            if (p instanceof Short) {
                stmt.setShort(++i, (Short)p);
                continue;
            }
            if (p instanceof Date) {
                stmt.setString(++i, this.formatDate((Date)p));
                continue;
            }
            if (p instanceof Boolean) {
                stmt.setBoolean(++i, (Boolean)p);
                continue;
            }
            if (p instanceof JSONObject) {
                stmt.setString(++i, p.toString());
                continue;
            }
            if (p instanceof JSONArray) {
                stmt.setString(++i, p.toString());
                continue;
            }
            if (p instanceof NullTypes) {
                switch ((NullTypes)((Object)p)) {
                    case BIT: {
                        stmt.setNull(++i, -7);
                        continue block40;
                    }
                    case TINYINT: {
                        stmt.setNull(++i, -6);
                        continue block40;
                    }
                    case SMALLINT: {
                        stmt.setNull(++i, 5);
                        continue block40;
                    }
                    case INTEGER: {
                        stmt.setNull(++i, 4);
                        continue block40;
                    }
                    case BIGINT: {
                        stmt.setNull(++i, -5);
                        continue block40;
                    }
                    case FLOAT: {
                        stmt.setNull(++i, 6);
                        continue block40;
                    }
                    case REAL: {
                        stmt.setNull(++i, 7);
                        continue block40;
                    }
                    case DOUBLE: {
                        stmt.setNull(++i, 8);
                        continue block40;
                    }
                    case NUMERIC: {
                        stmt.setNull(++i, 2);
                        continue block40;
                    }
                    case DECIMAL: {
                        stmt.setNull(++i, 3);
                        continue block40;
                    }
                    case CHAR: {
                        stmt.setNull(++i, 1);
                        continue block40;
                    }
                    case VARCHAR: {
                        stmt.setNull(++i, 12);
                        continue block40;
                    }
                    case LONGVARCHAR: {
                        stmt.setNull(++i, -1);
                        continue block40;
                    }
                    case DATE: {
                        stmt.setNull(++i, 91);
                        continue block40;
                    }
                    case TIME: {
                        stmt.setNull(++i, 92);
                        continue block40;
                    }
                    case TIMESTAMP: {
                        stmt.setNull(++i, 93);
                        continue block40;
                    }
                    case BINARY: {
                        stmt.setNull(++i, -2);
                        continue block40;
                    }
                    case VARBINARY: {
                        stmt.setNull(++i, -3);
                        continue block40;
                    }
                    case LONGVARBINARY: {
                        stmt.setNull(++i, -4);
                        continue block40;
                    }
                    case NULL: {
                        stmt.setNull(++i, 0);
                        continue block40;
                    }
                    case JAVA_OBJECT: {
                        stmt.setNull(++i, 2000);
                        continue block40;
                    }
                    case DISTINCT: {
                        stmt.setNull(++i, 2001);
                        continue block40;
                    }
                    case STRUCT: {
                        stmt.setNull(++i, 2002);
                        continue block40;
                    }
                    case ARRAY: {
                        stmt.setNull(++i, 2003);
                        continue block40;
                    }
                    case BLOB: {
                        stmt.setNull(++i, 2004);
                        continue block40;
                    }
                    case CLOB: {
                        stmt.setNull(++i, 2005);
                        continue block40;
                    }
                    case REF: {
                        stmt.setNull(++i, 2006);
                        continue block40;
                    }
                    case DATALINK: {
                        stmt.setNull(++i, 70);
                        continue block40;
                    }
                    case BOOLEAN: {
                        stmt.setNull(++i, 16);
                        continue block40;
                    }
                    case ROWID: {
                        stmt.setNull(++i, -8);
                        continue block40;
                    }
                    case NCHAR: {
                        stmt.setNull(++i, -15);
                        continue block40;
                    }
                    case NVARCHAR: {
                        stmt.setNull(++i, -9);
                        continue block40;
                    }
                    case LONGNVARCHAR: {
                        stmt.setNull(++i, -16);
                        continue block40;
                    }
                    case NCLOB: {
                        stmt.setNull(++i, 2011);
                        continue block40;
                    }
                    case SQLXML: {
                        stmt.setNull(++i, 2009);
                        continue block40;
                    }
                    case REF_CURSOR: {
                        stmt.setNull(++i, 2012);
                        continue block40;
                    }
                    case TIME_WITH_TIMEZONE: {
                        stmt.setNull(++i, 2013);
                        continue block40;
                    }
                    case TIMESTAMP_WITH_TIMEZONE: {
                        stmt.setNull(++i, 2014);
                        continue block40;
                    }
                }
                stmt.setNull(++i, 1111);
                continue;
            }
            if (p instanceof String) {
                stmt.setString(++i, (String)p);
                continue;
            }
            if (p instanceof String[]) {
                stmt.setArray(++i, stmt.getConnection().createArrayOf("VARCHAR", (Object[])p));
                continue;
            }
            logger.info("could not fill for type {}", (Object)p.getClass().toString());
            stmt.setString(++i, p.toString());
        }
    }

    protected int doUpdate(String query) {
        return this.doUpdate(query, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    protected int doUpdate(String query, Object[] params) {
        Connection conn = this.connect(query);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int affected = 0;
        try {
            stmt = conn.prepareStatement(query);
            this.fillStatement(stmt, params);
            affected = stmt.executeUpdate();
        }
        catch (SQLException ex) {
            this.checkException(ex, query, params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.clean(stmt, rs);
            this.close(conn);
        }
        return affected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    protected <T> List<T> doSelect(String query, Object[] params, Function<T, IController, ResultSet, Boolean> parser, boolean fetchdata) {
        LinkedList<T> list;
        block8: {
            list = new LinkedList<T>();
            Connection conn = this.connect(query);
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = conn.prepareStatement(query);
                this.fillStatement(stmt, params);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    T t = parser.apply(this.server, rs, fetchdata);
                    if (t == null) continue;
                    list.add(t);
                }
                this.clean(stmt, rs);
                this.close(conn);
            }
            catch (SQLException ex) {
                this.checkException(ex, query, params);
                this.clean(stmt, rs);
                this.close(conn);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.clean(stmt, rs);
                this.close(conn);
            }
        }
        return list;
    }

    protected <T> List<T> doSelect(String query, Object[] params, Function<T, IController, ResultSet, Boolean> parser) {
        return this.doSelect(query, params, parser, true);
    }

    protected <T> T doSelectFirst(String query, Object[] params, Function<T, IController, ResultSet, Boolean> parser) throws NotFoundInPersistenceException {
        return this.doSelectFirst(query, params, parser, true);
    }

    protected int doSelectFirstAsInt(String query, Object[] params) throws NotFoundInPersistenceException {
        return this.doSelectFirst(query, params, SQLPersistence::getInt, true);
    }

    protected int[] doSelectFirst2AsInt(String query, Object[] params) throws NotFoundInPersistenceException {
        return this.doSelectFirst(query, params, SQLPersistence::getInta2, true);
    }

    protected double doSelectFirstAsDouble(String query, Object[] params) throws NotFoundInPersistenceException {
        return this.doSelectFirst(query, params, SQLPersistence::getDouble, true);
    }

    protected long doSelectFirstAsLong(String query, Object[] params) throws NotFoundInPersistenceException {
        return this.doSelectFirst(query, params, SQLPersistence::getLong, true);
    }

    protected Date doSelectFirstAsDate(String query, Object[] params) throws NotFoundInPersistenceException {
        return this.doSelectFirst(query, params, SQLPersistence::getDate, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    protected <T> T doSelectFirst(String query, Object[] params, Function<T, IController, ResultSet, Boolean> parser, boolean fetchdata) throws NotFoundInPersistenceException {
        Connection conn = this.connect(query);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int tries = 5;
        while (tries > 0) {
            block9: {
                T t;
                try {
                    stmt = conn.prepareStatement(query);
                    this.fillStatement(stmt, params);
                    rs = stmt.executeQuery();
                    if (!rs.next()) break block9;
                    t = parser.apply(this.server, rs, fetchdata);
                    this.clean(stmt, rs);
                    this.close(conn);
                }
                catch (SQLException ex) {
                    try {
                        if (!this.checkException(ex, query, params)) {
                            throw new NotFoundInPersistenceException(String.format("query:%s", SQLPersistence.fullPrint(query, params)));
                        }
                        if (--tries > 0) {
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        this.clean(stmt, rs);
                        this.close(conn);
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.clean(stmt, rs);
                        this.close(conn);
                        throw throwable;
                    }
                }
                return t;
            }
            this.clean(stmt, rs);
            this.close(conn);
        }
        throw new NotFoundInPersistenceException(String.format("query:%s", SQLPersistence.fullPrint(query, params)));
    }

    public abstract List<LogEntry> getStates(long var1, long var3);

    public abstract Collection<Device.Location> initLocations();

    public boolean parseBoolean(String value) {
        return value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1");
    }

    protected int doAddI(String query) {
        return this.doAddI(query, new Object[0]);
    }

    protected int doAddI(String query, Object param) {
        return this.doAddI(query, new Object[]{param});
    }

    protected int doAddI(String query, Object param1, Object param2) {
        return this.doAddI(query, new Object[]{param1, param2});
    }

    protected int doAddI(String query, Object param1, Object param2, Object param3) {
        return this.doAddI(query, new Object[]{param1, param2, param3});
    }

    protected int doAddI(String query, Object param1, Object param2, Object param3, Object param4) {
        return this.doAddI(query, new Object[]{param1, param2, param3, param4});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    protected int doAddI(String query, Object[] params) {
        int id;
        block8: {
            Connection conn = this.connect(query);
            PreparedStatement stmt = null;
            ResultSet rs = null;
            id = 0;
            try {
                stmt = conn.prepareStatement(query, 1);
                this.fillStatement(stmt, params);
                stmt.executeUpdate();
                rs = stmt.getGeneratedKeys();
                if (rs.next()) {
                    id = rs.getInt(1);
                }
                this.clean(stmt, rs);
                this.close(conn);
            }
            catch (SQLException ex) {
                this.checkException(ex, query, params);
            }
            catch (Exception e) {
                logger.debug("error", (Throwable)e);
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.clean(stmt, rs);
                this.close(conn);
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    protected short doAddS(String query, Object[] params) {
        short id;
        block8: {
            Connection conn = this.connect(query);
            PreparedStatement stmt = null;
            ResultSet rs = null;
            id = 0;
            try {
                stmt = conn.prepareStatement(query, 1);
                this.fillStatement(stmt, params);
                stmt.executeUpdate();
                rs = stmt.getGeneratedKeys();
                if (rs.next()) {
                    id = rs.getShort(1);
                }
                this.clean(stmt, rs);
                this.close(conn);
            }
            catch (SQLException ex) {
                this.checkException(ex, query, params);
            }
            catch (Exception e) {
                logger.debug("error", (Throwable)e);
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.clean(stmt, rs);
                this.close(conn);
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    protected byte doAddB(String query, Object[] params) {
        byte id;
        block8: {
            Connection conn = this.connect(query);
            PreparedStatement stmt = null;
            ResultSet rs = null;
            id = 0;
            try {
                stmt = conn.prepareStatement(query, 1);
                this.fillStatement(stmt, params);
                stmt.executeUpdate();
                rs = stmt.getGeneratedKeys();
                if (rs.next()) {
                    id = rs.getByte(1);
                }
                this.clean(stmt, rs);
                this.close(conn);
            }
            catch (SQLException ex) {
                this.checkException(ex, query, params);
            }
            catch (Exception e) {
                logger.debug("error", (Throwable)e);
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.clean(stmt, rs);
                this.close(conn);
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    protected int doAdd(String query, Object[] params) {
        Connection conn = this.connect(query);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int affected = 0;
        try {
            stmt = conn.prepareStatement(query);
            this.fillStatement(stmt, params);
            affected = stmt.executeUpdate();
        }
        catch (SQLException ex) {
            this.checkException(ex, query, params);
        }
        catch (Exception e) {
            logger.debug("error", (Throwable)e);
        }
        finally {
            this.clean(stmt, rs);
            this.close(conn);
        }
        return affected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    protected int doAddBatch(String query, Collection<Object[]> params) {
        Connection conn = this.connect(query);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int affected = 0;
        try {
            int[] aff;
            stmt = conn.prepareStatement(query);
            for (Object[] p : params) {
                try {
                    this.fillStatement(stmt, p);
                    stmt.addBatch();
                }
                catch (SQLException ex) {
                    this.checkException(ex, query, p);
                }
            }
            for (int i : aff = stmt.executeBatch()) {
                affected += i;
            }
        }
        catch (SQLException ex) {
            this.checkException(ex, query, new Object[0]);
        }
        catch (Exception e) {
            logger.debug("error", (Throwable)e);
        }
        finally {
            this.clean(stmt, rs);
            this.close(conn);
        }
        return affected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    protected int doUpdateBatch(String query, Collection<Object[]> params) {
        Connection conn = this.connect(query);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int affected = 0;
        try {
            int[] aff;
            stmt = conn.prepareStatement(query);
            for (Object[] p : params) {
                try {
                    this.fillStatement(stmt, p);
                    stmt.addBatch();
                }
                catch (SQLException ex) {
                    this.checkException(ex, query, p);
                }
            }
            for (int i : aff = stmt.executeBatch()) {
                affected += i;
            }
        }
        catch (SQLException ex) {
            this.checkException(ex, query, new Object[0]);
        }
        catch (Exception e) {
            logger.debug("error", (Throwable)e);
        }
        finally {
            this.clean(stmt, rs);
            this.close(conn);
        }
        return affected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    protected long doAddL(String query, Object[] params) {
        long id;
        block8: {
            Connection conn = this.connect(query);
            PreparedStatement stmt = null;
            ResultSet rs = null;
            id = 0L;
            try {
                stmt = conn.prepareStatement(query, 1);
                this.fillStatement(stmt, params);
                stmt.executeUpdate();
                rs = stmt.getGeneratedKeys();
                if (rs.next()) {
                    id = rs.getLong(1);
                }
                this.clean(stmt, rs);
                this.close(conn);
            }
            catch (SQLException ex) {
                this.checkException(ex, query, params);
            }
            catch (Exception e) {
                logger.debug("error", (Throwable)e);
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.clean(stmt, rs);
                this.close(conn);
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        Connection conn = this.connect("#truncate all");
        Statement stmt = null;
        ResultSet rs = null;
        LinkedList<String> tables = new LinkedList<String>();
        try {
            DatabaseMetaData md = conn.getMetaData();
            rs = md.getTables(null, null, "%", null);
            while (rs.next()) {
                tables.add(rs.getString("TABLE_NAME"));
            }
            if (tables.size() > 0) {
                for (String t : tables) {
                    this.doUpdate("DELETE FROM `" + t + "`;");
                }
            }
            this.clean(stmt, rs);
            this.close(conn);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.clean(stmt, rs);
            this.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table describeTable(String table) {
        LinkedHashSet<Column> cols = new LinkedHashSet<Column>();
        HashMap<String, Index> indexMap = new HashMap<String, Index>();
        LinkedHashSet<Index> index = new LinkedHashSet<Index>();
        HashMap<String, Column> colMap = new HashMap<String, Column>();
        Connection conn = this.connect("describeTable");
        ResultSet rs = null;
        ResultSet rs2 = null;
        try {
            DatabaseMetaData dbmeta = conn.getMetaData();
            rs = dbmeta.getColumns(null, null, table, null);
            StringWriter sb = new StringWriter();
            while (rs.next()) {
                logger.info("----------------------------");
                ResultSetMetaData meta = rs.getMetaData();
                int columnCount = meta.getColumnCount();
                for (int column = 1; column <= columnCount; ++column) {
                    Object value = rs.getObject(column);
                    logger.info("{} : {}", (Object)meta.getColumnName(column), value);
                }
                try {
                    Column c = new Column(rs.getString("COLUMN_NAME"), this.parseBoolean(rs.getString("IS_AUTOINCREMENT")), rs.getInt("DATA_TYPE"), this.parseBoolean(rs.getString("IS_NULLABLE")), 0);
                    if (cols.contains(c) || colMap.containsKey(c.name)) continue;
                    cols.add(c);
                    colMap.put(c.name, c);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            logger.info(sb.toString());
            rs2 = dbmeta.getIndexInfo(null, null, table, false, false);
            while (rs2.next()) {
                Column c = (Column)colMap.get(rs2.getString("COLUMN_NAME"));
                c.index = true;
                Index ind = (Index)indexMap.get(rs2.getString("INDEX_NAME"));
                if (ind == null) {
                    ind = new Index(rs2.getString("INDEX_NAME"));
                    indexMap.put(ind.name, ind);
                    index.add(ind);
                }
                ind.unique = !rs2.getBoolean("NON_UNIQUE");
                ind.addColumn(c);
            }
            this.clean(null, rs);
            this.clean(null, rs2);
            this.close(conn);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.clean(null, rs);
            this.clean(null, rs2);
            this.close(conn);
        }
        return new Table(table, cols, index);
    }

    public String createSQL(Table t) {
        StringBuffer sb = new StringBuffer();
        StringBuffer f = new StringBuffer();
        String fields = "";
        StringBuffer ins = new StringBuffer();
        String insert = "";
        StringBuffer ins2 = new StringBuffer();
        sb.append("\t\t\t /**\n\t * this class is automatically generated from the actual SQL database scheme of the table `" + t.name + "` and will be manually adapted by new queries and the parse method.\n\t */\npublic static class SQL {\n\t\t// {{ begin autogenerated code from SQL\n\t\tpublic class Field {\n");
        StringBuffer selects = new StringBuffer();
        StringBuffer getter = new StringBuffer();
        StringBuffer indexes = new StringBuffer();
        StringBuffer deletes = new StringBuffer();
        StringBuffer updates = new StringBuffer();
        StringBuffer removes = new StringBuffer();
        int index = 1;
        for (Column col : t.getCols()) {
            String c = col.name;
            String cc = StringFunctions.toCamelCase((String)c);
            String field = "Field." + c;
            sb.append("\t\t\tpublic static final String " + c + " = \"`" + c + "`\";\n");
            f.append(field + "+\",\"+");
            if (!col.increment) {
                ins.append(field + "+\",\"+");
                ins2.append("?,");
            }
            if (col.type == 4) {
                if (col.nullable) {
                    getter.append("\t\t\tpublic static Integer " + cc + " (ResultSet rs) throws SQLException {\n").append("\t\t\t\tint v = rs.getInt(Index." + cc + ");\n").append("\t\t\t\tif ( rs.wasNull()) \n").append("\t\t\t\t{\n").append("\t\t\t\t\treturn null;\n").append("\t\t\t\t}\n").append("\t\t\t\treturn v;\n").append("\t\t\t}\n");
                } else {
                    getter.append("\t\t\tpublic static int " + cc + " (ResultSet rs) throws SQLException {\n\t\t\t\treturn rs.getInt(Index." + cc + ");\n\t\t\t}\n");
                }
            } else if (col.type == 6 || col.type == 7) {
                if (col.nullable) {
                    getter.append("\t\t\tpublic static Float " + cc + " (ResultSet rs) throws SQLException {\n").append("\t\t\t\tfloat v = rs.getFloat(Index." + cc + ");\n").append("\t\t\t\tif ( rs.wasNull()) \n").append("\t\t\t\t{\n").append("\t\t\t\t\treturn null;\n").append("\t\t\t\t}\n\t\t\t\treturn v;\n\t\t\t}\n");
                } else {
                    getter.append("\t\t\tpublic static float " + cc + " (ResultSet rs) throws SQLException {\n\t\t\t\treturn rs.getFloat(Index." + cc + ");\n\t\t\t}\n");
                }
            } else if (col.type == 5) {
                if (col.nullable) {
                    getter.append("\t\t\tpublic static Short " + cc + " (ResultSet rs) throws SQLException {\n").append("\t\t\t\tshort v = rs.getShort(Index." + cc + ");\n").append("\t\t\t\tif ( rs.wasNull()) \n").append("\t\t\t\t{\n").append("\t\t\t\t\treturn null;\n").append("\t\t\t\t}\n").append("\t\t\t\treturn v;\n").append("\t\t\t}\n");
                } else {
                    getter.append("\t\t\tpublic static short " + cc + " (ResultSet rs) throws SQLException {\n\t\t\t\treturn rs.getShort(Index." + cc + ");\n\t\t\t}\n");
                }
            } else if (col.type == -6) {
                if (col.nullable) {
                    getter.append("\t\t\tpublic static Byte " + cc + " (ResultSet rs) throws SQLException {\n").append("\t\t\t\tbyte v = rs.getByte(Index." + cc + ");\n").append("\t\t\t\tif ( rs.wasNull()) \n").append("\t\t\t\t{\n").append("\t\t\t\t\treturn null;\n").append("\t\t\t\t}\n").append("\t\t\t\treturn v;\n").append("\t\t\t}\n");
                } else {
                    getter.append("\t\t\tpublic static byte " + cc + " (ResultSet rs) throws SQLException {\n\t\t\t\treturn rs.getByte(Index." + cc + ");\n\t\t\t}\n");
                }
            } else if (col.type == 91) {
                if (col.nullable) {
                    getter.append("\t\t\tpublic static java.util.Date " + cc + " (ResultSet rs) throws SQLException {\n").append("\t\t\t\tjava.util.Date v = rs.getDate(Index." + cc + ");\n").append("\t\t\t\tif ( rs.wasNull()) \n").append("\t\t\t\t{\n").append("\t\t\t\t\treturn null;\n").append("\t\t\t\t}\n").append("\t\t\t\treturn v;\n").append("\t\t\t}\n");
                } else {
                    getter.append("\t\t\tpublic static java.util.Date " + cc + " (ResultSet rs) throws SQLException {\n\t\t\t\treturn rs.getDate(Index." + cc + ");\n\t\t\t}\n");
                }
            } else if (col.type == 93) {
                if (col.nullable) {
                    getter.append("\t\t\tpublic static java.util.Date " + cc + " (ResultSet rs) throws SQLException {\n").append("\t\t\t\tfinal Timestamp ts = rs.getTimestamp(Index." + cc + ");\n").append("\t\t\t\tif ( rs.wasNull()) \n").append("\t\t\t\t{\n").append("\t\t\t\t\treturn null;\n").append("\t\t\t\t}\n").append("\t\t\t\treturn new java.util.Date(ts.getTime());\n").append("\t\t\t}\n");
                } else {
                    getter.append("\t\t\tpublic static java.util.Date " + cc + " (ResultSet rs) throws SQLException {\n\t\t\t\treturn new java.util.Date(rs.getTimestamp(Index." + cc + ").getTime());\n\t\t\t}\n");
                }
            } else if (col.type == -5) {
                if (col.nullable) {
                    getter.append("\t\t\tpublic static Long " + cc + " (ResultSet rs) throws SQLException {\n").append("\t\t\t\tlong v = rs.getLong(Index." + cc + ");\n").append("\t\t\t\tif ( rs.wasNull()) \n").append("\t\t\t\t{\n").append("\t\t\t\t\treturn null;\n").append("\t\t\t\t}\n").append("\t\t\t\treturn v;\n").append("\t\t\t}\n");
                } else {
                    getter.append("\t\t\tpublic static long " + cc + " (ResultSet rs) throws SQLException {\n\t\t\t\treturn rs.getLong(Index." + cc + ");\n\t\t\t}\n");
                }
            } else if (col.type == 16 || col.type == -7) {
                if (col.nullable) {
                    getter.append("\t\t\tpublic static Boolean " + cc + " (ResultSet rs) throws SQLException {\n").append("\t\t\t\tboolean v = rs.getBoolean(Index." + cc + ");\n").append("\t\t\t\tif ( rs.wasNull()) \n").append("\t\t\t\t{\n").append("\t\t\t\t\treturn null;\n").append("\t\t\t\t}\n").append("\t\t\t\treturn v;\n").append("\t\t\t}\n");
                } else {
                    getter.append("\t\t\tpublic static boolean " + cc + " (ResultSet rs) throws SQLException {\n\t\t\t\treturn rs.getBoolean(Index." + cc + ");\n\t\t\t}\n");
                }
            } else if (col.type == 1 || col.type == 12 || col.type == -1) {
                getter.append("\t\t\tpublic static String " + cc + " (ResultSet rs) throws SQLException {\n\t\t\t\treturn rs.getString(Index." + cc + ");\n\t\t\t}\n");
            } else {
                logger.warn("cannot find type: {} for {}", (Object)col.type, (Object)col.name);
            }
            indexes.append("\t\t\tpublic static final int " + cc + " = " + index++ + ";\n");
        }
        HashSet<Column> nonUniqueCols = new HashSet<Column>();
        HashSet<Column> uniqueCols = new HashSet<Column>();
        for (Index i : t.getIndex()) {
            StringBuffer iFields = new StringBuffer();
            StringBuffer iName = new StringBuffer();
            if (i.columns.size() <= 0) continue;
            if (i.unique) {
                for (Column col : t.getCols()) {
                    for (Column icol : i.columns) {
                        if (!icol.equals(col) && !icol.name.equals(col.name)) {
                            nonUniqueCols.add(col);
                            continue;
                        }
                        uniqueCols.add(col);
                    }
                }
            }
            for (Column col : i.columns) {
                String c = col.name;
                String cc = StringFunctions.toCamelCase((String)c);
                String field = "Field." + c;
                iFields.append("\"+" + field + "+\"=? AND ");
                iName.append(cc);
                iName.append("And");
            }
            String field = iFields.toString();
            field = field.substring(0, field.length() - 4).trim();
            String name = iName.toString();
            name = name.substring(0, name.length() - 3);
            selects.append("\t\tpublic final static String selectBy" + name + " =\"select \"+fields+\" from \"+table+\" where " + field + "\";\n");
            deletes.append("\t\tpublic final static String deleteBy" + name + " =\"delete from \"+table+\"  where " + field + "\";\n");
            for (Column col2 : t.getCols()) {
                String c2 = col2.name;
                String cc2 = StringFunctions.toCamelCase((String)c2);
                String field2 = "Field." + c2;
                updates.append("\t\tpublic final static String update" + cc2 + "By" + name + " =\"update \"+table+\" set \"+" + field2 + "+\"=? where " + field + "\";\n");
                if (!col2.nullable) continue;
                removes.append("\t\tpublic final static String remove" + cc2 + "By" + name + " =\"update \"+table+\" set \"+" + field2 + "+\"=NULL where " + field + "\";\n");
            }
        }
        sb.append("\t\t}\n");
        sb.append("\t\tpublic static class Getter {\n");
        sb.append(getter);
        sb.append("\t\t}\n");
        sb.append("\t\tpublic static class Index {\n");
        sb.append(indexes);
        sb.append("\t\t}\n");
        sb.append("\t\tpublic final static String table = \"`" + t.name + "`\";\n");
        if (f.length() > 2) {
            fields = f.substring(0, f.length() - 5);
            sb.append("\t\tpublic final static String fields =" + fields + ";\n");
        }
        sb.append("\t\tpublic final static String selectAll =\"select \"+fields+\" from \"+table;\n");
        sb.append(selects);
        sb.append(deletes);
        sb.append(updates);
        sb.append(removes);
        if (ins.length() > 2) {
            insert = ins.substring(0, ins.length() - 3);
            sb.append("\t\tpublic final static String add =\"insert into \"+table+\" (\"+" + insert + ") values (" + ins2.substring(0, ins2.length() - 1) + ")\";\n");
            if (nonUniqueCols.size() > 0) {
                sb.append("\t\tpublic final static String addOrUpdate =\"insert into \"+table+\" (\"+" + insert + ") values (" + ins2.substring(0, ins2.length() - 1) + ") ON DUPLICATE KEY UPDATE ");
                for (Column col : nonUniqueCols) {
                    sb.append("\"+Field." + col.name + "+\"=VALUES(\"+Field." + col.name + "+\"), ");
                }
                sb.deleteCharAt(sb.length() - 2);
                sb.append("\";\n");
                Iterator<Index> iterator = uniqueCols.iterator();
                if (iterator.hasNext()) {
                    Column ucol = (Column)((Object)iterator.next());
                    sb.append("\t\tpublic final static String update =\" UPDATE \"+table+\" set ");
                    for (Column col : nonUniqueCols) {
                        sb.append("\"+Field." + col.name + "+\"=?, ");
                    }
                    sb.deleteCharAt(sb.length() - 2);
                    sb.append("WHERE \"+Field." + ucol.name + "+\"=?");
                    sb.append("\";\n");
                }
            }
        }
        sb.append("\t\t// }} end autogenerated code\n");
        sb.append("\t\tpublic final static Object parse(IController controller, ResultSet rs, boolean getData)\n\t\t{\n\t\t\ttry\n\t\t\t{\n\t\t\t\t\n\t\t\t\t\n\t\t\t}\n\t\t\tcatch (Exception e)\n\t\t\t{\n\t\t\t\te.printStackTrace();\n\t\t\t}\n\t\t\treturn null;\n\t\t}\n");
        sb.append("\t\t// {{ custom queries not generated:\n\t\t\n");
        sb.append("\t\t// }} \n");
        sb.append("\t}");
        return sb.toString();
    }

    public String createSQL(String table) {
        return this.createSQL(this.describeTable(table));
    }

    public static String fullPrint(String query, Object[] params) {
        for (int i = 0; i < params.length; ++i) {
            try {
                Object p = params[i];
                if (p == null || query.indexOf(63) <= -1) continue;
                query = query.replaceFirst("\\?", p.toString());
                continue;
            }
            catch (Exception exx) {
                logger.error("could not get full query! for {} ", (Object)query, (Object)exx);
            }
        }
        return query;
    }

    public static String print(Object[] params) {
        StringBuilder sb = new StringBuilder();
        for (Object o : params) {
            sb.append(o);
            sb.append(",");
        }
        String str = sb.toString();
        if (str.length() > 0) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    public class Table {
        public Collection<Column> columns;
        public Collection<Index> indexes;
        public String name;

        public Table(String name, Collection<Column> columns, Collection<Index> indexes) {
            this.name = name;
            this.columns = columns;
            this.indexes = indexes;
        }

        public Collection<Column> getCols() {
            return this.columns;
        }

        public Collection<Index> getIndex() {
            return this.indexes;
        }
    }

    public class Index {
        public String name;
        public List<Column> columns;
        public boolean unique;

        public Index(String name) {
            this.name = name;
            this.columns = new LinkedList<Column>();
        }

        public void addColumn(Column c) {
            this.columns.add(c);
        }
    }

    public class Column {
        public int type;
        public boolean nullable;
        public int len;
        public String name;
        public boolean index = false;
        public boolean increment = false;

        public Column(String name, boolean autoincr, int type, boolean nullable, int len) {
            this.name = name;
            this.increment = autoincr;
            this.type = type;
            this.nullable = nullable;
            this.len = len;
        }

        public boolean equals(Column c) {
            return c.name.equalsIgnoreCase(this.name);
        }

        public boolean equals(Object c) {
            if (c instanceof Column) {
                return ((Column)c).name.equalsIgnoreCase(this.name);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.type, this.nullable, this.len, this.name, this.index, this.increment);
        }
    }

    @FunctionalInterface
    static interface Function<One, Two, Three, Four> {
        public One apply(Two var1, Three var2, Four var3);
    }

    protected static enum NullTypes {
        BIT,
        TINYINT,
        SMALLINT,
        INTEGER,
        BIGINT,
        FLOAT,
        REAL,
        DOUBLE,
        NUMERIC,
        DECIMAL,
        CHAR,
        VARCHAR,
        LONGVARCHAR,
        DATE,
        TIME,
        TIMESTAMP,
        BINARY,
        VARBINARY,
        LONGVARBINARY,
        NULL,
        OTHER,
        JAVA_OBJECT,
        DISTINCT,
        STRUCT,
        ARRAY,
        BLOB,
        CLOB,
        REF,
        DATALINK,
        BOOLEAN,
        ROWID,
        NCHAR,
        NVARCHAR,
        LONGNVARCHAR,
        NCLOB,
        SQLXML,
        REF_CURSOR,
        TIME_WITH_TIMEZONE,
        TIMESTAMP_WITH_TIMEZONE;

    }
}

