/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.platform.rules;

import de.dfki.baall.helper.webserver.JWT;
import de.dfki.baall.helper.webserver.data.IUser;
import de.kosmos_lab.kosmos.exceptions.UserNotFoundException;
import de.kosmos_lab.kosmos.platform.IController;
import de.kosmos_lab.kosmos.platform.rules.RulesExecuter;
import de.kosmos_lab.kosmos.platform.web.WebSocketService;
import de.kosmos_lab.utils.KosmosFileUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.websocket.server.ServerEndpoint;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerEndpoint(value="/kreews")
@WebSocket
public class RulesService
extends WebSocketService {
    private static final Logger logger = LoggerFactory.getLogger((String)"RulesService");
    private final HashMap<Session, IUser> webSocketClients = new HashMap();
    private final IController controller;
    private final HashMap<IUser, RulesExecuter> executors = new HashMap();
    private final String ruleDirectory;
    private final File ruleDirectoryFile;
    private final HashMap<Session, IUser> logins = new HashMap();

    public RulesService(IController controller) {
        this(controller, "rules");
    }

    @SuppressFBWarnings(value={"DM_EXIT"})
    public RulesService(@Nonnull IController controller, @Nonnull String dir) {
        File[] files;
        logger.info("started RulesService");
        this.controller = controller;
        this.ruleDirectory = dir + "/rules/";
        this.ruleDirectoryFile = new File(this.ruleDirectory);
        if (!this.ruleDirectoryFile.exists() && !this.ruleDirectoryFile.mkdirs()) {
            logger.warn("could not create gesture folder \"{}\" - exiting", (Object)this.ruleDirectoryFile);
            System.exit(1);
        }
        if (!controller.currentlyInTesting() && (files = this.ruleDirectoryFile.listFiles()) != null) {
            for (File f : files) {
                if (!f.getName().endsWith(".py")) continue;
                try {
                    logger.info("found Rule: {}", (Object)f.getName());
                    String uid = f.getName();
                    uid = uid.substring(0, uid.length() - 3);
                    try {
                        IUser u = controller.getUser(Integer.parseInt(uid));
                        this.startExecutor(u);
                    }
                    catch (UserNotFoundException userNotFoundException) {}
                }
                catch (Exception e) {
                    logger.error("exception: ", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OnWebSocketConnect
    public void addWebSocketClient(@Nonnull Session sess) {
        HashMap<Session, IUser> hashMap = this.webSocketClients;
        synchronized (hashMap) {
            this.webSocketClients.put(sess, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastToUser(@Nonnull IUser user, @Nonnull String text) {
        HashMap<Session, IUser> hashMap = this.webSocketClients;
        synchronized (hashMap) {
            for (Map.Entry<Session, IUser> entry : this.webSocketClients.entrySet()) {
                if (user != entry.getValue()) continue;
                try {
                    entry.getKey().getRemote().sendString(text);
                }
                catch (EofException eofException) {
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delWebSocketClient(@Nonnull Session sess) {
        HashMap<Session, IUser> hashMap = this.webSocketClients;
        synchronized (hashMap) {
            this.webSocketClients.remove(sess);
        }
    }

    @Nonnull
    public String getName(@Nonnull IUser user) {
        return this.ruleDirectory + user.getUUID().getLeastSignificantBits();
    }

    @Nonnull
    public File getRuleDir() {
        return this.ruleDirectoryFile;
    }

    @Nonnull
    public String getRuleDirString() {
        return this.ruleDirectory;
    }

    @CheckForNull
    public String getXML(@Nonnull IUser user) {
        File file = new File(this.getName(user) + ".xml");
        if (file.exists()) {
            return KosmosFileUtils.readFile((File)file);
        }
        return null;
    }

    public void newLogMessage(@Nonnull IUser user, @Nonnull String line) {
        logger.info("new log for {}: {}", (Object)user.getUUID().getLeastSignificantBits(), (Object)line);
        this.broadcastToUser(user, new JSONObject().put("type", (Object)"log").put("value", (Object)line).toString());
    }

    @Override
    @OnWebSocketMessage
    public void onWebSocketMessage(@Nonnull Session sess, @Nonnull String message) {
        if (message.equalsIgnoreCase("ping")) {
            try {
                sess.getRemote().sendString("pong");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        if (message.startsWith("user/auth:")) {
            try {
                JSONObject j = new JSONObject(message.substring(10).trim());
                IUser u = this.controller.tryLogin(j.getString("user"), j.getString("pass"));
                if (u != null) {
                    this.webSocketClients.put(sess, u);
                    this.logins.put(sess, u);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return;
        }
        if (message.startsWith("Bearer ")) {
            message = message.substring(6).trim();
            try {
                JSONObject s = this.controller.getJwt().verify(message);
                IUser u = this.controller.getUser(s.getString("name"));
                if (u != null) {
                    this.webSocketClients.put(sess, u);
                    this.logins.put(sess, u);
                    try {
                        sess.getRemote().sendString("auth successful");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        sess.getRemote().sendString("auth failed");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (InvalidKeyException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (JWT.JWTVerifyFailed jwtVerifyFailed) {
                jwtVerifyFailed.printStackTrace();
            }
            return;
        }
    }

    public void savePython(@Nonnull IUser user, @Nonnull String code) {
        KosmosFileUtils.writeToFile((File)new File(this.getName(user) + ".py"), (String)code);
        if (!this.controller.currentlyInTesting()) {
            this.restartExecutor(user);
        }
    }

    public void saveXML(@Nonnull IUser user, @Nonnull String xml) {
        KosmosFileUtils.writeToFile((File)new File(this.getName(user) + ".xml"), (String)xml);
    }

    private void startExecutor(@Nonnull IUser user) {
        if (!this.controller.currentlyInTesting()) {
            RulesExecuter re = new RulesExecuter(this, user);
            this.executors.put(user, re);
            re.start();
        }
    }

    public void restartExecutor(@Nonnull IUser user) {
        RulesExecuter re = this.executors.get(user);
        if (re != null) {
            re.restart();
        } else {
            re = new RulesExecuter(this, user);
            this.executors.put(user, re);
            re.start();
        }
    }

    public void restartAllExecutors() {
        for (RulesExecuter re : this.executors.values()) {
            if (re == null) continue;
            re.restart();
        }
    }
}

