/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.platform.smarthome;

import de.kosmos_lab.kosmos.data.Device;
import java.awt.Color;
import java.util.Collections;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyTranslator {
    protected static final Logger logger = LoggerFactory.getLogger((String)"PropertyTranslator");

    public static boolean transform(Device device, JSONObject json, Set<String> keys) {
        for (String key : keys) {
            float[] hsv;
            logger.trace("transforming key {}", (Object)key);
            if (json.has("rgb_color")) {
                Object arr = json.get("rgb_color");
                if (!(arr instanceof JSONArray)) continue;
                json.put("r", ((JSONArray)arr).getInt(0));
                json.put("g", ((JSONArray)arr).getInt(1));
                json.put("b", ((JSONArray)arr).getInt(2));
                json.remove("rgb_color");
                PropertyTranslator.transform(device, json, Collections.singleton("r"));
                continue;
            }
            if (key.equalsIgnoreCase("brightness")) {
                JSONObject color;
                if (device.canHave("dimmingLevel", false)) {
                    json.put("dimmingLevel", (int)(json.optDouble("brightness", 255.0) / 2.55));
                    json.remove("brightness");
                    continue;
                }
                if (!device.has("color") || !(color = device.optJSONObject("color")).has("r") || !color.has("g") || !color.has("b")) continue;
                color.put("r", color.getInt("r") * device.getInt("brightness") / 255);
                color.put("g", color.getInt("g") * device.getInt("brightness") / 255);
                color.put("b", color.getInt("b") * device.getInt("brightness") / 255);
                continue;
            }
            if (key.equalsIgnoreCase("red")) {
                if (!json.has("green") || !json.has("blue")) continue;
                if (device.canHave("hue", false) && device.canHave("saturation", false)) {
                    hsv = new float[3];
                    Color.RGBtoHSB(json.getInt("red"), json.getInt("green"), json.getInt("blue"), hsv);
                    json.remove("red");
                    json.remove("green");
                    json.remove("blue");
                    json.put("hue", (double)(hsv[0] * 360.0f));
                    json.put("saturation", (double)(hsv[1] * 100.0f));
                    json.put("brightness", (double)(hsv[2] * 255.0f));
                    PropertyTranslator.transform(device, json, Collections.singleton("brightness"));
                    continue;
                }
                hsv = new float[3];
                Color.RGBtoHSB(json.getInt("red"), json.getInt("green"), json.getInt("blue"), hsv);
                json.remove("red");
                json.remove("green");
                json.remove("blue");
                json.put("hs_color", (Object)new JSONArray().put((double)(hsv[0] * 360.0f)).put((double)(hsv[1] * 100.0f)));
                json.put("brightness", (double)(hsv[2] * 255.0f));
                PropertyTranslator.transform(device, json, Collections.singleton("brightness"));
                continue;
            }
            if (!key.equalsIgnoreCase("r") || !json.has("g") || !json.has("b")) continue;
            if (device.canHave("color", false)) {
                json.put("color", (Object)new JSONObject().put("r", json.getInt("r")).put("g", json.getInt("g")).put("b", json.getInt("b")));
                json.remove("r");
                json.remove("g");
                json.remove("b");
                PropertyTranslator.transform(device, json, Collections.singleton("brightness"));
                continue;
            }
            if (device.canHave("hue", false) && device.canHave("saturation", false)) {
                hsv = new float[3];
                Color.RGBtoHSB(json.getInt("r"), json.getInt("g"), json.getInt("b"), hsv);
                json.remove("r");
                json.remove("g");
                json.remove("b");
                json.put("hue", (double)(hsv[0] * 360.0f));
                json.put("saturation", (double)(hsv[1] * 100.0f));
                json.put("brightness", (double)(hsv[2] * 255.0f));
                PropertyTranslator.transform(device, json, Collections.singleton("brightness"));
                continue;
            }
            hsv = new float[3];
            Color.RGBtoHSB(json.getInt("r"), json.getInt("g"), json.getInt("b"), hsv);
            json.remove("r");
            json.remove("g");
            json.remove("b");
            json.put("hs_color", (Object)new JSONArray().put((double)(hsv[0] * 360.0f)).put((double)(hsv[1] * 100.0f)));
            PropertyTranslator.transform(device, json, Collections.singleton("brightness"));
        }
        return false;
    }
}

