/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.platform.utils;

import de.kosmos_lab.kosmos.data.DataSchema;
import de.kosmos_lab.kosmos.exceptions.NotObjectSchemaException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.json.JSONObject;
import org.json.JSONTokener;

public class DataFactory {
    private static boolean allRead = false;
    private static final HashMap<String, DataSchema> cache = new HashMap();

    public static DataSchema getSchema(File f) throws NotObjectSchemaException {
        if (f.exists()) {
            try {
                JSONObject json = new JSONObject(new JSONTokener((Reader)new FileReader(f, StandardCharsets.UTF_8)));
                DataSchema schema = new DataSchema(json);
                if (json.has("$id")) {
                    cache.put(json.getString("$id"), schema);
                }
                try {
                    cache.put(f.getCanonicalPath(), schema);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return schema;
            }
            catch (FileNotFoundException json) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static DataSchema getSchema(String name) throws NotObjectSchemaException {
        File f;
        DataSchema schema = cache.get(name);
        if (schema == null && (schema = DataFactory.getSchema(f = !name.endsWith(".json") ? new File("schema/" + new File(name).getName() + ".json") : new File("schema/" + new File(name).getName()))) == null && !allRead) {
            File[] filelist;
            File dir = new File("schema/");
            if (dir.exists() && (filelist = dir.listFiles()) != null) {
                for (File f2 : filelist) {
                    if (!f2.getName().endsWith(".json")) continue;
                    DataFactory.getSchema(f2);
                }
            }
            allRead = true;
            schema = cache.get(name);
        }
        return schema;
    }
}

