/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.kosmos.platform.web;

import de.dfki.baall.helper.webserver.JWT;
import de.dfki.baall.helper.webserver.data.IUser;
import de.dfki.baall.helper.webserver.exceptions.ParameterNotFoundException;
import de.kosmos_lab.kosmos.data.DataSchema;
import de.kosmos_lab.kosmos.data.Device;
import de.kosmos_lab.kosmos.exceptions.DeviceAlreadyExistsException;
import de.kosmos_lab.kosmos.exceptions.DeviceNotFoundException;
import de.kosmos_lab.kosmos.exceptions.NoAccessToScope;
import de.kosmos_lab.kosmos.exceptions.SchemaNotFoundException;
import de.kosmos_lab.kosmos.exceptions.UserNotFoundException;
import de.kosmos_lab.kosmos.platform.IController;
import de.kosmos_lab.kosmos.platform.persistence.Constants;
import de.kosmos_lab.kosmos.platform.rules.RulesService;
import de.kosmos_lab.kosmos.platform.smarthome.CommandInterface;
import de.kosmos_lab.kosmos.platform.smarthome.CommandSourceName;
import de.kosmos_lab.kosmos.platform.web.WebServer;
import de.kosmos_lab.kosmos.platform.web.WebSocketService;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerEndpoint(value="/ws")
@WebSocket
public class KosmoSWebSocketService
extends WebSocketService
implements CommandInterface {
    private static final Logger logger = LoggerFactory.getLogger((String)"KosmoSWebSocketService");
    private final IController controller;
    private final WebServer server;
    public HashMap<String, MessageTimer> messageTimers = new HashMap();
    private final HashMap<Session, IUser> webSocketClients = new HashMap();
    private final HashMap<Session, IUser> logins = new HashMap();
    private final HashMap<Session, String> types = new HashMap();
    HashMap<IUser, HashSet<Device>> ignoredDevices = new HashMap();

    public KosmoSWebSocketService(WebServer server, IController c) {
        this.controller = c;
        this.server = server;
        this.controller.addCommandInterface(this);
    }

    private CommandSourceName getSourceName(Session session) {
        return this.controller.getSource("WebSocket" + session.getLocalAddress().toString());
    }

    private CommandSourceName getSourceName(Session session, String pre) {
        return this.controller.getSource(pre + "WebSocket" + session.getLocalAddress().toString());
    }

    public void broadCast(String text) {
        this.broadCast(text, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadCast(String text, Session sess) {
        HashMap<Session, IUser> hashMap = this.webSocketClients;
        synchronized (hashMap) {
            for (Map.Entry<Session, IUser> e : this.webSocketClients.entrySet()) {
                if (e.getValue() == null || sess == e.getKey()) continue;
                try {
                    e.getKey().getRemote().sendString(text);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastToReadUsers(Device device, String text, CommandSourceName source) {
        HashMap<Session, IUser> hashMap = this.webSocketClients;
        synchronized (hashMap) {
            for (Map.Entry<Session, IUser> e : this.webSocketClients.entrySet()) {
                try {
                    IUser user = e.getValue();
                    if (user == null || !device.canRead(user)) continue;
                    try {
                        String type;
                        if (source.getSourceName().startsWith("haset") && ("HAIntegration".equals(type = this.types.get(e.getKey())) || user.getName().equalsIgnoreCase("ha"))) {
                            logger.trace("SKIPPING broadcast, because it came from HASET in the first place");
                            continue;
                        }
                        e.getKey().getRemote().sendString(text);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                catch (NoAccessToScope noAccessToScope) {}
            }
        }
    }

    @Override
    public void deviceAdded(CommandInterface from, Device device, CommandSourceName source) {
        this.broadcastToReadUsers(device, "device/" + device.getUniqueID() + "/config:" + device.toJSON(), source);
    }

    @Override
    public void deviceRemoved(CommandInterface from, Device device, CommandSourceName source) {
        this.broadcastToReadUsers(device, "device/" + device.getUniqueID() + "/config:", source);
    }

    @Override
    public void deviceUpdate(CommandInterface from, Device device, String key, CommandSourceName source) {
        this.broadcastToReadUsers(device, "device/" + device.getUniqueID() + "/state:" + device, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        HashMap<Session, IUser> hashMap = this.webSocketClients;
        synchronized (hashMap) {
            for (Map.Entry<Session, IUser> e : this.webSocketClients.entrySet()) {
                try {
                    e.getKey().close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OnWebSocketConnect
    public void addWebSocketClient(Session sess) {
        HashMap<Session, IUser> hashMap = this.webSocketClients;
        synchronized (hashMap) {
            this.webSocketClients.put(sess, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OnWebSocketClose
    public void delWebSocketClient(Session sess) {
        HashMap<Session, IUser> hashMap = this.webSocketClients;
        synchronized (hashMap) {
            this.webSocketClients.remove(sess);
        }
    }

    @Override
    @OnWebSocketMessage
    public void onWebSocketMessage(Session sess, String message) {
        block86: {
            IUser user = this.logins.get(sess);
            if (user != null) {
                String type = this.types.get(sess);
                if (type != null) {
                    logger.info("Received TEXT message: {} from: {} {} ({}) ", new Object[]{message, sess, user.getName(), type});
                } else {
                    logger.info("Received TEXT message: {} from: {} {} ", new Object[]{message, sess, user.getName()});
                }
            } else {
                logger.info("Received TEXT message: {} from {}", (Object)message, (Object)sess);
            }
            if (message.equalsIgnoreCase("ping")) {
                try {
                    sess.getRemote().sendString("pong");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            Matcher m = Constants.websocketSplitPattern.matcher(message);
            if (m.matches()) {
                String topic = m.group(1);
                if (topic == null) {
                    return;
                }
                if (topic.startsWith("kosmos/")) {
                    topic = topic.substring(7);
                }
                if (topic.startsWith("device/")) {
                    topic = topic.substring(7);
                }
                String payload = m.group(2);
                if (topic.equals("user/auth")) {
                    JSONObject json = new JSONObject(payload);
                    String usern = json.optString("user");
                    String pass = json.optString("pass");
                    if (usern != null && pass != null) {
                        IUser u = this.controller.tryLogin(usern, pass);
                        if (u != null) {
                            this.webSocketClients.put(sess, u);
                            this.logins.put(sess, u);
                            logger.info("auth successful");
                            this.afterAuth(sess, u);
                            return;
                        }
                    } else {
                        logger.warn("json not correct");
                    }
                    try {
                        logger.warn("json auth failed!");
                        sess.getRemote().sendString("auth failed");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else if (topic.equals("user/token")) {
                    if (payload != null && !payload.equals("null")) {
                        try {
                            JSONObject o = this.controller.getJwt().verify(payload);
                            IUser u = this.controller.getUser(o.getInt("id"));
                            this.webSocketClients.put(sess, u);
                            this.logins.put(sess, u);
                            logger.info("auth successful");
                            sess.getRemote().sendString("auth successful");
                            this.afterAuth(sess, u);
                            return;
                        }
                        catch (InvalidKeyException e) {
                            e.printStackTrace();
                        }
                        catch (NoSuchAlgorithmException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalStateException e) {
                            e.printStackTrace();
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                        catch (JWT.JWTVerifyFailed e) {
                            e.printStackTrace();
                        }
                        catch (UserNotFoundException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        logger.info("token auth failed!");
                        sess.getRemote().sendString("auth failed");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else if (topic.equals("user/type")) {
                    this.types.put(sess, payload);
                } else if (user != null) {
                    Device d;
                    String uuid;
                    if (topic.equals("kree/stdout")) {
                        try {
                            JSONObject obj = new JSONObject();
                            obj.put("type", (Object)"log");
                            obj.put("value", (Object)payload);
                            RulesService s = this.controller.getRulesService();
                            if (s != null) {
                                s.broadcastToUser(this.webSocketClients.get(sess), obj.toString());
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        return;
                    }
                    if (topic.equals("kree/stderr")) {
                        try {
                            JSONObject obj = new JSONObject();
                            obj.put("type", (Object)"error");
                            obj.put("value", (Object)payload);
                            RulesService s = this.controller.getRulesService();
                            if (s != null) {
                                s.broadcastToUser(this.webSocketClients.get(sess), obj.toString());
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        return;
                    }
                    if (topic.equals("locations")) {
                        try {
                            for (Device device : this.controller.getAllDevices()) {
                                try {
                                    Device.Location loc;
                                    if (!device.canRead(user) || (loc = device.getLocation()) == null) continue;
                                    sess.getRemote().sendString("device/" + device.getUniqueID() + "/location:" + loc.toJSON().toString());
                                }
                                catch (NoAccessToScope loc) {}
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        return;
                    }
                    if (topic.endsWith("/set")) {
                        uuid = topic.substring(0, topic.length() - 4);
                        try {
                            JSONObject pl = new JSONObject();
                            try {
                                pl = new JSONObject(payload);
                            }
                            catch (JSONException loc) {
                                // empty catch block
                            }
                            String type = this.types.get(sess);
                            if (type != null && type.equals("HAIntegration")) {
                                this.controller.parseHASet(this, uuid, pl, this.getSourceName(sess, "haset/"), user);
                                return;
                            }
                            this.controller.parseSet((CommandInterface)this, uuid, pl, this.getSourceName(sess), user);
                        }
                        catch (DeviceNotFoundException | NoAccessToScope e) {
                            logger.warn(e.getMessage());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (topic.endsWith("/haset")) {
                        int c;
                        MessageTimer mt = this.messageTimers.get(topic);
                        if (mt == null) {
                            mt = new MessageTimer();
                            this.messageTimers.put(topic, mt);
                        }
                        if ((c = mt.count()) > 3) {
                            return;
                        }
                        mt.addEntry();
                        String uuid2 = topic.substring(0, topic.length() - 6);
                        try {
                            JSONObject p = new JSONObject(payload);
                            if (!p.has("state")) {
                                p.put("state", (Object)new JSONObject());
                            }
                            this.controller.parseHASet(this, uuid2, p, this.getSourceName(sess, "haset/"), user);
                        }
                        catch (DeviceNotFoundException | NoAccessToScope ex) {
                            logger.warn("Exception:", (Throwable)ex);
                        }
                        catch (JSONException ex) {
                            logger.warn("Exception:", (Throwable)ex);
                        }
                        catch (Exception ex) {
                            logger.warn("Exception:", (Throwable)ex);
                        }
                    } else if (topic.endsWith("/setname")) {
                        uuid = topic.substring(0, topic.length() - 8);
                        d = null;
                        try {
                            d = this.controller.getDevice(uuid);
                            this.controller.setName(d, payload);
                        }
                        catch (DeviceNotFoundException e) {
                            e.printStackTrace();
                        }
                    } else if (topic.endsWith("/config")) {
                        try {
                            if (payload.length() > 2) {
                                this.controller.parseAddDevice(this, new JSONObject(payload), this.getSourceName(sess), user);
                                break block86;
                            }
                            uuid = topic.substring(0, topic.length() - 7);
                            d = this.controller.getDevice(uuid);
                            if (d == null) break block86;
                            try {
                                if (d.canDel(user)) {
                                    this.controller.deleteDevice(this, d);
                                }
                            }
                            catch (NoAccessToScope e) {
                                e.printStackTrace();
                            }
                        }
                        catch (DeviceAlreadyExistsException uuid3) {
                        }
                        catch (ParameterNotFoundException | SchemaNotFoundException e) {
                            logger.warn(e.getMessage());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (topic.endsWith("/location")) {
                        try {
                            JSONObject json = new JSONObject(payload);
                            if (!json.has("uuid")) {
                                json.put("uuid", (Object)topic.substring(0, topic.length() - 9));
                            }
                            this.controller.setLocation(user, json, this.getSourceName(sess));
                        }
                        catch (DeviceNotFoundException json) {
                        }
                        catch (ParameterNotFoundException e) {
                            logger.warn(e.getMessage());
                        }
                        catch (NoAccessToScope noAccessToScope) {
                            noAccessToScope.printStackTrace();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    logger.warn("user is NOT authed!");
                }
            }
        }
    }

    public void addIgnoredDevice(IUser user, Device device) {
        HashSet<Device> set = this.ignoredDevices.get(user);
        if (set == null) {
            set = new HashSet();
            this.ignoredDevices.put(user, set);
        }
        set.add(device);
    }

    private void afterAuth(Session sess, IUser u) {
        try {
            sess.getRemote().sendString("auth successful");
            HashSet<DataSchema> schemas = new HashSet<DataSchema>();
            JSONArray arr = new JSONArray();
            HashSet<Device> set = this.ignoredDevices.get(u);
            for (Device device : this.controller.getAllDevices()) {
                try {
                    if (!device.canRead(u)) continue;
                    schemas.add(device.getDataSchema());
                    JSONObject d = device.toJSON();
                    if (device.canWriteReadOnly(u)) {
                        d.put("canWriteReadOnly", true);
                    }
                    if (set != null && set.contains((Object)device) && d.has("state")) {
                        d.remove("state");
                    }
                    arr.put((Object)d);
                }
                catch (NoAccessToScope d) {}
            }
            JSONObject s = new JSONObject();
            for (DataSchema schema : schemas) {
                s.put(schema.getSchema().getId(), (Object)schema.getRawSchema());
            }
            sess.getRemote().sendString("schemas:" + s);
            sess.getRemote().sendString("devices:" + arr);
            return;
        }
        catch (Exception e) {
            logger.warn("Exception:", (Throwable)e);
            return;
        }
    }

    @Override
    public String getSourceName() {
        return "HTTPApi";
    }

    private static class MessageTimerEntry {
        public long aliveUntil = System.currentTimeMillis() + 1000L;
    }

    private static class MessageTimer {
        public ConcurrentLinkedQueue<MessageTimerEntry> entries = new ConcurrentLinkedQueue();

        private MessageTimer() {
        }

        public void addEntry() {
            this.entries.add(new MessageTimerEntry());
        }

        public int count() {
            long now = System.currentTimeMillis();
            int c = 0;
            for (MessageTimerEntry e : this.entries) {
                if (e.aliveUntil <= now) {
                    this.entries.remove(e);
                    continue;
                }
                ++c;
            }
            return c;
        }
    }
}

